/*
 * Decompiled with CFR 0.152.
 */
package management.operations.events.impl;

import com.gemstone.gemfire.cache.Region;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import management.operations.OperationEvent;
import management.operations.OperationPrms;
import management.operations.OperationsBlackboard;
import management.operations.events.RegionOperationEvents;
import management.operations.events.impl.AbstractEvents;
import management.util.HydraUtil;

public class RegionEvents
extends AbstractEvents
implements RegionOperationEvents {
    public RegionEvents(Map<String, List<OperationEvent>> eventMap) {
        super(eventMap);
    }

    public RegionEvents() {
    }

    @Override
    public void regionAdded(Region region) {
        if (OperationPrms.recordRegionOperations()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_REGION_ADDED";
            event.data = region.getFullPath();
            this.addEvent(event);
        }
        HydraUtil.logInfo("RegionOperations: Finished with creating region : " + region.getFullPath());
    }

    @Override
    public void regionAdded(String regionPath) {
        if (OperationPrms.recordRegionOperations()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_REGION_ADDED";
            event.data = regionPath;
            this.addEvent(event);
        }
        HydraUtil.logInfo("RegionOperations: Finished with creating region : " + regionPath);
    }

    @Override
    public void regionDestroyed(String name, Set<String> chlildren) {
        if (OperationPrms.recordRegionOperations()) {
            ArrayList<OperationEvent> eList = new ArrayList<OperationEvent>();
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_REGION_DESTROYED";
            event.data = name;
            eList.add(event);
            if (chlildren != null && !chlildren.isEmpty()) {
                for (String child : chlildren) {
                    OperationEvent childrenevent = new OperationEvent();
                    event.name = "EVENT_REGION_DESTROYED";
                    event.data = child;
                    eList.add(childrenevent);
                }
            }
            this.addEvents(eList);
        }
        HydraUtil.logInfo("RegionOperations: Finished with destroying region : " + name);
    }

    @Override
    public void regionInvalidated(String name) {
        if (OperationPrms.recordRegionOperations()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_REGION_DESTROYED";
            event.data = name;
            this.addEvent(event);
        }
        HydraUtil.logInfo("RegionOperations: Finished with invalidating region : " + name);
    }

    @Override
    public void regionClosed(String name) {
        if (OperationPrms.recordRegionOperations()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_REGION_CLOSED";
            event.data = name;
            this.addEvent(event);
        }
        HydraUtil.logInfo("RegionOperations: Finished with closing region : " + name);
    }

    @Override
    public void regionCleared(String name) {
        if (OperationPrms.recordRegionOperations()) {
            OperationEvent event = new OperationEvent();
            event.name = "EVENT_REGION_CLEARED";
            event.data = name;
            this.addEvent(event);
        }
        HydraUtil.logInfo("RegionOperations: Finished with clearing region : " + name);
    }

    public static List<String> getAllRegions() {
        ArrayList<String> regionList = new ArrayList<String>();
        Map<String, AbstractEvents> emap = AbstractEvents.importFromBlackBoard("EVENT_REGION_ADDED", OperationsBlackboard.getBB());
        if (emap != null) {
            for (Map.Entry<String, AbstractEvents> e : emap.entrySet()) {
                String clientName = e.getKey();
                AbstractEvents ae = e.getValue();
                RegionEvents regionEvents = (RegionEvents)ae;
                List<OperationEvent> opList = regionEvents.getEvents("EVENT_REGION_ADDED");
                for (OperationEvent oe : opList) {
                    String regionName = (String)oe.data;
                    if (regionList.contains(regionName)) continue;
                    regionList.add((String)oe.data);
                }
            }
        }
        return regionList;
    }

    public static List<String> getCurrentRegions() {
        String regionName;
        List<OperationEvent> opList;
        RegionEvents regionEvents;
        AbstractEvents ae;
        String clientName;
        ArrayList<String> regionList = new ArrayList<String>();
        Map<String, AbstractEvents> emap = AbstractEvents.importFromBlackBoard("EVENT_REGION_ADDED", OperationsBlackboard.getBB());
        Map<String, AbstractEvents> emap2 = AbstractEvents.importFromBlackBoard("EVENT_REGION_DESTROYED", OperationsBlackboard.getBB());
        if (emap != null) {
            for (Map.Entry<String, AbstractEvents> e : emap.entrySet()) {
                clientName = e.getKey();
                ae = e.getValue();
                regionEvents = (RegionEvents)ae;
                opList = regionEvents.getEvents("EVENT_REGION_ADDED");
                for (OperationEvent oe : opList) {
                    regionName = (String)oe.data;
                    if (regionList.contains(regionName)) continue;
                    regionList.add((String)oe.data);
                }
            }
        }
        HydraUtil.logInfo("Region Create List : " + regionList);
        if (emap2 != null) {
            for (Map.Entry<String, AbstractEvents> e : emap2.entrySet()) {
                clientName = e.getKey();
                ae = e.getValue();
                regionEvents = (RegionEvents)ae;
                opList = regionEvents.getEvents("EVENT_REGION_DESTROYED");
                for (OperationEvent oe : opList) {
                    regionName = (String)oe.data;
                    if (!regionList.contains(regionName)) continue;
                    regionList.remove((String)oe.data);
                }
            }
        }
        HydraUtil.logInfo("Region List(After sbustracting destroyed regiond) : " + regionList);
        return regionList;
    }

    public static List<String> getAllRegions(String givenClientName) {
        ArrayList<String> regionList = new ArrayList<String>();
        AbstractEvents ae = AbstractEvents.importFromBlackBoard("EVENT_REGION_ADDED", givenClientName, OperationsBlackboard.getBB());
        if (ae != null) {
            RegionEvents regionEvents = (RegionEvents)ae;
            List<OperationEvent> opList = regionEvents.getEvents("EVENT_REGION_ADDED");
            for (OperationEvent oe : opList) {
                String regionName = (String)oe.data;
                if (regionList.contains(regionName)) continue;
                regionList.add((String)oe.data);
            }
        }
        return regionList;
    }

    public List<String> getLocalRegions() {
        ArrayList<String> regionList = new ArrayList<String>();
        RegionEvents ae = this;
        if (ae != null) {
            RegionEvents regionEvents = ae;
            List<OperationEvent> opList = regionEvents.getEvents("EVENT_REGION_ADDED");
            for (OperationEvent oe : opList) {
                String regionName = (String)oe.data;
                if (regionList.contains(regionName)) continue;
                regionList.add((String)oe.data);
            }
        }
        return regionList;
    }
}

