/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops;

import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.GsRandom;
import hydra.TestConfig;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import management.operations.OperationPrms;
import management.operations.OperationsBlackboard;
import management.operations.events.DLockOperationEvents;
import util.TestException;

public class DLockOperations {
    public static final int CREATE_DLOCK = 81;
    public static final int DESTROY_DLOCK = 82;
    public static final int LOCKUNLCOK_DLOCK = 83;
    public static final int BECOMEGRANTOR_DLCOK = 84;
    private static long waitTimeMillis = 0L;
    private static long leaseTimeMillis = 0L;
    private static long delay = 0L;
    private static Set<String> dLcokNames = new HashSet<String>();
    private static GsRandom randGen = TestConfig.tab().getRandGen();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock readLock = this.lock.readLock();
    private Lock writeLock = this.lock.writeLock();
    private DLockOperationEvents operationRecorder = null;
    private DistributedSystem ds = null;
    private String DLOCK_PREFIX = "DLOCK";

    public DLockOperations(DistributedSystem ds, DLockOperationEvents events) {
        this.ds = ds;
        waitTimeMillis = TestConfig.tab().longAt(OperationPrms.dlockWaitTimeMillis);
        leaseTimeMillis = TestConfig.tab().longAt(OperationPrms.dlockLeaseTimeMillis);
        delay = TestConfig.tab().longAt(OperationPrms.dlockDelay);
        this.operationRecorder = events;
    }

    public DLockOperationEvents getOperationRecorder() {
        return this.operationRecorder;
    }

    public void setOperationRecorder(DLockOperationEvents operationRecorder) {
        this.operationRecorder = operationRecorder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createDLock() {
        this.writeLock.lock();
        try {
            String name = this.DLOCK_PREFIX + OperationsBlackboard.getBB().getNextDLockCounter();
            DistributedLockService service = DistributedLockService.create((String)name, (DistributedSystem)this.ds);
            if (service == null) {
                throw new TestException("Create Operation for LockService named " + name + " failed, returned null");
            }
            dLcokNames.add(name);
            this.operationRecorder.dlockCreated(name, service);
            String string = name;
            return string;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyLock(String name) {
        block5: {
            this.writeLock.lock();
            try {
                if (dLcokNames.contains(name)) {
                    DistributedLockService service = DistributedLockService.getServiceNamed((String)name);
                    if (service == null) {
                        throw new TestException("LockService named " + name + " not found");
                    }
                    DistributedLockService.destroy((String)name);
                    this.operationRecorder.dlockDestroyed(name, service);
                    break block5;
                }
                throw new TestException("DLock named " + name + " was not created by DLockOperations");
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> listOfAvailableLocks() {
        this.readLock.lock();
        try {
            Set<String> set = Collections.unmodifiableSet(dLcokNames);
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLockUnLock(String name, long delay) {
        this.readLock.lock();
        try {
            DistributedLockService service = DistributedLockService.getServiceNamed((String)name);
            if (service == null) {
                throw new TestException("LockService named " + name + " not found");
            }
            long l1 = System.currentTimeMillis();
            int randomNumber = randGen.nextInt(10);
            String lockName = name + "_LOCK_" + randomNumber;
            service.lock((Object)lockName, waitTimeMillis, leaseTimeMillis);
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            service.unlock((Object)lockName);
            long l2 = System.currentTimeMillis();
            this.operationRecorder.dlockLockUnLock(name, service, l1, l2, lockName);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void becomeGrantor(String name) {
        this.readLock.lock();
        try {
            DistributedLockService.becomeLockGrantor((String)name);
            DistributedLockService service = DistributedLockService.getServiceNamed((String)name);
            this.operationRecorder.dlockBecomeGrantor(name, service);
        }
        finally {
            this.readLock.unlock();
        }
    }
}

