/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops;

import hydra.HydraVector;
import hydra.TestConfig;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import management.jmx.JMXBlackboard;
import management.jmx.JMXEventRecorder;
import management.jmx.JMXOperation;
import management.jmx.JMXPrms;
import management.operations.ops.jmx.AbstractTestMBean;
import management.operations.ops.jmx.TestMBean;
import management.test.federation.FederationBlackboard;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import util.TestException;

public class JMXOperations {
    public static final String LOCAL_MBEAN_SERVER = "<local>";
    public static final int JMX_OP_ATTR_ACCESS = 1;
    public static final int JMX_OP_OPERATION = 2;
    public static final String JMX_ATTR_ACESS = "accessAttribute";
    public static final String JMX_OPERATION_EXEC = "executeOperation";
    protected static String opPrefix = "JMXOperations: ";
    private Map<ObjectName, TestMBean> mbeanList = new HashMap<ObjectName, TestMBean>();
    private List<String> managingUrls = new ArrayList<String>();
    private Random randomGen = new Random();
    private JMXEventRecorder eventRecorder = JMXBlackboard.getBB();

    public void setEventRecorder(JMXEventRecorder eventRecorder) {
        this.eventRecorder = eventRecorder;
    }

    public static void HydraStartTask_ReadMbeanDescriptors() {
        HydraVector mbeanSpecList = TestConfig.tab().vecAt(JMXPrms.mbeanSpec);
        Iterator iterator = mbeanSpecList.iterator();
        HashMap<String, TestMBean> mbeanMap = new HashMap<String, TestMBean>();
        while (iterator.hasNext()) {
            String mbeanSpec = (String)iterator.next();
            mbeanSpec = mbeanSpec.replaceAll("'", "\"");
            HydraUtil.logInfo("Mbean Descriptor : " + mbeanSpec);
            TestMBean testMbean = AbstractTestMBean.parseMBeanDescriptor(mbeanSpec);
            mbeanMap.put(testMbean.getTemplateObjectName(), testMbean);
        }
        HydraUtil.logInfo("Mbean map is " + mbeanMap);
        JMXBlackboard.getBB().saveMap("MBEAN_MAP", mbeanMap);
    }

    public void doJMXTest() {
        String url = this.selectManagingNode();
        HydraUtil.logFine("Selecting mbean from  " + this.mbeanList);
        ObjectName targetMbean = this.selectMbean();
        HydraUtil.logFine("Selected mbean for operation " + targetMbean);
        TestMBean testMBean = this.mbeanList.get(targetMbean);
        HydraUtil.logFine("Test MBean instance for mbean " + targetMbean + " is  " + testMBean);
        if (testMBean == null) {
            throw new TestException("Could not find testmbean for " + targetMbean);
        }
        testMBean.executeTest(this, targetMbean);
    }

    public MBeanServerConnection getMBeanConnection(String managingUrl) {
        MBeanServerConnection remoteMBS = null;
        try {
            remoteMBS = !LOCAL_MBEAN_SERVER.equals(managingUrl) ? ManagementUtil.connectToUrlOrGemfireProxy(managingUrl) : ManagementUtil.getPlatformMBeanServerDW();
            return remoteMBS;
        }
        catch (MalformedURLException e) {
            HydraUtil.logErrorAndRaiseException("Error trying to connect managing node at " + managingUrl, e);
        }
        catch (IOException e) {
            if (HydraUtil.isSerialTest()) {
                HydraUtil.logErrorAndRaiseException("Error trying to connect managing node at " + managingUrl, e);
            }
            HydraUtil.logInfo("Error " + e.getMessage() + " expected during concurrent test. Continuing test.");
            this.eventRecorder.addEvent(new JMXOperation(null, null, "EXPECTED_EXCPTION", e, null));
            return null;
        }
        return remoteMBS;
    }

    public void setAttribute(String managingUrl, ObjectName targetMbean, String attrName, Object value) {
        MBeanServerConnection remoteMBS = null;
        try {
            remoteMBS = !LOCAL_MBEAN_SERVER.equals(managingUrl) ? ManagementUtil.connectToUrlOrGemfireProxy(managingUrl) : ManagementUtil.getPlatformMBeanServerDW();
        }
        catch (MalformedURLException e) {
            HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
        }
        catch (IOException e) {
            if (HydraUtil.isSerialTest()) {
                HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
            }
            HydraUtil.logInfo("Error " + e.getMessage() + " expected during concurrent test. Continuing test.");
            this.eventRecorder.addEvent(new JMXOperation(targetMbean, "det" + attrName, "EXPECTED_EXCPTION", e, null));
        }
        try {
            HydraUtil.logInfo("Setting attribute " + attrName + " on " + targetMbean + " hosted in manging node " + managingUrl);
            Attribute attr = new Attribute(attrName, value);
            remoteMBS.setAttribute(targetMbean, attr);
            HydraUtil.logInfo("Successfully set attribute " + attrName + " on " + targetMbean + " hosted in manging node " + managingUrl);
        }
        catch (AttributeNotFoundException e) {
            HydraUtil.logErrorAndRaiseException("Error accessing attribute " + attrName + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
        }
        catch (InstanceNotFoundException e) {
            if (HydraUtil.isSerialTest()) {
                HydraUtil.logErrorAndRaiseException("Error executing operation " + attrName + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
            } else {
                HydraUtil.logInfo("Continuing test expected execption " + e.getMessage() + " for mbean " + targetMbean);
                this.eventRecorder.addEvent(new JMXOperation(targetMbean, attrName, "EXPECTED_EXCPTION", e, null));
            }
        }
        catch (MBeanException e) {
            HydraUtil.logErrorAndRaiseException("Error accessing attribute " + attrName + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
        }
        catch (ReflectionException e) {
            HydraUtil.logErrorAndRaiseException("Error accessing attribute " + attrName + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
        }
        catch (IOException e) {
            HydraUtil.logErrorAndRaiseException("Error accessing attribute " + attrName + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
        }
        catch (InvalidAttributeValueException e) {
            HydraUtil.logErrorAndRaiseException("Error accessing attribute " + attrName + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
        }
    }

    public Object getAttribute(String managingUrl, ObjectName targetMbean, String attrName) {
        MBeanServerConnection remoteMBS = null;
        try {
            remoteMBS = !LOCAL_MBEAN_SERVER.equals(managingUrl) ? ManagementUtil.connectToUrlOrGemfireProxy(managingUrl) : ManagementUtil.getPlatformMBeanServerDW();
        }
        catch (MalformedURLException e) {
            HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
        }
        catch (IOException e) {
            if (HydraUtil.isSerialTest()) {
                HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
            }
            HydraUtil.logInfo("Error " + e.getMessage() + " expected during concurrent test. Continuing test.");
            this.eventRecorder.addEvent(new JMXOperation(targetMbean, "get" + attrName, "EXPECTED_EXCPTION", e, null));
            return null;
        }
        Object returnValue = null;
        try {
            HydraUtil.logInfo("Accessing attribute " + attrName + " on " + targetMbean + " hosted in manging node " + managingUrl);
            returnValue = remoteMBS.getAttribute(targetMbean, attrName);
            HydraUtil.logInfo("Successfully accessed attribute " + attrName + " on " + targetMbean + " hosted in manging node " + managingUrl + " result of type : " + (returnValue == null ? "<NULL>" : returnValue.getClass()));
            return returnValue;
        }
        catch (AttributeNotFoundException e) {
            HydraUtil.logErrorAndRaiseException("Error accessing attribute " + attrName + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
        }
        catch (InstanceNotFoundException e) {
            if (HydraUtil.isSerialTest()) {
                HydraUtil.logErrorAndRaiseException("Error executing operation " + attrName + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
            } else {
                HydraUtil.logInfo("Continuing test expected execption " + e.getMessage() + " for mbean " + targetMbean);
                this.eventRecorder.addEvent(new JMXOperation(targetMbean, attrName, "EXPECTED_EXCPTION", e, null));
            }
        }
        catch (MBeanException e) {
            HydraUtil.logErrorAndRaiseException("Error accessing attribute " + attrName + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
        }
        catch (ReflectionException e) {
            HydraUtil.logErrorAndRaiseException("Error accessing attribute " + attrName + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
        }
        catch (IOException e) {
            HydraUtil.logErrorAndRaiseException("Error accessing attribute " + attrName + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
        }
        return null;
    }

    public Object getAttributes(String managingUrl, ObjectName targetMbean, String[] attrs) {
        MBeanServerConnection remoteMBS = null;
        try {
            remoteMBS = !LOCAL_MBEAN_SERVER.equals(managingUrl) ? ManagementUtil.connectToUrlOrGemfireProxy(managingUrl) : ManagementUtil.getPlatformMBeanServerDW();
        }
        catch (MalformedURLException e) {
            HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
        }
        catch (IOException e) {
            if (HydraUtil.isSerialTest()) {
                HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
            }
            HydraUtil.logInfo("Error " + e.getMessage() + " expected during concurrent test. Continuing test.");
            this.eventRecorder.addEvent(new JMXOperation(targetMbean, "get" + HydraUtil.ObjectToString(attrs), "EXPECTED_EXCPTION", e, null));
            return null;
        }
        AttributeList returnValue = null;
        try {
            HydraUtil.logInfo("Accessing attribute " + HydraUtil.ObjectToString(attrs) + " on " + targetMbean + " hosted in manging node " + managingUrl);
            returnValue = remoteMBS.getAttributes(targetMbean, attrs);
            HydraUtil.logInfo("Successfully accessed attribute " + HydraUtil.ObjectToString(attrs) + " on " + targetMbean + " hosted in manging node " + managingUrl + " result of type : " + returnValue.getClass());
            if (returnValue != null) {
                AttributeList list = returnValue;
                HydraUtil.logInfo(" Return list size " + list.size() + " input attributes " + attrs.length);
                if (list.size() != attrs.length) {
                    ArrayList<String> attributeDiff = new ArrayList<String>();
                    for (String attr : attrs) {
                        boolean flag = false;
                        for (Object a : list) {
                            Attribute returnAttribute = (Attribute)a;
                            if (!returnAttribute.getName().equals(attr)) continue;
                            flag = true;
                        }
                        if (flag) continue;
                        attributeDiff.add(attr);
                    }
                    HydraUtil.logError("Return list " + HydraUtil.ObjectToString(list));
                    throw new TestException(" #Bug 45474 Return attribute list does not match with input attributelist Differing attributes - " + attributeDiff);
                }
            }
            return returnValue;
        }
        catch (InstanceNotFoundException e) {
            if (HydraUtil.isSerialTest()) {
                HydraUtil.logErrorAndRaiseException("Error executing operation " + HydraUtil.ObjectToString(attrs) + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
            } else {
                HydraUtil.logInfo("Continuing test expected execption " + e.getMessage() + " for mbean " + targetMbean);
                this.eventRecorder.addEvent(new JMXOperation(targetMbean, HydraUtil.ObjectToString(attrs), "EXPECTED_EXCPTION", e, null));
            }
        }
        catch (ReflectionException e) {
            HydraUtil.logErrorAndRaiseException("Error accessing attribute " + HydraUtil.ObjectToString(attrs) + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
        }
        catch (IOException e) {
            HydraUtil.logErrorAndRaiseException("Error accessing attribute " + HydraUtil.ObjectToString(attrs) + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
        }
        return null;
    }

    public Object doJMXOp(String managingUrl, ObjectName targetMbean, String opName, Object[] params, String[] signature) {
        MBeanServerConnection remoteMBS = null;
        try {
            remoteMBS = !LOCAL_MBEAN_SERVER.equals(managingUrl) ? ManagementUtil.connectToUrlOrGemfireProxy(managingUrl) : ManagementUtil.getPlatformMBeanServerDW();
        }
        catch (MalformedURLException e) {
            HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
        }
        catch (IOException e) {
            if (HydraUtil.isSerialTest()) {
                HydraUtil.logErrorAndRaiseException("Error trying to managing node at " + managingUrl, e);
            }
            HydraUtil.logInfo("Error " + e.getMessage() + " expected during concurrent test. Continuing test.");
            this.eventRecorder.addEvent(new JMXOperation(targetMbean, opName, "EXPECTED_EXCPTION", e, null));
            return null;
        }
        Object returnValue = null;
        try {
            HydraUtil.logInfo("Invoking operation " + opName + " on " + targetMbean + " hosted in manging node " + managingUrl);
            returnValue = remoteMBS.invoke(targetMbean, opName, params, signature);
            if (returnValue != null) {
                HydraUtil.logInfo("Successfully completed operation " + opName + " on " + targetMbean + " hosted in manging node " + managingUrl + " result of type : " + returnValue.getClass());
            } else {
                HydraUtil.logInfo("Successfully completed operation " + opName + " on " + targetMbean + " hosted in manging node " + managingUrl + " result null");
            }
            this.addEvent(returnValue, opName, targetMbean);
            return returnValue;
        }
        catch (InstanceNotFoundException e) {
            if (HydraUtil.isSerialTest()) {
                HydraUtil.logErrorAndRaiseException("Error executing operation " + opName + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
            } else {
                HydraUtil.logInfo("Continuing test expected execption " + e.getMessage() + " for mbean " + targetMbean);
                this.eventRecorder.addEvent(new JMXOperation(targetMbean, opName, "EXPECTED_EXCPTION", e, null));
            }
        }
        catch (MBeanException e) {
            HydraUtil.logErrorAndRaiseException("Error executing operation " + opName + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
        }
        catch (ReflectionException e) {
            HydraUtil.logErrorAndRaiseException("Error executing operation " + opName + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
        }
        catch (IOException e) {
            HydraUtil.logErrorAndRaiseException("Error executing operation " + opName + " for mbean " + targetMbean + " on managing node " + managingUrl, e);
        }
        return null;
    }

    private void addEvent(Object returnValue, String opName, ObjectName targetMbean) {
        if (returnValue instanceof Serializable) {
            this.eventRecorder.addEvent(new JMXOperation(targetMbean, opName, returnValue, null, null));
        } else if (returnValue != null) {
            this.eventRecorder.addEvent(new JMXOperation(targetMbean, opName, returnValue.toString(), null, null));
        }
    }

    private int selectOp() {
        return 2;
    }

    public JMXOperations addMbean(ObjectName name, TestMBean test) {
        this.mbeanList.put(name, test);
        return this;
    }

    public JMXOperations addManagingUrl(String url) {
        this.managingUrls.add(url);
        return this;
    }

    private ObjectName selectMbean() {
        if (this.mbeanList.size() == 1) {
            ObjectName mbeanOn = null;
            Iterator<ObjectName> i$ = this.mbeanList.keySet().iterator();
            while (i$.hasNext()) {
                ObjectName on;
                mbeanOn = on = i$.next();
            }
            return mbeanOn;
        }
        return HydraUtil.getRandomElement(this.mbeanList.keySet());
    }

    public String selectManagingNode() {
        if (this.managingUrls.size() == 0) {
            Collection<String> urls = FederationBlackboard.getBB().getManagingNodes();
            for (String str : urls) {
                this.managingUrls.add(str);
            }
        }
        if (this.managingUrls.size() == 1) {
            return this.managingUrls.get(0);
        }
        return HydraUtil.getRandomElement(this.managingUrls);
    }

    public void doJMXValidation() {
        for (String url : this.managingUrls) {
            for (ObjectName targetMbean : this.mbeanList.keySet()) {
                HydraUtil.logFine("Performing validations on " + targetMbean + " on url " + url);
                TestMBean testMBean = this.mbeanList.get(targetMbean);
                HydraUtil.logFine("Test MBean instance for mbean " + targetMbean + " is  " + testMBean);
                if (testMBean != null) {
                    testMBean.doValidation(this);
                    continue;
                }
                throw new TestException("Could not find testmbean for " + targetMbean);
            }
        }
    }
}

