/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.Scope;
import hydra.DistributedConnectionMgr;
import hydra.GsRandom;
import hydra.HydraVector;
import hydra.ProcessMgr;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import management.operations.OperationPrms;
import management.operations.OperationsBlackboard;
import management.operations.events.RegionOperationEvents;
import management.util.HydraUtil;
import util.TestException;

public class RegionOperations {
    public static final int ADD_REGION = 21;
    public static final int DESTROY_REGION = 22;
    public static final int INVALIDATE_REGION = 23;
    public static final int INVALDIATELOCAL_REGION = 24;
    public static final int CLEAR_REGION = 25;
    public static final int RE_CREATE_REGION = 26;
    public static final AtomicInteger regionTotalOp = new AtomicInteger();
    private static List<String> regionNames = null;
    private static GsRandom randGen = TestConfig.tab().getRandGen();
    private RegionOperationEvents operationRecorder = null;
    private Cache cache = null;
    private Set<Region> availableRegions = new HashSet<Region>();

    public RegionOperations(Cache cache) {
        this.operationRecorder = OperationsBlackboard.getBB();
        this.cache = cache;
        RegionOperations.populateRegionList();
    }

    public synchronized void setOperationRecorder(RegionOperationEvents operationRecorder) {
        this.operationRecorder = operationRecorder;
    }

    public synchronized RegionOperationEvents getOperationRecorder() {
        return this.operationRecorder;
    }

    private static synchronized void populateRegionList() {
        if (regionNames == null) {
            regionNames = new ArrayList<String>();
            HydraVector regionList = TestConfig.tab().vecAt(OperationPrms.regionList);
            Iterator regionIterator = regionList.iterator();
            while (regionIterator.hasNext()) {
                regionNames.add((String)regionIterator.next());
            }
        }
    }

    public RegionOperations(Cache cache, RegionOperationEvents operationRecorder) {
        this.operationRecorder = operationRecorder;
        this.cache = cache;
        RegionOperations.populateRegionList();
    }

    public static void HydraStartTask_ReadRegionSpecs() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Region> createAllRegions() {
        HydraUtil.logInfo("RegionOperations: Creating regions List : " + regionNames);
        for (String s : regionNames) {
            Set<Region> set = this.availableRegions;
            synchronized (set) {
                this.availableRegions.add(this.createRegion(this.getUniqueRegionName(s), s));
            }
        }
        HydraUtil.logInfo("RegionOperations: Finished with creating regions List : " + regionNames);
        return this.availableRegions;
    }

    private String getUniqueRegionName(String s) {
        return s + "_" + OperationsBlackboard.getBB().getNextRegionCounter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Region> getAvailableRegions() {
        Set<Region> set = this.availableRegions;
        synchronized (set) {
            return Collections.unmodifiableSet(this.availableRegions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region getRegion() {
        Set<Region> set = this.availableRegions;
        synchronized (set) {
            StringBuilder sb = new StringBuilder();
            for (Region r : this.availableRegions) {
                sb.append(r.getName() + ", ");
            }
            HydraUtil.logInfo("List of Regions " + sb);
            if (this.availableRegions.size() > 0) {
                int index = randGen.nextInt(this.availableRegions.size() - 1);
                int i = 0;
                Object r1 = null;
                for (Region r : this.availableRegions) {
                    if (i == index) {
                        return r;
                    }
                    ++i;
                }
                throw new TestException("No random region why? index=" + index + " i=" + i);
            }
            HydraUtil.logInfo("Error no available regions !!!");
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createRegion(String regionTemplateName) {
        Set<Region> set = this.availableRegions;
        synchronized (set) {
            RegionDescription regionDescription = RegionHelper.getRegionDescription(regionTemplateName);
            String regionName = this.getUniqueRegionName(regionDescription.getRegionName());
            Region r = this.createRegion(regionName, regionTemplateName);
            this.availableRegions.add(r);
            return r.getFullPath();
        }
    }

    public String createRegion() {
        HydraVector regionTemplateList = TestConfig.tab().vecAt(OperationPrms.regionList);
        String s = (String)regionTemplateList.get(TestConfig.tab().getRandGen().nextInt(regionTemplateList.size() - 1));
        return this.createRegion(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSubRegion(String name) {
        Set<Region> set = this.availableRegions;
        synchronized (set) {
            Region parent = RegionHelper.getRegion(name);
            String subregionName = "child" + OperationsBlackboard.getBB().getNextRegionCounter();
            HydraUtil.logInfo("RegionOperations: Creating subregion named : " + subregionName + " with parent " + parent.getFullPath());
            RegionAttributes attr = parent.getAttributes();
            Region child = parent.createSubregion(subregionName, attr);
            HydraUtil.logInfo("RegionOperations: Created subregion named " + child.getFullPath());
            this.availableRegions.add(child);
            this.operationRecorder.regionAdded(child);
            return child.getFullPath();
        }
    }

    public Region addRegion(String templateName) {
        boolean flag = false;
        HydraVector regionTemplateList = TestConfig.tab().vecAt(OperationPrms.regionList);
        for (int i = 0; i < regionTemplateList.size(); ++i) {
            if (!regionTemplateList.get(i).equals(templateName)) continue;
            flag = true;
        }
        if (!flag) {
            throw new TestException("Template named " + templateName + " not present in regionTemplateList : " + regionTemplateList);
        }
        return this.createRegion(this.getUniqueRegionName(templateName), templateName);
    }

    public void invalidateRegion(Region region) {
        this._invalidateRegion(region);
    }

    public void closeRegion(Region region) {
        this._closeRegion(region);
    }

    public void clearedRegion(Region region) {
        this._clearedRegion(region);
    }

    public void destroyRegion(Region region) {
        this._destroyRegion(region);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Region createRegion(String name, String regionTemplateName) {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            Region region = RegionHelper.getRegion(name);
            if (region == null) {
                HydraUtil.logInfo("RegionOperations: Creating region named : " + name + " with template " + regionTemplateName);
                String regionConfig = regionTemplateName;
                AttributesFactory aFactory = RegionHelper.getAttributesFactory(regionConfig);
                HydraUtil.logInfo("RegionOperations: RegionAttrs Factory " + aFactory.toString());
                Region rootRegion = RegionHelper.createRegion(name, aFactory);
                HydraUtil.logInfo("RegionOperations: Created root region " + name);
                if (rootRegion.getAttributes().getPoolName() != null) {
                    rootRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
                    HydraUtil.logInfo("RegionOperations: registered interest in ALL_KEYS for " + name);
                }
                region = rootRegion;
                this.availableRegions.add(rootRegion);
                this.operationRecorder.regionAdded(rootRegion);
            }
            return region;
        }
    }

    private void invalidateRegion() {
        Object name = null;
        Region region = this.getRegion();
        this._invalidateRegion(region);
    }

    private void _invalidateRegion(Region region) {
        if (region != null) {
            String name = region.getName();
            HydraUtil.logInfo("RegionOperations: Invalidating region named : " + name);
            String callback = this.callback("Invalidating region" + name + " in ");
            try {
                region.invalidateRegion((Object)callback);
                this.operationRecorder.regionInvalidated(name);
            }
            catch (Exception e) {
                this.handleException("RegionOperationError : invalidateRegion", e, region);
            }
        } else {
            HydraUtil.logInfo("No region Found continuing test list : " + this.availableRegions);
        }
    }

    private void closeRegion() {
        Object name = null;
        Region region = this.getRegion();
        this._closeRegion(region);
    }

    private void _closeRegion(Region region) {
        if (region != null) {
            String name = region.getName();
            String callback = this.callback("RegionOperations: Closing region" + name + " in ");
            HydraUtil.logInfo(callback);
            try {
                region.close();
                this.removeAvailableRegion(region);
                this.operationRecorder.regionClosed(name);
            }
            catch (Exception e) {
                this.handleException("RegionOperationError : closeRegion", e, region);
            }
        } else {
            HydraUtil.logInfo("No region Found continuing test list : " + this.availableRegions);
        }
    }

    private void clearedRegion() {
        Object name = null;
        Region region = this.getRegion();
        this._clearedRegion(region);
    }

    private void _clearedRegion(Region region) {
        if (region != null) {
            String name = region.getName();
            String callback = this.callback("RegionOperations: Clearing region" + name + " in ");
            HydraUtil.logInfo(callback);
            try {
                region.clear();
                this.operationRecorder.regionCleared(name);
            }
            catch (Exception e) {
                this.handleException("RegionOperationError : clearedRegion", e, region);
            }
        } else {
            HydraUtil.logInfo("No region Found continuing test list : " + this.availableRegions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAvailableRegion(Region region) {
        Set<Region> set = this.availableRegions;
        synchronized (set) {
            Region toDelete = null;
            for (Region r : this.availableRegions) {
                if (!r.getFullPath().equals(region.getFullPath())) continue;
                toDelete = r;
            }
            if (toDelete != null) {
                this.availableRegions.remove(toDelete);
            } else if (!HydraUtil.isConcurrentTest()) {
                throw new TestException("Can't find region in the availableRegions list ");
            }
        }
    }

    private void destroyRegion() {
        Object name = null;
        Region region = this.getRegion();
        this._destroyRegion(region);
    }

    private void _destroyRegion(Region region) {
        if (region != null) {
            String name = region.getName();
            String path = region.getFullPath();
            String callback = this.callback("RegionOperations: Destroying region" + name + " in ");
            HydraUtil.logInfo(callback);
            try {
                Region r = CacheFactory.getAnyInstance().getRegion(name);
                Set children = r.subregions(true);
                HashSet<String> childrennames = new HashSet<String>();
                if (children != null && children.size() > 0) {
                    for (Region child : children) {
                        childrennames.add(child.getFullPath());
                    }
                }
                region.destroyRegion();
                this.removeAvailableRegion(region);
                this.operationRecorder.regionDestroyed(path, childrennames);
            }
            catch (Exception e) {
                this.handleException("RegionOperationError : destroyRegion", e, region);
            }
        } else {
            HydraUtil.logInfo("No region Found continuing test list : " + this.availableRegions);
        }
    }

    private void handleException(String string, Exception e, Region r) {
        if (HydraUtil.isConcurrentTest() && e instanceof RegionDestroyedException) {
            HydraUtil.logInfo(string + " RegionDestroy expected during concurrent test. Contnuing test ");
        }
        if (!(e instanceof RegionDestroyedException) || r.getAttributes().getScope().equals(Scope.LOCAL)) {
            throw new TestException(string, e);
        }
        HydraUtil.logInfo(string + " Region is already destroyed probably due to remote destroy, continuing with test");
        this.removeAvailableRegion(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doRegionOperations() {
        int whichOp;
        String operation = TestConfig.tab().stringAt(OperationPrms.regionOperations);
        if ("add".equals(operation)) {
            whichOp = 21;
        } else if ("destroy".equals(operation)) {
            whichOp = 22;
        } else if ("invalidate".equals(operation)) {
            whichOp = 23;
        } else if ("clear".equals(operation)) {
            whichOp = 25;
        } else if ("reCreate".equals(operation)) {
            whichOp = 26;
        } else {
            throw new TestException("Unknow region operations " + operation);
        }
        Set<Region> set = this.availableRegions;
        synchronized (set) {
            int size = this.availableRegions.size();
            if (size < 1) {
                HydraUtil.logInfo("RegionOperations: Number of Regions " + this.availableRegions.size() + " so adding a new region.");
                whichOp = 21;
            }
        }
        switch (whichOp) {
            case 21: {
                this.addRegion();
                break;
            }
            case 22: {
                this.destroyRegion();
                break;
            }
            case 23: {
                this.invalidateRegion();
                break;
            }
            case 25: {
                this.clearedRegion();
                break;
            }
            case 26: {
                this.reCreateRegion();
                break;
            }
            default: {
                throw new TestException("Unknow region operations " + whichOp);
            }
        }
    }

    private void reCreateRegion() {
        throw new UnsupportedOperationException();
    }

    private void addRegion() {
        HydraVector regionTemplateList = TestConfig.tab().vecAt(OperationPrms.regionList);
        String s = (String)regionTemplateList.get(TestConfig.tab().getRandGen().nextInt(regionTemplateList.size() - 1));
        this.createRegion(s);
    }

    private String callback(String createCallbackPrefix) {
        String memberId = null;
        if (DistributedConnectionMgr.getConnection() != null) {
            memberId = DistributedConnectionMgr.getConnection().getDistributedMember().toString();
        }
        String callback = createCallbackPrefix + " " + ProcessMgr.getProcessId() + " memberId=" + memberId;
        return callback;
    }
}

