/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.cli;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import management.operations.ops.cli.TestCommand;
import management.operations.ops.cli.TestCommandInstance;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import util.TestException;
import util.TestHelper;

public class GfshCommandDescriptorReader {
    public static final String TOKEN_EXECUTOR = "executor";
    public static final String TOKEN_COMMAND = "command";
    public static final String TOKEN_ARGUMENTS = "arguments";
    public static final String TOKEN_MANDATORY_OPTIONS = "mandatoryOptions";
    public static final String TOKEN_OPTIONS = "options";
    public static final String TOKEN_MODES = "modes";
    public static final String TOKEN_PROBABILITY = "probability";
    public static final String TOKEN_ALSO_INCLUDE = "alsoInclude";

    public static TestCommand parseCommandDescriptor(String commandDesc) {
        JSONObject json = null;
        TestCommand testCommand = null;
        try {
            json = new JSONObject(commandDesc);
            String command = json.getString(TOKEN_COMMAND);
            String executorName = null;
            try {
                executorName = json.getString(TOKEN_EXECUTOR);
            }
            catch (JSONException e) {
                throw new TestException("No executor for command " + command);
            }
            JSONArray arguments = json.getJSONArray(TOKEN_ARGUMENTS);
            JSONArray mandatoryOptions = json.getJSONArray(TOKEN_MANDATORY_OPTIONS);
            JSONArray options = json.getJSONArray(TOKEN_OPTIONS);
            JSONArray modes = json.getJSONArray(TOKEN_MODES);
            testCommand = new TestCommand();
            testCommand.command = command;
            testCommand.executorName = executorName;
            testCommand.arguments = GfshCommandDescriptorReader.readCommandArguments(arguments);
            testCommand.mandatoryOptions = GfshCommandDescriptorReader.readMandatoryOptions(mandatoryOptions);
            testCommand.options = GfshCommandDescriptorReader.readOptions(options);
            testCommand.modes = GfshCommandDescriptorReader.readModes(modes);
            return testCommand;
        }
        catch (JSONException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private static Map<String, TestCommand.CommandMode> readModes(JSONArray jsonModes) throws JSONException {
        HashMap<String, TestCommand.CommandMode> modes = new HashMap<String, TestCommand.CommandMode>();
        for (int i = 0; i < jsonModes.length(); ++i) {
            JSONObject jsonMode = (JSONObject)jsonModes.get(i);
            TestCommand.CommandMode mode = new TestCommand.CommandMode();
            mode.name = jsonMode.getString("name");
            mode.mandatoryOptions = GfshCommandDescriptorReader.readMandatoryOptions(jsonMode.getJSONArray(TOKEN_MANDATORY_OPTIONS));
            mode.options = GfshCommandDescriptorReader.readOptions(jsonMode.getJSONArray(TOKEN_OPTIONS));
            try {
                JSONArray jsonArguments = jsonMode.getJSONArray(TOKEN_ARGUMENTS);
                mode.arguments = GfshCommandDescriptorReader.readCommandArguments(jsonArguments);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            if (jsonMode.has(TOKEN_PROBABILITY)) {
                mode.probability = jsonMode.getInt(TOKEN_PROBABILITY);
            }
            modes.put(mode.name, mode);
        }
        return modes;
    }

    private static List<TestCommand.CommandOption> readOptions(JSONArray jsonOptions) throws JSONException {
        ArrayList<TestCommand.CommandOption> options = new ArrayList<TestCommand.CommandOption>();
        for (int i = 0; i < jsonOptions.length(); ++i) {
            JSONObject jsonOption = (JSONObject)jsonOptions.get(i);
            options.add(GfshCommandDescriptorReader.readOption(jsonOption));
        }
        return options;
    }

    private static List<String> readMandatoryOptions(JSONArray jSonmandatoryOptions) throws JSONException {
        ArrayList<String> mandatoryOptions = new ArrayList<String>();
        for (int i = 0; i < jSonmandatoryOptions.length(); ++i) {
            String jsonArgument = (String)jSonmandatoryOptions.get(i);
            mandatoryOptions.add(jsonArgument);
        }
        return mandatoryOptions;
    }

    private static List<String> readCommandArguments(JSONArray jsonArguments) throws JSONException {
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 0; i < jsonArguments.length(); ++i) {
            String jsonArgument = (String)jsonArguments.get(i);
            arguments.add(jsonArgument);
        }
        return arguments;
    }

    private static TestCommand.CommandOption readOption(JSONObject jsonOption) throws JSONException {
        TestCommand.CommandOption option = new TestCommand.CommandOption();
        option.name = jsonOption.getString("name");
        if (jsonOption.has(TOKEN_PROBABILITY)) {
            option.probability = jsonOption.getInt(TOKEN_PROBABILITY);
        }
        if (jsonOption.has(TOKEN_ALSO_INCLUDE)) {
            option.linkedSet = new ArrayList<String>();
            JSONArray jsonArray = jsonOption.getJSONArray(TOKEN_ALSO_INCLUDE);
            for (int i = 0; i < jsonArray.length(); ++i) {
                String str = (String)jsonArray.get(i);
                option.linkedSet.add(str);
            }
        }
        return option;
    }

    public static void main(String[] args) throws Exception {
        File textFile = new File("/tushark1/code-checkout/checkout/mnm/mm_dev_Jan12/tests/management/test/gfshCommand.txt");
        BufferedReader reader = new BufferedReader(new FileReader(textFile));
        char[] bytes = new char[(int)textFile.length()];
        reader.read(bytes, 0, bytes.length);
        String commandString = new String(bytes);
        System.out.println("Input String : " + commandString);
        TestCommand command = GfshCommandDescriptorReader.parseCommandDescriptor(commandString);
        TestCommandInstance cmdInstance = command.getRandomCommandInstnance();
        System.out.println("Generate Commands 1 " + cmdInstance.toString());
        cmdInstance = command.getRandomCommandInstnance();
        System.out.println("Generate Commands 2 " + cmdInstance.toString());
        cmdInstance = command.getRandomCommandInstnance();
        System.out.println("Generate Commands 3 " + cmdInstance.toString());
        cmdInstance = command.getRandomCommandInstnance();
        System.out.println("Generate Commands 4 " + cmdInstance.toString());
        cmdInstance = command.getRandomCommandInstnance();
        System.out.println("Generate Commands 5 " + cmdInstance.toString());
        cmdInstance = command.getRandomCommandInstnance();
        System.out.println("Generate Commands 6 " + cmdInstance.toString());
    }
}

