/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.cli.executors;

import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import management.cli.TestableGfsh;
import management.operations.OperationsBlackboard;
import management.operations.events.impl.RegionEvents;
import management.operations.ops.cli.TestCommand;
import management.operations.ops.cli.TestCommandInstance;
import management.operations.ops.cli.executors.AbstractTestCommandExecutor;
import management.test.cli.CLITest;
import management.test.federation.FederationBlackboard;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import util.TestException;

public class DestroyRegionExecutor
extends AbstractTestCommandExecutor {
    private String regionPath = null;
    private static String regionPattern = "GemFire:service=Region,name=?1,type=Member,member=?2";
    private static String distrRgionPattern = "GemFire:service=Region,name=?1,type=Distributed";

    @Override
    protected void fillArgument(TestCommandInstance instance, String name) {
        if ("name".equals(name)) {
            this.regionPath = this.getCurrentRegion();
            instance.addOption(name, this.regionPath);
        }
    }

    @Override
    public Object executeAndVerify(TestCommandInstance instance) {
        TestableGfsh gfsh = CLITest.getTestableShell();
        if (!gfsh.isConnectedAndReady()) {
            CLITest.connectGfshToManagerNode();
        }
        Object[] object = TestableGfsh.execAndLogCommand(gfsh, instance.toString(), CLITest.getGfshOutputFile(), false);
        Map map = (Map)object[0];
        CommandResult result = null;
        Collection values = map.values();
        for (Object r : values) {
            if (!(r instanceof CommandResult)) continue;
            result = (CommandResult)r;
            if (!result.getStatus().equals((Object)Result.Status.OK)) {
                CLITest.currentCommand.append(" Command return status is *NOT* OK. Command execution has failed");
                CLITest.hasCommandFailed = true;
                continue;
            }
            HydraUtil.logInfo("Completed exeuction of <" + instance + "> successfully");
        }
        this.verifyGemfire(gfsh, object);
        this.verifyJMX(gfsh, object);
        this.verifyCommand(gfsh, object);
        RegionEvents e = new RegionEvents();
        e.regionDestroyed(this.regionPath, null);
        e.exportToBlackBoard(OperationsBlackboard.getBB());
        this.regionPath = null;
        return object;
    }

    @Override
    protected void fillOption(TestCommandInstance instance, TestCommand.CommandOption op) {
    }

    @Override
    public Object verifyJMX(TestableGfsh gfsh, Object object) {
        HydraUtil.logInfo("Sleeping for replication");
        HydraUtil.sleepForReplicationJMX();
        HydraUtil.logInfo("Checking mbeans for region " + this.regionPath + " Executor " + this);
        try {
            boolean jmxMBeansFound = DestroyRegionExecutor.checkMBean(this.regionPath, null);
            if (jmxMBeansFound) {
                CLITest.currentCommand.append(" Cant find mbeans for regionPath " + this.regionPath + " group=" + null);
                CLITest.hasCommandFailed = true;
            }
            return jmxMBeansFound;
        }
        catch (MalformedObjectNameException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
        catch (InstanceNotFoundException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
        catch (AttributeNotFoundException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
        catch (MalformedURLException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
        catch (NullPointerException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
        catch (MBeanException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
        catch (ReflectionException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
        catch (IOException e) {
            throw new TestException("Error checking regionMBeans", e);
        }
    }

    public static boolean checkMBean(String regionName, String group) throws MalformedURLException, IOException, MalformedObjectNameException, NullPointerException, InstanceNotFoundException, AttributeNotFoundException, MBeanException, ReflectionException {
        boolean regionMBeansExist = true;
        Collection<String> urls = FederationBlackboard.getBB().getManagingNodes();
        ObjectName distributedRegionMBean = new ObjectName(distrRgionPattern.replace("?1", regionName));
        String regionMBean1 = regionPattern.replace("?1", regionName);
        HydraUtil.logInfo("Checking for JMX MBean for region : " + regionName);
        for (String url : urls) {
            MBeanServerConnection connection = ManagementUtil.connectToUrl(url);
            HydraUtil.logInfo("Checking DistrRegionMBean on url " + url);
            boolean distrFound = ManagementUtil.checkIfMBeanExists(connection, distributedRegionMBean);
            if (!distrFound) {
                HydraUtil.logInfo("DistributedRegionMBean " + distributedRegionMBean + " is not found on url " + url);
                regionMBeansExist = false;
            }
            Set<String> members = ManagementUtil.getMembersForGroup(connection, group);
            HydraUtil.logInfo("Member for group(" + group + ") : " + HydraUtil.ObjectToString(members));
            for (String member : members) {
                ObjectName regionMBean = new ObjectName(regionMBean1.replace("?2", member));
                if (!ManagementUtil.checkIfMBeanExists(connection, regionMBean)) {
                    HydraUtil.logInfo("RegionMBean " + regionMBean + " is not found on url " + url);
                    return false;
                }
                HydraUtil.logInfo("RegionMBean " + regionMBean + " is FOUND on url " + url);
            }
        }
        return regionMBeansExist;
    }

    @Override
    protected void fillMandatoryOption(TestCommandInstance instance, String name) {
        if ("name".equals(name)) {
            this.regionPath = this.getCurrentRegionFilterColocated();
            instance.addOption(name, this.regionPath);
        }
    }
}

