/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.cli.executors;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import management.cli.CommandOutputValidator;
import management.cli.TestableGfsh;
import management.operations.ops.cli.TestCommand;
import management.operations.ops.cli.TestCommandInstance;
import management.operations.ops.cli.executors.AbstractTestCommandExecutor;
import management.util.HydraUtil;

public class ExportLogsExecutor
extends AbstractTestCommandExecutor {
    static SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss/SSS/z");
    private Calendar calendar = null;
    private String directory = null;

    @Override
    public Object verifyCommand(TestableGfsh gfsh, Object object) {
        Object[] outputs = (Object[])object;
        CommandOutputValidator validator = new CommandOutputValidator(gfsh, outputs);
        validator.addUnExpectedErrorString("Cannot execute").addUnExpectedErrorString("Could not merge the files in target directory").addUnExpectedErrorString("Specify one of group or member ID").addUnExpectedErrorString("Error in executing function").addUnExpectedErrorString("Does not exist").addUnExpectedErrorString("Target Directory {0} cannot be created").addUnExpectedErrorString("Specify End Time.").addUnExpectedErrorString("Specify Start Time.").addUnExpectedErrorString("Invalid Time Range.").addUnExpectedErrorString("No member found for executing function").addExpectedString(this.directory);
        CommandOutputValidator.CommandOutputValidatorResult result = validator.validate();
        if (!result.result) {
            this.addFailure(result.getExceptionMessage());
        }
        if (!this.checkDirectory(this.directory)) {
            this.addFailure("Export logs command failed to create logs in directory " + this.directory);
        }
        this.calendar = null;
        this.directory = null;
        return result;
    }

    @Override
    protected void fillOption(TestCommandInstance instance, TestCommand.CommandOption op) {
    }

    @Override
    protected void fillMandatoryOption(TestCommandInstance instance, String name) {
        if ("member".equals(name)) {
            instance.addOption(name, this.getMemberId());
        } else if ("group".equals(name)) {
            instance.addOption(name, this.getGroup());
        } else if ("log-level".equals(name)) {
            instance.addOption(name, this.getLogLevel());
        } else if ("only-log-level".equals(name)) {
            instance.addOption(name, String.valueOf(HydraUtil.getRandomBoolean()));
        } else if ("merge-log".equals(name)) {
            instance.addOption(name, "true");
        } else if ("start-time".equals(name)) {
            String startTime = this.getStartTime();
            HydraUtil.logInfo("Adding start-time=" + startTime);
            instance.addOption(name, startTime);
        } else if ("end-time".equals(name)) {
            String endTime = this.getEndTime();
            HydraUtil.logInfo("Adding end-time=" + endTime);
            instance.addOption(name, endTime);
        } else if (name.equals("dir")) {
            this.directory = this.getDirectory(instance.getMode());
            instance.addOption(name, this.directory);
        }
    }

    private String getEndTime() {
        Date date = null;
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
            int rollback = 1 + HydraUtil.getnextRandomInt(10);
            HydraUtil.logFine("Adding diff=" + rollback + " minutes to " + this.calendar.getTime());
            this.calendar.add(12, -1 * rollback);
            date = this.calendar.getTime();
        } else {
            int rollback = 1 + HydraUtil.getnextRandomInt(10);
            HydraUtil.logFine("Adding diff=" + rollback + " minutes to " + this.calendar.getTime());
            this.calendar.add(12, rollback);
            date = this.calendar.getTime();
        }
        HydraUtil.logFine("Final End Time " + date);
        return formatter.format(date);
    }

    private String getStartTime() {
        this.calendar = Calendar.getInstance();
        int rollback = -1 * HydraUtil.getnextRandomInt(60);
        this.calendar.add(12, rollback);
        Date date = this.calendar.getTime();
        HydraUtil.logFine("Final Start Time " + date);
        return formatter.format(date);
    }

    private Object getLogLevel() {
        String[] logLevels = new String[]{"ALL", "FINEST", "FINER", "FINE", "INFO", "CONFIG", "WARNING", "ERROR", "SEVERE"};
        return HydraUtil.getRandomElement(logLevels);
    }

    @Override
    protected void fillArgument(TestCommandInstance instance, String name) {
    }
}

