/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.jmx;

import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import management.jmx.Expectation;
import management.jmx.JMXNotificationListener;
import management.jmx.SimpleJMXRecorder;
import management.jmx.validation.JMXValidator;
import management.operations.ops.JMXOperations;
import management.operations.ops.jmx.CacheServerTestMBean;
import management.operations.ops.jmx.DiskStoreTestMBean;
import management.operations.ops.jmx.DistributedLockServiceTestMBean;
import management.operations.ops.jmx.DistributedRegionTestMBean;
import management.operations.ops.jmx.DistributedSystemTestMBean;
import management.operations.ops.jmx.GatewayReceiverTestMBean;
import management.operations.ops.jmx.GatewaySenderTestMBean;
import management.operations.ops.jmx.LocatorTestMBean;
import management.operations.ops.jmx.LockServiceTestMBean;
import management.operations.ops.jmx.MemberTestMbean;
import management.operations.ops.jmx.PulseTestMBean;
import management.operations.ops.jmx.RegionTestMBean;
import management.operations.ops.jmx.TestMBean;
import management.test.jmx.JMXTest;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import util.TestException;
import util.TestHelper;

public abstract class AbstractTestMBean<T>
implements TestMBean {
    private static final long serialVersionUID = 1L;
    public static final String TOKEN_TYPE = "type";
    public static final String TOKEN_CLASS = "class";
    public static final String TOKEN_ATRRIBUTES = "attributes";
    public static final String TOKEN_OPERATIONS = "operations";
    public static final String TOKEN_ON = "templateObjectName";
    private static final String TOKEN_TEST = "tests";
    public static final String[] gemfireDefinedMBeanTypes = new String[]{"member", "cacheServer", "region", "lockService", "diskStore", "gatewaySender", "gatewayReceiver", "locator", "manager", "distributedSystem", "distributedRegion", "distributedLockService", "memberGroup", "pulse"};
    public static final int MemberMBean = 0;
    public static final int CacheServerMBean = 1;
    public static final int RegionMBean = 2;
    public static final int LockServiceMBean = 3;
    public static final int DiskStoreMBean = 4;
    public static final int GatewaySenderMBean = 5;
    public static final int GatewayReceiverMBean = 6;
    public static final int LocatorMBean = 7;
    public static final int ManagerMBean = 8;
    public static final int DistributedSystemMBean = 9;
    public static final int DistributedRegionMBean = 10;
    public static final int DistributedLockServiceMBean = 11;
    public static final int MemberGroupMBean = 12;
    public static final int PULSEMBean = 13;
    protected String[] attributes;
    protected Object[][] ops;
    protected String templateObjectName;
    protected String[] tests;
    protected static String prefix;

    public AbstractTestMBean(List<String> attrs, List<Object[]> ops, Class klass, String templateObjectName, String[] tests) {
        this.attributes = new String[attrs.size()];
        int i = 0;
        for (String s : attrs) {
            this.attributes[i++] = s;
        }
        i = 0;
        this.ops = new Object[ops.size()][];
        for (Object[] op : ops) {
            this.ops[i++] = op;
        }
        this.templateObjectName = templateObjectName;
        this.tests = tests;
        this.validateOps(this.ops, klass);
        this.validateAttr(this.attributes, klass);
    }

    private void validateAttr(String[] attributes2, Class klass) {
    }

    private void validateOps(Object[][] ops2, Class klass) {
    }

    @Override
    public String[] getAttributes() {
        return this.attributes;
    }

    @Override
    public Object[][] getOperations() {
        return this.ops;
    }

    public static TestMBean parseMBeanDescriptor(String mbeanDesc) {
        JSONObject json = null;
        TestMBean testmbean = null;
        try {
            json = new JSONObject(mbeanDesc);
            String mbeanClass = json.getString(TOKEN_CLASS);
            String mbeanType = json.getString(TOKEN_TYPE);
            String templateObjectName = json.getString(TOKEN_ON);
            String[] tests = AbstractTestMBean.getStringArray(json.getJSONArray(TOKEN_TEST));
            Class<?> klass = Class.forName(mbeanClass);
            Method[] ms = klass.getDeclaredMethods();
            ArrayList<String> attrs = new ArrayList<String>();
            ArrayList<Object[]> ops = new ArrayList<Object[]>();
            testmbean = AbstractTestMBean.getTestMbean(mbeanType, attrs, ops, templateObjectName, tests);
            return testmbean;
        }
        catch (JSONException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (ClassNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    private static String[] getStringArray(JSONArray jsonArray) throws JSONException {
        int length = jsonArray.length();
        String[] array = new String[length];
        for (int i = 0; i < length; ++i) {
            array[i] = (String)jsonArray.get(i);
        }
        return array;
    }

    private static TestMBean getTestMbean(String mbeanType, List<String> attrs, List<Object[]> ops, String ton, String[] tests) {
        boolean found = false;
        int ordinal = 0;
        for (int i = 0; i < gemfireDefinedMBeanTypes.length; ++i) {
            if (!mbeanType.equals(gemfireDefinedMBeanTypes[i])) continue;
            found = true;
            ordinal = i;
            break;
        }
        if (!found) {
            throw new TestException("Unknown mbean type in mbean descriptor " + mbeanType);
        }
        AbstractTestMBean testMBean = null;
        switch (ordinal) {
            case 0: {
                testMBean = new MemberTestMbean(attrs, ops, ton, tests);
                break;
            }
            case 1: {
                testMBean = new CacheServerTestMBean(attrs, ops, ton, tests);
                break;
            }
            case 2: {
                testMBean = new RegionTestMBean(attrs, ops, ton, tests);
                break;
            }
            case 3: {
                testMBean = new LockServiceTestMBean(attrs, ops, ton, tests);
                break;
            }
            case 4: {
                testMBean = new DiskStoreTestMBean(attrs, ops, ton, tests);
                break;
            }
            case 5: {
                testMBean = new GatewaySenderTestMBean(attrs, ops, ton, tests);
                break;
            }
            case 6: {
                testMBean = new GatewayReceiverTestMBean(attrs, ops, ton, tests);
                break;
            }
            case 7: {
                testMBean = new LocatorTestMBean(attrs, ops, ton, tests);
                break;
            }
            case 9: {
                testMBean = new DistributedSystemTestMBean(attrs, ops, ton, tests);
                break;
            }
            case 10: {
                testMBean = new DistributedRegionTestMBean(attrs, ops, ton, tests);
                break;
            }
            case 11: {
                testMBean = new DistributedLockServiceTestMBean(attrs, ops, ton, tests);
                break;
            }
            case 13: {
                testMBean = new PulseTestMBean(attrs, ops, ton, tests);
                break;
            }
            default: {
                throw new TestException("Either not implemented test mbean or unknown mbean type " + mbeanType);
            }
        }
        return testMBean;
    }

    @Override
    public String getTemplateObjectName() {
        return this.templateObjectName;
    }

    protected void runMethod(Class class1, TestMBean testMbean, String test, JMXOperations ops, ObjectName name) {
        Method[] ms = class1.getDeclaredMethods();
        Method targetMethod = null;
        for (Method m : ms) {
            if (!m.getName().equals(test)) continue;
            targetMethod = m;
        }
        if (targetMethod == null) {
            throw new TestException("Test " + test + " not present in " + this.getClass().getName());
        }
        Object[] args = new Object[]{ops, name};
        try {
            targetMethod.invoke((Object)testMbean, args);
        }
        catch (IllegalArgumentException e) {
            HydraUtil.logErrorAndRaiseException("Error running test " + test, e);
        }
        catch (IllegalAccessException e) {
            HydraUtil.logErrorAndRaiseException("Error running test " + test, e);
        }
        catch (InvocationTargetException e) {
            HydraUtil.logErrorAndRaiseException("Error running test " + test, e);
        }
    }

    @Override
    public String[] getTests() {
        return this.tests;
    }

    @Override
    public void executeTest(JMXOperations ops, ObjectName name) {
        String test = HydraUtil.getRandomElement(this.tests);
        HydraUtil.logInfo(prefix + "Selected Testcase " + test);
        HydraUtil.logInfo("Running method of class " + this.getClass() + " on " + this + " with test " + test + " argument : " + ops);
        this.runMethod(this.getClass(), this, test, ops, name);
    }

    protected Object callJmxOperation(String url, JMXOperations ops, Object[] operation, ObjectName targetMbean) {
        String opName = (String)operation[0];
        Object[] params = (Object[])operation[1];
        String[] signature = (String[])operation[2];
        Object result = ops.doJMXOp(url, targetMbean, opName, params, signature);
        return result;
    }

    protected Object[] buildOperationArray(String opName, Object[] params, String[] signature, Object returnValue) {
        Object[] operation = new Object[]{opName, params, signature, returnValue};
        return operation;
    }

    public void addRegionCreateNotificationExp(String newRegion) {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.cache.region.created", ManagementUtil.getMemberID(), "Region Created With Name " + newRegion);
        if (ManagementUtil.subscribeDSNotifs()) {
            JMXTest.addExpectationForNotification(MBeanJMXAdapter.getDistributedSystemName(), "gemfire.distributedsystem.cache.region.created", ManagementUtil.getMemberID(), "Region Created With Name " + newRegion);
        }
    }

    public void addRegionDestroyNotificationExp(String region) {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.cache.region.closed", ManagementUtil.getMemberID(), "Region Destroyed/Closed With Name " + region);
        if (ManagementUtil.subscribeDSNotifs()) {
            JMXTest.addExpectationForNotification(MBeanJMXAdapter.getDistributedSystemName(), "gemfire.distributedsystem.cache.region.closed", ManagementUtil.getMemberID(), "Region Destroyed/Closed With Name " + region);
        }
    }

    public void addDiskStoreCreatedNotificationExp(String diskStoreName) {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.cache.disk.created", ManagementUtil.getMemberID(), "DiskStore Created With Name " + diskStoreName);
        if (ManagementUtil.subscribeDSNotifs()) {
            JMXTest.addExpectationForNotification(MBeanJMXAdapter.getDistributedSystemName(), "gemfire.distributedsystem.cache.disk.created", ManagementUtil.getMemberID(), "DiskStore Created With Name " + diskStoreName);
        }
    }

    public void addDiskStoreDestroyedNotificationExp(String diskStoreName) {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.cache.disk.closed", ManagementUtil.getMemberID(), "DiskStore Destroyed/Closed With Name " + diskStoreName);
        if (ManagementUtil.subscribeDSNotifs()) {
            JMXTest.addExpectationForNotification(MBeanJMXAdapter.getDistributedSystemName(), "gemfire.distributedsystem.cache.disk.closed", ManagementUtil.getMemberID(), "DiskStore Destroyed/Closed With Name " + diskStoreName);
        }
    }

    public void addLockServiceCreateNotificationExp(String lockServiceName) {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.cache.lockservice.created", ManagementUtil.getMemberID(), "LockService Created With Name " + lockServiceName);
        if (ManagementUtil.subscribeDSNotifs()) {
            JMXTest.addExpectationForNotification(MBeanJMXAdapter.getDistributedSystemName(), "gemfire.distributedsystem.cache.lockservice.created", ManagementUtil.getMemberID(), "LockService Created With Name " + lockServiceName);
        }
    }

    public void addLockServiceDestroyNotificationExp(String lockServiceName) {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.cache.lockservice.closed", ManagementUtil.getMemberID(), "Lockservice closed With Name " + lockServiceName);
        if (ManagementUtil.subscribeDSNotifs()) {
            JMXTest.addExpectationForNotification(MBeanJMXAdapter.getDistributedSystemName(), "gemfire.distributedsystem.cache.lockservice.closed", ManagementUtil.getMemberID(), "Lockservice closed With Name " + lockServiceName);
        }
    }

    public void addMemberDepartedNotificationExp(String memberId) {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getDistributedSystemName(), "gemfire.distributedsystem.cache.member.departed", ManagementUtil.getMemberID(), "Member Departed " + memberId);
    }

    public void addMemberSuspectNotificationExp(String memberId) {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getDistributedSystemName(), "gemfire.distributedsystem.cache.member.suspect", ManagementUtil.getMemberID(), "Member Suspected " + memberId);
    }

    public void addMemberJoinedNotificationExp(String memberId) {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getDistributedSystemName(), "gemfire.distributedsystem.cache.member.joined", ManagementUtil.getMemberID(), "Member Joined " + memberId);
    }

    public void addClientJoinedNotificationExp(ObjectName cacheServerMBean) {
        JMXTest.addExpectationForNotificationPseudoMatch(cacheServerMBean, "gemfire.distributedsystem.cacheserver.client.joined", cacheServerMBean.toString(), "Client joined with Id ");
    }

    public void addClientLeftNotificationExp(ObjectName cacheServerMBean, String clientId) {
        JMXTest.addExpectationForNotificationPseudoMatch(cacheServerMBean, "gemfire.distributedsystem.cacheserver.client.left", cacheServerMBean.toString(), clientId);
    }

    public void addClientCrashedNotificationExp(ObjectName cacheServerMBean, String clientId) {
        JMXTest.addExpectationForNotificationPseudoMatch(cacheServerMBean, "gemfire.distributedsystem.cacheserver.client.crashed", cacheServerMBean.toString(), clientId);
    }

    public static void addGWReceiverCreatedNotificationExp() {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.gateway.receiver.created", ManagementUtil.getMemberID(), "GatewayReceiver Created in the VM ");
    }

    public static void addGWReceiverStartedNotificationExp() {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.gateway.receiver.started", ManagementUtil.getMemberID(), "GatewayReceiver Started in the VM ");
    }

    public static void addGWReceiverStoppedNotificationExp() {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.gateway.receiver.stopped", ManagementUtil.getMemberID(), "GatewayReceiver Stopped in the VM ");
    }

    public static void addGWSenderCreatedNotificationExp(int count) {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.gateway.sender.created", ManagementUtil.getMemberID(), "GatewaySender Created in the VM ");
    }

    public static void addGWSenderStoppedNotificationExp(int count) {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.gateway.sender.stopped", ManagementUtil.getMemberID(), "GatewaySender Stopped in the VM ");
    }

    public static void addGWSenderPausedNotificationExp() {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.gateway.sender.paused", ManagementUtil.getMemberID(), "GatewaySender Paused in the VM ");
    }

    public static void addAsyncEventQueueCreatedNotificationExp() {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.asycn.event.queue.created", ManagementUtil.getMemberID(), "Async Event Queue is Created  in the VM ");
    }

    public void addLocaterCreatedNotificationExp() {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.locator.started", ManagementUtil.getMemberID(), "Locator is Started in the VM ");
    }

    public void addSystemAlertNotificationExp(String message) {
        JMXTest.addExpectationForNotificationPseudoMatch(MBeanJMXAdapter.getDistributedSystemName(), "system.alert", ManagementUtil.getMemberID(), message);
    }

    public void addCacheServerStartedNotificationExp() {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.cache.server.started", ManagementUtil.getMemberID(), "Cache Server is Started in the VM ");
        if (ManagementUtil.subscribeDSNotifs()) {
            JMXTest.addExpectationForNotification(MBeanJMXAdapter.getDistributedSystemName(), "gemfire.distributedsystem.cache.server.started", ManagementUtil.getMemberID(), "Cache Server is Started in the VM ");
        }
    }

    public void addCacheServerStoppedNotificationExp() {
        JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.cache.server.stopped", ManagementUtil.getMemberID(), "Cache Server is stopped in the VM ");
        if (ManagementUtil.subscribeDSNotifs()) {
            JMXTest.addExpectationForNotification(MBeanJMXAdapter.getDistributedSystemName(), "gemfire.distributedsystem.cache.server.stopped", ManagementUtil.getMemberID(), "Cache Server is stopped in the VM ");
        }
    }

    public static void addDSNotifListener(ObjectName name, String memberId) {
        if (!JMXTest.isNotifListenerRegistered(name)) {
            JMXTest.addDSNotifListener(name, memberId);
        }
    }

    public static void addMemberNotifListener(ObjectName name, String memberId) {
        if (!JMXTest.isNotifListenerRegistered(name)) {
            JMXTest.addMemberNotifListener(name, memberId);
        }
    }

    public static void addCacheServerNotifListener(ObjectName cacheServerON, String memberId) {
        if (!JMXTest.isNotifListenerRegistered(cacheServerON)) {
            JMXTest.addCacheServerNotifListener(cacheServerON, memberId);
        }
    }

    public static class InPlaceJMXNotifValidator {
        public SimpleJMXRecorder recorder = new SimpleJMXRecorder();
        public JMXNotificationListener listener = null;
        public List<Expectation> expectationList = new ArrayList<Expectation>();
        MBeanServerConnection server = null;
        public ObjectName mbean;

        public InPlaceJMXNotifValidator(String notifListenerPrefix, ObjectName targetMbean, String url) {
            JMXNotificationListener listener = new JMXNotificationListener(notifListenerPrefix, this.recorder, targetMbean);
            try {
                this.server = !"<local>".equals(url) ? ManagementUtil.connectToUrlOrGemfireProxy(url) : ManagementUtil.getPlatformMBeanServerDW();
                HydraUtil.logFine("Adding InPlaceJMXNotifValidator listener for mbean " + targetMbean + " named " + notifListenerPrefix);
                this.server.addNotificationListener(targetMbean, listener, null, null);
                this.mbean = targetMbean;
            }
            catch (MalformedURLException e) {
                throw new TestException("error", e);
            }
            catch (IOException e) {
                throw new TestException("error", e);
            }
            catch (InstanceNotFoundException e) {
                throw new TestException("error", e);
            }
            this.listener = listener;
        }

        public void validateNotifications() {
            try {
                this.server.removeNotificationListener(this.mbean, this.listener);
            }
            catch (InstanceNotFoundException e) {
                HydraUtil.logError("Error while removing listener ", e);
            }
            catch (ListenerNotFoundException e) {
                HydraUtil.logError("Error while removing listener ", e);
            }
            catch (IOException e) {
                HydraUtil.logError("Error while removing listener ", e);
            }
            catch (Exception e) {
                HydraUtil.logError("Error while removing listener ", e);
            }
            JMXValidator validator = new JMXValidator(this.recorder, this.expectationList);
            JMXTest.validateAndPrint(validator);
        }
    }
}

