/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.jmx;

import com.gemstone.gemfire.management.DiskMetrics;
import com.gemstone.gemfire.management.GemFireProperties;
import com.gemstone.gemfire.management.JVMMetrics;
import com.gemstone.gemfire.management.NetworkMetrics;
import com.gemstone.gemfire.management.OSMetrics;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import hydra.ClientPrms;
import hydra.ClientVmInfo;
import hydra.HydraVector;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import management.Expectations;
import management.jmx.JMXPrms;
import management.operations.ops.JMXOperations;
import management.operations.ops.jmx.AbstractTestMBean;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;

public class DistributedSystemTestMBean
extends AbstractTestMBean<DistributedSystemTestMBean> {
    private static final Pattern memberPattern;

    public DistributedSystemTestMBean(List<String> attrs, List<Object[]> ops, String ton, String[] tests) {
        super(attrs, ops, DistributedSystemTestMBean.class, ton, tests);
    }

    @Override
    public String getType() {
        return gemfireDefinedMBeanTypes[9];
    }

    public void checkDSRuntime(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"MemberCount", "LocatorCount", "SystemDiskStoreCount", "AlertLevel", "DistributedSystemId"};
        HydraUtil.logInfo(prefix + " Calling checkDSRuntime");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkDSRuntime " + HydraUtil.ObjectToString(attrList));
    }

    public void checkDSRuntimeMetrics(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"TotalHeapSize", "TotalRegionEntryCount", "TotalRegionCount", "TotalMissCount", "TotalHitCount", "NumClients", "NumInitialImagesInProgress", "ActiveCQCount"};
        HydraUtil.logInfo(prefix + " Calling checkDSRuntimeMetrics");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkDSRuntimeMetrics " + HydraUtil.ObjectToString(attrList));
    }

    public void checkStatistics(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"QueryRequestRate"};
        HydraUtil.logInfo(prefix + " Calling checkStatistics");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkStatistics " + HydraUtil.ObjectToString(attrList));
    }

    public void checkDiskStoreStatistics(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"DiskReadsRate", "DiskWritesRate", "DiskFlushAvgLatency", "TotalBackupInProgress"};
        HydraUtil.logInfo(prefix + " Calling checkDiskStoreStatistics");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkDiskStoreStatistics " + HydraUtil.ObjectToString(attrList));
    }

    public void checkWANStatistics(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{};
        HydraUtil.logInfo(prefix + " Calling checkWANStatistics");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkWANStatistics " + HydraUtil.ObjectToString(attrList));
    }

    public void fetchMemberConfiguration(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling fetchMemberConfiguration");
        String url = ops.selectManagingNode();
        String member = this.getMemberId(ops, url, targetMbean);
        HydraUtil.logInfo(prefix + " Calling fetchMemberConfiguration for member " + member);
        Object[] params = new Object[]{member};
        String[] signature = new String[]{"java.lang.String"};
        if (!JMXPrms.useGemfireProxies()) {
            CompositeData props = (CompositeData)this.callJmxOperation(url, ops, this.buildOperationArray("fetchMemberConfiguration", params, signature, null), targetMbean);
            if (props == null) {
                throw new TestException("fetchMemberConfiguration returned null for " + member);
            }
            HydraUtil.logInfo(prefix + " Member configuration for member " + member);
            HydraUtil.logInfo(prefix + " " + HydraUtil.ObjectToString(props));
        } else {
            GemFireProperties props = (GemFireProperties)this.callJmxOperation(url, ops, this.buildOperationArray("fetchMemberConfiguration", params, signature, null), targetMbean);
            if (props == null) {
                throw new TestException("fetchMemberConfiguration returned null for " + member);
            }
            HydraUtil.logInfo(prefix + " Member configuration for member " + member);
            HydraUtil.logInfo(prefix + " " + HydraUtil.ObjectToString(props));
        }
        HydraUtil.logInfo(prefix + " Completed fetchMemberConfiguration test successfully");
    }

    private String getMemberId(JMXOperations ops, String url, ObjectName targetMBean) {
        String[] members = (String[])this.callJmxOperation(url, ops, this.buildOperationArray("listMembers", null, null, null), targetMBean);
        String member = HydraUtil.getRandomElement(members);
        if ("UNDEFINED".equals(member)) {
            throw new TestException("Could not locate member. Return value is UNDEFINED indicates exception while calling jmx operations");
        }
        return member;
    }

    public void fetchMemberUpTime(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling fetchMemberUpTime");
        String url = ops.selectManagingNode();
        String member = this.getMemberId(ops, url, targetMbean);
        HydraUtil.logInfo(prefix + " Calling fetchMemberUpTime for member " + member);
        Object[] params = new Object[]{member};
        String[] signature = new String[]{"java.lang.String"};
        Long prop = (Long)this.callJmxOperation(url, ops, this.buildOperationArray("fetchMemberUpTime", params, signature, null), targetMbean);
        HydraUtil.logInfo(prefix + " Member fetchMemberUpTime for member " + member + " is " + prop);
        HydraUtil.logInfo(prefix + " Completed fetchMemberUpTime test successfully");
    }

    public void fetchJVMMetrics(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling fetchJVMMetrics");
        String url = ops.selectManagingNode();
        String member = this.getMemberId(ops, url, targetMbean);
        HydraUtil.logInfo(prefix + " Calling fetchJVMMetrics for member " + member);
        Object[] params = new Object[]{member};
        String[] signature = new String[]{"java.lang.String"};
        if (!JMXPrms.useGemfireProxies()) {
            CompositeData props = (CompositeData)this.callJmxOperation(url, ops, this.buildOperationArray("showJVMMetrics", params, signature, null), targetMbean);
            if (props == null) {
                throw new TestException("fetchJVMMetrics returned null for " + member);
            }
            HydraUtil.logInfo(prefix + " Member fetchJVMMetrics for member " + member);
            HydraUtil.logInfo(prefix + " " + HydraUtil.ObjectToString(props));
        } else {
            JVMMetrics props = (JVMMetrics)this.callJmxOperation(url, ops, this.buildOperationArray("showJVMMetrics", params, signature, null), targetMbean);
            if (props == null) {
                throw new TestException("fetchJVMMetrics returned null for " + member);
            }
            HydraUtil.logInfo(prefix + " Member fetchJVMMetrics for member " + member);
            HydraUtil.logInfo(prefix + " " + HydraUtil.ObjectToString(props));
        }
        HydraUtil.logInfo(prefix + " Completed fetchJVMMetrics test successfully");
    }

    public void fetchOSMetrics(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling fetchOSMetrics");
        String url = ops.selectManagingNode();
        String member = this.getMemberId(ops, url, targetMbean);
        HydraUtil.logInfo(prefix + " Calling fetchOSMetrics for member " + member);
        Object[] params = new Object[]{member};
        String[] signature = new String[]{"java.lang.String"};
        if (!JMXPrms.useGemfireProxies()) {
            CompositeData props = (CompositeData)this.callJmxOperation(url, ops, this.buildOperationArray("showOSMetrics", params, signature, null), targetMbean);
            if (props == null) {
                throw new TestException("fetchOSMetrics returned null for " + member);
            }
            HydraUtil.logInfo(prefix + " Member fetchOSMetrics for member " + member);
            HydraUtil.logInfo(prefix + " " + HydraUtil.ObjectToString(props));
        } else {
            OSMetrics props = (OSMetrics)this.callJmxOperation(url, ops, this.buildOperationArray("showOSMetrics", params, signature, null), targetMbean);
            if (props == null) {
                throw new TestException("fetchOSMetrics returned null for " + member);
            }
            HydraUtil.logInfo(prefix + " Member fetchOSMetrics for member " + member);
            HydraUtil.logInfo(prefix + " " + HydraUtil.ObjectToString(props));
        }
        HydraUtil.logInfo(prefix + " Completed fetchOSMetrics test successfully");
    }

    public void fetchNetworkMetric(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling fetchNetworkMetric");
        String url = ops.selectManagingNode();
        String member = this.getMemberId(ops, url, targetMbean);
        HydraUtil.logInfo(prefix + " Calling fetchNetworkMetric for member " + member);
        Object[] params = new Object[]{member};
        String[] signature = new String[]{"java.lang.String"};
        if (!JMXPrms.useGemfireProxies()) {
            CompositeData props = (CompositeData)this.callJmxOperation(url, ops, this.buildOperationArray("showNetworkMetric", params, signature, null), targetMbean);
            if (props == null) {
                throw new TestException("showNetworkMetric returned null for " + member);
            }
            HydraUtil.logInfo(prefix + " Member showNetworkMetric for member " + member);
            HydraUtil.logInfo(prefix + " " + HydraUtil.ObjectToString(props));
        } else {
            NetworkMetrics props = (NetworkMetrics)this.callJmxOperation(url, ops, this.buildOperationArray("showNetworkMetric", params, signature, null), targetMbean);
            if (props == null) {
                throw new TestException("showNetworkMetric returned null for " + member);
            }
            HydraUtil.logInfo(prefix + " Member showNetworkMetric for member " + member);
            HydraUtil.logInfo(prefix + " " + HydraUtil.ObjectToString(props));
        }
        HydraUtil.logInfo(prefix + " Completed fetchNetworkMetric test successfully");
    }

    public void fetchDiskMetrics(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling fetchDiskMetrics");
        String url = ops.selectManagingNode();
        String member = this.getMemberId(ops, url, targetMbean);
        HydraUtil.logInfo(prefix + " Calling fetchDiskMetrics for member " + member);
        Object[] params = new Object[]{member};
        String[] signature = new String[]{"java.lang.String"};
        if (!JMXPrms.useGemfireProxies()) {
            CompositeData props = (CompositeData)this.callJmxOperation(url, ops, this.buildOperationArray("showDiskMetrics", params, signature, null), targetMbean);
            if (props == null) {
                throw new TestException("showDiskMetrics returned null for " + member);
            }
            HydraUtil.logInfo(prefix + " Member showDiskMetrics for member " + member);
            HydraUtil.logInfo(prefix + " " + HydraUtil.ObjectToString(props));
        } else {
            DiskMetrics props = (DiskMetrics)this.callJmxOperation(url, ops, this.buildOperationArray("showDiskMetrics", params, signature, null), targetMbean);
            if (props == null) {
                throw new TestException("showDiskMetrics returned null for " + member);
            }
            HydraUtil.logInfo(prefix + " Member showDiskMetrics for member " + member);
            HydraUtil.logInfo(prefix + " " + HydraUtil.ObjectToString(props));
        }
        HydraUtil.logInfo(prefix + " Completed fetchDiskMetrics test successfully");
    }

    public void revokeMissingDiskStores(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling revokeMissingDiskStores");
        HydraUtil.logInfo(prefix + " Completed revokeMissingDiskStores test successfully");
    }

    public void listMissingDiskStores(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling listMissingDiskStores");
        HydraUtil.logInfo(prefix + " Completed listMissingDiskStores test successfully");
    }

    public void shutDownAllMembers(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling shutDownAllMembers");
        HydraUtil.logInfo(prefix + " Completed shutDownAllMembers test successfully");
    }

    public void backupAllMembers(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling backupAllMembers");
        HydraUtil.logInfo(prefix + " Completed backupAllMembers test successfully");
    }

    String getMemberIdFromON(ObjectName name) {
        Matcher match = memberPattern.matcher(name.toString());
        String memberName = null;
        if (match.find()) {
            memberName = match.group(1);
            return memberName;
        }
        return null;
    }

    public void restartMembers(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling restartMembers");
        String url = ops.selectManagingNode();
        AbstractTestMBean.InPlaceJMXNotifValidator validator = new AbstractTestMBean.InPlaceJMXNotifValidator("restartMembers-Before", targetMbean, url);
        String[] list = (String[])this.callJmxOperation(url, ops, this.buildOperationArray("listMembers", null, null, null), targetMbean);
        HydraUtil.logInfo("Members " + HydraUtil.ObjectToString(list));
        ObjectName managerMemberON = (ObjectName)ops.getAttribute(url, targetMbean, "MemberObjectName");
        String managerMemberId = this.getMemberIdFromON(managerMemberON);
        HydraUtil.logFine("Excluding manager member from list " + managerMemberId);
        if (list != null && list.length > 0) {
            int members = 1 + HydraUtil.getnextRandomInt(list.length);
            HydraUtil.logInfo("Searching " + members + " eligible member/s, excluding manager, this member and at least one locator.");
            if (members == list.length) {
                --members;
            }
            List vmList = StopStartVMs.getAllVMs();
            ArrayList<ClientVmInfo> selectedVmList = new ArrayList<ClientVmInfo>();
            ArrayList<String> stopModeList = new ArrayList<String>();
            ArrayList<String> memberIdsGoingDown = new ArrayList<String>();
            for (int i = 0; i < members; ++i) {
                String selectedMember = list[i];
                HydraUtil.logFine("Checking for " + selectedMember);
                for (ClientVmInfo cInfo : vmList) {
                    String memberName = cInfo.getClientName();
                    String gemfireName = this.getGemfireName(memberName);
                    String complaintName = MBeanJMXAdapter.makeCompliantRegionNameAppender((String)selectedMember);
                    HydraUtil.logFine("clientName : " + memberName + " gemfireName = " + gemfireName + " name returned by mbean : " + selectedMember);
                    boolean makeSureAtleastOneLocatorIsInDs = this.makeSureAtleastOneLocatorIsInDs(memberIdsGoingDown, memberName);
                    if (!selectedMember.contains(gemfireName) || complaintName.equals(managerMemberId) || cInfo.getVmid() == RemoteTestModule.getMyVmid() || !makeSureAtleastOneLocatorIsInDs) continue;
                    HydraUtil.logFine("Adding " + selectedMember + " Generated Name " + gemfireName);
                    memberIdsGoingDown.add(selectedMember);
                    selectedVmList.add(cInfo);
                    String stopMode = TestConfig.tab().stringAt(StopStartPrms.stopModes);
                    stopModeList.add(stopMode);
                    validator.expectationList.add(Expectations.forMBean(targetMbean).expectMBeanAt(url).expectNotification("gemfire.distributedsystem.cache.member.departed", (Object)selectedMember, "Member Departed " + selectedMember, null, 4));
                }
            }
            members = memberIdsGoingDown.size();
            if (members != 0) {
                HydraUtil.logInfo("Number of members " + list.length + " Restarting " + members + " members");
                HydraUtil.logInfo("CliendIds not expected after shutdown : " + HydraUtil.ObjectToString(memberIdsGoingDown));
                ManagementUtil.stopRmiConnectors(selectedVmList);
                StopStartVMs.stopVMs(selectedVmList, stopModeList);
                HydraUtil.sleepForReplicationJMX();
                HydraUtil.sleepForReplicationJMX();
                String[] oldMembers = list;
                list = (String[])this.callJmxOperation(url, ops, this.buildOperationArray("listMembers", null, null, null), targetMbean);
                HydraUtil.logInfo("MemberIds after shutdown : " + HydraUtil.ObjectToString(list));
                validator.validateNotifications();
                validator = new AbstractTestMBean.InPlaceJMXNotifValidator("restartMembers-After", targetMbean, url);
                if (list != null) {
                    int diff = oldMembers.length - list.length;
                    ArrayList<String> diffList = new ArrayList<String>();
                    for (String cId : memberIdsGoingDown) {
                        validator.expectationList.add(Expectations.forMBean(targetMbean).expectMBeanAt(url).expectNotification("gemfire.distributedsystem.cache.member.joined", (Object)ManagementUtil.getMemberID(), "Member Joined ", members, 5));
                        for (String c : list) {
                            if (!c.equals(cId)) continue;
                            diffList.add(c);
                        }
                    }
                    if (diff != members) {
                        throw new TestException("Member list shows " + list.length + " member/s expected " + (oldMembers.length - members) + " diff : " + diffList);
                    }
                    if (diffList.size() > 0) {
                        throw new TestException("Member list shows " + list.length + " member/s expected " + (oldMembers.length - members) + " diff : " + diffList);
                    }
                }
                StopStartVMs.startVMs(selectedVmList);
                HydraUtil.logInfo("Restarting VMS : " + HydraUtil.ObjectToString(memberIdsGoingDown));
                HydraUtil.sleepForReplicationJMX();
                validator.validateNotifications();
            } else {
                HydraUtil.logInfo("No eligible memberFound");
            }
        }
        HydraUtil.logInfo(prefix + " Completed restartMembers test successfully");
    }

    private boolean makeSureAtleastOneLocatorIsInDs(List<String> memberIdsGoingDown, String memberName) {
        String name;
        int i;
        int totalLocatorsInSystem = 0;
        int locatorsAdded = 0;
        HydraVector clientNames = TestConfig.tab().vecAt(ClientPrms.names);
        for (i = 0; i < clientNames.size(); ++i) {
            name = (String)clientNames.get(i);
            if (!name.contains("locator")) continue;
            ++totalLocatorsInSystem;
        }
        for (i = 0; i < memberIdsGoingDown.size(); ++i) {
            name = memberIdsGoingDown.get(i);
            if (!name.contains("locator")) continue;
            ++locatorsAdded;
        }
        if (memberName.contains("locator")) {
            ++locatorsAdded;
        }
        HydraUtil.logFine("totalLocatorsInSystem = " + totalLocatorsInSystem + " locatorsAdded=" + locatorsAdded + " for memberName " + memberName + " Including Member : " + (locatorsAdded < totalLocatorsInSystem));
        return locatorsAdded < totalLocatorsInSystem;
    }

    private String getGemfireName(String memberName) {
        HydraVector gemfireNames = TestConfig.tab().vecAt(ClientPrms.gemfireNames);
        HydraVector clientNames = TestConfig.tab().vecAt(ClientPrms.names);
        for (int i = 0; i < clientNames.size(); ++i) {
            String name = (String)clientNames.get(i);
            if (!name.equals(memberName)) continue;
            return (String)gemfireNames.get(i);
        }
        return null;
    }

    @Override
    public void doValidation(JMXOperations ops) {
    }

    static {
        prefix = "DistributedSystemTestMBean : ";
        memberPattern = Pattern.compile("GemFire:type=Member,member=(.*)");
    }
}

