/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.jmx;

import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.AttributeList;
import javax.management.ObjectName;
import management.Expectations;
import management.operations.ops.JMXOperations;
import management.operations.ops.jmx.AbstractTestMBean;
import management.util.HydraUtil;
import util.TestException;

public class GatewaySenderTestMBean
extends AbstractTestMBean<GatewaySenderTestMBean> {
    private static final Pattern memberPattern;

    public GatewaySenderTestMBean(List<String> attrs, List<Object[]> ops, String ton, String[] tests) {
        super(attrs, ops, GatewaySenderTestMBean.class, ton, tests);
    }

    @Override
    public String getType() {
        return gemfireDefinedMBeanTypes[5];
    }

    public void checkSenderConfig(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"RemoteDSId", "SocketBufferSize", "SocketReadTimeout", "OverflowDiskStoreName", "MaximumQueueMemory", "BatchSize", "BatchTimeInterval", "BatchConflationEnabled", "PersistenceEnabled", "AlertThreshold", "GatewayEventFilters", "GatewayTransportFilters", "ManualStart", "OrderPolicy", "DiskSynchronous", "Parallel"};
        HydraUtil.logInfo(prefix + " Calling checkSenderConfig");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkSenderConfig " + HydraUtil.ObjectToString(attrList));
    }

    public void checkSenderRuntime(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"Running", "Paused", "Primary", "DispatcherThreads"};
        HydraUtil.logInfo(prefix + " Calling checkSenderRuntime");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkSenderRuntime " + HydraUtil.ObjectToString(attrList));
    }

    public void checkSenderStatistics(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"EventsReceivedRate", "EventsQueuedRate", "EventQueueSize", "TotalEventsConflated", "AverageDistributionTimePerBatch", "TotalBatchesRedistributed"};
        HydraUtil.logInfo(prefix + " Calling checkSenderStatistics");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkSenderStatistics " + HydraUtil.ObjectToString(attrList));
    }

    public void startStopSender(JMXOperations ops, ObjectName targetMbean) throws MalformedURLException, IOException {
        HydraUtil.logInfo(prefix + " Calling startStopSender on GW-Sender " + targetMbean);
        String url = ops.selectManagingNode();
        boolean isRunning = (Boolean)ops.getAttribute(url, targetMbean, "Running");
        if (isRunning) {
            AbstractTestMBean.InPlaceJMXNotifValidator validator = new AbstractTestMBean.InPlaceJMXNotifValidator("startStopSender-stop", targetMbean, url);
            this.callJmxOperation(url, ops, this.buildOperationArray("stop", null, null, null), targetMbean);
            validator.expectationList.add(Expectations.forMBean(targetMbean).expectMBeanAt(url).expectNotification("gemfire.distributedsystem.gateway.sender.stopped", this.getWanSenderMemberId(targetMbean), "GatewaySender Stopped in the VM ", null, 4));
            HydraUtil.sleepForReplicationJMX();
            boolean running = (Boolean)ops.getAttribute(url, targetMbean, "Running");
            if (running) {
                throw new TestException("Stop operation failed to stop the gateway sender represented by mbean " + targetMbean);
            }
            validator.validateNotifications();
            validator = new AbstractTestMBean.InPlaceJMXNotifValidator("startStopSender-start", targetMbean, url);
            this.callJmxOperation(url, ops, this.buildOperationArray("start", null, null, null), targetMbean);
            HydraUtil.sleepForReplicationJMX();
            boolean isStarted = (Boolean)ops.getAttribute(url, targetMbean, "Running");
            if (!isStarted) {
                throw new TestException("Start operation failed to stop the gateway sender represented by mbean " + targetMbean);
            }
        } else {
            this.callJmxOperation(url, ops, this.buildOperationArray("start", null, null, null), targetMbean);
            HydraUtil.sleepForReplicationJMX();
            boolean isStarted = (Boolean)ops.getAttribute(url, targetMbean, "Running");
            if (!isStarted) {
                throw new TestException("Start operation failed to stop the gateway sender represented by mbean " + targetMbean);
            }
        }
        HydraUtil.logInfo(prefix + " startStopSender test completed successfully");
    }

    public void pauseResumeSender(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling pauseResumeSender on GW-Sender " + targetMbean);
        String url = ops.selectManagingNode();
        boolean isRunning = (Boolean)ops.getAttribute(url, targetMbean, "Running");
        if (isRunning) {
            ObjectName dsObjectName = MBeanJMXAdapter.getDistributedSystemName();
            AbstractTestMBean.InPlaceJMXNotifValidator validator = new AbstractTestMBean.InPlaceJMXNotifValidator("pauseResumeSender-pause", dsObjectName, url);
            this.callJmxOperation(url, ops, this.buildOperationArray("pause", null, null, null), targetMbean);
            HydraUtil.sleepForReplicationJMX();
            validator.expectationList.add(Expectations.forMBean(dsObjectName).expectMBeanAt(url).expectNotification("gemfire.distributedsystem.gateway.sender.paused", this.getWanSenderMemberId(targetMbean), "GatewaySender Paused in the VM ", null, 4));
            boolean isPaused = (Boolean)ops.getAttribute(url, targetMbean, "Paused");
            if (!isPaused) {
                throw new TestException("Pause operation failed to pause the gateway sender represented by mbean " + targetMbean);
            }
            validator.validateNotifications();
            validator = new AbstractTestMBean.InPlaceJMXNotifValidator("pauseResumeSender-resume", targetMbean, url);
            this.callJmxOperation(url, ops, this.buildOperationArray("resume", null, null, null), targetMbean);
            HydraUtil.sleepForReplicationJMX();
            boolean isResumed = (Boolean)ops.getAttribute(url, targetMbean, "Running");
            if (!isResumed) {
                throw new TestException("Resume operation failed to resume the gateway sender represented by mbean " + targetMbean);
            }
        } else {
            HydraUtil.logInfo(prefix + " Calling GW-Sender is stopeed starting it : " + targetMbean);
            this.callJmxOperation(url, ops, this.buildOperationArray("start", null, null, null), targetMbean);
            HydraUtil.sleepForReplicationJMX();
            HydraUtil.logInfo(prefix + " Now Calling GW-Sender resume() : " + targetMbean);
            this.callJmxOperation(url, ops, this.buildOperationArray("resume", null, null, null), targetMbean);
            HydraUtil.sleepForReplicationJMX();
            boolean isResumed = (Boolean)ops.getAttribute(url, targetMbean, "Running");
            if (!isResumed) {
                throw new TestException("Start/Resume operation failed to resume the gateway sender represented by mbean " + targetMbean);
            }
        }
        HydraUtil.logInfo(prefix + " pauseResumeSender test completed successfully");
    }

    private Object getWanSenderMemberId(ObjectName targetMbean) {
        String name = targetMbean.toString();
        Matcher match = memberPattern.matcher(name.toString());
        String memberName = null;
        if (match.find()) {
            memberName = match.group(2);
        }
        HydraUtil.logFine("WanSenderMember Id = " + memberName + " for ON" + name);
        return memberName;
    }

    @Override
    public void doValidation(JMXOperations ops) {
    }

    static {
        prefix = "GatewaySenderTestMBean : ";
        memberPattern = Pattern.compile("GemFire:service=GatewaySender,gatewaySender=(.*),type=Member,member=(.*)");
    }
}

