/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.jmx;

import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import management.operations.ops.JMXOperations;
import management.operations.ops.jmx.AbstractTestMBean;
import management.test.jmx.JMXTest;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import util.TestException;

public class LockServiceTestMBean
extends AbstractTestMBean<LockServiceTestMBean> {
    public LockServiceTestMBean(List<String> attrs, List<Object[]> ops, String ton, String[] tests) {
        super(attrs, ops, LockServiceTestMBean.class, ton, tests);
    }

    @Override
    public String getType() {
        return gemfireDefinedMBeanTypes[3];
    }

    public void createAndDestroyDLock(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling createAndDestroyDLock");
        HydraUtil.logInfo(prefix + " Calling createDLock");
        String localUrl = "<local>";
        ObjectName oldTargetMbean = targetMbean;
        targetMbean = ManagementUtil.getLocalMemberMBeanON();
        HydraUtil.logInfo("Target mbean for test createDLock has been changed from " + oldTargetMbean + " to " + targetMbean);
        String lockName = JMXTest.getDLockOperations().createDLock();
        this.addLockServiceCreateNotificationExp(lockName);
        ObjectName newLockMBean = MBeanJMXAdapter.getLockServiceMBeanName((String)ManagementUtil.getMemberID(), (String)lockName);
        ObjectName newDistributedLockMBean = MBeanJMXAdapter.getDistributedLockServiceName((String)lockName);
        HydraUtil.sleepForReplicationJMX();
        try {
            MBeanServerConnection server = ops.getMBeanConnection(localUrl);
            if (!ManagementUtil.checkIfMBeanExists(server, newLockMBean)) {
                throw new TestException("Could not locate lockService mbean in local mbean server for DLock " + lockName);
            }
            server = ops.getMBeanConnection(ops.selectManagingNode());
            if (!ManagementUtil.checkIfMBeanExists(server, newLockMBean)) {
                throw new TestException("Could not locate lockService mbean on managing node for DLock " + lockName);
            }
            if (!ManagementUtil.checkIfMBeanExists(server, newDistributedLockMBean)) {
                throw new TestException("Could not locate lockService mbean on managing node for DLock " + lockName);
            }
        }
        catch (IOException e) {
            HydraUtil.logErrorAndRaiseException("Error during checking mbean presence", e);
        }
        HydraUtil.logInfo(prefix + " Completed createDLock test successfully");
        HydraUtil.logInfo(prefix + " Calling destroyDLock");
        HydraUtil.logInfo(prefix + " Selected DLock : " + lockName);
        ObjectName destroyedLockMBean = MBeanJMXAdapter.getLockServiceMBeanName((String)ManagementUtil.getMemberID(), (String)lockName);
        ObjectName destroyedDistributedLockMBean = MBeanJMXAdapter.getDistributedLockServiceName((String)lockName);
        JMXTest.getDLockOperations().destroyLock(lockName);
        this.addLockServiceDestroyNotificationExp(lockName);
        HydraUtil.sleepForReplicationJMX();
        try {
            MBeanServerConnection server = ops.getMBeanConnection(localUrl);
            if (ManagementUtil.checkIfMBeanExists(server, destroyedLockMBean)) {
                throw new TestException("After destroy still lockService mbean is present in local mbean server for DLock " + lockName);
            }
            server = ops.getMBeanConnection(ops.selectManagingNode());
            if (ManagementUtil.checkIfMBeanExists(server, destroyedLockMBean)) {
                throw new TestException("After destroy still lockService mbean is present in  managing node for DLock " + lockName);
            }
            if (ManagementUtil.checkIfMBeanExists(server, destroyedDistributedLockMBean)) {
                throw new TestException("After destroy still lockService mbean is present in  managing node for DLock " + lockName);
            }
        }
        catch (IOException e) {
            HydraUtil.logErrorAndRaiseException("Error during checking mbean presence", e);
        }
        HydraUtil.logInfo(prefix + " Completed destroyDLock test successfully");
        HydraUtil.logInfo(prefix + " Completed createAndDestroyDLock test successfully");
    }

    public void checkDLockConfig(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"Name"};
        HydraUtil.logInfo(prefix + " Calling checkDLockConfig");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkDLockConfig " + HydraUtil.ObjectToString(attrList));
    }

    public void checkDLockCounters(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"MemberCount", "MemberNames"};
        HydraUtil.logInfo(prefix + " Calling checkDLockCounters");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkDLockCounters " + HydraUtil.ObjectToString(attrList));
    }

    public void becomeLockGrantor(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling becomeLockGrantor");
        String url = ops.selectManagingNode();
        this.callJmxOperation(url, ops, this.buildOperationArray("becomeLockGrantor", null, null, null), targetMbean);
        HydraUtil.sleepForReplicationJMX();
        boolean isLockGrantor = (Boolean)ops.getAttribute(url, targetMbean, "LockGrantor");
        HydraUtil.logInfo(prefix + " Result of becomeLockGrantor : " + isLockGrantor);
        HydraUtil.logInfo(prefix + " Completed becomeLockGrantor test successfully");
    }

    public void listThreadsHoldingLock(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling listThreadsHoldingLock");
        String url = ops.selectManagingNode();
        Map result = (Map)this.callJmxOperation(url, ops, this.buildOperationArray("listThreadsHoldingLock", null, null, null), targetMbean);
        HydraUtil.logInfo(prefix + " Result of listThreadsHoldingLock : " + HydraUtil.ObjectToString(result));
        HydraUtil.logInfo(prefix + " Completed listThreadsHoldingLock test successfully");
    }

    public void listHeldLocks(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling listHeldLocks");
        String url = ops.selectManagingNode();
        String[] result = (String[])this.callJmxOperation(url, ops, this.buildOperationArray("listHeldLocks", null, null, null), targetMbean);
        HydraUtil.logInfo(prefix + " Result of listHeldLocks : " + HydraUtil.ObjectToString(result));
        HydraUtil.logInfo(prefix + " Completed listHeldLocks test successfully");
    }

    @Override
    public void doValidation(JMXOperations ops) {
    }

    static {
        prefix = "LockServiceTestMBean : ";
    }
}

