/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.jmx;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.FunctionDomainException;
import com.gemstone.gemfire.cache.query.NameResolutionException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvocationTargetException;
import com.gemstone.gemfire.cache.query.TypeMismatchException;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.ObjectName;
import management.jmx.JMXPrms;
import management.operations.SimpleRegionKeyValueConfig;
import management.operations.events.impl.EntryEvents;
import management.operations.events.impl.RegionEvents;
import management.operations.ops.EntryOperations;
import management.operations.ops.JMXOperations;
import management.operations.ops.jmx.AbstractTestMBean;
import management.util.HydraUtil;
import util.StopStartPrms;
import util.StopStartVMs;

public class PulseTestMBean
extends AbstractTestMBean<PulseTestMBean> {
    private static final long serialVersionUID = 1L;
    private static Map<String, EntryOperations> allEops;

    public PulseTestMBean(List<String> attrs, List<Object[]> ops, String ton, String[] tests) {
        super(attrs, ops, PulseTestMBean.class, ton, tests);
    }

    public void bounceManager(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling bounceManager");
        List vmList = StopStartVMs.getAllVMs();
        ArrayList<ClientVmInfo> selectedVmList = new ArrayList<ClientVmInfo>();
        ArrayList<String> stopModeList = new ArrayList<String>();
        int i = 0;
        for (ClientVmInfo info : vmList) {
            String name = info.getClientName();
            if (!name.startsWith("managing")) continue;
            selectedVmList.add(info);
            stopModeList.add(TestConfig.tab().stringAt(StopStartPrms.stopModes));
            ++i;
            break;
        }
        if (i == 1) {
            StopStartVMs.stopVMs(selectedVmList, stopModeList);
            HydraUtil.sleepForReplicationJMX();
            HydraUtil.sleepForReplicationJMX();
            try {
                Thread.sleep(JMXPrms.pulseManagerHATime());
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } else {
            HydraUtil.logInfo(prefix + " bounceManager did not find any manager");
        }
        StopStartVMs.startVMs(selectedVmList);
        HydraUtil.logInfo("Restarting VMS : " + HydraUtil.ObjectToString(selectedVmList));
        HydraUtil.sleepForReplicationJMX();
        HydraUtil.logInfo(prefix + " Completed bounceManager test successfully");
    }

    public void pulseTest(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling pulseTest");
        this.doEntryOperations();
        this.raiseAlerts();
        HydraUtil.logInfo("Sleeping for 1 seconds ");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        HydraUtil.logInfo("Done Sleeping for 5 seconds ");
        HydraUtil.logInfo(prefix + " Completed pulseTest test successfully");
    }

    private void raiseAlerts() {
        int num = HydraUtil.getnextRandomInt(5);
        if (num == 0) {
            ++num;
        }
        Cache cache = CacheHelper.getCache();
        LogWriter writer = cache.getLogger();
        for (int i = 0; i < num; ++i) {
            String message = "MSG" + System.nanoTime();
            writer.severe(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntryOperations getEntryOperations(String region) {
        Object eop = null;
        Map<String, EntryOperations> map = allEops;
        synchronized (map) {
            if (!allEops.containsKey(region)) {
                Region r = CacheHelper.getCache().getRegion(region);
                EntryOperations eops = new EntryOperations(r, new EntryEvents());
                eops.setKeyValueConfig(new SimpleRegionKeyValueConfig(RemoteTestModule.getMyClientName(), 100000));
                allEops.put(region, eops);
            }
            return allEops.get(region);
        }
    }

    private void doEntryOperations() {
        List<String> regionList = RegionEvents.getAllRegions();
        for (String region : regionList) {
            HydraUtil.logInfo("Doing 10 EntryOperations on " + region);
            EntryOperations eOps = this.getEntryOperations(region);
            for (int i = 0; i < 10; ++i) {
                eOps.doEntryOperation();
            }
            try {
                HydraUtil.logInfo("Doing a queryOperations on " + region);
                String query = null;
                query = !region.contains("/") ? "select * from /" + region : "select * from " + region;
                Cache cache = CacheHelper.getCache();
                Query queryObj = CacheHelper.getCache().getQueryService().newQuery(query);
                HydraUtil.logInfo("Firing query |" + query + "|");
                queryObj.execute();
                HydraUtil.logInfo("Completed query |" + query + "|");
            }
            catch (FunctionDomainException e) {
                HydraUtil.logError("error doing query op", e);
            }
            catch (TypeMismatchException e) {
                HydraUtil.logError("error doing query op", e);
            }
            catch (NameResolutionException e) {
                HydraUtil.logError("error doing query op", e);
            }
            catch (QueryInvocationTargetException e) {
                HydraUtil.logError("error doing query op", e);
            }
        }
        HydraUtil.logInfo("Finished with EntryOperations on " + regionList);
    }

    @Override
    public String getType() {
        return gemfireDefinedMBeanTypes[13];
    }

    @Override
    public void doValidation(JMXOperations ops) {
    }

    static {
        prefix = "PulseTestMBean : ";
        allEops = new HashMap<String, EntryOperations>();
    }
}

