/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.jmx;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.management.EvictionAttributesData;
import com.gemstone.gemfire.management.FixedPartitionAttributesData;
import com.gemstone.gemfire.management.MembershipAttributesData;
import com.gemstone.gemfire.management.PartitionAttributesData;
import com.gemstone.gemfire.management.RegionAttributesData;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import management.jmx.JMXBlackboard;
import management.jmx.JMXPrms;
import management.operations.OperationEvent;
import management.operations.OperationsBlackboard;
import management.operations.events.impl.AbstractEvents;
import management.operations.events.impl.RegionEvents;
import management.operations.ops.JMXOperations;
import management.operations.ops.RegionOperations;
import management.operations.ops.jmx.AbstractTestMBean;
import management.test.federation.FederationBlackboard;
import management.test.jmx.JMXTest;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import util.TestException;
import util.TestHelper;

public class RegionTestMBean
extends AbstractTestMBean<RegionTestMBean> {
    private static boolean validationsComplete;

    public RegionTestMBean(List<String> attrs, List<Object[]> ops, String ton, String[] tests) {
        super(attrs, ops, RegionTestMBean.class, ton, tests);
    }

    @Override
    public String getType() {
        return gemfireDefinedMBeanTypes[2];
    }

    public void createRegion(JMXOperations ops, ObjectName targetMbean) throws IOException {
        HydraUtil.logInfo(prefix + " Calling createRegion");
        String newRegion = null;
        RegionOperations regionOps = JMXTest.getRegionOperations();
        boolean createSubRegion = HydraUtil.getRandomBoolean();
        if (!createSubRegion) {
            newRegion = regionOps.createRegion();
        } else {
            Set<Region> regions = regionOps.getAvailableRegions();
            List destroyedRegions = JMXBlackboard.getBB().getList(JMXBlackboard.REGION_DELETE_LIST);
            HydraUtil.logFine("RegionOperations: Searching replicatged regions in " + HydraUtil.ObjectToString(regions));
            ArrayList<Region> replicatedRegions = new ArrayList<Region>();
            for (Region replR : regions) {
                String path = null;
                path = replR.getParentRegion() != null ? replR.getParentRegion().getFullPath() : replR.getFullPath();
                if (!(replR instanceof DistributedRegion) || destroyedRegions.contains(path)) continue;
                replicatedRegions.add(replR);
            }
            HydraUtil.logFine("RegionOperations: Region eligible for destroy operations " + HydraUtil.ObjectToString(replicatedRegions));
            if (replicatedRegions.size() > 0) {
                newRegion = regionOps.createSubRegion(((Region)HydraUtil.getRandomElement(replicatedRegions)).getFullPath());
            } else {
                throw new TestException("No replicated regions found. Subregions can be created only on replicated regions");
            }
        }
        HydraUtil.logInfo(prefix + " Finished with creating region named " + newRegion + " adding a notif expectation");
        this.addRegionCreateNotificationExp(newRegion);
        Region region = RegionHelper.getRegion(newRegion);
        if (newRegion.contains("Persistent") && !createSubRegion) {
            String diskStoreName = region.getAttributes().getDiskStoreName();
            if (diskStoreName == null) {
                throw new TestException("Diskstore returned null for persistent region " + newRegion);
            }
            this.addDiskStoreCreatedNotificationExp(diskStoreName);
        }
        if (region == null) {
            throw new TestException("Could not find newly created Region " + newRegion);
        }
        String regionPath = region.getFullPath();
        HydraUtil.logInfo(prefix + " Waiting for sleepReplication");
        HydraUtil.sleepForReplicationJMX();
        InternalDistributedMember distributedMember = InternalDistributedSystem.getConnectedInstance().getDistributedMember();
        ObjectName regionName = JMXTest.getManagementService().getRegionMBeanName((DistributedMember)distributedMember, regionPath);
        ObjectName distributedRegionName = MBeanJMXAdapter.getDistributedRegionMbeanName((String)regionPath);
        String url = ops.selectManagingNode();
        boolean runningOnManaingNode = RemoteTestModule.getMyClientName().contains("managing");
        MBeanServerConnection server = null;
        if (runningOnManaingNode) {
            server = ManagementUtil.getPlatformMBeanServerDW();
            HydraUtil.logInfo(prefix + " Checking for " + regionPath + " local platform mbeanServer");
        } else {
            server = ManagementUtil.connectToUrlOrGemfireProxy(url);
            HydraUtil.logInfo(prefix + " Checking for " + regionPath + " MBeans at node " + url);
        }
        targetMbean = regionName;
        if (!ManagementUtil.checkIfMBeanExists(server, targetMbean)) {
            throw new TestException("Could not find mean " + targetMbean + " on manager " + url);
        }
        targetMbean = distributedRegionName;
        if (!ManagementUtil.checkIfMBeanExists(server, targetMbean)) {
            throw new TestException("Could not find mean " + targetMbean + " on manager " + url);
        }
        HydraUtil.logInfo(prefix + " Completed createRegion test successfully");
    }

    public void destroyRegion(JMXOperations ops, ObjectName targetMbean) throws IOException {
        HydraUtil.logInfo(prefix + " Calling destroyRegion");
        RegionOperations regionOps = JMXTest.getRegionOperations();
        List<String> regions = RegionEvents.getAllRegions(RemoteTestModule.getMyClientName());
        List deletedRegions = JMXBlackboard.getBB().getList(JMXBlackboard.REGION_DELETE_LIST);
        HydraUtil.logInfo(prefix + " Regions Created in this VM : " + regions);
        HydraUtil.logInfo(prefix + " Regions Deleted in all VMs : " + deletedRegions);
        Region regionToDelete = null;
        for (int i = 0; i < regions.size() && ((regionToDelete = RegionHelper.getRegion(regions.get(i))) == null || deletedRegions.equals(regionToDelete)); ++i) {
        }
        if (regionToDelete != null) {
            String name = regionToDelete.getName();
            String regionPath = regionToDelete.getFullPath();
            regionOps.destroyRegion(regionToDelete);
            JMXBlackboard.getBB().addToList(JMXBlackboard.REGION_DELETE_LIST, regionPath);
            HydraUtil.logInfo(prefix + " Finished with destroying region named " + name + " adding a notif expectation");
            this.addRegionDestroyNotificationExp(regionPath);
            HydraUtil.logInfo(prefix + " Waiting for sleepReplication");
            HydraUtil.sleepForReplicationJMX();
            InternalDistributedMember distributedMember = InternalDistributedSystem.getConnectedInstance().getDistributedMember();
            ObjectName regionName = JMXTest.getManagementService().getRegionMBeanName((DistributedMember)distributedMember, regionPath);
            ObjectName distributedRegionName = MBeanJMXAdapter.getDistributedRegionMbeanName((String)regionPath);
            String url = ops.selectManagingNode();
            MBeanServerConnection server = ManagementUtil.connectToUrlOrGemfireProxy(url);
            HydraUtil.logInfo(prefix + " Checking for " + regionPath + " MBeans at node " + url);
            targetMbean = regionName;
            if (ManagementUtil.checkIfMBeanExists(server, targetMbean)) {
                throw new TestException("Proxy to " + targetMbean + " is stil present at " + url);
            }
            targetMbean = distributedRegionName;
            if (ManagementUtil.checkIfMBeanExists(server, targetMbean)) {
                throw new TestException("Proxy to " + targetMbean + " is stil present at " + url);
            }
        } else {
            throw new TestException("No Regions found in this VM for destoroRegion Test case");
        }
        HydraUtil.logInfo(prefix + " Completed destroyRegion test successfully");
    }

    public void checkRegionStatistics(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkRegionStatistics");
        String[] attributes = new String[]{"GetsRate", "PutsRate", "CreatesRate", "DestroyRate", "PutAllRate", "PutLocalRate", "PutRemoteRate", "PutRemoteLatency", "PutRemoteAvgLatency", "DiskReadsRate", "DiskWritesRate", "CacheWriterCallsAvgLatency", "CacheListenerCallsAvgLatency", "LruEvictionRate", "LruDestroyRate"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkRegionStatistics " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkRegionStatistics test successfully");
    }

    public void checkRegionRuntimeAttributes(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkRegionRuntimeAttributes");
        String[] attributes = new String[]{"LastModifiedTime", "LastAccessedTime", "MissCount", "HitCount", "HitRatio", "EntryCount", "TotalEntriesOnlyOnDisk", "TotalDiskEntriesInVM"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkRegionRuntimeAttributes " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkRegionRuntimeAttributes test successfully");
    }

    public void checkRegionConfigAttributes(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkRegionConfigAttributes");
        String[] attributes = new String[]{"Name", "RegionType", "FullPath", "ParentRegion"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkRegionConfigAttributes " + HydraUtil.ObjectToString(attrList));
        if (!JMXPrms.useGemfireProxies()) {
            CompositeData gemfireProp = (CompositeData)this.callJmxOperation(url, ops, this.buildOperationArray("listRegionAttributes", null, null, null), targetMbean);
            HydraUtil.logInfo("checkRegionConfigAttributes:listRegionAttributes " + HydraUtil.ObjectToString(gemfireProp));
            gemfireProp = (CompositeData)this.callJmxOperation(url, ops, this.buildOperationArray("listPartitionAttributes", null, null, null), targetMbean);
            HydraUtil.logInfo("checkRegionConfigAttributes:listPartitionAttributes " + HydraUtil.ObjectToString(gemfireProp));
            gemfireProp = (CompositeData)this.callJmxOperation(url, ops, this.buildOperationArray("listFixedPartitionAttributes", null, null, null), targetMbean);
            HydraUtil.logInfo("checkRegionConfigAttributes:listFixedPartitionAttributesData " + HydraUtil.ObjectToString(gemfireProp));
            gemfireProp = (CompositeData)this.callJmxOperation(url, ops, this.buildOperationArray("listEvictionAttributes", null, null, null), targetMbean);
            HydraUtil.logInfo("checkRegionConfigAttributes:listEvictionAttributes " + HydraUtil.ObjectToString(gemfireProp));
            gemfireProp = (CompositeData)this.callJmxOperation(url, ops, this.buildOperationArray("listMembershipAttributes", null, null, null), targetMbean);
            HydraUtil.logInfo("checkRegionConfigAttributes:listMembershipAttributes " + HydraUtil.ObjectToString(gemfireProp));
        } else {
            RegionAttributesData gemfireProp = (RegionAttributesData)this.callJmxOperation(url, ops, this.buildOperationArray("listRegionAttributes", null, null, null), targetMbean);
            HydraUtil.logInfo("checkRegionConfigAttributes:listRegionAttributes " + HydraUtil.ObjectToString(gemfireProp));
            PartitionAttributesData gemfireProp2 = (PartitionAttributesData)this.callJmxOperation(url, ops, this.buildOperationArray("listPartitionAttributes", null, null, null), targetMbean);
            HydraUtil.logInfo("checkRegionConfigAttributes:listRegionAttributes " + HydraUtil.ObjectToString(gemfireProp2));
            FixedPartitionAttributesData[] gemfireProp3 = (FixedPartitionAttributesData[])this.callJmxOperation(url, ops, this.buildOperationArray("listFixedPartitionAttributes", null, null, null), targetMbean);
            HydraUtil.logInfo("checkRegionConfigAttributes:listRegionAttributes " + HydraUtil.ObjectToString(gemfireProp3));
            EvictionAttributesData gemfireProp4 = (EvictionAttributesData)this.callJmxOperation(url, ops, this.buildOperationArray("listEvictionAttributes", null, null, null), targetMbean);
            HydraUtil.logInfo("checkRegionConfigAttributes:listRegionAttributes " + HydraUtil.ObjectToString(gemfireProp4));
            MembershipAttributesData gemfireProp5 = (MembershipAttributesData)this.callJmxOperation(url, ops, this.buildOperationArray("listMembershipAttributes", null, null, null), targetMbean);
            HydraUtil.logInfo("checkRegionConfigAttributes:listRegionAttributes " + HydraUtil.ObjectToString(gemfireProp5));
        }
        HydraUtil.logInfo(prefix + " Completed checkRegionConfigAttributes test successfully");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doValidation(JMXOperations ops) {
        try {
            Class<RegionTestMBean> clazz = RegionTestMBean.class;
            synchronized (RegionTestMBean.class) {
                if (!validationsComplete) {
                    Map map;
                    validationsComplete = true;
                    int count = 0;
                    if (JMXPrms.useGemfireProxies()) {
                        map = FederationBlackboard.getBB().getManagerONs();
                        count = map.size();
                    } else {
                        map = FederationBlackboard.getBB().getMemberONs();
                        count = map.size();
                    }
                    HydraUtil.logInfo("Waiting for even VM to export events to blackboard and updates its counters");
                    String clientName = RemoteTestModule.getMyClientName();
                    TestHelper.waitForCounter(JMXBlackboard.getBB(), "TASKS_COMPLETE_COUNT", JMXBlackboard.VM_TASKS_COMPLETE_COUNT, count, true, 10000L);
                    AbstractEvents createEvents = AbstractEvents.importFromBlackBoard("EVENT_REGION_ADDED", clientName, OperationsBlackboard.getBB());
                    AbstractEvents destroyEvents = AbstractEvents.importFromBlackBoard("EVENT_REGION_DESTROYED", clientName, OperationsBlackboard.getBB());
                    ArrayList<String> regions = new ArrayList<String>();
                    ArrayList<String> destroyedRegion = new ArrayList<String>();
                    for (OperationEvent e : createEvents.getEvents("EVENT_REGION_ADDED")) {
                        regions.add((String)e.data);
                    }
                    for (OperationEvent e : destroyEvents.getEvents("EVENT_REGION_DESTROYED")) {
                        destroyedRegion.add((String)e.data);
                    }
                    for (OperationEvent name : JMXBlackboard.getBB().getList(JMXBlackboard.REGION_DELETE_LIST)) {
                        if (destroyedRegion.contains(name)) continue;
                        destroyedRegion.add((String)((Object)name));
                    }
                    HydraUtil.logInfo("Checking to see if region " + destroyedRegion + " still exists.");
                    String url = ops.selectManagingNode();
                    MBeanServerConnection server = ManagementUtil.connectToUrlOrGemfireProxy(url);
                    for (String name : destroyedRegion) {
                        InternalDistributedMember distributedMember = InternalDistributedSystem.getConnectedInstance().getDistributedMember();
                        ObjectName regionName = JMXTest.getManagementService().getRegionMBeanName((DistributedMember)distributedMember, name);
                        if (ManagementUtil.checkIfMBeanExists(server, regionName)) {
                            throw new TestException("MBean " + regionName + " is not expected");
                        }
                        regions.remove(name);
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            throw new TestException("Error doing validation ", e);
        }
        {
            return;
        }
    }

    static {
        prefix = "RegionTestMBean : ";
        validationsComplete = false;
    }
}

