/*
 * Decompiled with CFR 0.152.
 */
package management.test.cli;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.internal.cli.dto.Key1;
import com.gemstone.gemfire.management.internal.cli.dto.Value2;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.CachePrms;
import hydra.ClientPrms;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GatewayReceiverHelper;
import hydra.GatewaySenderHelper;
import hydra.GatewaySenderPrms;
import hydra.GemFireDescription;
import hydra.HydraThreadLocal;
import hydra.HydraVector;
import hydra.JMXManagerBlackboard;
import hydra.JMXManagerHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import management.cli.CLIBlackboard;
import management.cli.GfshPrms;
import management.cli.TestableGfsh;
import management.operations.OperationsBlackboard;
import management.operations.RegionKeyValueConfig;
import management.operations.SimpleRegionKeyValueConfig;
import management.operations.events.impl.AbstractEvents;
import management.operations.events.impl.EntryEvents;
import management.operations.events.impl.FunctionEvents;
import management.operations.events.impl.RegionEvents;
import management.operations.ops.CLIOperations;
import management.operations.ops.EntryOperations;
import management.operations.ops.FunctionOperations;
import management.operations.ops.RegionOperations;
import management.operations.ops.cli.TestCommand;
import management.operations.ops.cli.TestCommandExecutor;
import management.operations.ops.cli.TestCommandInstance;
import management.test.cli.ShellCommandTest;
import management.test.federation.FederationBlackboard;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import util.TestException;
import util.TestHelper;

public class CLITest {
    private static CLITest cliTestInstance;
    private DistributedSystem ds = null;
    private GemFireCacheImpl cache = null;
    private ManagementService service;
    private CacheServer server = null;
    private HydraThreadLocal regionHT = new HydraThreadLocal();
    private HydraThreadLocal entryHT = new HydraThreadLocal();
    private HydraThreadLocal cliHT = new HydraThreadLocal();
    private HydraThreadLocal functionHT = new HydraThreadLocal();
    public static final String REGION_NAME = "OperationsRegion";
    private static HydraThreadLocal regionKeyValueConfigHL;
    public static HydraThreadLocal commands;
    public static HydraThreadLocal tGfshInstances;
    public static HydraThreadLocal outputFileHL;
    private static final String dataRegionName = "PartitionBridge";
    private static final String jsonRegionName = "PartitionJSONBridge";
    private static final String childRegionNames = "ReplicatedNoAckBridge";
    private Region dataStringRegion = null;
    private Region dataJsonRegion = null;
    private Region[] regionHierarchyRegions = null;
    private static List<String> regionList;
    public static List<String> failedCommands;
    public static StringBuilder currentCommand;
    public static boolean hasCommandFailed;

    public static synchronized void HydraInitTask_startLocator() {
        if (cliTestInstance == null) {
            cliTestInstance = new CLITest();
        }
        cliTestInstance.startLocator();
    }

    public static synchronized void HydraInitTask_initialize() {
        if (cliTestInstance == null) {
            cliTestInstance = new CLITest();
        }
        cliTestInstance.initializeCLI();
    }

    public static void HydraInitTask_becomeManager() {
        cliTestInstance.becomeManager();
    }

    public static synchronized void HydraInitTask_createRegionsOnEdge() {
        cliTestInstance.createRegionsOnEdge();
    }

    public static synchronized void HydraInitTask_createRegionsOnBridge() {
        cliTestInstance.createRegionsOnBridge();
    }

    public static synchronized void HydraInitTask_createDataRegions() {
        cliTestInstance.createDataRegions();
    }

    public static synchronized void HydraInitTask_registerFunctions() {
        cliTestInstance.registerFunctions();
    }

    public static void HydraInitTask_startWANSendersAndReceivers() {
        cliTestInstance.startWANSendersAndReceivers();
    }

    public static void HydraCloseTask_printEvents() {
        cliTestInstance.printEvents();
    }

    public static void HydraCloseTask_validateEvents() {
    }

    public static void HydraCloseTask_printFailedCommands() {
        StringBuilder sb = new StringBuilder();
        for (String s : failedCommands) {
            sb.append(s).append("\n");
        }
        HydraUtil.logInfo("Failed Commands " + failedCommands.size());
        if (failedCommands.size() > 0) {
            HydraUtil.logErrorAndRaiseException("Failed Commands " + sb.toString());
        }
    }

    public static void HydraCloseTask_PrintRegionOps() {
        HydraUtil.logInfo("Printing all events ");
        HydraUtil.logInfo("Printing all commands ");
        StringBuilder sb = (StringBuilder)commands.get();
        HydraUtil.logInfo(sb.toString());
    }

    public static void HydraTask_cliOps() {
        CLIBlackboard.getBB().printSharedCounters();
        long numCommandsCompleted = CLIBlackboard.getBB().getSharedCounters().incrementAndRead(CLIBlackboard.gfshExecutionNumberCompleted);
        if (numCommandsCompleted == (long)GfshPrms.getNumCommandToExecute()) {
            throw new StopSchedulingOrder("CLITest : Finished with " + numCommandsCompleted + " commands as configured. Test is exiting now");
        }
        long gfshCount = CLITest.logGfshExecutionNumber();
        HydraUtil.logInfo("CLITest : Cli operation task : " + gfshCount);
        currentCommand = new StringBuilder();
        hasCommandFailed = false;
        TestCommand selecteCommand = CLITest.selectCommand();
        TestCommandInstance selectedMOde = selecteCommand.getRandomCommandInstnance();
        HydraUtil.logInfo("Selecting command for iteration #" + gfshCount + " : " + selecteCommand.command);
        CLITest.executeAndVerifyCommand(selecteCommand, selectedMOde);
        if (hasCommandFailed) {
            failedCommands.add("Command # " + gfshCount + " " + currentCommand.toString());
        }
        HydraUtil.logInfo("CLITest : Cli operation task #" + gfshCount + " completed successfully");
    }

    public static TestCommand selectCommand() {
        String command = TestConfig.tab().stringAt(GfshPrms.cliCommands);
        HydraUtil.logInfo("CLITest :  Selected Command " + command);
        HashMap commandMap = (HashMap)CLIBlackboard.getBB().getMap("commandMap");
        if (commandMap.containsKey(command)) {
            TestCommand testCommand = (TestCommand)commandMap.get(command);
            return testCommand;
        }
        throw new TestException("Command descriptor for " + command + " not found. Please check your hydra configurations.");
    }

    private static void executeAndVerifyCommand(TestCommand testCommand, TestCommandInstance instance) {
        TestCommandExecutor executor = testCommand.getExecutor();
        HydraUtil.logInfo("CLITest : Executing command {<" + instance.toString() + ">}");
        StringBuilder sb = (StringBuilder)commands.get();
        String command = instance.toString();
        command = command.replaceAll(HydraUtil.NEW_LINE, HydraUtil.NEW_LINE + "\t" + "\t");
        currentCommand.append("Command <").append(command).append("> ");
        Object result = executor.executeAndVerify(instance);
        HydraUtil.logInfo("CLITest : Successfully completed executing command {<" + instance.toString() + ">}");
    }

    public static void HydraTask_shellCommands() {
        cliTestInstance.doShellCommandTests();
    }

    public static ManagementService getManagementService() {
        return CLITest.cliTestInstance.service;
    }

    public static HydraThreadLocal getRegionHT() {
        return CLITest.cliTestInstance.regionHT;
    }

    private static HydraThreadLocal getEntryOpHT() {
        return CLITest.cliTestInstance.entryHT;
    }

    private static HydraThreadLocal getCLIOpHT() {
        return CLITest.cliTestInstance.cliHT;
    }

    private static HydraThreadLocal getFuncHT() {
        return CLITest.cliTestInstance.functionHT;
    }

    public static String getStringRegionName() {
        return CLITest.cliTestInstance.dataStringRegion.getName();
    }

    public static String getJSONRegionName() {
        return CLITest.cliTestInstance.dataJsonRegion.getName();
    }

    private void startLocator() {
        DistributedSystemHelper.createLocator();
        DistributedSystemHelper.startLocatorAndDS();
        this.waitForLocatorDiscovery();
    }

    protected void waitForLocatorDiscovery() {
        boolean isDiscovered;
        HydraUtil.logInfo("Waititng for locator discovery.");
        do {
            isDiscovered = true;
            List locators = Locator.getLocators();
            ConcurrentMap gfLocMap = ((InternalLocator)locators.get(0)).getAllLocatorsInfo();
            ArrayList<Integer> dsList = new ArrayList<Integer>();
            for (GemFireDescription gfd : TestConfig.getInstance().getGemFireDescriptions().values()) {
                Integer ds = gfd.getDistributedSystemId();
                if (ds.equals(-1) || dsList.contains(ds) || gfLocMap.containsKey(ds)) continue;
                dsList.add(ds);
                isDiscovered = false;
            }
            if (isDiscovered) continue;
            HydraUtil.logInfo("Waiting for locator discovery to complete. Locators not discoverd so far from ds " + dsList + ". Distribution locator map from gemfire system is " + new ConcurrentHashMap(gfLocMap).toString());
            MasterController.sleepForMs(5000);
        } while (!isDiscovered);
        HydraUtil.logInfo("Locator discovery completed.");
    }

    public static RegionKeyValueConfig getRegionKeyValueConfig() {
        RegionKeyValueConfig regionkeyValueConfig = (RegionKeyValueConfig)regionKeyValueConfigHL.get();
        if (regionkeyValueConfig == null) {
            regionkeyValueConfig = new SimpleRegionKeyValueConfig("KEY" + RemoteTestModule.getCurrentThread().getThreadId(), 100000);
            regionKeyValueConfigHL.set(regionkeyValueConfig);
        }
        return regionkeyValueConfig;
    }

    public static synchronized RegionOperations getRegionOperations() {
        RegionOperations regionOps = (RegionOperations)CLITest.getRegionHT().get();
        if (regionOps == null) {
            regionOps = new RegionOperations((Cache)CLITest.cliTestInstance.cache, new RegionEvents());
            CLITest.getRegionHT().set(regionOps);
        }
        return regionOps;
    }

    public static synchronized FunctionOperations getFunctionOperations() {
        FunctionOperations funcOps = (FunctionOperations)CLITest.getFuncHT().get();
        if (funcOps == null) {
            funcOps = new FunctionOperations(new FunctionEvents());
            CLITest.getFuncHT().set(funcOps);
        }
        return funcOps;
    }

    public static synchronized CLIOperations getCLIOperations() {
        CLIOperations cliOps = (CLIOperations)CLITest.getCLIOpHT().get();
        if (cliOps == null) {
            cliOps = new CLIOperations();
            cliOps.selectCommand();
            cliOps.getSelectedcommandMode();
            CLITest.getCLIOpHT().set(cliOps);
        }
        return cliOps;
    }

    public static PrintWriter getGfshOutputFile() {
        return (PrintWriter)outputFileHL.get();
    }

    public static synchronized TestableGfsh getTestableShell() {
        TestableGfsh shell = (TestableGfsh)tGfshInstances.get();
        if (shell == null) {
            Gfsh.SUPPORT_MUTLIPLESHELL = true;
            String[] argss = new String[]{};
            try {
                String tName = Thread.currentThread().getName();
                shell = new TestableGfsh(tName, true, argss);
                shell.start();
                PrintWriter commandOutputFile = null;
                String fileName = "commandOutput_" + RemoteTestModule.getMyPid() + "_" + tName;
                try {
                    commandOutputFile = new PrintWriter(new FileOutputStream(new File(fileName)));
                }
                catch (FileNotFoundException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
                outputFileHL.set(commandOutputFile);
            }
            catch (ClassNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IOException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            tGfshInstances.set(shell);
        }
        return shell;
    }

    public static synchronized EntryOperations getEntryOperations(String region) {
        EntryOperations entryOps;
        HashMap<String, EntryOperations> entryOpsMap = (HashMap<String, EntryOperations>)CLITest.getEntryOpHT().get();
        if (entryOpsMap == null) {
            entryOpsMap = new HashMap<String, EntryOperations>();
            CLITest.getEntryOpHT().set(entryOpsMap);
        }
        if ((entryOps = (EntryOperations)entryOpsMap.get(region)) == null) {
            Region regionObject = CLITest.cliTestInstance.cache.getRegion(region);
            if (regionObject != null) {
                entryOps = new EntryOperations(regionObject, new EntryEvents());
                entryOps.setKeyValueConfig(CLITest.getRegionKeyValueConfig());
                entryOpsMap.put(region, entryOps);
            } else {
                throw new TestException("Region does not exist " + region);
            }
        }
        return entryOps;
    }

    protected static long logGfshExecutionNumber() {
        long exeNum = CLIBlackboard.getBB().getSharedCounters().incrementAndRead(CLIBlackboard.gfshExecutionNumber);
        Log.getLogWriter().info("Beginning Gfsh task with execution number " + exeNum);
        return exeNum;
    }

    protected static long logGemfireExecutionNumber() {
        long exeNum = CLIBlackboard.getBB().getSharedCounters().incrementAndRead(CLIBlackboard.gemfireExecutionNumber);
        Log.getLogWriter().info("Beginning Gemfire task with execution number " + exeNum);
        return exeNum;
    }

    private void doShellCommandTests() {
        ShellCommandTest.testConnectDisconnect();
        ShellCommandTest.testHelp();
        ShellCommandTest.testHint();
        ShellCommandTest.testSetVariableAndEcho();
        ShellCommandTest.testEncryptPassword();
    }

    private void initializeCLI() {
        CLIBlackboard.getBB().initBlackBoard();
        String clientName = RemoteTestModule.getMyClientName();
        if (!clientName.contains("gfsh")) {
            this.createCache();
            String memberName = ManagementUtil.getMemberID();
            FederationBlackboard.getBB().addMemberName("vmId" + RemoteTestModule.getMyVmid(), memberName);
        }
        if (!(clientName.contains("edge") || clientName.contains("managing") || clientName.contains("gfsh"))) {
            ManagementUtil.saveMemberMbeanInBlackboard();
        }
        if (!clientName.contains("edge") && !clientName.contains("gfsh") && this.service == null) {
            this.service = ManagementService.getManagementService((Cache)this.cache);
            if (!ManagementUtil.checkLocalMemberMBean()) {
                throw new TestException("Could not find MemberMbean in platform mbean server");
            }
        }
    }

    public String selectManagingNode() {
        Collection<String> urls = FederationBlackboard.getBB().getManagingNodes();
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(urls);
        return (String)HydraUtil.getRandomElement(list);
    }

    private void printEvents() {
        HydraVector printEventsList = TestConfig.tab().vecAt(GfshPrms.printEventsList);
        boolean exportRegionEvents = false;
        boolean exportDlocknEvents = false;
        boolean exportFuncnEvents = false;
        for (int i = 0; i < printEventsList.size(); ++i) {
            String eventName = (String)printEventsList.get(i);
            if (eventName.contains("REGION")) {
                exportRegionEvents = true;
            }
            if (eventName.contains("DLOCK")) {
                exportDlocknEvents = true;
            }
            if (!eventName.contains("FUNCT")) continue;
            exportFuncnEvents = true;
        }
        if (exportRegionEvents) {
            RegionEvents regionEvents = (RegionEvents)CLITest.getRegionOperations().getOperationRecorder();
            HydraUtil.logInfo("Exporting region events");
            regionEvents.exportToBlackBoard(OperationsBlackboard.getBB());
        }
        if (exportFuncnEvents) {
            FunctionEvents regionEvents = (FunctionEvents)CLITest.getFunctionOperations().getOperationRecorder();
            HydraUtil.logInfo("Exporting region events");
            regionEvents.exportToBlackBoard(OperationsBlackboard.getBB());
        }
        HydraVector clientNames = TestConfig.tab().vecAt(ClientPrms.names);
        Iterator iterator = clientNames.iterator();
        int count = 0;
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            if (!name.contains("gfsh")) continue;
            ++count;
        }
        CLIBlackboard.getBB().getSharedCounters().increment(CLIBlackboard.VM_TASKS_COMPLETE_COUNT);
        HydraUtil.logInfo("Waiting for even VM to export events to blackboard and updates its counters");
        TestHelper.waitForCounter(CLIBlackboard.getBB(), "TASKS_COMPLETE_COUNT", CLIBlackboard.VM_TASKS_COMPLETE_COUNT, count, true, 10000L);
        for (int i = 0; i < printEventsList.size(); ++i) {
            String eventName = (String)printEventsList.get(i);
            Map<String, AbstractEvents> emap = AbstractEvents.importFromBlackBoard(eventName, OperationsBlackboard.getBB());
            if (emap != null) {
                for (Map.Entry<String, AbstractEvents> e : emap.entrySet()) {
                    String clientName = e.getKey();
                    AbstractEvents ae = e.getValue();
                    HydraUtil.logInfo("Events from client " + clientName);
                    ae.printEvents();
                }
                continue;
            }
            HydraUtil.logInfo("No events found of type " + eventName);
        }
    }

    private void createRegionsOnBridge() {
        RegionOperations regionOps = CLITest.getRegionOperations();
        HydraVector regionList = TestConfig.tab().vecAt(GfshPrms.regionListToStartWith);
        HydraUtil.logInfo("Creating regions on gemfire bridges : ");
        int count = 1;
        for (int i = 0; i < regionList.size(); ++i) {
            String name = (String)regionList.get(i);
            if (!name.contains("Bridge")) continue;
            int index = name.indexOf("Bridge");
            String rName = "Test" + name.substring(0, index) + "_" + count++;
            HydraUtil.logInfo("Creating region named " + rName + " with template " + name);
            regionOps.createRegion(rName, name);
            HydraUtil.logInfo("Created region named " + rName + " with template " + name);
        }
        RegionEvents regionEvents = (RegionEvents)regionOps.getOperationRecorder();
        regionEvents.exportToBlackBoard(OperationsBlackboard.getBB());
    }

    private void createDataRegions() {
        int i;
        RegionOperations regionOps = CLITest.getRegionOperations();
        HydraUtil.logInfo("Creating data-regions on gemfire bridges : ");
        String dataRegionCreated = regionOps.createRegion(dataRegionName);
        this.dataStringRegion = RegionHelper.getRegion(dataRegionCreated);
        if (this.dataStringRegion == null) {
            throw new TestException("Error in creating data region, its null");
        }
        for (int i2 = 0; i2 < 1000; ++i2) {
            this.dataStringRegion.put((Object)("KEY_" + i2), (Object)("VALUE_" + i2));
        }
        dataRegionCreated = regionOps.createRegion(jsonRegionName);
        this.dataJsonRegion = RegionHelper.getRegion(dataRegionCreated);
        if (this.dataJsonRegion == null) {
            throw new TestException("Error in creating data region, its null");
        }
        int numTopRegions = TestConfig.tab().intAt(GfshPrms.regionHierarchyWidth);
        int numChildRegions = TestConfig.tab().intAt(GfshPrms.regionHierarchyWidth);
        int regionCount = 0;
        int totalRegions = numTopRegions + numTopRegions * numChildRegions;
        this.regionHierarchyRegions = new Region[totalRegions];
        for (i = 0; i < numTopRegions; ++i) {
            String genName = regionOps.createRegion(childRegionNames);
            Region topRegion = RegionHelper.getRegion(genName);
            this.regionHierarchyRegions[regionCount++] = topRegion;
            Region parentRegion = topRegion;
            for (int j = 0; j < numChildRegions; ++j) {
                HydraUtil.logInfo("Creating subregion named " + parentRegion.getName() + "_" + j);
                Region childRegion = parentRegion.createSubregion(parentRegion.getName() + "_" + j, parentRegion.getAttributes());
                HydraUtil.logInfo("Created subregion named " + childRegion.getFullPath());
                this.regionHierarchyRegions[regionCount++] = childRegion;
                CLITest.getRegionOperations().getOperationRecorder().regionAdded(childRegion);
                parentRegion = childRegion;
            }
        }
        for (i = 0; i < 1000; ++i) {
            Key1 key = new Key1();
            String keyId = "KEY_" + i;
            key.setId(keyId);
            key.setName(keyId);
            Value2 value = new Value2();
            value.setStateName(key.toString());
            value.setAreaInSqKm(0.0);
            value.setCapitalCity(key.toString());
            value.setPopulation(0);
            this.dataJsonRegion.put((Object)key, (Object)value);
        }
        for (i = 0; i < 1000; ++i) {
            Region region = HydraUtil.getRandomElement(this.regionHierarchyRegions);
            region.put((Object)("KEY_" + i), (Object)("VALUE_" + i));
        }
        RegionEvents regionEvents = (RegionEvents)regionOps.getOperationRecorder();
        regionEvents.exportToBlackBoard(OperationsBlackboard.getBB());
    }

    private void createRegionsOnEdge() {
        HydraUtil.logInfo("Creating region on gemfire clients");
        RegionOperations regionOps = CLITest.getRegionOperations();
        HydraVector regionList = TestConfig.tab().vecAt(GfshPrms.regionListToStartWith);
        HydraUtil.logInfo("Creating regions on gemfire edges : ");
        int count = 1;
        for (int i = 0; i < regionList.size(); ++i) {
            String name = (String)regionList.get(i);
            if (!name.contains("Edge")) continue;
            int index = name.indexOf("Edge");
            String rName = "Test" + name.substring(0, index) + "_" + count++;
            HydraUtil.logInfo("Creating region named " + rName + " with template " + name);
            regionOps.createRegion(rName, name);
            HydraUtil.logInfo("Created region named " + rName + " with template " + name);
        }
    }

    private void starBridgeServer() {
        if (this.server == null) {
            String bridgeConfig = TestConfig.tab().stringAt(BridgePrms.names);
            this.server = BridgeHelper.startBridgeServer(bridgeConfig);
            HydraUtil.logInfo("Started cacheServer on " + RemoteTestModule.getMyClientName());
            HydraUtil.logInfo("Has server started " + this.server.isRunning());
        }
    }

    private void registerFunctions() {
        CLITest.getFunctionOperations().registerFunctions();
        FunctionEvents funcEvents = (FunctionEvents)CLITest.getFunctionOperations().getOperationRecorder();
        funcEvents.exportToBlackBoard(OperationsBlackboard.getBB());
    }

    private void createCache() {
        if (this.cache == null) {
            String clientName = RemoteTestModule.getMyClientName();
            String cacheConfig = TestConfig.tab().stringAt(CachePrms.names);
            this.cache = (GemFireCacheImpl)CacheHelper.createCache(cacheConfig);
            this.ds = this.cache.getDistributedSystem();
        }
    }

    private void becomeManager() {
        ManagementUtil.saveMemberManagerInBlackboard();
        if (!this.service.isManager()) {
            this.service.startManager();
        }
        HydraUtil.sleepForReplicationJMX();
        try {
            ManagementUtil.checkIfThisMemberIsCompliantManager(ManagementFactory.getPlatformMBeanServer());
        }
        catch (IOException e) {
            throw new TestException("Error connecting manager", e);
        }
        catch (TestException e) {
            throw e;
        }
        HydraUtil.logInfo("JMX Manager Blackboard ");
        JMXManagerBlackboard.getInstance().print();
        HydraUtil.logInfo("JMX Manager Endpoints  " + HydraUtil.ObjectToString(JMXManagerHelper.getEndpoints()));
    }

    private void startWANSendersAndReceivers() {
        String receiverConfig = ConfigPrms.getGatewayReceiverConfig();
        HydraVector names = TestConfig.tab().vecAt(GatewaySenderPrms.names);
        Set<GatewayReceiver> rs = GatewayReceiverHelper.createAndStartGatewayReceivers(receiverConfig);
        for (GatewayReceiver r : rs) {
            HydraUtil.logInfo("Started GatewayReceiver " + r);
        }
        String wanDsSenderName = "GW_SENDER_ID_LIST_" + ManagementUtil.getWanSiteName();
        String wanDsRunningSenderName = "GW_SENDER_RUNNING_" + ManagementUtil.getWanSiteName();
        String wanDsStoppedSenderName = "GW_SENDER_STOPPED_" + ManagementUtil.getWanSiteName();
        String wanDsPausedSenderName = "GW_SENDER_PAUSED_" + ManagementUtil.getWanSiteName();
        if (!CLIBlackboard.getBB().getSharedMap().containsKey(wanDsSenderName)) {
            CLIBlackboard.getBB().getSharedMap().put(wanDsSenderName, new ArrayList());
        }
        if (!CLIBlackboard.getBB().getSharedMap().containsKey(wanDsRunningSenderName)) {
            CLIBlackboard.getBB().getSharedMap().put(wanDsRunningSenderName, new ArrayList());
        }
        if (!CLIBlackboard.getBB().getSharedMap().containsKey(wanDsStoppedSenderName)) {
            CLIBlackboard.getBB().getSharedMap().put(wanDsStoppedSenderName, new ArrayList());
        }
        if (!CLIBlackboard.getBB().getSharedMap().containsKey(wanDsPausedSenderName)) {
            CLIBlackboard.getBB().getSharedMap().put(wanDsPausedSenderName, new ArrayList());
        }
        int stopped = (int)((double)names.size() * 0.33);
        int paused = (int)((double)names.size() * 0.33);
        for (Object i : names) {
            HydraUtil.logInfo("Starting GatewaySender " + i);
            Set<GatewaySender> senders = GatewaySenderHelper.createAndStartGatewaySenders((String)i);
            for (GatewaySender sender : senders) {
                if (HydraUtil.getRandomBoolean()) {
                    HydraUtil.logInfo("Adding senderId to running list" + sender.getId());
                    CLIBlackboard.getBB().addToList(wanDsSenderName, sender.getId());
                    CLIBlackboard.getBB().addToList(wanDsRunningSenderName, sender.getId());
                    continue;
                }
                if (stopped > 0) {
                    sender.stop();
                    HydraUtil.logInfo("Adding senderId to stopped list" + sender.getId());
                    CLIBlackboard.getBB().addToList(wanDsStoppedSenderName, sender.getId());
                    --stopped;
                    continue;
                }
                if (paused <= 0) continue;
                sender.pause();
                HydraUtil.logInfo("Adding senderId tpo paused list" + sender.getId());
                CLIBlackboard.getBB().addToList(wanDsPausedSenderName, sender.getId());
                --paused;
            }
        }
    }

    public static void connectGfshToManagerNode() {
        String url = FederationBlackboard.getBB().getManagingNode();
        Pattern MY_PATTERN = Pattern.compile("service:jmx:rmi:///jndi/rmi://(.*?):(.*?)/jmxrmi");
        Matcher m = MY_PATTERN.matcher(url);
        String endpoint = null;
        while (m.find()) {
            String s = m.group(1);
            String s2 = m.group(2);
            endpoint = s + "[" + s2 + "]";
        }
        TestableGfsh shell = CLITest.getTestableShell();
        Log.getLogWriter().info("Connecting shell " + shell + " to managing node hosted at url " + url);
        TestableGfsh.execAndLogCommand(shell, "connect --jmx-manager=" + endpoint, CLITest.getGfshOutputFile(), false);
        boolean connected = shell.isConnectedAndReady();
        if (!connected) {
            throw new TestException("connect command failed to connect to manager " + endpoint);
        }
        Log.getLogWriter().info("Successfully connected to managing node ");
    }

    public static synchronized String getChildRegion() {
        if (regionList == null) {
            regionList = RegionEvents.getAllRegions();
        }
        ArrayList<String> childregions = new ArrayList<String>();
        for (int i = 0; i < regionList.size(); ++i) {
            if (!regionList.get(i).contains("Child")) continue;
            childregions.add(regionList.get(i));
        }
        return (String)HydraUtil.getRandomElement(childregions);
    }

    public static synchronized String getStringRegion() {
        if (regionList == null) {
            regionList = RegionEvents.getAllRegions();
        }
        ArrayList<String> childregions = new ArrayList<String>();
        for (int i = 0; i < regionList.size(); ++i) {
            if (!regionList.get(i).contains("String")) continue;
            childregions.add(regionList.get(i));
        }
        return (String)HydraUtil.getRandomElement(childregions);
    }

    public static synchronized String getJSONRegion() {
        if (regionList == null) {
            regionList = RegionEvents.getAllRegions();
        }
        ArrayList<String> childregions = new ArrayList<String>();
        for (int i = 0; i < regionList.size(); ++i) {
            if (!regionList.get(i).contains("JSON")) continue;
            childregions.add(regionList.get(i));
        }
        return (String)HydraUtil.getRandomElement(childregions);
    }

    public static void useRegion(TestCommandInstance instnace, String name, String jsonRegion) {
        instnace.addOption(name, jsonRegion);
    }

    static {
        regionKeyValueConfigHL = new HydraThreadLocal();
        commands = new HydraThreadLocal();
        tGfshInstances = new HydraThreadLocal();
        outputFileHL = new HydraThreadLocal();
        regionList = null;
        failedCommands = new ArrayList<String>();
        currentCommand = null;
    }
}

