/*
 * Decompiled with CFR 0.152.
 */
package management.test.cli;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.cache.BucketDump;
import com.gemstone.gemfire.internal.cache.ForceReattemptException;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.management.ManagementService;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.Log;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import management.test.cli.ValidationInfo;
import parReg.ParRegUtil;
import recovDelay.PrState;
import util.TestException;
import util.TestHelper;

public class CliHelperFunction
extends FunctionAdapter {
    public void execute(FunctionContext context) {
        String[] arguments = (String[])context.getArguments();
        if (arguments.length < 2) {
            throw new TestException("Expected three arguments for function, 1) hydra logical thread id 2) regionFullPath");
        }
        String initiatingThreadID = arguments[0];
        String regionFullPath = arguments[1];
        String loggingID = "Initiated in hydra thread thr_" + initiatingThreadID + "_; ";
        Log.getLogWriter().info("In execute with context " + context + " " + loggingID + "regionFullPath " + regionFullPath);
        Region aRegion = CacheHelper.getCache().getRegion(regionFullPath);
        if (aRegion == null) {
            throw new TestException("Unable to get region " + regionFullPath);
        }
        ValidationInfo info = new ValidationInfo();
        RegionAttributes attr = aRegion.getAttributes();
        Log.getLogWriter().info("region full path: " + regionFullPath + ", region name: " + aRegion.getName());
        Log.getLogWriter().info(loggingID + "Attributes for " + regionFullPath + ": " + attr);
        info.prAttr = attr.getPartitionAttributes();
        Log.getLogWriter().info(loggingID + "PartitionAttributes for " + regionFullPath + ": " + info.prAttr);
        info.membershipAttr = attr.getMembershipAttributes();
        Log.getLogWriter().info(loggingID + "MembershipAttributes for " + regionFullPath + ": " + info.membershipAttr);
        info.evictionAttr = attr.getEvictionAttributes();
        Log.getLogWriter().info(loggingID + "EvictionAttributes for " + regionFullPath + ": " + info.evictionAttr);
        Cache theCache = CacheHelper.getCache();
        info.isManager = false;
        if (theCache != null) {
            ManagementService service = ManagementService.getExistingManagementService((Cache)theCache);
            info.isManager = service.isManager();
        }
        info.member = DistributedSystemHelper.getDistributedSystem().getDistributedMember().toString();
        info.regionFullPath = regionFullPath;
        info.regionSize = aRegion.size();
        info.dataPolicy = attr.getDataPolicy();
        info.withPersistence = info.dataPolicy.withPersistence();
        Region parentRegion = aRegion.getParentRegion();
        info.parentRegionName = parentRegion == null ? null : parentRegion.getName();
        info.cacheListeners = Arrays.asList(attr.getCacheListeners());
        info.cacheLoader = attr.getCacheLoader();
        info.cacheWriter = attr.getCacheWriter();
        info.compressor = attr.getCompressor();
        info.concurrencyLevel = attr.getConcurrencyLevel();
        info.customEntryIdleTimeout = attr.getCustomEntryIdleTimeout();
        info.customEntryTimeToLive = attr.getCustomEntryTimeToLive();
        info.diskStoreName = attr.getDiskStoreName();
        info.enableOffHeapMemory = attr.getEnableOffHeapMemory();
        info.entryIdleTimeout = attr.getEntryIdleTimeout();
        info.entryTimeToLive = attr.getEntryTimeToLive();
        info.gatewayHubId = attr.getGatewayHubId();
        info.initialCapacity = attr.getInitialCapacity();
        info.interestPolicy = attr.getSubscriptionAttributes().getInterestPolicy();
        info.keyConstraint = attr.getKeyConstraint();
        info.loadFactor = Float.valueOf(attr.getLoadFactor());
        info.poolName = attr.getPoolName();
        info.regionIdleTimeout = attr.getRegionIdleTimeout();
        info.regionTimeToLive = attr.getRegionTimeToLive();
        info.scope = attr.getScope();
        info.valueConstraint = attr.getValueConstraint();
        info.asyncConflationEnabled = attr.getEnableAsyncConflation();
        info.cloningEnabled = attr.getCloningEnabled();
        info.diskSynchronous = attr.isDiskSynchronous();
        info.gatewayEnabled = attr.getEnableGateway();
        info.ignoreJTA = attr.getIgnoreJTA();
        info.indexMaintenanceSynchronous = attr.getIndexMaintenanceSynchronous();
        info.lockGrantor = attr.isLockGrantor();
        info.multicastEnabled = attr.getMulticastEnabled();
        info.publisher = attr.getPublisher();
        info.statisticsEnabled = attr.getStatisticsEnabled();
        info.subscriptionConflationEnabled = attr.getEnableSubscriptionConflation();
        info.hdfsStoreName = attr.getHDFSStoreName();
        info.hdfsWriteOnly = attr.getHDFSWriteOnly();
        info.directSubregions = new HashSet<String>();
        Set aSet = aRegion.subregions(false);
        for (Region reg : aSet) {
            info.directSubregions.add(reg.getFullPath());
        }
        info.allSubregions = new HashSet<String>();
        aSet = aRegion.subregions(true);
        for (Region reg : aSet) {
            info.allSubregions.add(reg.getFullPath());
        }
        info.primaryBucketCount = 0;
        info.localEntryCount = aRegion.size();
        if (info.dataPolicy.withPartitioning()) {
            Log.getLogWriter().info(loggingID + PrState.getPrPicture(aRegion));
            info.localEntryCount = 0;
            int numBuckets = info.prAttr.getTotalNumBuckets();
            for (int bucketId = 0; bucketId < numBuckets; ++bucketId) {
                Boolean[] tmp = ParRegUtil.getBucketStatus(aRegion, bucketId);
                if (tmp == null) continue;
                boolean bucketIsLocal = tmp[0];
                boolean bucketIsPrimary = tmp[1];
                if (!bucketIsLocal || !bucketIsPrimary) continue;
                ValidationInfo validationInfo = info;
                Integer n = validationInfo.primaryBucketCount;
                Serializable serializable = validationInfo.primaryBucketCount = Integer.valueOf(validationInfo.primaryBucketCount + 1);
                try {
                    List aList = ((PartitionedRegion)aRegion).getAllBucketEntries(bucketId);
                    if (aList == null || aList.size() <= 0) continue;
                    BucketDump bucket = (BucketDump)aList.get(0);
                    serializable = info;
                    Integer.valueOf(((ValidationInfo)serializable).localEntryCount + bucket.getValues().size());
                    ((ValidationInfo)serializable).localEntryCount = ((ValidationInfo)serializable).localEntryCount;
                    continue;
                }
                catch (ForceReattemptException e) {
                    throw new TestException(TestHelper.getStackTrace(e));
                }
            }
        } else {
            info.primaryBucketCount = -1;
        }
        Log.getLogWriter().info(loggingID + "Returning " + info);
        context.getResultSender().lastResult((Object)info);
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

