/*
 * Decompiled with CFR 0.152.
 */
package management.test.cli;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.ClassPathLoader;
import hydra.CacheHelper;
import hydra.Log;
import hydra.RemoteTestModule;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import util.BaseValueHolder;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;

public class DeployTestFunction
extends FunctionAdapter {
    public static final String VERIFY_CLASS_AVAILABILITY = "verifyClassAvailability";
    private static final long serialVersionUID = 1L;

    public void execute(FunctionContext context) {
        ArrayList arguments = (ArrayList)context.getArguments();
        Object initiatingThreadID = arguments.get(0);
        String task = (String)arguments.get(1);
        Log.getLogWriter().info("In execute with context " + context + " initiated in hydra thread thr_" + initiatingThreadID + "_; fcn task is " + task);
        if (task.equals(VERIFY_CLASS_AVAILABILITY)) {
            BaseValueHolder newObj;
            List expectAvailable = (List)arguments.get(2);
            List expectUnavailable = (List)arguments.get(3);
            Log.getLogWriter().info("Expect available: " + Arrays.asList(expectAvailable));
            Log.getLogWriter().info("Expect unavailable: " + Arrays.asList(expectUnavailable));
            Set<Region<?, ?>> allRegions = this.getAllRegions();
            RandomValues rv = new RandomValues();
            for (String className : expectAvailable) {
                Log.getLogWriter().info("Attempting to create instance of " + className + "; expect this to succeed");
                String key = NameFactory.getNextPositiveObjectName();
                newObj = null;
                try {
                    newObj = DeployTestFunction.createValueHolderInstance(className, key, rv);
                }
                catch (ClassNotFoundException e) {
                    throw new TestException("Got unexpected " + TestHelper.getStackTrace(e));
                }
                String newObjStr = TestHelper.toString(newObj);
                Log.getLogWriter().info("Successfully created " + newObjStr);
                for (Region<?, ?> aRegion : allRegions) {
                    Log.getLogWriter().info("Putting " + key + ", " + newObjStr + " into " + aRegion.getFullPath());
                    aRegion.put((Object)key, (Object)newObj);
                }
            }
            String key = NameFactory.getNextPositiveObjectName();
            for (String className : expectUnavailable) {
                Log.getLogWriter().info("Attempting to create instance of " + className + "; expect this to fail");
                try {
                    newObj = DeployTestFunction.createValueHolderInstance(className, key, rv);
                    throw new TestException("Expected to not find " + className + " but was able to create " + TestHelper.toString(newObj));
                }
                catch (ClassNotFoundException e) {
                    Log.getLogWriter().info("Test got expected exception for " + className + ": " + e);
                }
            }
        } else {
            throw new TestException("Unknown task specified for function: " + task);
        }
        context.getResultSender().lastResult((Object)("Validation was successful for vm_" + RemoteTestModule.getMyVmid()));
    }

    protected Set<Region<?, ?>> getAllRegions() {
        HashSet regionSet = new HashSet(CacheHelper.getCache().rootRegions());
        HashSet rootRegions = new HashSet(regionSet);
        for (Region aRegion : rootRegions) {
            regionSet.addAll(aRegion.subregions(true));
        }
        if (regionSet.size() == 0) {
            throw new TestException("Test problem; expected regions to be defined");
        }
        return regionSet;
    }

    public static BaseValueHolder createValueHolderInstance(String className, String key, RandomValues rv) throws ClassNotFoundException {
        try {
            Class aClass = ClassPathLoader.getLatest().forName(className);
            Constructor constructor = aClass.getConstructor(String.class, RandomValues.class);
            Object newObj = constructor.newInstance(key, rv);
            return (BaseValueHolder)newObj;
        }
        catch (InvocationTargetException e) {
            throw new TestException(TestHelper.getStackTrace(e.getTargetException()));
        }
        catch (SecurityException e) {
            throw new TestException(TestHelper.getStackTrace(TestHelper.getStackTrace(e)));
        }
        catch (NoSuchMethodException e) {
            throw new TestException(TestHelper.getStackTrace(TestHelper.getStackTrace(e)));
        }
        catch (IllegalArgumentException e) {
            throw new TestException(TestHelper.getStackTrace(TestHelper.getStackTrace(e)));
        }
        catch (InstantiationException e) {
            throw new TestException(TestHelper.getStackTrace(TestHelper.getStackTrace(e)));
        }
        catch (IllegalAccessException e) {
            throw new TestException(TestHelper.getStackTrace(TestHelper.getStackTrace(e)));
        }
    }

    public String getId() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

