/*
 * Decompiled with CFR 0.152.
 */
package management.test.cli;

import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.CommandManager;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import management.cli.TestableGfsh;
import management.test.cli.CLITest;
import management.util.HydraUtil;
import util.TestException;

public class ShellCommandTest {
    public static void testConnectDisconnect() {
        String[] cmd = new String[]{"describe connection", "disconnect"};
        TestableGfsh gfsh = CLITest.getTestableShell();
        if (gfsh.isConnectedAndReady()) {
            TestableGfsh.execAndLogCommand(gfsh, cmd[1], CLITest.getGfshOutputFile(), true);
        }
        for (int i = 0; i < 10; ++i) {
            CLITest.connectGfshToManagerNode();
            if (!gfsh.isConnectedAndReady()) {
                throw new TestException("Connect command failed");
            }
            Object[] object = TestableGfsh.execAndLogCommand(gfsh, cmd[0], CLITest.getGfshOutputFile(), true);
            ShellCommandTest.logOutput(cmd[0], object);
            object = TestableGfsh.execAndLogCommand(gfsh, cmd[1], CLITest.getGfshOutputFile(), true);
            ShellCommandTest.logOutput(cmd[0], object);
        }
    }

    private static void logOutput(String command, Object[] object) {
        Map map = (Map)object[0];
        CommandResult result = null;
        Collection values = map.values();
        for (Object r : values) {
            if (!(r instanceof CommandResult)) continue;
            result = (CommandResult)r;
            if (!result.getStatus().equals((Object)Result.Status.OK)) {
                throw new TestException("Command return status is OK. Command execution has failed");
            }
            HydraUtil.logInfo("Completed exeuction of <" + command + "> successfully");
        }
    }

    public static void testHelp() {
        Set commands2 = CommandManager.getExisting().getCommands().keySet();
        TestableGfsh gfsh = CLITest.getTestableShell();
        CLITest.connectGfshToManagerNode();
        if (!gfsh.isConnectedAndReady()) {
            throw new TestException("Connect command failed");
        }
        for (String cmd : commands2) {
            Object[] object = TestableGfsh.execAndLogCommand(gfsh, "help " + cmd, CLITest.getGfshOutputFile(), true);
            ShellCommandTest.logOutput("help " + cmd, object);
        }
    }

    public static void testHint() {
        String[] topics;
        TestableGfsh gfsh = CLITest.getTestableShell();
        if (gfsh.isConnectedAndReady()) {
            TestableGfsh.execAndLogCommand(gfsh, "disconnect", CLITest.getGfshOutputFile(), true);
        }
        if (gfsh.isConnectedAndReady()) {
            throw new TestException("Connect command failed");
        }
        for (String cmd : topics = new String[]{"Data", "Disk Store", "Function Execution", "GemFire", "Help", "JMX", "Lifecycle", "Locator", "Manager", "Region", "Server", "Statistics", "gfsh"}) {
            Object[] object = TestableGfsh.execAndLogCommand(gfsh, "hint " + cmd, CLITest.getGfshOutputFile(), true);
            ShellCommandTest.logOutput("help " + cmd, object);
        }
    }

    public static void testEncryptPassword() {
        TestableGfsh gfsh = CLITest.getTestableShell();
        if (gfsh.isConnectedAndReady()) {
            TestableGfsh.execAndLogCommand(gfsh, "disconnect", CLITest.getGfshOutputFile(), true);
        }
        String cmd = "encrypt password " + System.nanoTime();
        Object[] object = TestableGfsh.execAndLogCommand(gfsh, cmd, CLITest.getGfshOutputFile(), true);
        ShellCommandTest.logOutput(cmd, object);
    }

    public static void testSetVariableAndEcho() {
        String command;
        int i;
        TestableGfsh gfsh = CLITest.getTestableShell();
        if (gfsh.isConnectedAndReady()) {
            TestableGfsh.execAndLogCommand(gfsh, "disconnect", CLITest.getGfshOutputFile(), true);
        }
        for (i = 0; i < 10; ++i) {
            gfsh.setEnvProperty("TESTSYS" + i, "SYS_VALUE" + i);
            command = "echo \"Hello World! This is $TESTSYS" + i + "\"";
            Object[] objectArray = TestableGfsh.execAndLogCommand(gfsh, command, CLITest.getGfshOutputFile(), true);
        }
        for (i = 0; i < 10; ++i) {
            command = "set variable MYVAR" + i + "=" + "VARVAL" + i;
            Object[] object = TestableGfsh.execAndLogCommand(gfsh, command, CLITest.getGfshOutputFile(), true);
            command = "echo \"Hello World! This is $TESTSYS" + i + "\"";
            object = TestableGfsh.execAndLogCommand(gfsh, command, CLITest.getGfshOutputFile(), true);
        }
        Object[] object = TestableGfsh.execAndLogCommand(gfsh, "echo $*", CLITest.getGfshOutputFile(), true);
        CLITest.connectGfshToManagerNode();
        command = "set variable ARBITRARYVAR=qwertyuiop";
        object = TestableGfsh.execAndLogCommand(gfsh, command, CLITest.getGfshOutputFile(), true);
        TestableGfsh.execAndLogCommand(gfsh, "disconnect", CLITest.getGfshOutputFile(), true);
        TestableGfsh.execAndLogCommand(gfsh, "echo $*", CLITest.getGfshOutputFile(), true);
        String property = gfsh.getEnvProperty("ARBITRARYVAR");
        if (property != null) {
            throw new TestException("Bug 45579 : stale session information");
        }
    }
}

