/*
 * Decompiled with CFR 0.152.
 */
package management.test.cli;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.internal.cli.CommandManager;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import hydra.CacheHelper;
import hydra.CachePrms;
import hydra.Log;
import hydra.TestConfig;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import management.cli.TestableGfsh;
import management.jmx.JMXBlackboard;
import management.test.federation.FederationBlackboard;
import management.test.federation.FederationPrms;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import util.TestException;

public class TestableShellTest {
    private static TestableShellTest testInstance;
    private DistributedSystem ds = null;
    private GemFireCacheImpl cache = null;
    private ManagementService service;
    private Map<String, TestableGfsh> shellMap = null;
    private String[] commands = new String[]{"help", "history"};

    public static synchronized void HydraInitTask_initialize() {
        if (testInstance == null) {
            testInstance = new TestableShellTest();
            testInstance.initialize();
        }
    }

    public static void HydraInitTask_becomeManager() {
        testInstance.becomeManager();
    }

    public static void HydraInitTask_createShell() {
        testInstance.createShell();
    }

    public static void HydraTask_shellOperations() {
        testInstance.shellOps();
    }

    public static void HydraCloseTask_closeShell() {
        testInstance.closeShell();
    }

    public void closeShell() {
        TestableGfsh shell = this.shellMap.get(Thread.currentThread().getName());
        if (shell != null) {
            shell.eof();
        }
    }

    private static void execCommand(String id, TestableGfsh shell, String command) throws IOException, ClassNotFoundException {
        TestableShellTest.log(id + " : Executing command " + command + " with command Mgr " + CommandManager.getInstance());
        shell.addChars(command).addChars(";").newline();
        shell.waitForOutput();
        if (shell.hasError()) {
            TestableShellTest.log("Command failed with error " + shell.getError());
            throw new TestException("Command failed with error " + shell.getError());
        }
        Map<String, List> completorOutput = shell.getCompletorOutput();
        Map<String, Object> commandOutput = shell.getCommandOutput();
        TestableShellTest.log(id + " : Command completorOutput for " + command + "--->" + completorOutput);
        TestableShellTest.log(id + " : Command outputText for " + command + "--->" + shell.getOutputText());
        TestableShellTest.log(id + " : Command output for " + command + "--->" + commandOutput);
        shell.clearEvents();
    }

    private static void log(String string) {
        Log.getLogWriter().info(string);
    }

    public void createShell() {
        String[] argss = new String[]{};
        try {
            Gfsh.SUPPORT_MUTLIPLESHELL = true;
            String shellId = Thread.currentThread().getName();
            TestableGfsh shell = new TestableGfsh(shellId, true, argss);
            shell.start();
            this.shellMap.put(Thread.currentThread().getName(), shell);
        }
        catch (ClassNotFoundException e) {
            HydraUtil.logErrorAndRaiseException("Error starting shell", e);
        }
        catch (IOException e) {
            HydraUtil.logErrorAndRaiseException("Error starting shell", e);
        }
    }

    private void createCache() {
        if (this.cache == null) {
            String cacheConfig = TestConfig.tab().stringAt(CachePrms.names);
            this.cache = (GemFireCacheImpl)CacheHelper.createCache(cacheConfig);
        }
    }

    private void becomeManager() {
        ManagementUtil.saveMemberManagerInBlackboard();
        this.service.startManager();
        HydraUtil.sleepForReplicationJMX();
        if (!ManagementUtil.checkIfCommandsAreLoadedOrNot()) {
            throw new TestException("Member failed to load any commands");
        }
        String connector = TestConfig.tab().stringAt(FederationPrms.rmiConnectorType);
        if (connector == null | "custom".equals(connector)) {
            ManagementUtil.startRmiConnector();
        }
    }

    private void initialize() {
        JMXBlackboard.getBB().initBlackBoard();
        this.createCache();
        ManagementUtil.saveMemberMbeanInBlackboard();
        if (this.service == null) {
            this.service = ManagementService.getManagementService((Cache)this.cache);
            if (!ManagementUtil.checkLocalMemberMBean()) {
                throw new TestException("Could not find MemberMbean in platform mbean server");
            }
        }
        this.shellMap = new HashMap<String, TestableGfsh>();
        if (!ManagementUtil.checkIfCommandsAreLoadedOrNot()) {
            throw new TestException("Member failed to load any commands");
        }
    }

    private void shellOps() {
        String url = FederationBlackboard.getBB().getManagingNode();
        Pattern MY_PATTERN = Pattern.compile("service:jmx:rmi:///jndi/rmi://(.*?):(.*?)/jmxrmi");
        Matcher m = MY_PATTERN.matcher(url);
        String endpoint = null;
        while (m.find()) {
            String s = m.group(1);
            String s2 = m.group(2);
            endpoint = s + "[" + s2 + "]";
        }
        TestableGfsh shell = null;
        String shellId = Thread.currentThread().getName();
        TestableShellTest.log("Connecting shell to managing node hosted at url " + url);
        TestableShellTest.log("ShellMAp " + this.shellMap);
        try {
            shell = this.shellMap.get(Thread.currentThread().getName());
            TestableShellTest.execCommand(shellId, shell, "connect --jmx-manager=" + endpoint);
        }
        catch (IOException e) {
            HydraUtil.logErrorAndRaiseException("Error connecting shell to managing node", e);
        }
        catch (ClassNotFoundException e) {
            HydraUtil.logErrorAndRaiseException("Error connecting shell to managing node", e);
        }
        boolean connected = shell.isConnectedAndReady();
        if (!connected) {
            throw new TestException("connect command failed to connect to manager " + endpoint);
        }
        TestableShellTest.log("Successfully connected to managing node ");
        try {
            String command = HydraUtil.getRandomElement(this.commands);
            TestableShellTest.execCommand(shellId, shell, command);
            command = "disconnect";
            TestableShellTest.execCommand(shellId, shell, command);
            connected = shell.isConnectedAndReady();
            if (connected) {
                throw new TestException("connect command failed to dis-connect from manager " + endpoint);
            }
        }
        catch (IOException e) {
            HydraUtil.logErrorAndRaiseException("Error connecting shell to managing node", e);
        }
        catch (ClassNotFoundException e) {
            HydraUtil.logErrorAndRaiseException("Error connecting shell to managing node", e);
        }
    }
}

