/*
 * Decompiled with CFR 0.152.
 */
package management.test.federation;

import hydra.JMXManagerHelper;
import hydra.RemoteTestModule;
import hydra.blackboard.Blackboard;
import hydra.blackboard.SharedLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import management.util.HydraUtil;
import management.util.ManagementUtil;

public class FederationBlackboard
extends Blackboard {
    static final String BB_NAME = "MGMT_FED_Blackboard";
    static final String BB_TYPE = "RMI";
    private static FederationBlackboard bbInstance = null;
    public static String urlTemplate = "service:jmx:rmi:///jndi/rmi://?1:?2/jmxrmi";
    public static int MBEAN_OBJECTNAME_COUNT;
    public static boolean urlsChecked;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FederationBlackboard getBB() {
        if (bbInstance != null) return bbInstance;
        Class<FederationBlackboard> clazz = FederationBlackboard.class;
        synchronized (FederationBlackboard.class) {
            if (bbInstance != null) return bbInstance;
            bbInstance = new FederationBlackboard(BB_NAME, BB_TYPE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return bbInstance;
        }
    }

    public FederationBlackboard() {
    }

    public FederationBlackboard(String name, String type) {
        super(name, type, FederationBlackboard.class);
    }

    public int getNextObjectNameCounter() {
        return (int)FederationBlackboard.getBB().getSharedCounters().incrementAndRead(MBEAN_OBJECTNAME_COUNT);
    }

    public int getObjectNameCounter() {
        return (int)this.getSharedCounters().read(MBEAN_OBJECTNAME_COUNT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagingNode(String vmId, String url) {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            HashMap<String, String> map = (HashMap<String, String>)this.getSharedMap().get("MANAGING_NODE_URLS");
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.put(vmId, url);
            this.getSharedMap().put("MANAGING_NODE_URLS", map);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMemberONs() {
        SharedLock lock = this.getSharedLock();
        try {
            Map map;
            lock.lock();
            Map map2 = map = (Map)this.getSharedMap().get("MEMBERS");
            return map2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMemberNames() {
        SharedLock lock = this.getSharedLock();
        try {
            Map map;
            lock.lock();
            Map map2 = map = (Map)this.getSharedMap().get("MEMBERNAMES");
            return map2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getManagerONs() {
        SharedLock lock = this.getSharedLock();
        try {
            Map map;
            lock.lock();
            Map map2 = map = (Map)this.getSharedMap().get("MANAGERS");
            return map2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberON(String vmId, String on) {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            HashMap<String, String> map = (HashMap<String, String>)this.getSharedMap().get("MEMBERS");
            if (map == null) {
                map = new HashMap<String, String>();
            }
            HydraUtil.logInfo("Adding " + vmId + " into map " + HydraUtil.ObjectToString(map));
            map.put(vmId, on);
            this.getSharedMap().put("MEMBERS", map);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMemberName(String vmId, String name) {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            HashMap<String, String> map = (HashMap<String, String>)this.getSharedMap().get("MEMBERNAMES");
            if (map == null) {
                map = new HashMap<String, String>();
            }
            HydraUtil.logInfo("Adding " + vmId + " into map " + HydraUtil.ObjectToString(map));
            map.put(vmId, name);
            this.getSharedMap().put("MEMBERNAMES", map);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addManagerON(String vmId, String on) {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            HashMap<String, String> map = (HashMap<String, String>)this.getSharedMap().get("MANAGERS");
            if (map == null) {
                map = new HashMap<String, String>();
            }
            map.put(vmId, on);
            HydraUtil.logInfo("Adding " + vmId + " into map " + HydraUtil.ObjectToString(map));
            this.getSharedMap().put("MANAGERS", map);
        }
        finally {
            lock.unlock();
        }
    }

    public String getManagingNode() {
        JMXManagerHelper.Endpoint pt = HydraUtil.getRandomElement(ManagementUtil.filterForThisDS(JMXManagerHelper.getEndpoints()));
        if (pt != null) {
            String url = urlTemplate.replace("?1", pt.getHost());
            url = url.replace("?2", "" + pt.getPort());
            return url;
        }
        return null;
    }

    public String getOtherManagingNode() {
        List<JMXManagerHelper.Endpoint> dsFilteredList = ManagementUtil.filterForThisDS(JMXManagerHelper.getEndpoints());
        ArrayList<JMXManagerHelper.Endpoint> otherManagingNodes = new ArrayList<JMXManagerHelper.Endpoint>();
        for (JMXManagerHelper.Endpoint e : dsFilteredList) {
            int vmId = RemoteTestModule.getMyVmid();
            if (vmId == e.getVmid()) continue;
            otherManagingNodes.add(e);
        }
        JMXManagerHelper.Endpoint pt = (JMXManagerHelper.Endpoint)HydraUtil.getRandomElement(otherManagingNodes);
        if (pt != null) {
            String url = urlTemplate.replace("?1", pt.getHost());
            url = url.replace("?2", "" + pt.getPort());
            return url;
        }
        return null;
    }

    public String getMyManagingNode() {
        JMXManagerHelper.Endpoint pt = null;
        for (JMXManagerHelper.Endpoint e : JMXManagerHelper.getEndpoints()) {
            int vmId = RemoteTestModule.getMyVmid();
            if (vmId != e.getVmid()) continue;
            pt = e;
            break;
        }
        if (pt != null) {
            String url = urlTemplate.replace("?1", pt.getHost());
            url = url.replace("?2", "" + pt.getPort());
            return url;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getManagingNode(String vmId) {
        SharedLock lock = this.getSharedLock();
        try {
            lock.lock();
            Map map = (Map)this.getSharedMap().get("MANAGING_NODE_URLS");
            if (map == null) {
                HydraUtil.logErrorAndRaiseException("No Urls registered. Map is not initialised");
            }
            if (map.size() > 0) {
                String string = (String)map.get(vmId);
                return string;
            }
            HydraUtil.logErrorAndRaiseException("No Urls registered. Map is empty");
        }
        finally {
            lock.unlock();
        }
        return null;
    }

    public Collection<String> getManagingNodes() {
        List<JMXManagerHelper.Endpoint> dsFilteredList = ManagementUtil.filterForThisDS(JMXManagerHelper.getEndpoints());
        ArrayList<String> urls = new ArrayList<String>();
        for (JMXManagerHelper.Endpoint pt : dsFilteredList) {
            String url = urlTemplate.replace("?1", pt.getHost());
            url = url.replace("?2", "" + pt.getPort());
            if (urlsChecked) {
                urls.add(url);
                continue;
            }
            if (!ManagementUtil.checkUrl(url)) continue;
            urls.add(url);
        }
        return urls;
    }

    static {
        urlsChecked = false;
    }
}

