/*
 * Decompiled with CFR 0.152.
 */
package management.test.jmx;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.CachePrms;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GatewayReceiverHelper;
import hydra.GatewaySenderHelper;
import hydra.GatewaySenderPrms;
import hydra.GemFireDescription;
import hydra.HydraThreadLocal;
import hydra.HydraVector;
import hydra.JMXManagerBlackboard;
import hydra.JMXManagerHelper;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.relation.MBeanServerNotificationFilter;
import management.Expectations;
import management.jmx.Expectation;
import management.jmx.JMXBlackboard;
import management.jmx.JMXNotificationListener;
import management.jmx.JMXPrms;
import management.jmx.SimpleJMXRecorder;
import management.jmx.validation.JMXValidator;
import management.jmx.validation.ValidationResult;
import management.operations.OperationsBlackboard;
import management.operations.RegionKeyValueConfig;
import management.operations.SimpleRegionKeyValueConfig;
import management.operations.events.impl.AbstractEvents;
import management.operations.events.impl.CQAndIndexEvents;
import management.operations.events.impl.DLockEvents;
import management.operations.events.impl.RegionEvents;
import management.operations.ops.CQAndIndexOperations;
import management.operations.ops.DLockOperations;
import management.operations.ops.JMXOperations;
import management.operations.ops.RegionOperations;
import management.operations.ops.jmx.TestMBean;
import management.test.federation.FederationBlackboard;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import util.TestException;
import util.TestHelper;

public class JMXTest {
    private static JMXTest testInstance;
    private DistributedSystem ds = null;
    private GemFireCacheImpl cache = null;
    private ManagementService service;
    private CacheServer server = null;
    private SimpleJMXRecorder jmxNotifRecorder = new SimpleJMXRecorder();
    private List<Expectation> notifExpectationList = new ArrayList<Expectation>();
    private String managingNodeForNotifs = null;
    private Map<ObjectName, JMXNotificationListener> allNotiflisteners = new HashMap<ObjectName, JMXNotificationListener>();
    private HydraThreadLocal regionHT = new HydraThreadLocal();
    private HydraThreadLocal dlockHT = new HydraThreadLocal();
    private RegionKeyValueConfig regionkeyValueConfig = new SimpleRegionKeyValueConfig("KEY" + RemoteTestModule.getMyVmid(), 100000);
    private static String DISTRIBUTED_SUFFIX;
    public static String queryRegion;
    private static RegionOperations regionOps;
    private static DLockOperations dlockOps;
    private static CQAndIndexOperations cqOps;

    public static HydraThreadLocal getRegionHT() {
        return JMXTest.testInstance.regionHT;
    }

    public static HydraThreadLocal getDLockHT() {
        return JMXTest.testInstance.dlockHT;
    }

    public static ManagementService getManagementService() {
        return JMXTest.testInstance.service;
    }

    public static synchronized RegionOperations getRegionOperations() {
        if (regionOps == null) {
            regionOps = new RegionOperations((Cache)JMXTest.testInstance.cache, new RegionEvents());
        }
        return regionOps;
    }

    public static synchronized DLockOperations getDLockOperations() {
        if (dlockOps == null) {
            dlockOps = new DLockOperations(JMXTest.testInstance.ds, new DLockEvents());
        }
        return dlockOps;
    }

    public static synchronized CQAndIndexOperations getCQOperations() {
        if (cqOps == null) {
            Region region = RegionHelper.getRegion(queryRegion);
            cqOps = new CQAndIndexOperations(region, JMXTest.testInstance.regionkeyValueConfig, new CQAndIndexEvents());
        }
        return cqOps;
    }

    public static synchronized void HydraInitTask_startLocator() {
        if (testInstance == null) {
            testInstance = new JMXTest();
        }
        testInstance.startLocator();
    }

    public static synchronized void HydraInitTask_initialize() {
        if (testInstance == null) {
            testInstance = new JMXTest();
        }
        testInstance.initialize();
    }

    public static synchronized void HydraInitTask_becomeManager() {
        testInstance.becomeManager();
    }

    public static synchronized void HydraInitTask_setUpJMXListeners() {
        testInstance.setUpJMXListeners();
    }

    public static void HydraInitTask_startWANSendersAndReceivers() {
        testInstance.startWANSendersAndReceivers();
    }

    public static synchronized void HydraInitTask_startWithBridgeServer() {
        testInstance.starBridgeServer();
    }

    public static synchronized void HydraInitTask_createRegionsOnEdge() {
        testInstance.createRegionsOnEdge();
    }

    public static synchronized void HydraInitTask_createRegionsOnBridge() {
        testInstance.createRegionsOnBridge();
    }

    public static synchronized void HydraInitTask_createQueryResources() {
        testInstance.createQueryResources();
    }

    public static synchronized void HydraInitTask_createLockServiceInstances() {
        testInstance.createLockServiceInstances();
    }

    public static void HydraTask_jmxOperations() {
        testInstance.doJMXOps();
    }

    public static void HydraCloseTask_printEvents() {
        testInstance.printEvents();
    }

    public static void HydraCloseTask_validateEvents() {
        testInstance.validateEvents();
    }

    public static void HydraCloseTask_validateNotifications() {
        testInstance.validateNotifications();
    }

    public static void HydraCloseTask_validateWANEvents() {
        testInstance.validateWANEvents();
    }

    public static void addDSNotifListener(ObjectName name, String memberId) {
        try {
            MBeanServerConnection mbeanServer = ManagementUtil.connectToUrlOrGemfireProxy(JMXTest.testInstance.managingNodeForNotifs);
            JMXNotificationListener dsMBeanlistener = new JMXNotificationListener("JMXTest-DistributedSystemListener", JMXTest.testInstance.jmxNotifRecorder, name, memberId);
            HydraUtil.logInfo("Added DS JMX listener for " + name + " on server " + JMXTest.testInstance.managingNodeForNotifs);
            mbeanServer.addNotificationListener(name, dsMBeanlistener, null, null);
            JMXTest.testInstance.allNotiflisteners.put(name, dsMBeanlistener);
        }
        catch (MalformedURLException e) {
            throw new TestException("error", e);
        }
        catch (IOException e) {
            throw new TestException("error", e);
        }
        catch (InstanceNotFoundException e) {
            throw new TestException("error", e);
        }
    }

    public static void addMemberNotifListener(ObjectName name, String memberId) {
        try {
            JMXNotificationListener memberMBeanlistener = new JMXNotificationListener("JMXTest-MemberListener", JMXTest.testInstance.jmxNotifRecorder, name, memberId);
            MBeanServerConnection mbeanServer = ManagementUtil.connectToUrlOrGemfireProxy(JMXTest.testInstance.managingNodeForNotifs);
            mbeanServer.addNotificationListener(name, memberMBeanlistener, null, null);
            JMXTest.testInstance.allNotiflisteners.put(name, memberMBeanlistener);
            HydraUtil.logInfo("Added Member JMX listener for " + name + " on server " + JMXTest.testInstance.managingNodeForNotifs);
        }
        catch (MalformedURLException e) {
            throw new TestException("error", e);
        }
        catch (IOException e) {
            throw new TestException("error", e);
        }
        catch (InstanceNotFoundException e) {
            throw new TestException("error", e);
        }
    }

    public static void addCacheServerNotifListener(ObjectName cacheServerON, String memberId) {
        try {
            MBeanServerConnection mbeanServer = ManagementUtil.connectToUrlOrGemfireProxy(JMXTest.testInstance.managingNodeForNotifs);
            JMXNotificationListener cacheServerMBeanlistener = new JMXNotificationListener("JMXTest-CacheServerListener", JMXTest.testInstance.jmxNotifRecorder, cacheServerON);
            mbeanServer.addNotificationListener(cacheServerON, cacheServerMBeanlistener, null, null);
            JMXTest.testInstance.allNotiflisteners.put(cacheServerON, cacheServerMBeanlistener);
            HydraUtil.logInfo("Added CacheServer JMX listener for " + cacheServerON + " on server " + JMXTest.testInstance.managingNodeForNotifs);
        }
        catch (MalformedURLException e) {
            throw new TestException("error", e);
        }
        catch (IOException e) {
            throw new TestException("error", e);
        }
        catch (InstanceNotFoundException e) {
            throw new TestException("error", e);
        }
    }

    public static boolean isNotifListenerRegistered(ObjectName name) {
        return JMXTest.testInstance.allNotiflisteners.containsKey(name);
    }

    public static void cacheStopStart() throws IOException {
        final ArrayList<ObjectName> registeredMBeans = new ArrayList<ObjectName>();
        final ArrayList<ObjectName> unRegisteredMBeans = new ArrayList<ObjectName>();
        ArrayList<ObjectName> beforeConnectMBeans = new ArrayList<ObjectName>();
        ObjectName memberMBeanNameBeforeDisConnect = ManagementUtil.getLocalMemberMBeanON();
        for (ObjectName n : ManagementUtil.getPlatformMBeanServer().queryNames(null, null)) {
            if (!n.toString().contains("GemFire")) continue;
            beforeConnectMBeans.add(n);
            HydraUtil.logFine("Added " + n + " in gemfire mbean set");
        }
        NotificationListener superListener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notification, Object handback) {
                MBeanServerNotification mbs = (MBeanServerNotification)notification;
                if ("JMX.mbean.registered".equals(mbs.getType())) {
                    HydraUtil.logInfo("MBean Registered [" + mbs.getMBeanName() + "]");
                    if (mbs.getMBeanName().toString().contains("GemFire")) {
                        registeredMBeans.add(mbs.getMBeanName());
                    }
                } else if ("JMX.mbean.unregistered".equals(mbs.getType())) {
                    HydraUtil.logInfo("MBean Unregistered [" + mbs.getMBeanName() + "]");
                    unRegisteredMBeans.add(mbs.getMBeanName());
                }
            }
        };
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            MBeanServerNotificationFilter filter = new MBeanServerNotificationFilter();
            filter.enableAllObjectNames();
            server.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, superListener, (NotificationFilter)filter, null);
        }
        catch (InstanceNotFoundException e) {
            throw new TestException("Error starting locator", e);
        }
        catch (IOException e) {
            throw new TestException("Error starting locator", e);
        }
        JMXTest.testInstance.cache.getDistributedSystem().disconnect();
        JMXTest.testInstance.cache = null;
        JMXTest.testInstance.ds = null;
        JMXTest.testInstance.service = null;
        HydraUtil.sleepForReplicationJMX();
        Set<ObjectName> afterDisConnect = ManagementUtil.getPlatformMBeanServer().queryNames(null, null);
        HydraUtil.logFine("Checking for presence of any gemfire mbeans");
        for (ObjectName n : beforeConnectMBeans) {
            if (!afterDisConnect.contains(n)) continue;
            throw new TestException("Found gemfire mbean after cache disconnect  - " + n);
        }
        testInstance.initialize();
        if (RemoteTestModule.getMyClientName().contains("managing")) {
            testInstance.becomeManager();
        }
        ObjectName memberMBeanNameAfterDisConnect = ManagementUtil.getLocalMemberMBeanON();
        beforeConnectMBeans.remove(memberMBeanNameBeforeDisConnect);
        unRegisteredMBeans.remove(memberMBeanNameBeforeDisConnect);
        registeredMBeans.remove(memberMBeanNameAfterDisConnect);
        HydraUtil.logInfo("Gemfire MBean set(excluding memberMBean) before dis-connect : " + beforeConnectMBeans);
        HydraUtil.logInfo("Gemfire MBean set(excluding memberMBean) during dis-connect : " + unRegisteredMBeans);
        HydraUtil.logInfo("Gemfire MBean after(excluding memberMBean) re-connect : " + registeredMBeans);
        List<ObjectName> diffList = JMXTest.checkTwoLists(beforeConnectMBeans, unRegisteredMBeans);
        if (diffList.size() > 0) {
            throw new TestException("beforeConnectMBeans and unRegisteredMBeans mismatch Diff : " + diffList);
        }
        diffList = JMXTest.checkTwoLists(beforeConnectMBeans, registeredMBeans);
        if (diffList.size() > 0) {
            throw new TestException("beforeConnectMBeans and registeredMBeans mismatch Diff : " + diffList);
        }
        diffList = JMXTest.checkTwoLists(unRegisteredMBeans, registeredMBeans);
        if (diffList.size() > 0) {
            throw new TestException("unRegisteredMBeans and registeredMBeans mismatch Diff : " + diffList);
        }
        try {
            ManagementUtil.getPlatformMBeanServer().removeNotificationListener(MBeanServerDelegate.DELEGATE_NAME, superListener);
        }
        catch (InstanceNotFoundException e) {
            HydraUtil.logError("Error removing listener", e);
        }
        catch (ListenerNotFoundException e) {
            HydraUtil.logError("Error removing listener", e);
        }
    }

    public static void addExpectationForNotification(ObjectName mbeanName, String type, String source, String message) {
        testInstance._addExpectationForNotification(mbeanName, type, source, message, 0);
    }

    public static void addExpectationForNotificationPseudoMatch(ObjectName mbeanName, String type, String source, String message) {
        testInstance._addExpectationForNotification(mbeanName, type, source, message, 4);
    }

    public static void validateAndPrint(JMXValidator validator) {
        List<ValidationResult> result = validator.validate();
        if (result.size() > 0) {
            HydraUtil.logInfo("JMX Validations failed. See below details");
            StringBuilder sb = new StringBuilder();
            int i = 1;
            for (ValidationResult r : result) {
                HydraUtil.logError(r.toString());
                sb.append(i++ + "# " + r.toString()).append(HydraUtil.NEW_LINE);
            }
            throw new TestException(result.size() + " JMX validation failed \n" + sb.toString());
        }
        HydraUtil.logInfo("JMX Validations suceeded");
    }

    private void validateWANEvents() {
        Set<Region> regions = JMXTest.getRegionOperations().getAvailableRegions();
        HashMap<String, String> map = new HashMap<String, String>();
        for (Region r : regions) {
            String key = RemoteTestModule.getMyClientName() + r.getFullPath();
            String value = "VALUE";
            r.put((Object)key, (Object)value);
            map.put(key, value);
        }
        JMXBlackboard.getBB().saveMap("WANEVENTS_" + RemoteTestModule.getMyClientName(), map);
    }

    private void startLocator() {
        DistributedSystemHelper.createLocator();
        DistributedSystemHelper.startLocatorAndDS();
        this.waitForLocatorDiscovery();
    }

    private void waitForLocatorDiscovery() {
        boolean isDiscovered;
        HydraUtil.logInfo("Waititng for locator discovery.");
        do {
            isDiscovered = true;
            List locators = Locator.getLocators();
            ConcurrentMap gfLocMap = ((InternalLocator)locators.get(0)).getAllLocatorsInfo();
            ArrayList<Integer> dsList = new ArrayList<Integer>();
            for (GemFireDescription gfd : TestConfig.getInstance().getGemFireDescriptions().values()) {
                Integer ds = gfd.getDistributedSystemId();
                if (ds.equals(-1) || dsList.contains(ds) || gfLocMap.containsKey(ds)) continue;
                dsList.add(ds);
                isDiscovered = false;
            }
            if (isDiscovered) continue;
            HydraUtil.logInfo("Waiting for locator discovery to complete. Locators not discoverd so far from ds " + dsList + ". Distribution locator map from gemfire system is " + new ConcurrentHashMap(gfLocMap).toString());
            MasterController.sleepForMs(5000);
        } while (!isDiscovered);
        HydraUtil.logInfo("Locator discovery completed.");
    }

    private void validateEvents() {
        this.recycleConnections();
        Map mbeanMap = JMXBlackboard.getBB().getMap("MBEAN_MAP");
        String url = FederationBlackboard.getBB().getManagingNode();
        Set<ObjectName> gemfireMBeans = ManagementUtil.getGemfireMBeans(url);
        HydraUtil.logFine("MBeans " + gemfireMBeans + " found on url " + url);
        HydraUtil.logFine("mbeanMap " + mbeanMap);
        JMXOperations ops = this.buildeTestMap(gemfireMBeans, mbeanMap, url);
        ops.doJMXValidation();
    }

    private void printEvents() {
        Map map;
        this.recycleConnections();
        HydraVector printEventsList = TestConfig.tab().vecAt(JMXPrms.printEventsList);
        boolean exportRegionEvents = false;
        boolean exportDlocknEvents = false;
        for (int i = 0; i < printEventsList.size(); ++i) {
            String eventName = (String)printEventsList.get(i);
            if (eventName.contains("REGION")) {
                exportRegionEvents = true;
            }
            if (!eventName.contains("DLOCK")) continue;
            exportDlocknEvents = true;
        }
        if (exportRegionEvents) {
            RegionEvents regionEvents = (RegionEvents)JMXTest.getRegionOperations().getOperationRecorder();
            HydraUtil.logInfo("Exporting region events");
            regionEvents.exportToBlackBoard(OperationsBlackboard.getBB());
        }
        if (exportDlocknEvents) {
            DLockEvents dlockEvents = (DLockEvents)JMXTest.getDLockOperations().getOperationRecorder();
            HydraUtil.logInfo("Exporting dlock events");
            dlockEvents.exportToBlackBoard(OperationsBlackboard.getBB());
        }
        JMXBlackboard.getBB().getSharedCounters().increment(JMXBlackboard.VM_TASKS_COMPLETE_COUNT);
        String clientName = RemoteTestModule.getMyClientName();
        int count = 0;
        if (JMXPrms.useGemfireProxies()) {
            map = FederationBlackboard.getBB().getManagerONs();
            HydraUtil.logFine("Federation Manager Map " + map);
            count = map.size();
        } else {
            map = FederationBlackboard.getBB().getMemberONs();
            count = map.size();
        }
        HydraUtil.logInfo("Waiting for even VM to export events to blackboard and updates its counters");
        TestHelper.waitForCounter(JMXBlackboard.getBB(), "TASKS_COMPLETE_COUNT", JMXBlackboard.VM_TASKS_COMPLETE_COUNT, count, true, 10000L);
        for (int i = 0; i < printEventsList.size(); ++i) {
            String eventName = (String)printEventsList.get(i);
            Map<String, AbstractEvents> emap = AbstractEvents.importFromBlackBoard(eventName, OperationsBlackboard.getBB());
            if (emap != null) {
                for (Map.Entry<String, AbstractEvents> e : emap.entrySet()) {
                    clientName = e.getKey();
                    AbstractEvents ae = e.getValue();
                    HydraUtil.logInfo("Events from client " + clientName);
                    ae.printEvents();
                }
                continue;
            }
            HydraUtil.logInfo("No events found of type " + eventName);
        }
    }

    private synchronized void initManagerForResourceNotifs() {
        if (this.managingNodeForNotifs == null) {
            String clientName = RemoteTestModule.getMyClientName();
            this.managingNodeForNotifs = clientName.contains("managing") ? FederationBlackboard.getBB().getMyManagingNode() : FederationBlackboard.getBB().getManagingNode();
        }
    }

    private static List<ObjectName> checkTwoLists(List<ObjectName> list1, List<ObjectName> list2) {
        ArrayList<ObjectName> diffList = new ArrayList<ObjectName>();
        for (ObjectName n1 : list1) {
            if (list2.contains(n1)) continue;
            diffList.add(n1);
        }
        for (ObjectName n2 : list2) {
            if (list1.contains(n2)) continue;
            diffList.add(n2);
        }
        return diffList;
    }

    private void setUpJMXListeners() {
        this.initManagerForResourceNotifs();
        String clientName = RemoteTestModule.getMyClientName();
        DistributedMember distributedMember = ManagementUtil.getMember();
        if (!clientName.contains("edge")) {
            HydraUtil.sleepForReplicationJMX();
            ObjectName name = ManagementUtil.getLocalMemberMBeanON();
            JMXTest.addMemberNotifListener(name, ManagementUtil.getMemberID());
            if (ManagementUtil.subscribeDSNotifs()) {
                name = MBeanJMXAdapter.getDistributedSystemName();
                JMXTest.addDSNotifListener(name, ManagementUtil.getMemberID());
            }
            if (this.server != null) {
                ObjectName cacheServerON = this.service.getCacheServerMBeanName(this.server.getPort(), distributedMember);
                JMXTest.addCacheServerNotifListener(cacheServerON, ManagementUtil.getMemberID());
            }
        }
    }

    private void _addExpectationForNotification(ObjectName mbeanName, String type, String source, String message, int matchMode) {
        if (!this.allNotiflisteners.containsKey(mbeanName)) {
            throw new TestException("No notif listener setup for " + mbeanName);
        }
        HydraUtil.logInfo("Adding expectation for Notif Type " + type + " with message " + message + " on mbean " + mbeanName);
        this.notifExpectationList.add(Expectations.forMBean(mbeanName).expectMBeanAt(this.managingNodeForNotifs).expectNotification(type, (Object)source, message, null, matchMode));
    }

    private void validateNotifications() {
        JMXValidator validator = new JMXValidator(this.jmxNotifRecorder, this.notifExpectationList);
        JMXTest.validateAndPrint(validator);
    }

    private void createRegionsOnBridge() {
        RegionOperations regionOps = JMXTest.getRegionOperations();
        HydraVector regionList = TestConfig.tab().vecAt(JMXPrms.regionListToStartWith);
        HydraUtil.logInfo("Creating regions on gemfire bridges : ");
        int count = 1;
        for (int i = 0; i < regionList.size(); ++i) {
            String name = (String)regionList.get(i);
            if (!name.contains("Bridge")) continue;
            int index = name.indexOf("Bridge");
            String rName = "Test" + name.substring(0, index) + "_" + count++;
            HydraUtil.logInfo("Creating region named " + rName + " with template " + name);
            Region regionCreated = regionOps.createRegion(rName, name);
            rName = regionCreated.getFullPath();
            HydraUtil.logInfo("Created region named " + rName + " with template " + name);
            JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.cache.region.created", ManagementUtil.getMemberID(), "Region Created With Name " + rName);
            if (ManagementUtil.subscribeDSNotifs()) {
                JMXTest.addExpectationForNotification(MBeanJMXAdapter.getDistributedSystemName(), "gemfire.distributedsystem.cache.region.created", ManagementUtil.getMemberID(), "Region Created With Name " + rName);
            }
            if (!rName.contains("Persistent")) continue;
            String diskStoreName = regionCreated.getAttributes().getDiskStoreName();
            if (diskStoreName == null) {
                throw new TestException("Diskstore returned null for persistent region " + rName);
            }
            JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.cache.disk.created", ManagementUtil.getMemberID(), "DiskStore Created With Name " + diskStoreName);
            if (!ManagementUtil.subscribeDSNotifs()) continue;
            JMXTest.addExpectationForNotification(MBeanJMXAdapter.getDistributedSystemName(), "gemfire.distributedsystem.cache.disk.created", ManagementUtil.getMemberID(), "DiskStore Created With Name " + diskStoreName);
        }
        RegionEvents regionEvents = (RegionEvents)regionOps.getOperationRecorder();
        regionEvents.exportToBlackBoard(OperationsBlackboard.getBB());
    }

    private void createQueryResources() {
        CQAndIndexOperations indexOps = JMXTest.getCQOperations();
        QueryService service = this.cache.getQueryService();
        HydraUtil.logInfo("Created Index # : " + indexOps.createIndex());
        HydraUtil.logInfo("Created Index # : " + indexOps.createIndex());
        HydraUtil.logInfo("Created Index # : " + indexOps.createIndex());
        HydraUtil.logInfo("Created Index # : " + indexOps.createIndex());
        HydraUtil.logInfo("Created Index # : " + indexOps.createIndex());
        String clientName = RemoteTestModule.getMyClientName();
        if (clientName.contains("edge")) {
            String query = indexOps.createCq();
            HydraUtil.logInfo("Created CQ # : " + query);
            try {
                service.executeCqs();
            }
            catch (CqException e) {
                throw new TestException("Failed to start cqs ", e);
            }
            query = indexOps.createCq();
            HydraUtil.logInfo("Created CQ # : " + query);
            try {
                service.executeCqs();
            }
            catch (CqException e) {
                throw new TestException("Failed to start cqs ", e);
            }
            query = indexOps.createCq();
            HydraUtil.logInfo("Created CQ # : " + query);
            try {
                service.executeCqs();
            }
            catch (CqException e) {
                throw new TestException("Failed to start cqs ", e);
            }
            query = indexOps.createCq();
            HydraUtil.logInfo("Created CQ # : " + query);
            try {
                service.executeCqs();
            }
            catch (CqException e) {
                throw new TestException("Failed to start cqs ", e);
            }
            query = indexOps.createCq();
            HydraUtil.logInfo("Created CQ # : " + query);
            try {
                service.executeCqs();
            }
            catch (CqException e) {
                throw new TestException("Failed to start cqs ", e);
            }
        }
    }

    private void createRegionsOnEdge() {
        HydraUtil.logInfo("Creating region on gemfire clients");
        RegionOperations regionOps = JMXTest.getRegionOperations();
        HydraVector regionList = TestConfig.tab().vecAt(JMXPrms.regionListToStartWith);
        HydraUtil.logInfo("Creating regions on gemfire edges : ");
        int count = 1;
        for (int i = 0; i < regionList.size(); ++i) {
            String name = (String)regionList.get(i);
            if (!name.contains("Edge")) continue;
            int index = name.indexOf("Edge");
            String rName = "Test" + name.substring(0, index) + "_" + count++;
            HydraUtil.logInfo("Creating region named " + rName + " with template " + name);
            regionOps.createRegion(rName, name);
            HydraUtil.logInfo("Created region named " + rName + " with template " + name);
        }
    }

    private void createLockServiceInstances() {
        this.initManagerForResourceNotifs();
        DLockOperations lockOps = JMXTest.getDLockOperations();
        int locks = TestConfig.tab().intAt(JMXPrms.lockServicesToStartWith);
        HydraUtil.logInfo("Creating lockservice instances Num : " + locks);
        for (int i = 0; i < locks; ++i) {
            String lock = lockOps.createDLock();
            JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.cache.lockservice.created", ManagementUtil.getMemberID(), "LockService Created With Name " + lock);
            if (!ManagementUtil.subscribeDSNotifs()) continue;
            JMXTest.addExpectationForNotification(MBeanJMXAdapter.getDistributedSystemName(), "gemfire.distributedsystem.cache.lockservice.created", ManagementUtil.getMemberID(), "LockService Created With Name " + lock);
        }
    }

    private void starBridgeServer() {
        if (this.server == null) {
            String bridgeConfig = TestConfig.tab().stringAt(BridgePrms.names);
            this.server = BridgeHelper.startBridgeServer(bridgeConfig);
            HydraUtil.logInfo("Started cacheServer on " + RemoteTestModule.getMyClientName());
            HydraUtil.logInfo("Has server started " + this.server.isRunning());
            JMXTest.addExpectationForNotification(MBeanJMXAdapter.getMemberMBeanName((String)ManagementUtil.getMemberID()), "gemfire.distributedsystem.cache.server.started", ManagementUtil.getMemberID(), "Cache Server is Started in the VM ");
            if (ManagementUtil.subscribeDSNotifs()) {
                JMXTest.addExpectationForNotification(MBeanJMXAdapter.getDistributedSystemName(), "gemfire.distributedsystem.cache.server.started", ManagementUtil.getMemberID(), "Cache Server is Started in the VM ");
            }
        }
    }

    private void startWANSendersAndReceivers() {
        String receiverConfig = ConfigPrms.getGatewayReceiverConfig();
        HydraVector names = TestConfig.tab().vecAt(GatewaySenderPrms.names);
        GatewayReceiverHelper.createAndStartGatewayReceivers(receiverConfig);
        for (Object i : names) {
            HydraUtil.logInfo("Starting GatewaySender " + i);
            GatewaySenderHelper.createAndStartGatewaySenders((String)i);
        }
        ObjectName localMemberMBean = ManagementUtil.getLocalMemberMBeanON();
        this.notifExpectationList.add(Expectations.forMBean(localMemberMBean).expectMBeanAt(this.managingNodeForNotifs).expectNotification("gemfire.distributedsystem.gateway.receiver.created", (Object)ManagementUtil.getMemberID(), "GatewayReceiver Created in the VM ", null, 0));
        this.notifExpectationList.add(Expectations.forMBean(localMemberMBean).expectMBeanAt(this.managingNodeForNotifs).expectNotification("gemfire.distributedsystem.gateway.receiver.started", (Object)ManagementUtil.getMemberID(), "GatewayReceiver Started in the VM ", null, 0));
        this.notifExpectationList.add(Expectations.forMBean(localMemberMBean).expectMBeanAt(this.managingNodeForNotifs).expectNotification("gemfire.distributedsystem.gateway.sender.created", (Object)ManagementUtil.getMemberID(), "GatewaySender Created in the VM ", names.size(), 5));
    }

    private void recycleConnections() {
        FederationBlackboard.urlsChecked = false;
        FederationBlackboard.getBB().getManagingNodes();
        FederationBlackboard.urlsChecked = true;
    }

    private void doJMXOps() {
        this.recycleConnections();
        Map mbeanMap = JMXBlackboard.getBB().getMap("MBEAN_MAP");
        String url = FederationBlackboard.getBB().getManagingNode();
        Set<ObjectName> gemfireMBeans = ManagementUtil.getGemfireMBeans(url);
        HydraUtil.logFine("MBeans " + gemfireMBeans + " found on url " + url);
        HydraUtil.logFine("mbeanMap " + mbeanMap);
        JMXOperations ops = this.buildeTestMap(gemfireMBeans, mbeanMap, url);
        ops.doJMXTest();
    }

    private JMXOperations buildeTestMap(Set<ObjectName> gemfireMBeans, Map<String, TestMBean> mbeanMap, String url) {
        int mbeansVisited = gemfireMBeans.size();
        int testMbeansVisited = mbeanMap.size();
        JMXOperations op = new JMXOperations();
        op.addManagingUrl(url);
        for (ObjectName n : gemfireMBeans) {
            for (String s : mbeanMap.keySet()) {
                if (!this.regexAndMemberMatch(n, s)) continue;
                TestMBean t = mbeanMap.get(s);
                op.addMbean(n, t);
                HydraUtil.logFine("Adding testMBean " + t.getType() + " for objectName " + n);
                --testMbeansVisited;
                --mbeansVisited;
            }
        }
        return op;
    }

    private boolean regexAndMemberMatch(ObjectName n, String s) {
        String name = n.toString();
        if (s.contains("?")) {
            Pattern myPattern = Pattern.compile(s);
            Matcher match = myPattern.matcher(name);
            boolean matchFound = match.find();
            HydraUtil.logFine("RegexMatching templateName " + s + " with string " + name + " result " + matchFound);
            return matchFound;
        }
        boolean bothDistributed = true;
        if (n.toString().contains(DISTRIBUTED_SUFFIX)) {
            bothDistributed = n.toString().contains(DISTRIBUTED_SUFFIX) && s.contains(DISTRIBUTED_SUFFIX);
        }
        boolean matched = n.toString().contains(s) && bothDistributed;
        HydraUtil.logFine("StringMatching templateName " + s + " with string " + n + " result " + matched);
        return matched;
    }

    private void initialize() {
        HydraUtil.logInfo("Management Service created : " + this.service);
        JMXBlackboard.getBB().initBlackBoard();
        this.createCache();
        String clientName = RemoteTestModule.getMyClientName();
        this.checkForLocatorNotification(clientName);
        if (!(clientName.contains("edge") || clientName.contains("managing") || clientName.contains("locator"))) {
            ManagementUtil.saveMemberMbeanInBlackboard();
        }
        if (!clientName.contains("edge") && this.service == null) {
            this.service = ManagementService.getManagementService((Cache)this.cache);
            if (this.service == null) {
                this.service = ManagementService.getExistingManagementService((Cache)this.cache);
            }
            if (!ManagementUtil.checkLocalMemberMBean()) {
                throw new TestException("Could not find MemberMbean in platform mbean server");
            }
        }
        HydraUtil.logInfo("Management Service created : " + this.service);
        if (!clientName.contains("edge") && this.service != null) {
            SystemManagementService mgmtService = (SystemManagementService)this.service;
            mgmtService.getLocalManager().runManagementTaskAdhoc();
        }
        if (!clientName.contains("edge") && this.service == null) {
            throw new TestException("Could not find management service");
        }
    }

    private void checkForLocatorNotification(String name) {
    }

    private void createCache() {
        if (this.cache == null) {
            String cacheConfig = TestConfig.tab().stringAt(CachePrms.names);
            this.cache = CacheHelper.getCache() == null ? (GemFireCacheImpl)CacheHelper.createCache(cacheConfig) : (GemFireCacheImpl)CacheHelper.getCache();
            this.ds = this.cache.getDistributedSystem();
        }
    }

    private void becomeManager() {
        ManagementUtil.saveMemberManagerInBlackboard();
        if (this.service == null) {
            throw new TestException("Could not find management service");
        }
        if (!this.service.isManager()) {
            this.service.startManager();
        }
        HydraUtil.sleepForReplicationJMX();
        try {
            ManagementUtil.checkIfThisMemberIsCompliantManager(ManagementFactory.getPlatformMBeanServer());
        }
        catch (IOException e) {
            throw new TestException("Error connecting manager", e);
        }
        catch (TestException e) {
            throw e;
        }
        HydraUtil.logInfo("JMX Manager Blackboard ");
        JMXManagerBlackboard.getInstance().print();
        HydraUtil.logInfo("JMX Manager Endpoints  " + HydraUtil.ObjectToString(JMXManagerHelper.getEndpoints()));
    }

    static {
        DISTRIBUTED_SUFFIX = "Distributed";
        queryRegion = "TestReplicatedAck_1";
        regionOps = null;
        dlockOps = null;
        cqOps = null;
    }
}

