/*
 * Decompiled with CFR 0.152.
 */
package mapregion.diskRegion;

import cacheperf.CachePerfPrms;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestTask;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import mapregion.MapPrms;
import objects.ObjectHelper;
import util.TestException;
import util.TestHelper;

public class TempPerfForDiskReg {
    static TempPerfForDiskReg testInstance;
    static DistributedSystem ds;
    private static Cache cache;
    static Region diskRegion;
    static String regionName;
    static RegionAttributes attr;
    static int totalThreads;
    private static HydraThreadLocal localkeycount;
    private static volatile long totalPuts;
    static Object totalLock;
    static int maxKeys;
    static volatile long totalTime;
    static volatile int startPoint;
    static ArrayList al;
    private static FileOutputStream file;
    private static BufferedWriter wr;

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new TempPerfForDiskReg();
            testInstance.initialize();
        }
        testInstance.initHydraThreadLocals();
    }

    protected void initialize() {
        try {
            this.initCache();
            attr = RegionHelper.getRegionAttributes(ConfigPrms.getRegionConfig());
            regionName = RegionHelper.getRegionDescription(ConfigPrms.getRegionConfig()).getRegionName();
            TestTask task = RemoteTestModule.getCurrentThread().getCurrentTask();
            totalThreads = task.getTotalThreads();
            if (diskRegion == null) {
                diskRegion = RegionHelper.createRegion(regionName, attr);
            }
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    protected void initHydraThreadLocals() {
        int startPoint = this.getStartPoint();
        this.setKeyCount(startPoint);
    }

    protected void setKeyCount(int n) {
        localkeycount.set(new Integer(n));
    }

    protected int getKeyCount() {
        Integer n = (Integer)localkeycount.get();
        if (n == null) {
            n = new Integer(0);
            localkeycount.set(n);
        }
        return n;
    }

    protected synchronized int getStartPoint() {
        return ++startPoint;
    }

    private synchronized void initCache() {
        try {
            if (cache == null || cache.isClosed()) {
                cache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
            }
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    public static void HydraTask_PerformPuts() {
        testInstance.performPutOperations();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performPutOperations() {
        try {
            Object key = null;
            Object val = null;
            String objectType = MapPrms.getObjectType();
            long puts = 0L;
            int putKeyInt = 0;
            int startPoint = this.getKeyCount();
            startPoint *= maxKeys;
            long start = System.currentTimeMillis();
            do {
                key = ObjectHelper.createName(startPoint + ++putKeyInt);
                val = ObjectHelper.createObject(objectType, startPoint + putKeyInt);
                diskRegion.put(key, val);
                ++puts;
            } while (putKeyInt < maxKeys);
            long end = System.currentTimeMillis();
            Object object = totalLock;
            synchronized (object) {
                al.add(new Long(end - start));
                totalPuts += puts;
                totalTime += end - start;
            }
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    public static synchronized void HydraTask_CloseTask() {
        testInstance.printValues();
        testInstance.closeCache();
    }

    protected void printValues() {
        try {
            Date date = new Date(System.currentTimeMillis());
            file = new FileOutputStream("./diskRegPerf-" + date.toGMTString().substring(0, date.toGMTString().indexOf("200") + 4).replace(' ', '-') + ".txt");
            wr = new BufferedWriter(new OutputStreamWriter(file));
            double avgTime = totalTime / (long)totalThreads;
            wr.write("====================DISK REGION PERFORMANCE REPORT===============================");
            wr.newLine();
            wr.flush();
            wr.write(" TOTAL NUMBER OF THREADS ARE: " + totalThreads);
            wr.flush();
            wr.newLine();
            wr.write(" TOTAL NUMBER OF PUTS IS: " + totalPuts);
            wr.flush();
            wr.newLine();
            wr.write(" TOTAL TIME TAKEN IS (total time per thread): " + avgTime);
            wr.flush();
            wr.newLine();
            wr.write(" AVERAGE NUMBER OF PUTS PER SECOND IS: " + (double)(totalPuts * 1000L) / avgTime);
            wr.flush();
            Log.getLogWriter().info(" TOTAL NUMBER OF THREADS ARE: " + totalThreads);
            Log.getLogWriter().info(" key count for this thread is: " + this.getKeyCount());
            Log.getLogWriter().info(" TOTAL NUMBER OF PUTS IS: " + totalPuts);
            Log.getLogWriter().info(" TOTAL TIME TAKEN IS (total time per thread): " + avgTime);
            Log.getLogWriter().info(" AVERAGE NUMBER OF PUTS PER SECOND IS: " + (double)(totalPuts * 1000L) / avgTime);
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
        Iterator itr = al.iterator();
        while (itr.hasNext()) {
            System.out.println((Long)itr.next());
        }
        System.out.println("-------------------------------------------------------");
    }

    public void closeCache() {
        try {
            if (cache != null || !cache.isClosed()) {
                CacheHelper.closeCache();
            }
        }
        catch (Exception ex) {
            throw new TestException(TestHelper.getStackTrace(ex));
        }
    }

    static {
        totalThreads = 0;
        localkeycount = new HydraThreadLocal();
        totalPuts = 0L;
        totalLock = "total";
        maxKeys = CachePerfPrms.getMaxKeys();
        totalTime = 0L;
        startPoint = 0;
        al = new ArrayList();
    }
}

