/*
 * Decompiled with CFR 0.152.
 */
package memscale;

import cacheperf.CachePerfClient;
import cacheperf.CachePerfPrms;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.StopSchedulingTaskOnClientOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import memscale.MemScaleBB;
import memscale.MemScalePrms;
import objects.ArrayOfBytePrms;
import objects.ObjectHelper;
import util.TestException;
import util.TestHelper;

public class MemScaleTest
extends CachePerfClient {
    private static final String CREATE_STEP = "Creating";
    private static final String DESTROY_STEP = "Destroying";
    private static HydraThreadLocal threadLocal_currentTaskStep = new HydraThreadLocal();
    private static HydraThreadLocal threadLocal_isLeader = new HydraThreadLocal();
    private int currentSize = 0;
    private static List<Integer> alternateMaxKeysList = null;
    private static List<Integer> alternateObjectSizesList = null;

    public static void HydraTask_initialize() {
        threadLocal_currentTaskStep.set(DESTROY_STEP);
        MemScaleBB.getBB().getSharedCounters().setIfLarger(MemScaleBB.currentExecutionCycle, 1L);
        Log.getLogWriter().info("Current execution cycle: " + MemScaleBB.getBB().getSharedCounters().read(MemScaleBB.currentExecutionCycle));
        MemScaleTest.initAlternateValues();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void HydraTask_destroyTest() {
        Object value = threadLocal_isLeader.get();
        boolean isLeader = false;
        if (value == null) {
            long leaderCounter = MemScaleBB.getBB().getSharedCounters().incrementAndRead(MemScaleBB.leader);
            isLeader = leaderCounter == 1L;
            threadLocal_isLeader.set(isLeader);
        } else {
            isLeader = (Boolean)value;
        }
        Log.getLogWriter().info("isLeader: " + isLeader);
        String currentTaskStep = (String)threadLocal_currentTaskStep.get();
        if (currentTaskStep.equals(CREATE_STEP)) {
            try {
                Log.getLogWriter().info("Creating data...");
                MemScaleTest.memScaleCreateData();
                return;
            }
            catch (StopSchedulingTaskOnClientOrder e) {
                if (isLeader) {
                    TestHelper.waitForCounter(MemScaleBB.getBB(), "doneCreating", MemScaleBB.doneCreating, CachePerfClient.numThreads() - 1, true, -1L, 500L);
                    Log.getLogWriter().info("Zeroing doneDestroying");
                    MemScaleBB.getBB().getSharedCounters().zero(MemScaleBB.doneDestroying);
                    CachePerfClient.sleepTask();
                    MemScaleBB.getBB().getSharedCounters().increment(MemScaleBB.doneCreating);
                } else {
                    MemScaleBB.getBB().getSharedCounters().increment(MemScaleBB.doneCreating);
                    TestHelper.waitForCounter(MemScaleBB.getBB(), "doneCreating", MemScaleBB.doneCreating, CachePerfClient.numThreads(), true, -1L, 100L);
                }
                CachePerfClient.resetPseudoRandomUniqueKeysTask();
                Log.getLogWriter().info("Changing to destroy step");
                currentTaskStep = DESTROY_STEP;
                threadLocal_currentTaskStep.set(currentTaskStep);
                if (!isLeader) return;
                long counter = MemScaleBB.getBB().getSharedCounters().incrementAndRead(MemScaleBB.currentExecutionCycle);
                Log.getLogWriter().info("Current execution cycle: " + counter);
                return;
            }
        }
        if (!currentTaskStep.equals(DESTROY_STEP)) throw new TestException("Unknown task step " + currentTaskStep);
        try {
            boolean useClear = MemScalePrms.getUseClear();
            if (useClear) {
                Log.getLogWriter().info("Clearing region...");
                CachePerfClient.clearTask();
                throw new StopSchedulingTaskOnClientOrder("Done with clear");
            }
            Log.getLogWriter().info("Destroying data...");
            MemScaleTest.memScaleDestroyData();
            return;
        }
        catch (StopSchedulingTaskOnClientOrder e) {
            long counter = MemScaleBB.getBB().getSharedCounters().read(MemScaleBB.currentExecutionCycle);
            Log.getLogWriter().info("Determining if it is time to stop, current execution cycle is " + counter);
            if (counter >= (long)MemScalePrms.getNumberExecutionCycles()) {
                throw new StopSchedulingTaskOnClientOrder("Terminating test because " + counter + " test cycles have completed");
            }
            if (isLeader) {
                TestHelper.waitForCounter(MemScaleBB.getBB(), "doneDestroying", MemScaleBB.doneDestroying, CachePerfClient.numThreads() - 1, true, -1L, 500L);
                Log.getLogWriter().info("Zeroing doneCreating");
                MemScaleBB.getBB().getSharedCounters().zero(MemScaleBB.doneCreating);
                CachePerfClient.sleepTask();
                MemScaleTest.advanceAlternateValues();
                MemScaleBB.getBB().getSharedCounters().increment(MemScaleBB.doneDestroying);
            } else {
                MemScaleBB.getBB().getSharedCounters().increment(MemScaleBB.doneDestroying);
                TestHelper.waitForCounter(MemScaleBB.getBB(), "doneDestroying", MemScaleBB.doneDestroying, CachePerfClient.numThreads(), true, -1L, 100L);
            }
            CachePerfClient.resetPseudoRandomUniqueKeysTask();
            if (alternateMaxKeysList != null) {
                MemScaleTest memScale = new MemScaleTest();
                memScale.setNumPseudoRandomKeys(-1L);
            }
            Log.getLogWriter().info("Changing to create step");
            currentTaskStep = CREATE_STEP;
            threadLocal_currentTaskStep.set(currentTaskStep);
            return;
        }
    }

    private static void memScaleCreateData() {
        MemScaleTest memScale = new MemScaleTest();
        memScale.initialize(1);
        MemScaleTest.setAlternateValues(memScale);
        memScale.createData();
    }

    private static void memScaleDestroyData() {
        MemScaleTest memScale = new MemScaleTest();
        memScale.initialize(7);
        MemScaleTest.setAlternateValues(memScale);
        memScale.destroyData();
    }

    private static synchronized void initAlternateValues() throws TestException {
        Vector alternateMaxKeysParam = MemScalePrms.getAlternateMaxKeys();
        Vector alternateObjectSizesParam = MemScalePrms.getAlternateObjectSizes();
        if (alternateMaxKeysParam == null || alternateObjectSizesParam == null) {
            if (alternateMaxKeysParam != null || alternateObjectSizesParam != null) {
                throw new TestException(MemScalePrms.class.getName() + ".alternateObjectSizes and " + MemScalePrms.class.getName() + "-alternateMaxKeys must either both be set or neither set");
            }
            return;
        }
        if (alternateMaxKeysParam.size() != alternateObjectSizesParam.size()) {
            throw new TestException(MemScalePrms.class.getName() + ".alternateMaxKeys is size " + alternateMaxKeysParam.size() + ", but must be the same size as " + MemScalePrms.class.getName() + "-alternateObjectSizes of size " + alternateObjectSizesParam.size());
        }
        if (alternateMaxKeysParam.size() == 0) {
            throw new TestException(MemScalePrms.class.getName() + ".alternateMaxKeys is size 0");
        }
        alternateMaxKeysList = new ArrayList<Integer>();
        alternateObjectSizesList = new ArrayList<Integer>();
        for (int i = 0; i < alternateMaxKeysParam.size(); ++i) {
            alternateMaxKeysList.add(Integer.valueOf((String)alternateMaxKeysParam.get(i)));
            alternateObjectSizesList.add(Integer.valueOf((String)alternateObjectSizesParam.get(i)));
        }
        Log.getLogWriter().info("alternateMaxKeys is " + alternateMaxKeysList + ", alternateSizes is " + alternateObjectSizesList);
        MemScaleBB.getBB().getSharedCounters().setIfLarger(MemScaleBB.index, alternateMaxKeysList.size());
    }

    private static void setAlternateValues(MemScaleTest memScale) {
        int index = (int)MemScaleBB.getBB().getSharedCounters().read(MemScaleBB.index);
        if (alternateMaxKeysList != null) {
            if (index < alternateMaxKeysList.size()) {
                memScale.maxKeys = alternateMaxKeysList.get(index);
                memScale.currentSize = alternateObjectSizesList.get(index);
                int numMembers = MemScalePrms.getNumMembers();
                memScale.maxKeys *= numMembers;
            } else {
                memScale.maxKeys = CachePerfPrms.getMaxKeys();
                memScale.currentSize = ArrayOfBytePrms.getSize();
            }
            Log.getLogWriter().info("Using maxKeys " + memScale.maxKeys + ", objectSize " + memScale.currentSize);
        }
    }

    private static void advanceAlternateValues() {
        if (alternateMaxKeysList != null) {
            int index = (int)MemScaleBB.getBB().getSharedCounters().read(MemScaleBB.index);
            if (index >= alternateMaxKeysList.size()) {
                MemScaleBB.getBB().getSharedCounters().zero(MemScaleBB.index);
            } else {
                MemScaleBB.getBB().getSharedCounters().increment(MemScaleBB.index);
            }
            Log.getLogWriter().info("Advanced index used to choose maxKeys/objectSizes to " + MemScaleBB.getBB().getSharedCounters().read(MemScaleBB.index));
        }
    }

    @Override
    protected void create(int i) {
        if (alternateMaxKeysList != null) {
            Object key = ObjectHelper.createName(this.keyType, i);
            byte[] val = new byte[this.currentSize];
            long start = this.statistics.startCreate();
            this.cache.create(key, val);
            this.statistics.endCreate(start, this.isMainWorkload, this.histogram);
        } else {
            super.create(i);
        }
    }
}

