/*
 * Decompiled with CFR 0.152.
 */
package memscale;

public class OffHeapChunkInfo
implements Comparable {
    private String regionName = null;
    private Object key = null;
    private long firstMemoryAddress = -1L;
    private long numberBytes = -1L;

    public OffHeapChunkInfo(String regionNameArg, Object keyArg, long memoryAddressArg, long numberBytesArg) {
        this.regionName = regionNameArg;
        this.key = keyArg;
        this.firstMemoryAddress = memoryAddressArg;
        this.numberBytes = numberBytesArg;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.firstMemoryAddress ^ this.firstMemoryAddress >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OffHeapChunkInfo)) {
            return false;
        }
        OffHeapChunkInfo other = (OffHeapChunkInfo)obj;
        return this.firstMemoryAddress == other.firstMemoryAddress;
    }

    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        OffHeapChunkInfo other = (OffHeapChunkInfo)o;
        if (this.firstMemoryAddress < other.firstMemoryAddress) {
            return -1;
        }
        return 1;
    }

    public long getLastMemoryAddress() {
        return this.firstMemoryAddress + this.numberBytes - 1L;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public Object getKey() {
        return this.key;
    }

    public long getFirstMemoryAddress() {
        return this.firstMemoryAddress;
    }

    public long getNumberBytes() {
        return this.numberBytes;
    }

    public String toString() {
        return "Off-heap memory for key " + this.getKey() + " in " + this.getRegionName() + " starts at " + this.getFirstMemoryAddress() + " and ends at " + this.getLastMemoryAddress() + " (span of " + this.getNumberBytes() + " bytes)";
    }
}

