/*
 * Decompiled with CFR 0.152.
 */
package memscale;

import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import hydra.Log;
import hydra.RemoteTestModule;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import memscale.OffHeapHelper;
import memscale.OffHeapMemoryLifecycleBB;
import util.TestException;

public class OffHeapMemoryLifecycleListener
implements SimpleMemoryAllocatorImpl.LifecycleListener {
    private static boolean installed = false;
    private static Integer myVmId = null;
    private static Integer myPid = null;

    public static synchronized void install() {
        if (installed) {
            Log.getLogWriter().info("Not installing " + OffHeapMemoryLifecycleListener.class.getName() + " in this member because it is already installed");
        } else {
            SimpleMemoryAllocatorImpl.addLifecycleListener((SimpleMemoryAllocatorImpl.LifecycleListener)new OffHeapMemoryLifecycleListener());
            Log.getLogWriter().info("Installed " + OffHeapMemoryLifecycleListener.class.getName());
            myVmId = RemoteTestModule.getMyVmid();
            myPid = RemoteTestModule.getMyPid();
            installed = true;
        }
    }

    public static void checkForErrors() {
        List errList = (List)OffHeapMemoryLifecycleBB.getBB().getSharedMap().get("error");
        if (errList != null) {
            Log.getLogWriter().info("Detected " + errList.size() + " errors as follows:\n");
            for (Object err : errList) {
                Log.getLogWriter().info(err.toString());
            }
            throw new TestException(OffHeapMemoryLifecycleListener.class.getName() + " detected " + errList.size() + " errors (see logs), first error is " + errList.get(0));
        }
    }

    public void afterCreate(SimpleMemoryAllocatorImpl allocator) {
    }

    public void afterReuse(SimpleMemoryAllocatorImpl allocator) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeClose(SimpleMemoryAllocatorImpl allocator) {
        Log.getLogWriter().info("In " + this.getClass().getName() + ".beforeClose (of SimpleMemoryAllocator)");
        if (OffHeapHelper.isOffHeapMemoryConfigured()) {
            int objectsStat = OffHeapHelper.getOffHeapMemoryStats().getObjects();
            if (objectsStat != 0) {
                OffHeapHelper.waitForOffHeapSilence(30);
            }
            try {
                OffHeapHelper.verifyOffHeapMemoryConsistencyOnce();
            }
            catch (TestException e) {
                Class<?> clazz = this.getClass();
                synchronized (clazz) {
                    String errStr = this.getClass().getName() + " logged this exception in vmId " + myVmId + " (pid " + myPid + ") at " + new Date() + ": " + e.getMessage();
                    Log.getLogWriter().info(errStr);
                    ArrayList<String> aList = (ArrayList<String>)OffHeapMemoryLifecycleBB.getBB().getSharedMap().get("error");
                    if (aList == null) {
                        aList = new ArrayList<String>();
                    }
                    aList.add(errStr);
                    OffHeapMemoryLifecycleBB.getBB().getSharedMap().put("error", aList);
                }
            }
        } else {
            Log.getLogWriter().info("No off-heap memory in this member");
        }
    }
}

