/*
 * Decompiled with CFR 0.152.
 */
package memscale;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.OutOfOffHeapMemoryException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.offheap.OffHeapMemoryStats;
import com.gemstone.gemfire.pdx.PdxInstance;
import diskRecovery.RecoveryBB;
import diskRecovery.RecoveryTestVersionHelper;
import hydra.CacheHelper;
import hydra.DistributedSystemHelper;
import hydra.GsRandom;
import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import management.test.cli.CommandTestVersionHelper;
import memscale.MemScaleBB;
import memscale.MemScalePrms;
import memscale.OffHeapHelper;
import parReg.ParRegUtil;
import util.NameFactory;
import util.PRObserver;
import util.TestException;
import util.TestHelper;

public class OffHeapStressTest {
    private static GsRandom gsRand = TestConfig.tab().getRandGen();
    private static final int[] sizes = new int[]{1, 10000, 50, 863, 5000};
    private static HydraThreadLocal threadLocal_isLeader = new HydraThreadLocal();
    private static volatile long[] putDurationHistory = new long[100];
    private static volatile long[] failedPutDurationHistory = new long[100];
    private static volatile long[] destroyDurationHistory = new long[100];
    private static final int OP_DURATION_THRESHOLD_MS = 10000;
    private static final String allRegionsSnapshotKey = "snapshot";
    private static final String isDataStoreKey = "vmIdIsDataStore_";
    static long endTime = 0L;

    public static synchronized void HydraTask_createLocator() {
        DistributedSystemHelper.createLocator();
    }

    public static synchronized void HydraTask_startLocatorAndDS() {
        DistributedSystemHelper.startLocatorAndDS();
    }

    public static synchronized void HydraTask_initializeRegions() {
        if (CacheHelper.getCache() == null) {
            CacheHelper.createCache("cache1");
        }
        if (CacheHelper.getCache().rootRegions().size() == 0) {
            CommandTestVersionHelper.createRegions();
            PRObserver.installObserverHook();
            PRObserver.initialize();
            if (OffHeapStressTest.thisMemberIsDataStore()) {
                MemScaleBB.getBB().getSharedMap().put(isDataStoreKey + RemoteTestModule.getMyVmid(), RemoteTestModule.getMyVmid());
            }
        }
    }

    private static int getPRCount() {
        Set<Region<?, ?>> allRegions = OffHeapStressTest.getAllRegions();
        int PRCount = 0;
        for (Region<?, ?> aRegion : allRegions) {
            if (!aRegion.getAttributes().getDataPolicy().withPartitioning()) continue;
            ++PRCount;
        }
        return PRCount;
    }

    public static void HydraTask_offHeapCeilingTest() {
        SharedCounters sc = MemScaleBB.getBB().getSharedCounters();
        int numThreads = MemScalePrms.getNumThreads1();
        Object value = threadLocal_isLeader.get();
        boolean isLeader = false;
        if (value == null) {
            if (!OffHeapStressTest.thisMemberIsAccessor() && !OffHeapStressTest.thisMemberExpectsOOM()) {
                long leaderCounter = sc.incrementAndRead(MemScaleBB.leader);
                isLeader = leaderCounter == 1L;
                threadLocal_isLeader.set(isLeader);
            }
        } else {
            isLeader = (Boolean)value;
        }
        Log.getLogWriter().info("isLeader: " + isLeader);
        if (isLeader) {
            Log.getLogWriter().info("Execution number: " + sc.incrementAndRead(MemScaleBB.currentExecutionCycle));
        }
        Log.getLogWriter().info("Putting until designated members get out of memory for off-heap");
        OffHeapStressTest.putUntilOthersGetOOM();
        Log.getLogWriter().info("About to pause with pause1 counter, then do data validation");
        OffHeapStressTest.pause(isLeader, "pause1", new String[]{"pause3"}, numThreads, true);
        OffHeapStressTest.doDataValidationOnce();
        OffHeapHelper.verifyOffHeapMemoryConsistencyOnce();
        Log.getLogWriter().info("About to pause with pause2 counter, then close all regions and do off-heap memory consistency checks");
        OffHeapStressTest.pause(isLeader, "pause2", new String[]{"pause4"}, numThreads, false);
        OffHeapHelper.closeAllRegions();
        OffHeapHelper.waitForOffHeapSilence(10);
        OffHeapHelper.verifyOffHeapMemoryConsistencyOnce();
        if (sc.read(MemScaleBB.currentExecutionCycle) >= (long)MemScalePrms.getNumberExecutionCycles()) {
            sc.increment(MemScaleBB.timeToStop);
        }
        Log.getLogWriter().info("About to pause with pause3 counter, then reinitialize");
        OffHeapStressTest.pause(isLeader, "pause3", new String[]{"pause1", "receivedOOM"}, numThreads, false);
        OffHeapStressTest.HydraTask_initializeRegions();
        if (isLeader) {
            Log.getLogWriter().info("Leader is incrementing doneValidator to let OOM members know it is time to reinitialize");
            MemScaleBB.getBB().getSharedCounters().increment(MemScaleBB.doneValidating);
        }
        Log.getLogWriter().info("About to pause with pause4 counter to signal the end of the test cycle");
        OffHeapStressTest.pause(isLeader, "pause4", new String[]{"pause2", "doneValidating"}, MemScalePrms.getNumThreads2(), false);
        if (sc.read(MemScaleBB.timeToStop) > 0L) {
            throw new StopSchedulingTaskOnClientOrder("Completed " + sc.read(MemScaleBB.currentExecutionCycle) + " test cycles");
        }
    }

    private static List<Integer> getDataStoreVmIds() {
        Map sharedMap = MemScaleBB.getBB().getSharedMap().getMap();
        ArrayList<Integer> aList = new ArrayList<Integer>();
        for (Object key : sharedMap.keySet()) {
            if (!(key instanceof String) || !((String)key).startsWith(isDataStoreKey)) continue;
            aList.add((Integer)sharedMap.get(key));
        }
        return aList;
    }

    public static void HydraTask_offHeapCeilingTestOOM() throws Throwable {
        SharedCounters sc = MemScaleBB.getBB().getSharedCounters();
        boolean isLeader = false;
        Log.getLogWriter().info("isLeader: false");
        Cache theCache = CacheHelper.getCache();
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        OffHeapStressTest.putUntilOOMDetected();
        long begin = System.currentTimeMillis();
        while (!theCache.isClosed() || ds.isConnected()) {
            Thread.sleep(100L);
            if (System.currentTimeMillis() <= begin + 60000L) continue;
        }
        boolean cacheClosed = theCache.isClosed();
        boolean dsConnected = ds.isConnected();
        Log.getLogWriter().info("After getting off-heap OOM, cacheClosed is " + cacheClosed + ", dsConnected is " + dsConnected);
        if (!cacheClosed) {
            throw new TestException("Expected the cache to be closed, but Cache.isClosed() is " + cacheClosed);
        }
        if (dsConnected) {
            throw new TestException("Expected the distributed system to be disconnected, but isConnected() is " + dsConnected);
        }
        TestHelper.waitForCounter(MemScaleBB.getBB(), "doneValidating", MemScaleBB.doneValidating, 1L, true, -1L, 1000L);
        DistributedSystemHelper.cleanupAfterAutoDisconnect();
        OffHeapStressTest.HydraTask_initializeRegions();
        OffHeapStressTest.pause(false, "pause4", null, MemScalePrms.getNumThreads2(), false);
        OffHeapStressTest.logDurationHistory();
        if (sc.read(MemScaleBB.timeToStop) > 0L) {
            throw new StopSchedulingTaskOnClientOrder("Completed " + sc.read(MemScaleBB.currentExecutionCycle) + " test cycles");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doDataValidationOnce() {
        long verifyRequestedTime = System.currentTimeMillis();
        Class<OffHeapHelper> clazz = OffHeapHelper.class;
        synchronized (OffHeapHelper.class) {
            if (verifyRequestedTime > endTime) {
                OffHeapStressTest.verifyFromSnapshot();
                OffHeapStressTest.verifyPRs();
                endTime = System.currentTimeMillis();
            } else {
                Log.getLogWriter().info("This thread did not do data consistency validation because it was done by another thread in this member");
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    private static void pause(boolean isLeader, String pauseCounterName, String[] counterNamesToZero, int counterTarget, boolean writeSnapshot) {
        MemScaleBB bb = MemScaleBB.getBB();
        SharedCounters sc = bb.getSharedCounters();
        if (isLeader) {
            TestHelper.waitForCounter(bb, pauseCounterName, bb.getSharedCounter(pauseCounterName), counterTarget - 1, true, -1L, 1000L);
            Log.getLogWriter().info("Leader has determined that all threads have paused on counter " + pauseCounterName);
            if (writeSnapshot) {
                OffHeapStressTest.writeSnapshot();
            }
            if (counterNamesToZero != null) {
                for (String counterToZero : counterNamesToZero) {
                    Log.getLogWriter().info("Zeroing " + counterToZero);
                    sc.zero(bb.getSharedCounter(counterToZero));
                }
            }
            Log.getLogWriter().info("Leader is doing the last counter increment for counter " + pauseCounterName + " to allow all theads to proceed");
            sc.increment(bb.getSharedCounter(pauseCounterName));
        } else {
            sc.increment(bb.getSharedCounter(pauseCounterName));
            TestHelper.waitForCounter(bb, pauseCounterName, bb.getSharedCounter(pauseCounterName), counterTarget, true, -1L, 1000L);
        }
    }

    private static void writeSnapshot() {
        Set<Region<?, ?>> allRegions = OffHeapStressTest.getAllRegions();
        Log.getLogWriter().info("Preparing to write snapshot for " + allRegions.size() + " regions");
        HashMap allRegionsSnapshot = new HashMap();
        for (Region<?, ?> aRegion : allRegions) {
            HashMap regionSnapshot = new HashMap();
            for (Object key : aRegion.keySet()) {
                Object value = null;
                if (aRegion.containsValueForKey(key)) {
                    value = aRegion.get(key);
                }
                byte[] byteArr = (byte[])value;
                regionSnapshot.put(key, byteArr.length);
            }
            allRegionsSnapshot.put(aRegion.getFullPath(), regionSnapshot);
            Log.getLogWriter().info("Region snapshot for " + aRegion.getFullPath() + " is size " + regionSnapshot.size() + " and contains keys " + regionSnapshot.keySet());
        }
        RecoveryBB.getBB().getSharedMap().put(allRegionsSnapshotKey, allRegionsSnapshot);
        Log.getLogWriter().info("Put snapshot for " + allRegions.size() + " regions into blackboard at key " + allRegionsSnapshotKey);
    }

    private static void verifyFromSnapshot() {
        Map allRegionsSnapshot = (Map)RecoveryBB.getBB().getSharedMap().get(allRegionsSnapshotKey);
        for (String regionName : allRegionsSnapshot.keySet()) {
            Map regionSnapshot = (Map)allRegionsSnapshot.get(regionName);
            Region aRegion = CacheHelper.getCache().getRegion(regionName);
            if (aRegion == null) {
                throw new TestException("Region " + regionName + " could not be found in cache");
            }
            OffHeapStressTest.verifyFromSnapshot(aRegion, regionSnapshot);
        }
    }

    private static void verifyFromSnapshot(Region aRegion, Map regionSnapshot) {
        StringBuffer errStr = new StringBuffer();
        int snapshotSize = regionSnapshot.size();
        int regionSize = aRegion.size();
        long startVerifyTime = System.currentTimeMillis();
        Log.getLogWriter().info("Verifying " + aRegion.getFullPath() + "  of size " + aRegion.size() + " against snapshot containing " + regionSnapshot.size() + " entries...");
        if (aRegion.getAttributes().getDataPolicy().isEmpty()) {
            for (Object key : regionSnapshot.keySet()) {
                Object actualValue = aRegion.get(key);
                Object expectedValue = regionSnapshot.get(key);
                errStr.append(OffHeapStressTest.validate(key, actualValue, expectedValue));
            }
        } else {
            if (snapshotSize != regionSize) {
                errStr.append("Expected region " + aRegion.getFullPath() + " to be size " + snapshotSize + ", but it is " + regionSize + "\n");
            }
            for (Object key : regionSnapshot.keySet()) {
                try {
                    ParRegUtil.verifyContainsKey(aRegion, key, true);
                }
                catch (TestException e) {
                    errStr.append(e.getMessage() + "\n");
                }
                boolean containsValueForKey = aRegion.containsValueForKey(key);
                Object expectedValue = regionSnapshot.get(key);
                try {
                    ParRegUtil.verifyContainsValueForKey(aRegion, key, expectedValue != null);
                }
                catch (TestException e) {
                    errStr.append(e.getMessage() + "\n");
                }
                if (!containsValueForKey) continue;
                Object actualValue = aRegion.get(key);
                if (actualValue instanceof PdxInstance) {
                    actualValue = RecoveryTestVersionHelper.toValueHolder(actualValue);
                }
                errStr.append(OffHeapStressTest.validate(key, actualValue, expectedValue));
            }
        }
        HashSet aRegionKeySet = new HashSet(aRegion.keySet());
        Set snapshotKeySet = regionSnapshot.keySet();
        aRegionKeySet.removeAll(snapshotKeySet);
        if (aRegionKeySet.size() != 0) {
            errStr.append("Found the following unexpected keys in " + aRegion.getFullPath() + ": " + aRegionKeySet + "\n");
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
        Log.getLogWriter().info("Done verifying " + aRegion.getFullPath() + " from snapshot containing " + snapshotSize + " entries, " + "verification took " + (System.currentTimeMillis() - startVerifyTime) + "ms");
    }

    private static String validate(Object key, Object actualValue, Object expectedValue) {
        boolean isEqual = true;
        if (actualValue == null || expectedValue == null) {
            if (actualValue != expectedValue) {
                return "For key " + key + ", expected value to be " + TestHelper.toString(expectedValue) + ", but it is " + TestHelper.toString(actualValue) + "\n";
            }
        } else {
            byte[] actualByteArr = (byte[])actualValue;
            Integer expectedLength = (Integer)expectedValue;
            if (actualByteArr.length != expectedLength) {
                return "Expected " + TestHelper.toString(actualValue) + " to be a byte[] of length " + expectedLength + " but it is length " + actualByteArr.length;
            }
        }
        return "";
    }

    private static void putUntilOthersGetOOM() {
        Log.getLogWriter().info("Putting until other members get OOM");
        if (!OffHeapStressTest.thisMemberIsAccessor()) {
            long counter;
            OffHeapMemoryStats offHeapStats = OffHeapHelper.getOffHeapMemoryStats();
            long totalOffHeapSizeInBytes = offHeapStats.getMaxMemory();
            long thresholdInBytes = (long)((double)totalOffHeapSizeInBytes * 0.3);
            Set<Region<?, ?>> regionSet = OffHeapStressTest.getAllRegions();
            int numOOMMembers = MemScalePrms.getNumMembers();
            block4: while (true) {
                Iterator<Region<?, ?>> i$ = regionSet.iterator();
                do {
                    Object key;
                    if (!i$.hasNext()) continue block4;
                    Region<?, ?> aRegion = i$.next();
                    long currentOffHeapSizeInBytes = offHeapStats.getUsedMemory();
                    Log.getLogWriter().info("currentOffHeapSizeinBytes = " + currentOffHeapSizeInBytes + ", threshold in bytes is " + thresholdInBytes);
                    if (currentOffHeapSizeInBytes < thresholdInBytes) {
                        key = OffHeapStressTest.getNextKey();
                        Log.getLogWriter().info("Putting " + key + " into " + aRegion.getFullPath());
                        Object value = OffHeapStressTest.getValue();
                        long startTime = System.currentTimeMillis();
                        aRegion.put(key, value);
                        long duration = System.currentTimeMillis() - startTime;
                        OffHeapStressTest.handleSuccessfulPutDuration(duration);
                        continue;
                    }
                    try {
                        try {
                            key = aRegion.keySet().iterator().next();
                            Log.getLogWriter().info("Destroying " + key + " in " + aRegion.getFullPath());
                            long startTime = System.currentTimeMillis();
                            aRegion.destroy(key);
                            long duration = System.currentTimeMillis() - startTime;
                            OffHeapStressTest.handleSuccessfulDestroyDuration(duration);
                        }
                        catch (NoSuchElementException e) {
                            Log.getLogWriter().info("No element in " + aRegion.getFullPath() + " to destroy");
                        }
                    }
                    catch (EntryNotFoundException e) {
                        Log.getLogWriter().info("Caught expected " + ((Object)((Object)e)).getClass().getName());
                    }
                } while ((counter = MemScaleBB.getBB().getSharedCounters().read(MemScaleBB.receivedOOM)) != (long)numOOMMembers);
                break;
            }
            Log.getLogWriter().info(counter + " members received ouf-of-off-heap exceptions");
            return;
        }
        OffHeapStressTest.accessorPutUntilOthersGetOOM();
        OffHeapStressTest.logDurationHistory();
    }

    private static void handleSuccessfulPutDuration(long duration) {
        int sec;
        Log.getLogWriter().info("Put completed in " + duration + " ms");
        if (duration > 10000L) {
            OffHeapStressTest.logDurationHistory();
            throw new TestException("Bug 49735 detected: Put took " + duration + " ms, too long!");
        }
        int n = sec = (int)(duration / 1000L);
        putDurationHistory[n] = putDurationHistory[n] + 1L;
    }

    private static void handleSuccessfulDestroyDuration(long duration) {
        int sec;
        Log.getLogWriter().info("Destroy completed in " + duration + " ms");
        if (duration > 10000L) {
            OffHeapStressTest.logDurationHistory();
            throw new TestException("Bug 49735 detected: Destroy took " + duration + " ms, too long!");
        }
        int n = sec = (int)(duration / 1000L);
        destroyDurationHistory[n] = destroyDurationHistory[n] + 1L;
    }

    private static void handleFailedPutDuration(long duration) {
        int sec;
        Log.getLogWriter().info("Failed put completed in " + duration + " ms");
        if (duration > 10000L) {
            OffHeapStressTest.logDurationHistory();
            throw new TestException("Bug 49735 detected: Failed put took " + duration + " ms, too long!");
        }
        int n = sec = (int)(duration / 1000L);
        failedPutDurationHistory[n] = failedPutDurationHistory[n] + 1L;
    }

    public static void logDurationHistory() {
        OffHeapStressTest.logHistory("successful put", putDurationHistory);
        OffHeapStressTest.logHistory("failed put", failedPutDurationHistory);
        OffHeapStressTest.logHistory("successful destroy", destroyDurationHistory);
    }

    private static void logHistory(String opType, long[] history) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(opType + " duration history for this member:\n");
        int lastNonZeroIndex = 0;
        for (i = history.length - 1; i > 0; --i) {
            if (history[i] == 0L) continue;
            lastNonZeroIndex = i;
            break;
        }
        if (lastNonZeroIndex >= 0) {
            for (i = 0; i <= lastNonZeroIndex; ++i) {
                int lowerBoundMS = i * 1000;
                int upperBoundMS = lowerBoundMS + 999;
                sb.append("Num " + opType + "s between " + lowerBoundMS + " and " + upperBoundMS + " milliseconds: " + history[i] + "\n");
            }
        }
        Log.getLogWriter().info(sb.toString());
    }

    public static void checkOperationTimes() {
        OffHeapStressTest.checkOperationTimes("successful put", putDurationHistory);
        OffHeapStressTest.checkOperationTimes("failed put", failedPutDurationHistory);
        OffHeapStressTest.checkOperationTimes("successful destroy", destroyDurationHistory);
    }

    public static void checkOperationTimes(String opName, long[] history) {
        int threshold;
        int lastNonZeroIndex = -1;
        for (int i = history.length - 1; i > 0; --i) {
            if (history[i] == 0L) continue;
            lastNonZeroIndex = i;
            break;
        }
        if (lastNonZeroIndex >= (threshold = 10)) {
            throw new TestException("Bug 49735 detected: " + opName + " took longer than " + threshold + " seconds in this member");
        }
    }

    private static void accessorPutUntilOthersGetOOM() {
        Set<Region<?, ?>> regionSet = OffHeapStressTest.getAllRegions();
        int numOOMMembers = MemScalePrms.getNumMembers();
        block0: while (true) {
            Iterator<Region<?, ?>> i$ = regionSet.iterator();
            while (true) {
                if (!i$.hasNext()) continue block0;
                Region<?, ?> aRegion = i$.next();
                long counter = MemScaleBB.getBB().getSharedCounters().read(MemScaleBB.receivedOOM);
                if (counter == (long)numOOMMembers) {
                    Log.getLogWriter().info(counter + " members received ouf-of-off-heap exceptions");
                    OffHeapStressTest.logDurationHistory();
                    return;
                }
                Object key = OffHeapStressTest.getNextKey();
                Log.getLogWriter().info("Putting " + key + " into " + aRegion.getFullPath());
                Object value = OffHeapStressTest.getValue();
                long startTime = System.currentTimeMillis();
                aRegion.put(key, value);
                long duration = System.currentTimeMillis() - startTime;
                OffHeapStressTest.handleSuccessfulPutDuration(duration);
            }
            break;
        }
    }

    private static void putUntilOOMDetected() throws Throwable {
        Log.getLogWriter().info("Putting until this member gets OOM exception");
        Set<Region<?, ?>> regionSet = OffHeapStressTest.getAllRegions();
        OffHeapMemoryStats stats = OffHeapHelper.getOffHeapMemoryStats();
        long previousNumCompactions = stats.getCompactions();
        block4: while (true) {
            Iterator<Region<?, ?>> i$ = regionSet.iterator();
            while (true) {
                long duration;
                if (!i$.hasNext()) continue block4;
                Region<?, ?> aRegion = i$.next();
                long startTime = 0L;
                try {
                    Object key = OffHeapStressTest.getNextKey();
                    Log.getLogWriter().info("Putting " + key);
                    startTime = System.currentTimeMillis();
                    aRegion.put(key, OffHeapStressTest.getValue());
                    duration = System.currentTimeMillis() - startTime;
                    OffHeapStressTest.handleSuccessfulPutDuration(duration);
                }
                catch (Throwable t) {
                    duration = System.currentTimeMillis() - startTime;
                    OffHeapStressTest.handleException(t);
                    OffHeapStressTest.handleFailedPutDuration(duration);
                    OffHeapStressTest.verifyCompaction(stats, previousNumCompactions);
                    long begin = System.currentTimeMillis();
                    int sleepMs = 5000;
                    do {
                        try {
                            Log.getLogWriter().info("Trying to get the cache...");
                            CacheFactory.getAnyInstance();
                            Log.getLogWriter().info("Successfully got the cache");
                        }
                        catch (CancelException ce) {
                            Log.getLogWriter().info("Caught expected " + ((Object)((Object)ce)).getClass().getName());
                            long receivedOOM = MemScaleBB.getBB().getSharedCounters().incrementAndRead(MemScaleBB.receivedOOM);
                            Log.getLogWriter().info("MemScaleBB.receivedOOM is now " + receivedOOM);
                            return;
                        }
                        Log.getLogWriter().info("Cache not yet closed trying again in 5000 ms");
                        MasterController.sleepForMs(5000);
                    } while (System.currentTimeMillis() <= begin + 360000L);
                    throw new TestException("putUntilOOMDetected waited too long for CacheFactory.getAnyInstance() to throw CancelException");
                }
            }
            break;
        }
    }

    private static void verifyCompaction(OffHeapMemoryStats stats, long previousNumCompactions) {
        long compactions = stats.getCompactions();
        long compactionTime = stats.getCompactionTime();
        Log.getLogWriter().info("Compactions (from stats): " + compactions);
        Log.getLogWriter().info("Compaction time (from stats): " + compactionTime);
        if (compactions <= previousNumCompactions) {
            throw new TestException("Expected compactions stat to be " + previousNumCompactions + ", but it is " + compactions);
        }
        if (compactionTime <= 0L) {
            throw new TestException("Expected compactionTime stat to be > 0, but it is " + compactionTime);
        }
    }

    public static void handleException(Throwable t) throws Throwable {
        Log.getLogWriter().info("In handleException");
        if (t instanceof OutOfOffHeapMemoryException) {
            Log.getLogWriter().info("Got expected " + t.getClass().getName());
        } else if (t instanceof CancelException) {
            StringBuilder causeChainStr = new StringBuilder();
            ArrayList<Throwable> causeChain = new ArrayList<Throwable>();
            ArrayList<String> causeMsg = new ArrayList<String>();
            causeChain.add(t);
            causeMsg.add(t.getMessage());
            causeChainStr.append(t.getClass().getName());
            for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
                causeChain.add(cause);
                causeMsg.add(cause.getMessage());
                causeChainStr.append(" caused by " + cause.getClass().getName());
            }
            Throwable lastCause = (Throwable)causeChain.get(causeChain.size() - 1);
            String lastCauseMsg = (String)causeMsg.get(causeMsg.size() - 1);
            if (lastCause instanceof OutOfOffHeapMemoryException) {
                Log.getLogWriter().info("Got expected " + OutOfOffHeapMemoryException.class.getName() + " with this exeption chain: " + causeChainStr);
            }
        } else {
            throw t;
        }
    }

    private static void makeRoom(int percent) {
        Log.getLogWriter().info("Destroying " + percent + " percent of entries in each region");
        Set<Region<?, ?>> regionSet = OffHeapStressTest.getAllRegions();
        for (Region<?, ?> aRegion : regionSet) {
            int numToDestroy = (int)((double)aRegion.size() * ((double)percent * 0.01));
            Log.getLogWriter().info("Destroying " + numToDestroy + " in " + aRegion.getFullPath() + " of size " + aRegion.size());
            for (Object key : aRegion.keySet()) {
                aRegion.destroy(key);
            }
        }
    }

    private static Set<Region<?, ?>> getAllRegions() {
        HashSet regionSet = new HashSet(CacheHelper.getCache().rootRegions());
        HashSet rootRegions = new HashSet(regionSet);
        for (Region aRegion : rootRegions) {
            regionSet.addAll(aRegion.subregions(true));
        }
        return regionSet;
    }

    private static Object getNextKey() {
        String key = NameFactory.getNextPositiveObjectName();
        return key;
    }

    private static Object getValue() {
        byte[] value = new byte[sizes[gsRand.nextInt(0, sizes.length - 1)]];
        return value;
    }

    private static void verifyPRs() {
        StringBuilder aStr = new StringBuilder();
        Set<Region<?, ?>> regionSet = OffHeapStressTest.getAllRegions();
        for (Region<?, ?> aRegion : regionSet) {
            if (!aRegion.getAttributes().getDataPolicy().withPartitioning()) continue;
            try {
                ParRegUtil.verifyPRMetaData(aRegion);
            }
            catch (Exception e) {
                aStr.append(TestHelper.getStackTrace(e) + "\n");
            }
            catch (TestException e) {
                aStr.append(TestHelper.getStackTrace(e) + "\n");
            }
            try {
                ParRegUtil.verifyPrimaries(aRegion, -1);
            }
            catch (Exception e) {
                aStr.append(e.toString() + "\n");
            }
            try {
                ParRegUtil.verifyBucketCopies(aRegion, -1);
            }
            catch (Exception e) {
                aStr.append(TestHelper.getStackTrace(e) + "\n");
            }
            catch (TestException e) {
                aStr.append(e.toString() + "\n");
            }
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
    }

    private static boolean thisMemberIsAccessor() {
        return System.getProperty("clientName").contains("accessor");
    }

    private static boolean thisMemberIsDataStore() {
        return System.getProperty("clientName").contains("dataStore");
    }

    private static boolean thisMemberExpectsOOM() {
        return System.getProperty("clientName").contains("oomDataStore");
    }
}

