/*
 * Decompiled with CFR 0.152.
 */
package msgsim;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Scanner;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractClientServerSupport {
    protected static final boolean DEFAULT_DEBUG = false;
    protected static final boolean DEFAULT_RUNNING = true;
    private static boolean debug = false;
    private static volatile boolean running = true;
    protected static final int DEFAULT_PORT = 10235;
    private static int port = 10235;
    private static InetAddress serverAddress;
    protected static final ThreadGroup mainThreadGroup;

    protected static boolean isDebug() {
        return debug;
    }

    protected static DataInput getInputStream(Socket socket) throws IOException {
        assert (socket != null) : "The Socket to read from cannot be null!";
        return new DataInputStream(socket.getInputStream());
    }

    protected static DataOutput getOutputStream(Socket socket) throws IOException {
        assert (socket != null) : "The Socket to write to cannot be null!";
        return new DataOutputStream(socket.getOutputStream());
    }

    protected static int getPort() {
        return port;
    }

    protected static boolean isRunning() {
        return running;
    }

    protected static void setRunning(boolean running) {
        AbstractClientServerSupport.running = running;
    }

    protected static InetAddress getServerAddress() {
        return serverAddress;
    }

    protected static boolean close(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
                return true;
            }
            catch (IOException ignore) {
                return false;
            }
        }
        return false;
    }

    protected static boolean close(Socket socket) {
        if (socket != null) {
            try {
                socket.close();
                return true;
            }
            catch (IOException ignore) {
                return false;
            }
        }
        return false;
    }

    protected static ExecutorService createExecutor(final String threadName, final boolean daemon) {
        return Executors.newCachedThreadPool(new ThreadFactory(){
            final AtomicLong threadNumber = new AtomicLong(0L);

            @Override
            public Thread newThread(Runnable command) {
                Thread thread = new Thread(mainThreadGroup, command, threadName + " " + this.threadNumber.getAndIncrement());
                thread.setDaemon(daemon);
                return thread;
            }
        });
    }

    protected static String formatMessage(String message, Object ... arguments) {
        return MessageFormat.format(message, arguments);
    }

    protected static ServerSocket openServerSocket(InetAddress address, int port, boolean reuseAddress, int socketTimeout) throws IOException {
        ServerSocket serverSocket = new ServerSocket();
        serverSocket.setReuseAddress(reuseAddress);
        serverSocket.setSoTimeout(socketTimeout);
        serverSocket.bind(new InetSocketAddress(address, port));
        return serverSocket;
    }

    protected static Socket openSocket(InetAddress address, int port, boolean tcpNoDelay) throws IOException {
        Socket socket = new Socket();
        socket.setTcpNoDelay(tcpNoDelay);
        socket.connect(new InetSocketAddress(address, port));
        return socket;
    }

    protected static void parseCommandLineArguments(String ... args) throws Exception {
        AbstractClientServerSupport.parseCommandLineArguments(false, args);
    }

    protected static void parseCommandLineArguments(boolean ignoreUnknownCommands, String ... args) throws Exception {
        assert (args != null) : "The command line arguments should not be null!";
        for (int index = 0; index < args.length; ++index) {
            if ("server".equals(args[index])) {
                serverAddress = InetAddress.getByName(args[++index]);
                continue;
            }
            if ("port".equals(args[index])) {
                port = Integer.parseInt(args[++index]);
                continue;
            }
            if ("debug".equals(args[index])) {
                debug = true;
                continue;
            }
            if (ignoreUnknownCommands) continue;
            System.err.printf("Unknown command line argument (%1$s)!%n", args[index]);
        }
    }

    protected static boolean pause(int milliseconds) {
        try {
            Thread.sleep(milliseconds);
            return true;
        }
        catch (InterruptedException ignore) {
            return false;
        }
    }

    protected static void startServer(final String serverName, final ClientRequestHandler handler) {
        Runnable serverRunnable = new Runnable(){
            private Executor executor = AbstractClientServerSupport.createExecutor("Client Request Handler Thread", true);
            private ServerSocket serverSocket;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    this.serverSocket = AbstractClientServerSupport.openServerSocket(InetAddress.getLocalHost(), AbstractClientServerSupport.getPort(), true, 500);
                    System.out.printf("Started %1$s on port (%2$d) @ address (%3$s)...%n", serverName, AbstractClientServerSupport.getPort(), this.serverSocket.getInetAddress().toString());
                    while (AbstractClientServerSupport.isRunning()) {
                        try {
                            Socket clientSocket = this.serverSocket.accept();
                            clientSocket.setTcpNoDelay(true);
                            this.executor.execute(handler.service(clientSocket));
                        }
                        catch (SocketTimeoutException clientSocket) {}
                    }
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace(System.err);
                        AbstractClientServerSupport.setRunning(false);
                    }
                    catch (Throwable throwable) {
                        AbstractClientServerSupport.close(this.serverSocket);
                        System.out.printf("%1$s on port (%2$d) @ address (%3$s) stopped.%n", serverName, AbstractClientServerSupport.getPort(), this.serverSocket.getInetAddress().toString());
                        throw throwable;
                    }
                    AbstractClientServerSupport.close(this.serverSocket);
                    System.out.printf("%1$s on port (%2$d) @ address (%3$s) stopped.%n", serverName, AbstractClientServerSupport.getPort(), this.serverSocket.getInetAddress().toString());
                }
                AbstractClientServerSupport.close(this.serverSocket);
                System.out.printf("%1$s on port (%2$d) @ address (%3$s) stopped.%n", serverName, AbstractClientServerSupport.getPort(), this.serverSocket.getInetAddress().toString());
            }
        };
        Thread serverThread = new Thread(mainThreadGroup, serverRunnable, serverName + " Thread");
        serverThread.setDaemon(false);
        serverThread.start();
    }

    protected static void waitForUserInput(String input, String message) {
        Scanner in = new Scanner(System.in);
        while (!input.equalsIgnoreCase(in.nextLine().trim())) {
            System.err.println(message);
        }
    }

    static {
        mainThreadGroup = new ThreadGroup("Main Thread Group"){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                System.err.printf("Uncaught Exception in Thread (%1$s):%n", t.getName());
                e.printStackTrace(System.err);
                super.uncaughtException(t, e);
            }
        };
    }

    protected static final class ThreadCollection {
        private final Collection<Thread> threads = new LinkedList<Thread>();

        private ThreadCollection() {
        }

        public static ThreadCollection spawn(int numberOfThreads, Runnable runner, String threadBasename) {
            ThreadCollection collection = new ThreadCollection();
            while (numberOfThreads-- > 0) {
                collection.startThread(runner, threadBasename);
            }
            return collection;
        }

        private Thread startThread(Runnable runnable, String threadBasename) {
            Thread thread = this.createThread(runnable, threadBasename);
            thread.start();
            this.threads.add(thread);
            return thread;
        }

        private Thread createThread(Runnable runnable, String threadBasename) {
            assert (threadBasename != null) : "The basename of the Thread cannot be null!";
            Thread thread = new Thread(runnable, threadBasename.trim() + " " + this.threads.size());
            thread.setDaemon(false);
            return thread;
        }

        public void join() throws InterruptedException {
            for (Thread thread : this.threads) {
                thread.join();
            }
        }
    }

    protected static interface ClientRequestHandler {
        public Runnable service(Socket var1);
    }
}

