/*
 * Decompiled with CFR 0.152.
 */
package msgsim;

import java.io.DataInput;
import java.io.DataOutput;
import java.net.Socket;
import java.util.Scanner;
import msgsim.AbstractClientServerSupport;

public class EchoClient
extends AbstractClientServerSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String ... args) throws Exception {
        EchoClient.parseCommandLineArguments(args);
        assert (EchoClient.getServerAddress() != null && EchoClient.getServerAddress().isReachable(5000)) : EchoClient.formatMessage("The server address ({0}) cannot be null and must be reachable!", EchoClient.getServerAddress());
        Socket clientSocket = EchoClient.openSocket(EchoClient.getServerAddress(), EchoClient.getPort(), true);
        assert (clientSocket != null && clientSocket.isConnected()) : EchoClient.formatMessage("Failed to connect to Echo Server @ ({0})) on port ({1,number,integer})!", EchoClient.getServerAddress(), EchoClient.getPort());
        System.out.printf("Connected to Echo Server @ (%1$s) on port (%2$d)...%n", EchoClient.getServerAddress().toString(), EchoClient.getPort());
        DataInput in = EchoClient.getInputStream(clientSocket);
        DataOutput out = EchoClient.getOutputStream(clientSocket);
        Scanner userIn = new Scanner(System.in);
        try {
            String line;
            while (!"exit".equalsIgnoreCase(line = userIn.nextLine().trim())) {
                System.out.printf("Client says... \"%1$s\"%n", line);
                out.writeBytes(line + "\n");
                System.out.printf("Server says... \"%1$s\"%n", in.readLine());
            }
        }
        finally {
            EchoClient.close(clientSocket);
        }
    }
}

