/*
 * Decompiled with CFR 0.152.
 */
package msgsim;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.Socket;
import msgsim.AbstractClientServerSupport;

public class EchoServer
extends AbstractClientServerSupport {
    public static void main(String ... args) throws Exception {
        EchoServer.parseCommandLineArguments(args);
        EchoServer.startServer("Echo Server", new AbstractClientServerSupport.ClientRequestHandler(){

            @Override
            public Runnable service(Socket clientSocket) {
                return EchoServer.createEchoClientRunnable(clientSocket);
            }
        });
        EchoServer.waitForUserInput("exit", "Please enter 'exit' to stop the Echo Sever.");
        System.out.println("Exiting...");
        EchoServer.setRunning(false);
    }

    private static Runnable createEchoClientRunnable(final Socket clientSocket) {
        assert (clientSocket != null && !clientSocket.isClosed()) : "The Echo Client connection cannot be null or closed!";
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                System.out.printf("Receiving echo requests from client (%1$s) in Thread (%2$s)...%n", clientSocket.getInetAddress().toString(), Thread.currentThread().getName());
                try {
                    DataInput in = AbstractClientServerSupport.getInputStream(clientSocket);
                    DataOutput out = AbstractClientServerSupport.getOutputStream(clientSocket);
                    boolean running = true;
                    while (running) {
                        try {
                            String echoMessage = in.readLine();
                            System.out.printf("%1$s: \"%2$s\"%n", clientSocket.getInetAddress().toString(), echoMessage);
                            out.writeBytes(echoMessage + "\n");
                        }
                        catch (IOException e) {
                            running = false;
                            if (!AbstractClientServerSupport.isDebug()) continue;
                            System.err.printf("Failed to read message from echo client (%1$s): %2$s%n", clientSocket.getInetAddress().toString(), e.getMessage());
                        }
                    }
                }
                catch (IOException e) {
                    try {
                        e.printStackTrace(System.err);
                    }
                    catch (Throwable throwable) {
                        AbstractClientServerSupport.close(clientSocket);
                        System.out.printf("Echo client (%1$s) connection closed. Thread (%2$s) exiting.%n", clientSocket.getInetAddress().toString(), Thread.currentThread().getName());
                        throw throwable;
                    }
                    AbstractClientServerSupport.close(clientSocket);
                    System.out.printf("Echo client (%1$s) connection closed. Thread (%2$s) exiting.%n", clientSocket.getInetAddress().toString(), Thread.currentThread().getName());
                }
                AbstractClientServerSupport.close(clientSocket);
                System.out.printf("Echo client (%1$s) connection closed. Thread (%2$s) exiting.%n", clientSocket.getInetAddress().toString(), Thread.currentThread().getName());
            }
        };
    }
}

