/*
 * Decompiled with CFR 0.152.
 */
package msgsim;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.CountDownLatch;
import msgsim.AbstractClientServerSupport;

public class ExchangeTest
extends AbstractClientServerSupport {
    private static final CountDownLatch latch = new CountDownLatch(1);

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.err.println("usage: java msgsim.ExhangeTest <port-number>");
            System.exit(1);
        }
        int port = Integer.parseInt(args[0]);
        ExchangeTest.runServer(port);
        latch.await();
        Socket socket = ExchangeTest.openSocket(InetAddress.getLocalHost(), port, true);
        DataInput in = ExchangeTest.getInputStream(socket);
        DataOutput out = ExchangeTest.getOutputStream(socket);
        ExchangeTest.runClientNumberComm(in, out);
        ExchangeTest.close(socket);
    }

    private static void runClientMsgComm(DataInput in, DataOutput out) throws IOException {
        System.out.println("client says 'hello'");
        out.writeBytes("hello\n");
        out.writeBytes("I say po-ta-toe, you say...\n");
        String value = in.readLine();
        System.out.printf("client: server said '%1$s'%n", value);
    }

    private static void runClientNumberComm(DataInput in, DataOutput out) throws IOException {
        System.out.println("client: sending 1...");
        out.writeByte(1);
        System.out.println("client: receiving 2...");
        in.readByte();
        System.out.println("client: sending 3...");
        out.writeByte(3);
        System.out.println("client: receiving (byte) 4...");
        System.out.printf("client: %1$d%n", in.readByte());
        System.out.println("client: sending 5...");
        out.writeByte(5);
        System.out.println("client: receiving (byte) 6...");
        System.out.printf("client: %1$d%n", in.readByte());
        System.out.printf("client: %1$d%n", in.readByte());
        System.out.printf("client: %1$d%n", in.readByte());
        System.out.printf("client: %1$d%n", in.readByte());
    }

    private static void runServer(final int port) {
        Runnable serverThreadRunnable = new Runnable(){

            @Override
            public void run() {
                ServerSocket serverSocket = null;
                try {
                    serverSocket = AbstractClientServerSupport.openServerSocket(InetAddress.getLocalHost(), port, true, 0);
                    latch.countDown();
                    Socket clientSocket = serverSocket.accept();
                    clientSocket.setTcpNoDelay(true);
                    DataInput in = AbstractClientServerSupport.getInputStream(clientSocket);
                    DataOutput out = AbstractClientServerSupport.getOutputStream(clientSocket);
                    this.runServerNumberComm(in, out);
                }
                catch (IOException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        AbstractClientServerSupport.close(serverSocket);
                        throw throwable;
                    }
                }
                AbstractClientServerSupport.close(serverSocket);
            }

            private void runServerMsgComm(DataInput in, DataOutput out) throws IOException {
                String value = in.readLine();
                System.out.printf("server: client said '%1$s'%n", value);
                System.out.println("server is acknowledging");
                out.writeBytes("ACK\n");
                value = in.readLine();
                System.out.printf("server: client said '%1$s'%n", value);
                out.writeBytes("potato\n");
            }

            private void runServerNumberComm(DataInput in, DataOutput out) throws IOException {
                System.out.println("server: receiving 1...");
                in.readByte();
                System.out.println("server: sending 2...");
                out.writeByte(2);
                System.out.println("server: receiving 3...");
                in.readByte();
                System.out.println("server: sending (int) 4...");
                out.writeInt(4);
                System.out.println("server: receiving 5...");
                in.readByte();
                System.out.println("server: sending 6...");
                out.writeByte(6);
            }
        };
        Thread serverThread = new Thread(mainThreadGroup, serverThreadRunnable, "Server Thread");
        serverThread.setDaemon(true);
        serverThread.start();
    }
}

