/*
 * Decompiled with CFR 0.152.
 */
package msgsim;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.Socket;
import java.util.Calendar;
import java.util.Random;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import msgsim.AbstractClientServerSupport;

public class MessageClient
extends AbstractClientServerSupport {
    private static final int DEFAULT_MESSAGE_COUNT = 10000;
    private static final int DEFAULT_MESSAGE_THREADS = 8;
    private static final int DEFAULT_PAYLOAD_SIZE = 10000;
    private static final int DEFAULT_POOl_SIZE = 2;
    private static int messageCount = 10000;
    private static int messageThreads = 8;
    private static int payloadSize = 10000;
    private static int poolSize = 2;
    private static byte[] payload;
    private static SocketFactory socketFactory;
    private static SocketFactoryType socketFactoryType;

    public static void main(String ... args) throws Exception {
        MessageClient.init(args);
        long t0 = System.currentTimeMillis();
        AbstractClientServerSupport.ThreadCollection.spawn(messageThreads, MessageClient.createMessageClientRunnable(), "Message Client Thread").join();
        long t1 = System.currentTimeMillis();
        System.out.printf("Ran (%1$d) messaging client each sending (%2$d) messages having a payload of (%3$d) bytes using (%4$s) socket connections in (%5$d) milliseconds.%n", messageThreads, messageCount, payloadSize, socketFactoryType.equals((Object)SocketFactoryType.NEW_SOCKET) ? "unlimited" : String.valueOf(poolSize), t1 - t0);
    }

    private static void init(String ... args) throws Exception {
        MessageClient.customParseCommandLineArguments(args);
        MessageClient.initPayload();
        MessageClient.initSocketFactory();
    }

    private static void customParseCommandLineArguments(String ... args) throws Exception {
        MessageClient.parseCommandLineArguments(true, args);
        for (int index = 0; index < args.length; ++index) {
            if ("messageCount".equalsIgnoreCase(args[index])) {
                messageCount = Integer.parseInt(args[++index]);
                continue;
            }
            if ("messageThreads".equalsIgnoreCase(args[index])) {
                messageThreads = Integer.parseInt(args[++index]);
                continue;
            }
            if ("payloadSize".equalsIgnoreCase(args[index])) {
                payloadSize = Integer.parseInt(args[++index]);
                continue;
            }
            if ("poolSize".equalsIgnoreCase(args[index])) {
                poolSize = Integer.parseInt(args[++index]);
                continue;
            }
            if ("socketFactoryType".equalsIgnoreCase(args[index])) {
                socketFactoryType = SocketFactoryType.findBy(Integer.parseInt(args[++index]));
                continue;
            }
            System.err.printf("Ignoring command line argument (%1$s)!%n", args[index]);
        }
    }

    protected static void initPayload() {
        Random random = new Random(Calendar.getInstance().getTimeInMillis());
        payload = new byte[payloadSize];
        for (int index = 0; index < payload.length; ++index) {
            MessageClient.payload[index] = (byte)random.nextInt(64);
        }
    }

    private static void initSocketFactory() throws IOException {
        switch (socketFactoryType) {
            case POOLED_SOCKET: {
                socketFactory = new PooledSocketFactory(poolSize);
                break;
            }
            default: {
                socketFactory = new NewSocketFactory();
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                socketFactory.destroy();
            }
        });
    }

    protected static Runnable createMessageClientRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                int logCount = Math.max(messageCount / 10, 1);
                try {
                    for (int count = 0; count < messageCount; ++count) {
                        Socket clientSocket = socketFactory.getSocket();
                        DataInput in = AbstractClientServerSupport.getInputStream(clientSocket);
                        DataOutput out = AbstractClientServerSupport.getOutputStream(clientSocket);
                        out.writeInt(payloadSize);
                        out.write(payload);
                        in.readByte();
                        if (count % logCount == 0) {
                            System.out.printf("(%1$s) sent (%2$s) messages...%n", Thread.currentThread().getName(), count);
                        }
                        socketFactory.releaseSocket(clientSocket);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    static {
        socketFactoryType = SocketFactoryType.NEW_SOCKET;
    }

    protected static final class PooledSocketFactory
    implements SocketFactory {
        private final BlockingQueue<Socket> socketPool;

        public PooledSocketFactory(int numberOfConnections) throws IOException {
            this.socketPool = new ArrayBlockingQueue<Socket>(numberOfConnections, true);
            while (numberOfConnections-- > 0) {
                this.socketPool.add(AbstractClientServerSupport.openSocket(AbstractClientServerSupport.getServerAddress(), AbstractClientServerSupport.getPort(), true));
            }
        }

        @Override
        public void destroy() {
            Socket socket = (Socket)this.socketPool.poll();
            while (socket != null) {
                AbstractClientServerSupport.close(socket);
                socket = (Socket)this.socketPool.poll();
            }
        }

        @Override
        public Socket getSocket() throws IOException {
            try {
                return this.socketPool.take();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public SocketFactoryType getType() {
            return SocketFactoryType.POOLED_SOCKET;
        }

        @Override
        public void releaseSocket(Socket socket) throws IOException {
            this.socketPool.add(socket);
        }
    }

    protected static final class NewSocketFactory
    implements SocketFactory {
        protected NewSocketFactory() {
        }

        @Override
        public void destroy() {
        }

        @Override
        public Socket getSocket() throws IOException {
            return AbstractClientServerSupport.openSocket(AbstractClientServerSupport.getServerAddress(), AbstractClientServerSupport.getPort(), true);
        }

        @Override
        public SocketFactoryType getType() {
            return SocketFactoryType.NEW_SOCKET;
        }

        @Override
        public void releaseSocket(Socket socket) {
            AbstractClientServerSupport.close(socket);
        }
    }

    protected static interface SocketFactory {
        public void destroy();

        public Socket getSocket() throws IOException;

        public SocketFactoryType getType();

        public void releaseSocket(Socket var1) throws IOException;
    }

    protected static enum SocketFactoryType {
        NEW_SOCKET(1, "newsock", "Create New Socket for Each Request"),
        POOLED_SOCKET(2, "poolsock", "Use Pooled Socket for Each Request");

        private final int id;
        private final String code;
        private final String description;

        private SocketFactoryType(int id, String code, String description) {
            this.id = id;
            this.code = code;
            this.description = description;
        }

        public static SocketFactoryType findBy(int id) {
            for (SocketFactoryType strategy : SocketFactoryType.values()) {
                if (strategy.getId() != id) continue;
                return strategy;
            }
            throw new IllegalArgumentException("(" + id + ") is not a valid SocketFactoryType ID!");
        }

        public static SocketFactoryType findBy(String code) {
            for (SocketFactoryType strategy : SocketFactoryType.values()) {
                if (!strategy.getCode().equals(code)) continue;
                return strategy;
            }
            throw new IllegalArgumentException("(" + code + ") is not a valid SocketFactoryType code!");
        }

        public String getCode() {
            return this.code;
        }

        public String getDescription() {
            return this.description;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return this.getDescription();
        }
    }
}

