/*
 * Decompiled with CFR 0.152.
 */
package msgsim;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.Socket;
import msgsim.AbstractClientServerSupport;

public class MessageServer
extends AbstractClientServerSupport {
    public static void main(String ... args) throws Exception {
        MessageServer.parseCommandLineArguments(args);
        MessageServer.startServer("Message Server", new AbstractClientServerSupport.ClientRequestHandler(){

            @Override
            public Runnable service(Socket clientSocket) {
                return MessageServer.createMessageClientRunnable(clientSocket);
            }
        });
        MessageServer.waitForUserInput("exit", "Please enter 'exit' to stop the Message Server.");
        System.out.println("Exiting...");
        MessageServer.setRunning(false);
    }

    private static Runnable createMessageClientRunnable(final Socket clientSocket) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    DataInput in = AbstractClientServerSupport.getInputStream(clientSocket);
                    DataOutput out = AbstractClientServerSupport.getOutputStream(clientSocket);
                    boolean reading = true;
                    while (reading) {
                        try {
                            int payloadSize = in.readInt();
                            if (AbstractClientServerSupport.isDebug()) {
                                System.out.printf("Reading (%1$d) bytes from client (%2$s)...%n", payloadSize, clientSocket.getInetAddress().toString());
                            }
                            in.readFully(new byte[payloadSize]);
                            if (AbstractClientServerSupport.isDebug()) {
                                System.out.println("Sending ack...");
                            }
                            out.writeByte(1);
                        }
                        catch (IOException ignore) {
                            reading = false;
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    AbstractClientServerSupport.close(clientSocket);
                }
            }
        };
    }
}

