/*
 * Decompiled with CFR 0.152.
 */
package msgsim;

public interface commands {
    public static final int BASE_PORT = 15963;

    public static enum MessagingScenario {
        UNKNOWN(-1, "Unknown"),
        SERVER(0, "Server"),
        SHARED_CONNECTIONS(1, "conserve-sockets=true"),
        SHARED_CONNECTIONS_WITH_DOMINO(2, "conserve-sockets=true, readers get owned ack sockets (conserve-sockets=false"),
        THREAD_OWNED_CONNECTIONS(3, "conserve-sockets=false"),
        THREAD_OWNED_CONNECTIONS_WITH_DOMINO(4, "conserve-sockets=false, readers get conserve-sockets=false"),
        POOLED_CONNECTIONS(5, "queued connection pool"),
        POOLED_CONNECTIONS_WITH_DOMINO(6, "queued connection pool with domino messages"),
        HANDOFF_LISTENERS(7, "conserve-sockets=true, listener-handoff"),
        HANDOFF_LISTENERS_WITH_DOMINO(8, "conserve-sockets=true, readers get owned ack sockets (conserve-sockets=false"),
        EXIT(999, "Shutdown");

        private final int id;
        private final String description;

        private MessagingScenario(int id, String description) {
            this.id = id;
            this.description = description;
        }

        public static MessagingScenario getDefault() {
            return SERVER;
        }

        public static MessagingScenario valueOf(int id) {
            for (MessagingScenario scenario : MessagingScenario.values()) {
                if (scenario.getId() != id) continue;
                return scenario;
            }
            return UNKNOWN;
        }

        public String getDescription() {
            return this.description;
        }

        public int getId() {
            return this.id;
        }

        public boolean isExit() {
            return this.equals((Object)EXIT);
        }

        public boolean isServer() {
            return this.equals((Object)SERVER);
        }

        public String toString() {
            return this.getDescription();
        }
    }

    public static enum MessageProtocolCommand {
        INVALID(-1),
        INIT(0),
        USE_THREAD_OWNED(1),
        USE_SHARED(2),
        HAND_OFF_LISTENERS(3),
        USE_THREAD_OWNED_UNORDERED(4),
        USE_POOLED_CONNECTIONS(5),
        NORMAL_MESSAGE(10),
        SET_PAYLOAD_SIZE(11),
        ACK_MESSAGE(12),
        PRINT_QUEUE_SIZES(13),
        EXIT(127);

        private final byte byteValue;

        private MessageProtocolCommand(byte byteValue) {
            this.byteValue = byteValue;
        }

        public static MessageProtocolCommand valueOf(byte byteValue) {
            for (MessageProtocolCommand command : MessageProtocolCommand.values()) {
                if (command.toByte() != byteValue) continue;
                return command;
            }
            return INVALID;
        }

        public boolean isInvalid() {
            return this.equals((Object)INVALID);
        }

        public byte toByte() {
            return this.byteValue;
        }
    }
}

