/*
 * Decompiled with CFR 0.152.
 */
package newWan;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderImpl;
import hydra.GatewaySenderHelper;
import hydra.RemoteTestModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import newWan.WANBlackboard;
import util.SilenceListener;
import util.SilenceListenerBB;

public class ParallelSenderRegionQueueListener
extends SilenceListener {
    public static final String KEY_SENDER_RQ_LAST_VAL = "SenderRegionQueueLastVal_";
    private Map pausedMap = new HashMap();
    WANBlackboard bb = WANBlackboard.getInstance();

    @Override
    public void afterCreate(EntryEvent event) {
        SilenceListenerBB.getBB().getSharedCounters().setIfLarger(SilenceListenerBB.lastEventTime, System.currentTimeMillis());
        GatewaySender sender = this.getSenderForEvent(event);
        if (sender != null && !sender.isRunning()) {
            boolean isPrimary = sender instanceof SerialGatewaySenderImpl ? ((SerialGatewaySenderImpl)sender).isPrimary() : ((ParallelGatewaySenderImpl)sender).isPrimary();
            String s = "Event is enqueued even when sender is stopped in vm " + this.getMyUniqueName() + ". Not allowed with sender config isPrimary=" + isPrimary + ", isRunning=" + sender.isRunning() + ", isPaused=" + sender.isPaused() + GatewaySenderHelper.gatewaySenderToString(sender) + "\n" + this.toString("afterCreate", (CacheEvent)event);
            WANBlackboard.throwException(s);
        }
    }

    @Override
    public void afterDestroy(EntryEvent event) {
        SilenceListenerBB.getBB().getSharedCounters().setIfLarger(SilenceListenerBB.lastEventTime, System.currentTimeMillis());
    }

    private GatewaySender getSenderForEvent(EntryEvent event) {
        String string;
        String regionName = event.getRegion().getName();
        GatewaySender sender = null;
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders();
        if (senders != null) {
            for (GatewaySender s : senders) {
                String rname = regionName.replace("__", "_");
                if (!rname.contains(s.getId())) continue;
                sender = s;
                break;
            }
        } else {
            string = "Possible test issue. No senders are found in " + this.getMyUniqueName() + " for event " + this.toString("afterDestroy", (CacheEvent)event);
        }
        if (sender == null) {
            string = "Possible test issue. No sender is found in " + this.getMyUniqueName() + " for event " + this.toString("afterDestroy", (CacheEvent)event);
        }
        return sender;
    }

    public String getMyUniqueName() {
        StringBuffer buf = new StringBuffer(50);
        buf.append("vm_").append(RemoteTestModule.getMyVmid());
        buf.append("_").append(RemoteTestModule.getMyClientName());
        buf.append("_").append(RemoteTestModule.getMyHost());
        buf.append("_").append(RemoteTestModule.getMyPid());
        return buf.toString();
    }
}

