/*
 * Decompiled with CFR 0.152.
 */
package newWan;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderImpl;
import hydra.GatewaySenderHelper;
import hydra.Log;
import hydra.RemoteTestModule;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import newWan.WANBlackboard;
import util.SilenceListener;
import util.SilenceListenerBB;

public class SenderRegionQueueListener
extends SilenceListener {
    public static final String KEY_SENDER_RQ_LAST_VAL = "SenderRegionQueueLastVal_";
    private long lastKeyInSender = -1L;
    private int keysEvictionted = 0;
    private Map pausedMap = new HashMap();
    WANBlackboard bb = WANBlackboard.getInstance();

    @Override
    public void afterCreate(EntryEvent event) {
        SilenceListenerBB.getBB().getSharedCounters().setIfLarger(SilenceListenerBB.lastEventTime, System.currentTimeMillis());
        GatewaySender sender = this.getSenderForEvent(event);
        if (sender != null && !sender.isRunning()) {
            boolean isPrimary = sender instanceof SerialGatewaySenderImpl ? ((SerialGatewaySenderImpl)sender).isPrimary() : ((ParallelGatewaySenderImpl)sender).isPrimary();
            String string = "Event is enqueued even when sender is stopped in vm " + this.getMyUniqueName() + ". Not allowed with sender config isPrimary=" + isPrimary + ", isRunning=" + sender.isRunning() + ", isPaused=" + sender.isPaused() + GatewaySenderHelper.gatewaySenderToString(sender) + "\n" + this.toString("afterCreate", (CacheEvent)event);
        }
    }

    @Override
    public void afterDestroy(EntryEvent event) {
        SilenceListenerBB.getBB().getSharedCounters().setIfLarger(SilenceListenerBB.lastEventTime, System.currentTimeMillis());
        Long currentKey = (Long)event.getKey();
        if (this.lastKeyInSender != -1L && currentKey - this.lastKeyInSender != 1L) {
            String s = "Event is not dispatched sequentially from sender queue in vm " + this.getMyUniqueName() + ". Expected event for key " + (this.lastKeyInSender + 1L) + " , found " + currentKey + ". " + this.toString("afterDestroy", (CacheEvent)event);
            this.lastKeyInSender = currentKey;
            WANBlackboard.throwException(s);
        }
        this.lastKeyInSender = currentKey;
        GatewaySender sender = this.getSenderForEvent(event);
        if (sender != null) {
            if (sender.isPaused()) {
                Integer pausedCount = (Integer)this.pausedMap.get(sender.getId());
                pausedCount = pausedCount == null ? new Integer(1) : pausedCount + 1;
                this.pausedMap.put(sender.getId(), pausedCount);
                if (pausedCount > sender.getBatchSize()) {
                    boolean isPrimary = sender instanceof SerialGatewaySenderImpl ? ((SerialGatewaySenderImpl)sender).isPrimary() : ((ParallelGatewaySenderImpl)sender).isPrimary();
                    String string = "Event dispatched from sender are more than a batch size in vm " + this.getMyUniqueName() + " , not allowed with sender config isPrimary=" + isPrimary + ", isRunning=" + sender.isRunning() + ", isPaused=" + sender.isPaused() + ", dispatched events from last sender operation=" + pausedCount + GatewaySenderHelper.gatewaySenderToString(sender) + "\n" + this.toString("afterDestroy", (CacheEvent)event);
                }
            } else {
                this.pausedMap.put(sender.getId(), new Integer(0));
            }
        }
    }

    private GatewaySender getSenderForEvent(EntryEvent event) {
        String s;
        String regionName = event.getRegion().getName();
        GatewaySender sender = null;
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders();
        if (senders != null) {
            for (GatewaySender s2 : senders) {
                if (!regionName.contains(s2.getId())) continue;
                sender = s2;
                break;
            }
        } else {
            s = "Possible test issue. No senders are found in " + this.getMyUniqueName() + " for event " + this.toString("afterDestroy", (CacheEvent)event);
            Log.getLogWriter().info(s);
        }
        if (sender == null) {
            s = "Possible test issue. No sender is found in " + this.getMyUniqueName() + " for event " + this.toString("afterDestroy", (CacheEvent)event);
            Log.getLogWriter().info(s);
        }
        return sender;
    }

    public String getMyUniqueName() {
        StringBuffer buf = new StringBuffer(50);
        buf.append("vm_").append(RemoteTestModule.getMyVmid());
        buf.append("_").append(RemoteTestModule.getMyClientName());
        buf.append("_").append(RemoteTestModule.getMyHost());
        buf.append("_").append(RemoteTestModule.getMyPid());
        return buf.toString();
    }

    public static String getKeyForSenderRegionQueueLastVal(String senderid, String key, String regionName) {
        StringBuffer buf = new StringBuffer(KEY_SENDER_RQ_LAST_VAL);
        buf.append("vm_").append(RemoteTestModule.getMyVmid()).append("_").append(regionName).append("_").append(senderid).append("_").append(key);
        return buf.toString();
    }
}

