/*
 * Decompiled with CFR 0.152.
 */
package newWan;

import cq.CQUtilBB;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.Blackboard;
import util.TestException;
import util.TestHelper;

public class WANBlackboard
extends Blackboard {
    private static WANBlackboard blackboard;
    public static String LOCATORS_MAP;
    public static int currentEntry_valid;
    public static int currentEntry_invalid;
    public static int currentEntry_writer;
    public static int currentEntry_reader;
    public static int operation_counter;
    public static int NUM_CQ;

    public WANBlackboard() {
    }

    public WANBlackboard(String name, String type) {
        super(name, type, WANBlackboard.class);
    }

    public static synchronized WANBlackboard getInstance() {
        if (blackboard == null) {
            blackboard = new WANBlackboard("WAN", "RMI");
        }
        return blackboard;
    }

    public static void printBlackboard() {
        Log.getLogWriter().info("Printing WAN Blackboard contents");
        WANBlackboard bb = WANBlackboard.getInstance();
        bb.print();
        TestHelper.checkForEventError(bb);
        TestHelper.checkForEventError(CQUtilBB.getBB());
    }

    public static synchronized void throwException(String msg) {
        if (WANBlackboard.getInstance().getSharedMap().get(TestHelper.EVENT_ERROR_KEY) == null) {
            WANBlackboard.getInstance().getSharedMap().put(TestHelper.EVENT_ERROR_KEY, msg + " in " + WANBlackboard.getMyUniqueName() + " " + TestHelper.getStackTrace());
        }
        throw new TestException(msg);
    }

    public static String getMyUniqueName() {
        StringBuffer buf = new StringBuffer(50);
        buf.append("vm_").append(RemoteTestModule.getMyVmid());
        buf.append("_").append(RemoteTestModule.getMyClientName());
        buf.append("_").append(RemoteTestModule.getMyHost());
        buf.append("_").append(RemoteTestModule.getMyPid());
        return buf.toString();
    }

    public static synchronized Long increamentAndReadKeyCounter(String regionName, int size) {
        WANBlackboard bb = WANBlackboard.getInstance();
        bb.getSharedLock().lock();
        Long keyCounter = (Long)bb.getSharedMap().get(regionName);
        keyCounter = keyCounter == null ? new Long(size) : keyCounter + (long)size;
        bb.getSharedMap().put(regionName, keyCounter);
        bb.getSharedLock().unlock();
        return keyCounter;
    }

    static {
        LOCATORS_MAP = "locatorMap";
    }
}

