/*
 * Decompiled with CFR 0.152.
 */
package newWan;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.AttributesMutator;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.client.internal.locator.wan.LocatorDiscovery;
import com.gemstone.gemfire.cache.partition.PartitionRegionHelper;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.util.ObjectSizerImpl;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.admin.remote.DistributionLocatorId;
import com.gemstone.gemfire.internal.cache.BucketRegion;
import com.gemstone.gemfire.internal.cache.DiskRegionStats;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import com.gemstone.gemfire.internal.cache.wan.parallel.ConcurrentParallelGatewaySenderQueue;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderImpl;
import com.gemstone.gemfire.pdx.PdxInstance;
import cq.CQUtil;
import cq.CQUtilBB;
import diskReg.DiskRegUtil;
import durableClients.DurableClientsBB;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.BridgeHelper;
import hydra.BridgePrms;
import hydra.CacheHelper;
import hydra.CachePrms;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigHashtable;
import hydra.ConfigPrms;
import hydra.DiskStoreHelper;
import hydra.DistributedSystemHelper;
import hydra.GatewayReceiverHelper;
import hydra.GatewaySenderHelper;
import hydra.GemFireDescription;
import hydra.GsRandom;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.StopSchedulingOrder;
import hydra.TestConfig;
import hydra.TestConfigFcns;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedLock;
import hydra.blackboard.SharedMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import newWan.WANBlackboard;
import newWan.WANOperationsClient;
import newWan.WANOperationsClientBB;
import newWan.WANTestPrms;
import objects.PSTObject;
import pdx.PdxTest;
import splitBrain.RegionEntryComparator;
import util.BaseValueHolder;
import util.MethodCoordinator;
import util.NameFactory;
import util.PRObserver;
import util.QueryObject;
import util.RandomValues;
import util.SilenceListener;
import util.StopStartPrms;
import util.StopStartVMs;
import util.TestException;
import util.TestHelper;
import util.ValueHolder;
import util.ValueHolderPrms;
import wan.CacheClientPrms;

public class WANTest {
    protected static final int ITERATIONS = WANTestPrms.getIterations();
    protected static final long maxOperations = WANTestPrms.getMaxOperations();
    protected static List<String> regionDescriptNames = new ArrayList<String>();
    protected static List<String> regionNames = new ArrayList<String>();
    protected boolean isBridgeConfiguration = false;
    protected boolean isBridgeClient = false;
    private static Boolean isValidateDoEntryOperationsCalled = new Boolean(false);
    public static WANTest instance;
    protected static WANOperationsClient opsClient;
    public static volatile MethodCoordinator updateRegionSnapshot;
    public static LogWriter logger;
    public static GsRandom rand;
    public static RandomValues rv;
    WANBlackboard bb = WANBlackboard.getInstance();
    protected static Set<GatewaySender> gatewaySenders;
    ConfigHashtable conftab = TestConfig.tab();
    boolean isSenderStarted = false;
    static String SENDER_NAME_PREFIX;
    static boolean validPrefix;
    static boolean invalidPrefix;
    protected AtomicBoolean isQueuePrinting = new AtomicBoolean(false);

    public static synchronized void initializeLocator() {
        if (instance == null) {
            instance = new WANTest();
        }
    }

    public static synchronized void initializeDatastore() {
        if (instance == null) {
            instance = new WANTest();
            opsClient = new WANOperationsClient();
            PRObserver.installObserverHook();
            HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
            for (int i = 0; i < regionNames.size(); ++i) {
                String regionDescriptName = (String)regionNames.get(i);
                regionDescriptNames.add(regionDescriptName);
            }
            boolean bl = WANTest.instance.isBridgeConfiguration = TestConfig.tab().vecAt(BridgePrms.names, null) != null;
            if (WANTest.instance.isBridgeConfiguration) {
                WANTest.instance.isBridgeClient = false;
            }
            if (maxOperations % (long)ITERATIONS != 0L) {
                throw new TestException("Incorrect test configuration. maxOperations should be multiple of ITERATIONS. newWan.WANTestPrms-maxOperations=" + maxOperations + ", newWan.WANTestPrms-ITERATIONS=" + ITERATIONS);
            }
        }
    }

    public static synchronized void initializeClient() {
        if (instance == null) {
            instance = new WANTest();
            opsClient = new WANOperationsClient();
            HydraVector regionNames = TestConfig.tab().vecAt(RegionPrms.names, null);
            for (int i = 0; i < regionNames.size(); ++i) {
                String regionDescriptName = (String)regionNames.get(i);
                regionDescriptNames.add(regionDescriptName);
            }
            boolean bl = WANTest.instance.isBridgeConfiguration = TestConfig.tab().vecAt(BridgePrms.names, null) != null;
            if (WANTest.instance.isBridgeConfiguration) {
                WANTest.instance.isBridgeClient = true;
            }
        }
    }

    public static synchronized void createLocatorTask() {
        if (instance == null) {
            WANTest.initializeLocator();
            instance.createLocator();
        }
    }

    void createLocator() {
        DistributedSystemHelper.createLocator();
    }

    public static synchronized void startAndConnectLocatorTask() {
        if (instance == null) {
            WANTest.initializeLocator();
        }
        instance.startAndConnectLocator();
    }

    void startAndConnectLocator() {
        DistributedSystemHelper.startLocatorAndDS();
        this.waitForLocatorDiscovery();
    }

    public static synchronized void startAndConnectAndVerifyLocatorTask() {
        if (instance == null) {
            WANTest.initializeLocator();
        }
        instance.startAndConnectAndVerifyLocator();
    }

    void startAndConnectAndVerifyLocator() {
        Locator l = DistributedSystemHelper.startLocatorAndDS();
        this.waitForLocatorDiscovery();
        if (l != null) {
            Integer ds = DistributedSystemHelper.getDistributedSystemId();
            String locString = this.getLocatorAsString(l);
            SharedLock lock = this.bb.getSharedLock();
            lock.lock();
            Object locatorMap = this.bb.getSharedMap().get(WANBlackboard.LOCATORS_MAP);
            if (locatorMap == null) {
                HashMap<Integer, String> lMap = new HashMap<Integer, String>();
                lMap.put(ds, locString);
                this.bb.getSharedMap().put(WANBlackboard.LOCATORS_MAP, lMap);
            } else {
                Map lMap = (Map)locatorMap;
                String locators = (String)lMap.get(ds);
                if (locators == null) {
                    lMap.put(ds, locString);
                } else if (!locators.contains(locString)) {
                    String str = ((Map)this.bb.getSharedMap().get(WANBlackboard.LOCATORS_MAP)).get(ds) + "," + locString;
                    lMap.put(ds, str);
                }
                this.bb.getSharedMap().put(WANBlackboard.LOCATORS_MAP, lMap);
            }
            lock.unlock();
        }
        this.verifyLocators();
    }

    private String getLocatorAsString(Locator l) {
        String lHost = l.isServerLocator() ? ((InternalLocator)l).getServerLocatorAdvisee().getHostName() : l.getBindAddress().getHostAddress();
        StringBuilder locatorString = new StringBuilder(lHost);
        locatorString.append('[').append(l.getPort()).append(']');
        return locatorString.toString();
    }

    protected void waitForLocatorDiscovery() {
        boolean isDiscovered;
        logger.info("Waititng for locator discovery.");
        do {
            isDiscovered = true;
            List locators = Locator.getLocators();
            ConcurrentMap gfLocMap = ((InternalLocator)locators.get(0)).getAllLocatorsInfo();
            ArrayList<Integer> dsList = new ArrayList<Integer>();
            for (GemFireDescription gfd : TestConfig.getInstance().getGemFireDescriptions().values()) {
                Integer ds = gfd.getDistributedSystemId();
                if (ds.equals(-1) || dsList.contains(ds) || gfLocMap.containsKey(ds)) continue;
                dsList.add(ds);
                isDiscovered = false;
            }
            if (isDiscovered) continue;
            logger.info("Waiting for locator discovery to complete. Locators not discoverd so far from ds " + dsList + ". Distribution locator map from gemfire system is " + new ConcurrentHashMap(gfLocMap).toString());
            MasterController.sleepForMs(5000);
        } while (!isDiscovered);
        logger.info("Locator discovery completed.");
    }

    public static synchronized void startLocatorAndAdminDSTask() {
        if (instance == null) {
            WANTest.initializeLocator();
        }
        instance.startLocatorAndAdminDS();
    }

    void startLocatorAndAdminDS() {
        DistributedSystemHelper.startLocatorAndAdminDS();
        this.waitForLocatorDiscovery();
    }

    public static synchronized void starAndVerifytLocatorAdminDSTask() {
        if (instance == null) {
            WANTest.initializeLocator();
        }
        instance.startAndVerifyLocatorAdminDS();
    }

    void startAndVerifyLocatorAdminDS() {
        Locator l = DistributedSystemHelper.startLocatorAndAdminDS();
        this.waitForLocatorDiscovery();
        if (l != null) {
            Integer ds = DistributedSystemHelper.getDistributedSystemId();
            String locString = this.getLocatorAsString(l);
            SharedLock lock = this.bb.getSharedLock();
            lock.lock();
            Object locatorMap = this.bb.getSharedMap().get(WANBlackboard.LOCATORS_MAP);
            if (locatorMap == null) {
                HashMap<Integer, String> lMap = new HashMap<Integer, String>();
                lMap.put(ds, locString);
                this.bb.getSharedMap().put(WANBlackboard.LOCATORS_MAP, lMap);
            } else {
                Map lMap = (Map)locatorMap;
                String locators = (String)lMap.get(ds);
                if (locators == null) {
                    lMap.put(ds, locString);
                } else if (!locators.contains(locString)) {
                    String str = ((Map)this.bb.getSharedMap().get(WANBlackboard.LOCATORS_MAP)).get(ds) + "," + locString;
                    lMap.put(ds, str);
                }
                this.bb.getSharedMap().put(WANBlackboard.LOCATORS_MAP, lMap);
            }
            lock.unlock();
        }
        this.verifyLocators();
    }

    public static synchronized void stopLocatorTask() {
        instance.stopLocator();
    }

    void stopLocator() {
        DistributedSystemHelper.stopLocator();
    }

    public static synchronized void initPeerCacheTask() {
        if (instance == null) {
            WANTest.initializeDatastore();
            instance.initPeerCache();
        }
    }

    public void initPeerCache() {
        String cacheConfig = ConfigPrms.getCacheConfig();
        Cache c = CacheHelper.createCache(cacheConfig);
    }

    public static synchronized void initServerCacheTask() {
        if (instance == null) {
            WANTest.initializeDatastore();
            instance.initPeerCache();
        }
    }

    public static synchronized void initPeerRegionTask() {
        instance.initDatastoreRegion();
    }

    public void initDatastoreRegion() {
        this.initPdxDiskStore();
        Log.getLogWriter().info("Creating regions with descriptions :" + regionDescriptNames);
        for (int j = 0; j < regionDescriptNames.size(); ++j) {
            String regionDescriptName = regionDescriptNames.get(j);
            if (regionDescriptName.startsWith("client") || regionDescriptName.startsWith("accessor")) continue;
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            RegionHelper.createRegion(regionName, regionDescriptName);
            if (!regionNames.contains(regionName)) {
                regionNames.add(regionName);
            }
            Log.getLogWriter().info("Created datastore region " + regionName + " with region descript name " + regionDescriptName);
        }
    }

    public static synchronized void initAccessorRegionTask() {
        List<Region> regions = instance.initAccessorRegion();
        boolean isAllEmpty = true;
        for (Region reg : regions) {
            if (reg.getAttributes().getDataPolicy() == DataPolicy.EMPTY) continue;
            isAllEmpty = false;
        }
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        if (bridgeConfig != null && !isAllEmpty) {
            BridgeHelper.startBridgeServer(bridgeConfig);
        }
    }

    List<Region> initAccessorRegion() {
        this.initPdxDiskStore();
        ArrayList<Region> regions = new ArrayList<Region>();
        for (int j = 0; j < regionDescriptNames.size(); ++j) {
            String regionDescriptName = regionDescriptNames.get(j);
            if (!regionDescriptName.startsWith("accessor")) continue;
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region region = RegionHelper.createRegion(regionName, regionDescriptName);
            regions.add(region);
            if (!regionNames.contains(regionName)) {
                regionNames.add(regionName);
            }
            Log.getLogWriter().info("Created accessor region " + regionName + " with region descript name " + regionDescriptName);
        }
        return regions;
    }

    public static synchronized void initServerRegionTask() {
        instance.initDatastoreRegion();
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        BridgeHelper.startBridgeServer(bridgeConfig);
    }

    public static synchronized void initEdgeClientCacheTask() {
        if (instance == null) {
            WANTest.initializeClient();
            instance.initEdgeClientCache();
        }
    }

    public void initEdgeClientCache() {
        String cacheConfig = WANTestPrms.getClientCacheConfig();
        Cache cache = CacheHelper.createCache(cacheConfig);
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        ArrayList<Region> regions = new ArrayList<Region>();
        for (int j = 0; j < regionDescriptNames.size(); ++j) {
            String regionDescriptName = regionDescriptNames.get(j);
            if (!regionDescriptName.startsWith("client")) continue;
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region region = RegionHelper.createRegion(regionName, regionDescriptName);
            Log.getLogWriter().info("Created edge client region " + regionName + " with region descript name " + regionDescriptName);
            if (!regionNames.contains(regionName)) {
                regionNames.add(regionName);
            }
            PoolImpl mybw = ClientHelper.getPool(region);
            ServerLocation primaryEndpoint = mybw.getPrimary();
            Log.getLogWriter().info("The primary server endpoint is " + primaryEndpoint);
            regions.add(region);
        }
        if (!VmDurableId.equals("")) {
            Log.getLogWriter().info(" VM Durable Client Id is " + VmDurableId);
            if (!DurableClientsBB.getBB().getSharedMap().containsKey(VmDurableId)) {
                HashMap map = new HashMap();
                DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
            }
            cache.readyForEvents();
        }
        for (int i = 0; i < regions.size(); ++i) {
            this.registerInterest((Region)regions.get(i));
        }
    }

    public static synchronized void initCQClientTask() {
        if (instance == null) {
            WANTest.initializeClient();
        }
        instance.initCQClient();
    }

    public void initCQClient() {
        String cacheConfig = WANTestPrms.getClientCacheConfig();
        Cache cache = CacheHelper.createCache(cacheConfig);
        CQUtil.initialize();
        CQUtil.initializeCQService();
        for (int j = 0; j < regionDescriptNames.size(); ++j) {
            String regionDescriptName = regionDescriptNames.get(j);
            if (!regionDescriptName.startsWith("client")) continue;
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region region = RegionHelper.createRegion(regionName, regionDescriptName);
            Log.getLogWriter().info("Created edge client region " + regionName + " with region descript name " + regionDescriptName);
            if (!regionNames.contains(regionName)) {
                regionNames.add(regionName);
            }
            CQUtil.registerCQ(region);
            this.bb.getSharedCounters().increment(WANBlackboard.NUM_CQ);
            this.registerInterest(region);
        }
    }

    private void registerInterest(Region region) {
        InterestResultPolicy interestPolicy = CacheClientPrms.getInterestPolicy();
        LocalRegion localRegion = (LocalRegion)region;
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            Log.getLogWriter().info("Doing durable register interest");
            localRegion.registerInterest((Object)"ALL_KEYS", interestPolicy, true);
        } else {
            localRegion.registerInterest((Object)"ALL_KEYS", interestPolicy);
        }
        Log.getLogWriter().info("Initialized region " + region + "\nRegistered interest in ALL_KEYS with InterestResultPolicy = " + interestPolicy);
    }

    public static synchronized void createGatewaySenderIdsTask() {
        String senderConfig = ConfigPrms.getGatewaySenderConfig();
        GatewaySenderHelper.createGatewaySenderIds(senderConfig);
    }

    public static synchronized void initGatewaySenderTask() {
        instance.initGatewaySender();
    }

    public void initGatewaySender() {
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders();
        if (senders != null && senders.size() > 0) {
            Log.getLogWriter().info("Sender already created");
            return;
        }
        String senderConfig = ConfigPrms.getGatewaySenderConfig();
        gatewaySenders = GatewaySenderHelper.createAndStartGatewaySenders(senderConfig);
    }

    public static synchronized void startGatewaySenderTask() {
        instance.startGatewaySender();
    }

    public void startGatewaySender() {
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders();
        if (senders == null || senders.size() == 0) {
            throw new HydraConfigException("Test issue: Start gateway sender is called before creaing them.");
        }
        if (this.isSenderStarted) {
            Log.getLogWriter().info("Sender already started: " + senders);
            return;
        }
        HashSet<String> queueRegions = new HashSet<String>();
        GatewaySenderHelper.startGatewaySenders();
        for (GatewaySender sender : senders) {
            opsClient.updateSenderStateToBB(sender);
            this.addSenderQueueListener(sender);
            if (!(sender instanceof ParallelGatewaySenderImpl)) continue;
            ConcurrentParallelGatewaySenderQueue prq = (ConcurrentParallelGatewaySenderQueue)((ParallelGatewaySenderImpl)sender).getQueues().toArray(new RegionQueue[1])[0];
            if (null == prq.getRegion()) {
                Set prs = prq.getRegions();
                Iterator sit = prs.iterator();
                while (sit.hasNext()) {
                    queueRegions.add(((PartitionedRegion)sit.next()).getRegion().getFullPath());
                }
                continue;
            }
            queueRegions.add(prq.getRegion().getFullPath());
        }
        this.isSenderStarted = true;
        String dsName = DistributedSystemHelper.getDistributedSystemName();
        String senderkey = SENDER_NAME_PREFIX + DistributedSystemHelper.getDistributedSystemId();
        Set queueSet = (Set)this.bb.getSharedMap().get(senderkey);
        if (queueSet == null) {
            this.bb.getSharedMap().put(senderkey, queueRegions);
        } else {
            queueSet.addAll(queueRegions);
            this.bb.getSharedMap().put(senderkey, queueSet);
        }
    }

    private void addSenderQueueListener(GatewaySender sender) {
        String queueListenerClass = WANTestPrms.getSenderQueueRegionListener();
        if (queueListenerClass != null && !queueListenerClass.equalsIgnoreCase("none")) {
            Object queueListenerInstance = AbstractDescription.getInstance(WANTestPrms.senderQueueRegionListener, queueListenerClass);
            if (queueListenerInstance instanceof CacheListener) {
                if (sender instanceof SerialGatewaySenderImpl) {
                    Set sqSet = ((SerialGatewaySenderImpl)sender).getQueues();
                    for (RegionQueue rq : sqSet) {
                        rq.addCacheListener((CacheListener)queueListenerInstance);
                    }
                } else if (sender instanceof ParallelGatewaySenderImpl) {
                    RegionQueue parallelQueue = (RegionQueue)((ParallelGatewaySenderImpl)sender).getQueues().toArray()[0];
                    PartitionedRegion region = (PartitionedRegion)parallelQueue.getRegion();
                    for (int i = 0; i < region.getTotalNumberOfBuckets(); ++i) {
                        BucketRegion br = region.getBucketRegion((Object)i);
                        if (br == null) continue;
                        AttributesMutator mutator = br.getAttributesMutator();
                        mutator.addCacheListener((CacheListener)queueListenerInstance);
                    }
                } else {
                    throw new HydraConfigException("Test issue: Unknown class of gateway sender: " + GatewaySenderHelper.gatewaySenderToString(sender));
                }
                Log.getLogWriter().info("Configured cache listener " + queueListenerClass + " to queue region of sender " + sender.getId());
            } else {
                String s = BasePrms.nameForKey(WANTestPrms.senderQueueRegionListener) + " does not implement CacheListener: " + queueListenerClass;
                throw new HydraConfigException(s);
            }
        }
    }

    public static synchronized void HydraTask_stopWANComponents() {
        GatewaySenderHelper.stopGatewaySenders();
        GatewayReceiverHelper.stopGatewayReceivers();
    }

    public static synchronized void stopGatewaySenderTask() {
        instance.stopGatewaySender();
    }

    void stopGatewaySender() {
        GatewaySenderHelper.stopGatewaySenders();
    }

    public static synchronized void stopGatewayReceiverTask() {
        instance.stopGatewayReceiver();
    }

    void stopGatewayReceiver() {
        GatewayReceiverHelper.stopGatewayReceivers();
    }

    public static synchronized void initGatewayReceiverTask() {
        instance.initGatewayReceiver();
    }

    public void initGatewayReceiver() {
        String receiverConfig = ConfigPrms.getGatewayReceiverConfig();
        GatewayReceiverHelper.createAndStartGatewayReceivers(receiverConfig);
    }

    public static synchronized void HydraTask_initPeerTask() {
        if (instance == null) {
            WANTest.initializeDatastore();
            instance.initPeerCache();
            instance.initGatewaySender();
            instance.initDatastoreRegion();
            instance.initGatewayReceiver();
            instance.startGatewaySender();
        }
    }

    public static synchronized void HydraTask_initServerTask() {
        if (instance == null) {
            WANTest.initializeDatastore();
            instance.initPeerCache();
            instance.initGatewaySender();
            instance.initServerRegionTask();
            instance.initGatewayReceiver();
            instance.startGatewaySender();
        }
    }

    public static synchronized void HydraTask_initWANComponentsTask() {
        if (instance == null) {
            WANTest.initializeDatastore();
            instance.initGatewaySender();
            instance.startGatewaySender();
            instance.initGatewayReceiver();
        }
    }

    public static synchronized void closeEdgeClientCacheTask() {
        Cache cache = CacheHelper.getCache();
        if (cache != null) {
            for (int j = 0; j < regionDescriptNames.size(); ++j) {
                String regionName;
                Region region;
                String regionDescriptName = regionDescriptNames.get(j);
                if (!regionDescriptName.startsWith("client") || (region = RegionHelper.getRegion(regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName())) == null) continue;
                Log.getLogWriter().info("Client's region " + regionName + " contains " + region.keys().size() + " entries");
                if (region.getAttributes().getPartitionAttributes() != null) continue;
                CacheHelper.closeCache();
                return;
            }
        }
    }

    public static void validateSequentialKeysTask() {
        instance.validateSequentialKeysInRegion();
    }

    protected void validateSequentialKeysInRegion() {
        PdxTest.initClassLoader();
        Log.getLogWriter().info("validateSequentialKeysInRegion: Validation started");
        this.waitForQueuesToDrain();
        SilenceListener.waitForSilence(30L, 5000L);
        boolean onlyParentRegion = WANTestPrms.onlyParentRegion();
        if (onlyParentRegion && !regionNames.isEmpty()) {
            Region aRegion = RegionHelper.getRegion(regionNames.get(0));
            this.validateRegion(aRegion);
        } else {
            Region aRegion22 = null;
            Set rootRegions = CacheHelper.getCache().rootRegions();
            for (Region aRegion22 : rootRegions) {
                this.validateRegion(aRegion22);
                Set subRegions = aRegion22.subregions(true);
                for (Region aRegion22 : subRegions) {
                    this.validateRegion(aRegion22);
                }
            }
        }
        Log.getLogWriter().info("validateSequentialKeysInRegion: Validation complete");
    }

    public void validateRegion(Region aRegion) {
        Log.getLogWriter().info("Validating region: " + aRegion.getFullPath());
        if (aRegion == null) {
            throw new TestException("Region is null ");
        }
        StringBuffer aStr = new StringBuffer();
        if (RemoteTestModule.getMyClientName().contains("edge")) {
            Set serverKeys = aRegion.keySetOnServer();
            int expectedRegionSize = serverKeys.size();
            Set localKeys = aRegion.keySet();
            Set myEntries = aRegion.entrySet();
            Object[] entries = myEntries.toArray();
            int localKeySize = entries.length;
            RegionEntryComparator myComparator = new RegionEntryComparator();
            Arrays.sort(entries, myComparator);
            if (entries.length == 0 && expectedRegionSize == 0) {
                return;
            }
            Log.getLogWriter().info("Expecting " + expectedRegionSize + " entries from server in Region " + aRegion.getFullPath() + ", found " + localKeySize + " entries locally\n");
            if (localKeySize != expectedRegionSize) {
                aStr.append("Expected " + expectedRegionSize + " keys from  server in Region " + aRegion.getFullPath() + " but found " + localKeySize + " entries locally\n");
            }
            Log.getLogWriter().info("Checking for missing or extra keys in client region");
            ArrayList unexpectedKeys = new ArrayList(localKeys);
            unexpectedKeys.removeAll(serverKeys);
            if (unexpectedKeys.size() > 0) {
                aStr.append("Extra keys (not found on server): " + unexpectedKeys + "\n");
            }
            ArrayList missingKeys = new ArrayList(serverKeys);
            missingKeys.removeAll(localKeys);
            if (missingKeys.size() > 0) {
                aStr.append("Missing keys (found on server, but not locally) = " + missingKeys + "\n");
            }
        }
        int requiredSizeFromBB = this.bb.getSharedMap().get(aRegion.getName()) != null ? ((Long)this.bb.getSharedMap().get(aRegion.getName())).intValue() : 0;
        int keySize = aRegion.size();
        String str = "SUPPOSED TO HAVE:" + requiredSizeFromBB + " FROM BB, DOES HAVE:" + keySize;
        Log.getLogWriter().info(str);
        if (requiredSizeFromBB != keySize) {
            aStr.append(str);
        }
        Log.getLogWriter().info("Entering the validation loop ");
        for (long i = 1L; i < (long)requiredSizeFromBB; ++i) {
            String s;
            String s2;
            String key = NameFactory.getObjectNameForCounter(i);
            Object val = aRegion.get((Object)key);
            logger.info("Region " + aRegion.getName() + " has entry: " + key + " => " + val);
            if (val == null) {
                s2 = "No value in cache at " + key + " in Region " + aRegion.getFullPath();
                throw new TestException(s2);
            }
            if (val instanceof Integer) {
                int ival = (Integer)val;
                if (ival == ITERATIONS) continue;
                s = "Wrong value in cache at " + key + " in Region " + aRegion.getFullPath() + ", expected " + ITERATIONS + " but got " + ival;
                throw new TestException(s);
            }
            if (val instanceof byte[]) {
                if (((byte[])val).length == ITERATIONS) continue;
                s2 = "Wrong value in cache at " + key + ", expected byte[] of length " + ITERATIONS + " but got length " + ((byte[])val).length;
                throw new TestException(s2);
            }
            if (val instanceof PSTObject) {
                if (((PSTObject)val).getIndex() == ITERATIONS) continue;
                s2 = "Wrong value in cache at " + key + ", expected PSTObject with index " + ITERATIONS + " but got index " + ((PSTObject)val).getIndex();
                throw new TestException(s2);
            }
            if (val instanceof BaseValueHolder || val instanceof PdxInstance) {
                BaseValueHolder vh = (BaseValueHolder)(val = PdxTest.toValueHolder(val));
                if (!vh.getMyValue().equals(new Long(ITERATIONS))) {
                    s = "Wrong value in cache at " + key + ", expected ValueHolder with myValue " + ITERATIONS + " but got " + vh.getMyValue();
                    throw new TestException(s);
                }
                try {
                    vh.verifyMyFields((Long)vh.myValue);
                    continue;
                }
                catch (TestException e) {
                    throw new TestException("While checking key " + key + ": " + e.getMessage());
                }
            }
            if (val instanceof QueryObject) {
                if (((QueryObject)val).aPrimitiveLong == (long)ITERATIONS) continue;
                s2 = "Wrong value in cache at " + key + ", expected QueryObject with aPrimitiveLong=" + ITERATIONS + " but got " + ((QueryObject)val).aPrimitiveLong;
                throw new TestException(s2);
            }
            s2 = "Wrong value object type in cache at " + key + ", got " + val + " of type " + val.getClass().getName();
            throw new TestException(s2);
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("Validated region: " + aRegion.getFullPath());
    }

    public static void validateSequentialKeysCQTask() throws Exception {
        for (String regionName : regionNames) {
            instance.validateSequentialKeysCQ(RegionHelper.getRegion(regionName));
        }
    }

    public void validateSequentialKeysCQ(Region region) {
        long numOnErrorInvocations;
        long numCQDestroyEvents;
        long numCQInvalidateEvents;
        if (region == null) {
            throw new TestException("Region is null ");
        }
        Log.getLogWriter().info("Validating sequential keys CQ for region: " + region.getName());
        long numCqs = this.bb.getSharedCounters().read(WANBlackboard.NUM_CQ);
        this.waitForQueuesToDrain();
        SharedCounters sc = CQUtilBB.getBB().getSharedCounters();
        long requiredSize = (Long)this.bb.getSharedMap().get(region.getName());
        StringBuffer errMsg = new StringBuffer();
        Log.getLogWriter().info("Expected " + requiredSize * numCqs + " (" + requiredSize + " regionEntries * " + numCqs + " numCQs) for region " + region.getFullPath());
        try {
            TestHelper.waitForCounter(CQUtilBB.getBB(), "NUM_CREATE", CQUtilBB.NUM_CREATE, requiredSize * numCqs, true, 300000L);
            TestHelper.waitForCounter(CQUtilBB.getBB(), "NUM_UPDATE", CQUtilBB.NUM_UPDATE, (long)(ITERATIONS - 1) * (requiredSize * numCqs), true, 180000L);
        }
        catch (TestException e) {
            errMsg.append(e.toString() + "\n");
        }
        SharedMap aMap = CQUtilBB.getBB().getSharedMap();
        String exceptionStr = (String)aMap.get(TestHelper.EVENT_ERROR_KEY);
        if (exceptionStr != null) {
            errMsg.append("\nFirst Exception encountered by listener: \n");
            errMsg.append("\t" + exceptionStr + "\n");
            long missing = sc.read(CQUtilBB.MISSING_UPDATES);
            long late = sc.read(CQUtilBB.LATE_UPDATES);
            errMsg.append("\tTotal count of missingUpdates = " + missing + "\n");
            errMsg.append("\tTotal count of late (OutOfOrder) Updates = " + late + "\n");
        }
        if ((numCQInvalidateEvents = sc.read(CQUtilBB.NUM_INVALIDATE)) != 0L) {
            errMsg.append("Expected 0 CQ Invalidate Events, but found " + numCQInvalidateEvents + "\n");
        }
        if ((numCQDestroyEvents = sc.read(CQUtilBB.NUM_DESTROY)) != 0L) {
            errMsg.append("Expected 0 CQ Destroy Events, but found " + numCQDestroyEvents + "\n");
        }
        if ((numOnErrorInvocations = sc.read(CQUtilBB.NUM_ERRORS)) != 0L) {
            errMsg.append("Expected 0 onError() invocations, but found " + numOnErrorInvocations + "\n");
        }
        if (errMsg.length() > 0) {
            String errHdr = "Failures found while verifying CQEvents\n";
            throw new TestException(errHdr + errMsg.toString() + TestHelper.getStackTrace());
        }
        long numCQCreateEvents = sc.read(CQUtilBB.NUM_CREATE);
        long numCQUpdateEvents = sc.read(CQUtilBB.NUM_UPDATE);
        Log.getLogWriter().info("Successfully validated CQEvents in client");
        StringBuffer aStr = new StringBuffer("CQEvent Summary\n");
        aStr.append("   numCQCreateEvents = " + numCQCreateEvents + "\n");
        aStr.append("   numCQUpdateEvents = " + numCQUpdateEvents + "\n");
        aStr.append("   numCQDestroyEvents = " + numCQDestroyEvents + "\n");
        aStr.append("   numCQInvalidateEvents = " + numCQInvalidateEvents + "\n");
        aStr.append("   numOnErrorInvocations = " + numOnErrorInvocations + "\n");
        Log.getLogWriter().info(aStr.toString());
        SelectResults results = CQUtil.getCQResults();
        logger.info("SelectResults SUPPOSED TO HAVE:" + requiredSize + " DOES HAVE:" + results.size() + " numCqs = " + numCqs);
        if ((long)results.size() != requiredSize) {
            throw new TestException("Expected SelectResults to be size " + requiredSize + " but found " + results.size() + " elements");
        }
        for (Object val : results) {
            Serializable v;
            String s;
            if (val == null) {
                s = "Unexpected value " + val + " in SelectResults";
                throw new TestException(s);
            }
            if (val instanceof ValueHolder) {
                v = (ValueHolder)val;
                if (((BaseValueHolder)((Object)v)).getMyValue().equals(new Long(ITERATIONS))) continue;
                String s2 = "Wrong value in SelectResults, expected myValue to be " + ITERATIONS + " but got " + ((BaseValueHolder)((Object)v)).getMyValue() + " in value " + v;
                throw new TestException(s2);
            }
            if (val instanceof QueryObject) {
                v = (QueryObject)val;
                if (((QueryObject)v).aLong.equals(new Long(ITERATIONS))) continue;
                String s3 = "Wrong value in SelectResults, expected aLong to be " + ITERATIONS + " but got " + ((QueryObject)v).aLong + " in QueryObject value " + v;
                throw new TestException(s3);
            }
            s = "Wrong type in SelectResults, expected ValueHolder but got " + val + " of type " + val.getClass().getName();
            throw new TestException(s);
        }
        Log.getLogWriter().info("Successful validation of SelectResults (" + results.size() + "): " + results.toString());
    }

    public static synchronized void HydraTask_verifyQueueEviction() {
        instance.verifyQueueEviction();
    }

    public static synchronized void HydraTask_pauseSenders() {
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders();
        for (GatewaySender sender : senders) {
            logger.info("pausing sender: " + sender.getId());
            sender.pause();
        }
    }

    public static synchronized void HydraTask_resumeSenders() {
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders();
        for (GatewaySender sender : senders) {
            logger.info("resuming sender: " + sender.getId());
            sender.resume();
        }
    }

    protected void verifyQueueEviction() {
        Cache cache = CacheHelper.getCache();
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders();
        for (GatewaySender sender : senders) {
            logger.info("verifyQueueEviction on sender " + sender.getId());
            Set regionQueues = ((AbstractGatewaySender)sender).getQueues();
            for (RegionQueue rq : regionQueues) {
                Region queueRegion = rq.getRegion();
                long entriesInVm = this.getDiskStatNumEntriesInVM(queueRegion);
                long entriesInDisk = this.getDiskStatNumOverflowOnDisk(queueRegion);
                Set entries = queueRegion.entrySet();
                long entriesInRegion = entries.size();
                if (queueRegion instanceof PartitionedRegion) {
                    long totalEntriesInBuckets = 0L;
                    Set bucketList = ((PartitionedRegion)queueRegion).getDataStore().getAllLocalBuckets();
                    for (Map.Entry entry : bucketList) {
                        BucketRegion localBucket = (BucketRegion)entry.getValue();
                        if (localBucket == null) continue;
                        totalEntriesInBuckets += (long)localBucket.entryCount();
                    }
                    entriesInRegion = totalEntriesInBuckets;
                }
                if (entriesInDisk == 0L) {
                    throw new TestException("Test tuning required: no eviction happen for gateway sender: " + GatewaySenderHelper.gatewaySenderToString(sender));
                }
                int approxBytesPerEntry = 4;
                if (!entries.isEmpty()) {
                    Region.Entry entry = (Region.Entry)entries.iterator().next();
                    ObjectSizerImpl sizer = new ObjectSizerImpl();
                    approxBytesPerEntry = sizer.sizeof(entry.getKey()) + sizer.sizeof(entry.getValue());
                }
                logger.info("Approximate size of per entry is " + approxBytesPerEntry + " bytes");
                long approxBytesInVm = entriesInVm * (long)approxBytesPerEntry;
                long maxPermissibleBytes = sender.getMaximumQueueMemory() * 1024 * 1024 / ((AbstractGatewaySender)sender).getDispatcherThreads();
                long allowedOverhead = maxPermissibleBytes / 10L;
                StringBuffer str = new StringBuffer().append("Permissible Bytes for sender region " + queueRegion.getFullPath() + " is " + (maxPermissibleBytes + allowedOverhead) + " bytes (Configured maxPermissibleBytes=" + maxPermissibleBytes + " + 10% more for overhead)" + " but approx bytes in VM is " + approxBytesInVm).append(" (totalQueueRegionEntries= " + entriesInRegion + ", numEntriesInVm=" + entriesInVm + ", NumEntriesInDisk=" + entriesInDisk + ")");
                if (approxBytesInVm > maxPermissibleBytes + allowedOverhead) {
                    throw new TestException(str.toString());
                }
                Log.getLogWriter().info(str.toString());
                logger.info("Queue region entries for sender region " + queueRegion.getFullPath() + ". totalQueueRegionEntries= " + entriesInRegion + ", numEntriesInVm=" + entriesInVm + ", NumEntriesInDisk=" + entriesInDisk);
                if (entriesInRegion == entriesInVm + entriesInDisk) continue;
                throw new TestException("Queue region entries does not matched with entries in VM and Disk for sender region " + queueRegion.getFullPath() + ". totalQueueRegionEntries= " + entriesInRegion + ", numEntriesInVm=" + entriesInVm + ", NumEntriesInDisk=" + entriesInDisk);
            }
        }
    }

    private long getDiskStatNumEntriesInVM(Region queueRegion) {
        long numEntriesInVm = 0L;
        if (queueRegion instanceof PartitionedRegion) {
            PartitionedRegion shadowPR = (PartitionedRegion)queueRegion;
            numEntriesInVm = shadowPR.getDiskRegionStats().getNumEntriesInVM();
        } else if (queueRegion instanceof LocalRegion) {
            DiskRegionStats diskStat = ((LocalRegion)queueRegion).getDiskRegion().getStats();
            numEntriesInVm = diskStat.getNumEntriesInVM();
        } else {
            throw new TestException("Test issue: Unknown class of queueRegion : " + RegionHelper.regionAttributesToString(queueRegion.getAttributes()));
        }
        return numEntriesInVm;
    }

    private long getDiskStatNumOverflowOnDisk(Region queueRegion) {
        long numOverflowObDisk = 0L;
        if (queueRegion instanceof PartitionedRegion) {
            PartitionedRegion shadowPR = (PartitionedRegion)queueRegion;
            numOverflowObDisk = shadowPR.getDiskRegionStats().getNumOverflowOnDisk();
        } else if (queueRegion instanceof LocalRegion) {
            DiskRegionStats diskStat = ((LocalRegion)queueRegion).getDiskRegion().getStats();
            numOverflowObDisk = diskStat.getNumOverflowOnDisk();
        } else {
            throw new TestException("Test issue: Unknown class of queueRegion : " + RegionHelper.regionAttributesToString(queueRegion.getAttributes()));
        }
        return numOverflowObDisk;
    }

    public static void printQueueContentsTask() throws Exception {
        instance.printQueueContents();
    }

    public void printQueueContents() {
        if (!this.isQueuePrinting.get()) {
            this.isQueuePrinting.set(true);
            for (GatewaySender gs : gatewaySenders) {
                Log.getLogWriter().info("Printing queue contents for sender : " + gs.getId());
                HashSet<Region> queueRegions = new HashSet<Region>();
                if (!(gs instanceof ParallelGatewaySenderImpl)) continue;
                ConcurrentParallelGatewaySenderQueue prq = (ConcurrentParallelGatewaySenderQueue)((ParallelGatewaySenderImpl)gs).getQueues().toArray(new RegionQueue[1])[0];
                if (null == prq.getRegion()) {
                    Set prs = prq.getRegions();
                    Iterator sit = prs.iterator();
                    while (sit.hasNext()) {
                        queueRegions.add(((PartitionedRegion)sit.next()).getRegion());
                    }
                    sit = prs.iterator();
                    while (sit.hasNext()) {
                        this.printRegionQueue(((PartitionedRegion)sit.next()).getRegion(), queueRegions);
                    }
                    continue;
                }
                queueRegions.add(prq.getRegion());
                this.printRegionQueue(prq.getRegion(), queueRegions);
            }
            this.isQueuePrinting.set(false);
        } else {
            Log.getLogWriter().info("Some other thread is already printing queue content in this vm, thus skiping...");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void printRegionQueue(Region region, Set rq) {
        Object val;
        Object key;
        Region.Entry entry2;
        int i;
        Object[] myEntries;
        int totalCnt = region.size();
        int primCnt = 0;
        String primary = "";
        Region localPrimaryRegion = null;
        boolean isPartition = false;
        if (region instanceof PartitionedRegion) {
            localPrimaryRegion = PartitionRegionHelper.getLocalPrimaryData((Region)region);
            primary = ", " + localPrimaryRegion.size() + " primary entries.";
            primCnt = localPrimaryRegion.size();
            isPartition = true;
        }
        Log.getLogWriter().info("Gateway sender queue " + region.getFullPath() + " has " + totalCnt + " total entries " + primary);
        StringBuilder aStr = new StringBuilder();
        if (isPartition && primCnt < 20000) {
            try {
                myEntries = localPrimaryRegion.entrySet().toArray();
                aStr.append("Queue containts (only primary entries) are : Total entries=" + myEntries.length + "\n");
                for (i = 0; i < myEntries.length && i < 5; ++i) {
                    try {
                        entry2 = (Region.Entry)myEntries[i];
                        if (entry2 == null) continue;
                        key = entry2.getKey();
                        val = entry2.getValue();
                        aStr.append("\t" + key + " -> " + (val == null ? "null" : val) + "\n");
                        continue;
                    }
                    catch (EntryDestroyedException entry2) {
                        // empty catch block
                    }
                }
                if (myEntries.length > 5) {
                    aStr.append("\n The queue (only primary entries) contains more than 5 entries, ignoring others...\n");
                }
            }
            catch (RuntimeException tde) {
                if (!tde.toString().contains("ToDataException")) {
                    throw tde;
                }
                Log.getLogWriter().info("Observed ToDataException while iterating queue region, expected in case of OffHeap region, continue...");
            }
        }
        if (totalCnt < 20000) {
            try {
                myEntries = region.entrySet().toArray();
                aStr.append("Queue containts for all entries are : Total entries=" + myEntries.length + "\n");
                for (i = 0; i < myEntries.length && i < 5; ++i) {
                    try {
                        entry2 = (Region.Entry)myEntries[i];
                        if (entry2 == null) continue;
                        key = entry2.getKey();
                        val = entry2.getValue();
                        aStr.append("\t" + key + " -> " + (val == null ? "null" : val) + "\n");
                        continue;
                    }
                    catch (EntryDestroyedException entryDestroyedException) {
                        // empty catch block
                    }
                }
                if (myEntries.length > 5) {
                    aStr.append("\n The queue contains for all entries has more than 5 entries, ignoring others... ");
                }
            }
            catch (RuntimeException tde) {
                if (!tde.toString().contains("ToDataException")) {
                    throw tde;
                }
                Log.getLogWriter().info("Observed ToDataException while iterating queue region, expected in case of OffHeap region, continue...");
            }
        } else {
            aStr.append(" \n Queue contains total " + totalCnt + " entries, skipping printing.");
        }
        Log.getLogWriter().info(aStr.toString());
    }

    public static void waitForQueuesToDrainTask() {
        instance.waitForQueuesToDrain();
    }

    public void waitForQueuesToDrain() {
        SharedMap bb = WANBlackboard.getInstance().getSharedMap();
        long startTime = System.currentTimeMillis();
        long maxWait = WANTestPrms.getSecToWaitForQueue();
        long entriesLeft = 0L;
        HashMap<String, Integer> queueEntryMap = new HashMap<String, Integer>();
        while (System.currentTimeMillis() - startTime < maxWait * 1000L) {
            boolean pass = true;
            entriesLeft = 0L;
            for (GatewaySender gs : gatewaySenders) {
                if (gs instanceof SerialGatewaySenderImpl) {
                    int queuesize = 0;
                    Set qrs = ((SerialGatewaySenderImpl)gs).getQueues();
                    for (RegionQueue rq : qrs) {
                        queuesize += rq.size();
                    }
                    entriesLeft += (long)queuesize;
                    queueEntryMap.put(gs.getId(), new Integer(queuesize));
                    if (queuesize <= 0) continue;
                    logger.warning("Still waiting for queue to drain. SerialGatewaySender " + gs + " has " + queuesize + " entries in it.");
                    pass = false;
                    continue;
                }
                if (gs instanceof ParallelGatewaySenderImpl) {
                    RegionQueue rq = (RegionQueue)((ParallelGatewaySenderImpl)gs).getQueues().toArray()[0];
                    int queuesize = rq.size();
                    entriesLeft += (long)queuesize;
                    queueEntryMap.put(gs.getId(), new Integer(queuesize));
                    if (queuesize <= 0) continue;
                    logger.warning("Still waiting for queue to drain. ParallelGatewaySender " + gs + " has " + queuesize + " entries in it.");
                    pass = false;
                    continue;
                }
                throw new TestException("Unknown class of gateway sender: " + GatewaySenderHelper.gatewaySenderToString(gs));
            }
            if (pass) {
                entriesLeft = 0L;
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.printQueueContents();
        }
        if (entriesLeft > 0L) {
            throw new TestException("Timed out waiting for queue to drain. Waited for " + maxWait + " sec, total entries left in all queues are " + entriesLeft + ". queueEntryMap=" + queueEntryMap);
        }
        logger.info("SENDER QUEUES ARE DRAINED");
    }

    public static void waitForListenerSilence() {
        Log.getLogWriter().info("Silence Listeenr waiting for 30 seconds ...");
        SilenceListener.waitForSilence(30L, 5000L);
    }

    public static void printSequentialKeysTask() throws Exception {
        for (String rName : regionNames) {
            instance.printSequentialKeys(RegionHelper.getRegion(rName));
        }
    }

    public void printSequentialKeys(Region region) throws Exception {
        if (region == null) {
            throw new TestException("Region in printSequentialKeys is null");
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("Contents of region");
        buffer.append(region.getFullPath());
        buffer.append(":");
        Set keys = region.keys();
        for (Object key : keys) {
            Object val = DiskRegUtil.getValueInVM(region, key);
            if (val == null) continue;
            buffer.append("\n\tENTRY ");
            buffer.append(key);
            buffer.append(":");
            buffer.append(val);
        }
        Log.getLogWriter().info(buffer.toString());
    }

    public static void doHAEntryOperationTask() {
        Log.getLogWriter().info("In doHAEntryOperationTask");
        long cycleCounter = WANOperationsClientBB.getBB().getSharedCounters().read(WANOperationsClientBB.NumCycle);
        int numThreadsForTask = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        long numDoingOps = WANOperationsClientBB.getBB().getSharedCounters().read(WANOperationsClientBB.NumStartedDoingOps);
        if (numDoingOps >= (long)(numThreadsForTask - 1)) {
            Log.getLogWriter().info("Returning from doHAEntryOperationTask with noops as WANOperationsClientBB.NumStartedDoingOps reached to " + numDoingOps);
            MasterController.sleepForMs(10000);
            return;
        }
        WANOperationsClientBB.getBB().getSharedCounters().increment(WANOperationsClientBB.NumStartedDoingOps);
        logger.info("doHAEntryOperationTask: started doing operations counter is " + numDoingOps + " in current cycle, cycleCounter=" + cycleCounter);
        WANTest.doEntryOperationTask();
        long numDoneOps = WANOperationsClientBB.getBB().getSharedCounters().incrementAndRead(WANOperationsClientBB.NumFinishedDoingOps);
        logger.info("doHAEntryOperationTask: finished doing operation counter is " + numDoneOps + " in current cycle, cycleCounter=" + cycleCounter);
        Log.getLogWriter().info("Done doHAEntryOperationTask");
    }

    public static void doEntryOperationTask() {
        block2: {
            try {
                instance.doEntryOperationAllRegions();
            }
            catch (CacheClosedException except) {
                if (StopStartVMs.niceKillInProgress()) break block2;
                throw new TestException(TestHelper.getStackTrace(except));
            }
        }
    }

    protected void doEntryOperationAllRegions() {
        Region aRegion22 = null;
        HashSet<String> regionVisited = new HashSet<String>();
        Set rootRegions = CacheHelper.getCache().rootRegions();
        logger.info("doEntryOperationUniqueKeys: on regions " + rootRegions);
        for (Region aRegion22 : rootRegions) {
            if (!regionVisited.contains(aRegion22.getName())) {
                opsClient.doEntryOperations(aRegion22);
                regionVisited.add(aRegion22.getName());
            }
            Set subRegions = aRegion22.subregions(true);
            for (Region aRegion22 : subRegions) {
                if (regionVisited.contains(aRegion22.getName())) continue;
                opsClient.doEntryOperations(aRegion22);
                regionVisited.add(aRegion22.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateDoEntryOperationTask() {
        Boolean bl = isValidateDoEntryOperationsCalled;
        synchronized (bl) {
            if (!isValidateDoEntryOperationsCalled.booleanValue()) {
                instance.validateDoEntryOperationUniqueKeys();
                isValidateDoEntryOperationsCalled = new Boolean(true);
            }
        }
    }

    protected void validateDoEntryOperationUniqueKeys() {
        Log.getLogWriter().info("validateDoEntryOperation: Validation started");
        this.waitForQueuesToDrain();
        SilenceListener.waitForSilence(30L, 5000L);
        boolean onlyParentRegion = WANTestPrms.onlyParentRegion();
        if (onlyParentRegion && !regionNames.isEmpty()) {
            Region aRegion = RegionHelper.getRegion(regionNames.get(0));
            opsClient.verifyRegionContents(aRegion, opsClient.getBBSnapshotForUniqueKeyMap(aRegion));
        } else {
            Region aRegion22 = null;
            Set rootRegions = CacheHelper.getCache().rootRegions();
            for (Region aRegion22 : rootRegions) {
                opsClient.verifyRegionContents(aRegion22, opsClient.getBBSnapshotForUniqueKeyMap(aRegion22));
                Set subRegions = aRegion22.subregions(true);
                for (Region aRegion22 : subRegions) {
                    opsClient.verifyRegionContents(aRegion22, opsClient.getBBSnapshotForUniqueKeyMap(aRegion22));
                }
            }
        }
        Log.getLogWriter().info("validateDoEntryOperation: Validation complete");
    }

    public static void updateRegionSnapshotTask() {
        updateRegionSnapshot.executeOnce(opsClient, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void validateDoEntryOperationTxTask() {
        Boolean bl = isValidateDoEntryOperationsCalled;
        synchronized (bl) {
            if (!isValidateDoEntryOperationsCalled.booleanValue()) {
                instance.validateDoEntryOperationUniqueKeysTransactions();
                isValidateDoEntryOperationsCalled = new Boolean(true);
            }
        }
    }

    protected void validateDoEntryOperationUniqueKeysTransactions() {
        Log.getLogWriter().info("validateDoEntryOperation: Validation started");
        WANTest.waitForQueuesToDrainTask();
        SilenceListener.waitForSilence(30L, 5000L);
        Region aRegion22 = null;
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region aRegion22 : rootRegions) {
            opsClient.verifyRegionContents(aRegion22, opsClient.getBBSnapshot(aRegion22));
            Set subRegions = aRegion22.subregions(true);
            for (Region aRegion22 : subRegions) {
                opsClient.verifyRegionContents(aRegion22, opsClient.getBBSnapshot(aRegion22));
            }
        }
        Log.getLogWriter().info("validateDoEntryOperation: Validation complete");
    }

    public static void putSequentialKeysTask() throws Exception {
        HashSet<String> regionVisited = new HashSet<String>();
        for (String regionName : regionNames) {
            if (regionVisited.contains(regionName)) continue;
            instance.putSequentialKeys(RegionHelper.getRegion(regionName));
            regionVisited.add(regionName);
        }
    }

    public void putSequentialKeys(Region region) throws Exception {
        if (region == null) {
            throw new TestException("Region in putSequentialKeys is " + region);
        }
        PdxTest.initClassLoader();
        int putAllOps = 5;
        int sleepMs = WANTestPrms.getSleepSec() * 1000;
        for (int j = 0; j < WANTestPrms.getBatchSize(); ++j) {
            int doPutAll = rand.nextInt(putAllOps);
            if (doPutAll == 1) {
                this.putSequentialKeyUsingPutAll(region, sleepMs);
                continue;
            }
            long opsCounter = this.bb.getSharedCounters().read(WANBlackboard.operation_counter);
            if (opsCounter + (long)ITERATIONS > maxOperations) {
                throw new StopSchedulingOrder("Time to stop as max number of operations reached. Operations=" + opsCounter);
            }
            opsCounter = this.bb.getSharedCounters().add(WANBlackboard.operation_counter, ITERATIONS);
            Long keyCounter = WANBlackboard.increamentAndReadKeyCounter(region.getName(), 1);
            Object key = this.getKeyForCounter(keyCounter);
            logger.info("Working on key :" + key + " for region " + region.getFullPath() + " opsCounter=" + opsCounter);
            for (long i = 1L; i <= (long)ITERATIONS; ++i) {
                MasterController.sleepForMs(sleepMs);
                BaseValueHolder val = this.getValueForCounter(i);
                Object v = region.replace(key, (Object)val);
                if (v != null) continue;
                region.put(key, (Object)val);
            }
        }
    }

    public static void putSequentialKeysAndHATask() throws Exception {
        instance.putSequentialKeysAndHA();
    }

    public synchronized void putSequentialKeysAndHA() throws Exception {
        String peerName;
        int numVMsToStop = TestConfig.tasktab().intAt(StopStartPrms.numVMsToStop, TestConfig.tab().intAt(StopStartPrms.numVMsToStop));
        if (numVMsToStop <= 0) {
            logger.warning("putSequentialKeysAndHA: Not doing anything as number of vm requested to kill is " + numVMsToStop);
            return;
        }
        String dsName = DistributedSystemHelper.getDistributedSystemName();
        if (this.isBridgeConfiguration) {
            String vmName = RemoteTestModule.getMyClientName();
            peerName = "bridge" + vmName.substring(vmName.indexOf("_"), vmName.indexOf("_", vmName.indexOf("_") + 1));
        } else {
            peerName = "peer" + dsName.substring(dsName.indexOf("_"));
        }
        logger.info("putSequentialKeysAndHA: Looking for " + numVMsToStop + " vm with client name " + peerName);
        PRObserver.initialize();
        Object[] tmpArr = StopStartVMs.getOtherVMs(numVMsToStop, peerName);
        List vmList = (List)tmpArr[0];
        List stopModeList = (List)tmpArr[1];
        List threads = StopStartVMs.stopStartAsync(vmList, stopModeList);
        for (String regionName : regionNames) {
            this.putSequentialKeys(RegionHelper.getRegion(regionName));
        }
        StopStartVMs.joinStopStart(vmList, threads);
    }

    public static void putSequentialKeysCQTask() throws Exception {
        for (String regionName : regionNames) {
            instance.putSequentialKeysCQ(RegionHelper.getRegion(regionName));
        }
    }

    public void putSequentialKeysCQ(Region region) throws Exception {
        if (region == null) {
            throw new TestException("Region in putSequentialKeys is " + region);
        }
        int putAllOps = 5;
        int sleepMs = WANTestPrms.getSleepSec() * 1000;
        for (int j = 0; j < WANTestPrms.getBatchSize(); ++j) {
            int doPutAll = rand.nextInt(putAllOps);
            if (doPutAll == 1) {
                int mapSize = rand.nextInt(4) + 1;
                Long entryCounter = WANBlackboard.increamentAndReadKeyCounter(region.getName(), mapSize);
                logger.info("Working on key :" + this.getKeyForCounter(entryCounter - (long)mapSize + 1L) + " for region " + region.getFullPath() + ". PutAll with the map size of " + mapSize + " from key " + this.getKeyForCounter(entryCounter - (long)mapSize + 1L));
                HashMap<String, QueryObject> aMap = new HashMap<String, QueryObject>();
                for (long i = 1L; i <= (long)ITERATIONS; ++i) {
                    MasterController.sleepForMs(sleepMs);
                    for (long k = entryCounter - (long)mapSize + 1L; k <= entryCounter; ++k) {
                        String key = NameFactory.getObjectNameForCounter(k);
                        QueryObject val = this.getQueryObjectForCounter(i);
                        aMap.put(key, val);
                    }
                    region.putAll(aMap);
                }
                continue;
            }
            Long keyCounter = WANBlackboard.increamentAndReadKeyCounter(region.getName(), 1);
            String key = NameFactory.getObjectNameForCounter(keyCounter);
            logger.info("Working on key :" + key + " for region " + region.getFullPath());
            for (long i = 1L; i <= (long)ITERATIONS; ++i) {
                MasterController.sleepForMs(sleepMs);
                QueryObject val = this.getQueryObjectForCounter(i);
                Object v = region.replace((Object)key, (Object)val);
                if (v != null) continue;
                region.put((Object)key, (Object)val);
            }
        }
    }

    public static void mentionReferenceInBlackboard() {
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        Log.getLogWriter().info("Reference vm is : " + VmDurableId);
        DurableClientsBB.getBB().getSharedMap().put("REFERENCE VM:", VmDurableId);
    }

    public static void validateEventsReceived() {
        DurableClientsBB.getBB().printSharedMap();
        String ReferenceVm = (String)DurableClientsBB.getBB().getSharedMap().get("REFERENCE VM:");
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        HashMap currentVmMap = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
        HashMap referenceMap = (HashMap)DurableClientsBB.getBB().getSharedMap().get(ReferenceVm);
        if (currentVmMap.isEmpty()) {
            throw new TestException(" The map of threads is empty for the Vm " + VmDurableId);
        }
        if (referenceMap.isEmpty()) {
            throw new TestException(" The map of threads is empty for the Reference Vm " + ReferenceVm);
        }
        Iterator iterator = referenceMap.entrySet().iterator();
        Map.Entry entry = null;
        Object key = null;
        Object value = null;
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = entry.getKey();
            value = entry.getValue();
            HashMap referenceThreadMap = value;
            Iterator iterator1 = referenceThreadMap.entrySet().iterator();
            Map.Entry entry1 = null;
            Object key1 = null;
            Object value1 = null;
            while (iterator1.hasNext()) {
                entry1 = iterator1.next();
                key1 = entry1.getKey();
                value1 = entry1.getValue();
                if (!((String)key1).startsWith("EVENT SR. No : ")) continue;
                if (currentVmMap.get(key) == null) {
                    throw new TestException("Map is null");
                }
                if (((HashMap)currentVmMap.get(key)).get(key1) == null) {
                    throw new TestException("Event not received by the client for the key " + key + " for the event no " + key1);
                }
                if (value1.equals(((HashMap)currentVmMap.get(key)).get(key1))) continue;
                throw new TestException(" For the key " + key + " the event no " + key1 + " has different events");
            }
        }
    }

    public static synchronized void killClient() {
        try {
            MasterController.sleepForMs(1000);
            ClientVmInfo clientVmInfo = ClientVmMgr.stop("Killing the VM", -21, -30);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().warning(" Exception while killing client ", (Throwable)e);
        }
    }

    private Object getKeyForCounter(long key) {
        return NameFactory.getObjectNameForCounter(key);
    }

    private BaseValueHolder getValueForCounter(long counter) {
        String objectType = TestConfig.tab().stringAt(ValueHolderPrms.objectType, "util.ValueHolder");
        BaseValueHolder vh = opsClient.getValueForKey(NameFactory.getObjectNameForCounter(counter));
        if (objectType.equals("util.PdxVersionedValueHolder") || objectType.equals("util.VersionedValueHolder")) {
            return PdxTest.getVersionedValueHolder(objectType, ((ValueHolder)vh).getMyValue(), rv);
        }
        return (ValueHolder)vh;
    }

    public QueryObject getQueryObjectForCounter(long key) {
        return new QueryObject(key, 1, 0, 0);
    }

    public void putSequentialKeyUsingPutAll(Region region, int sleepMs) throws Exception {
        int mapSize = 1;
        long opsCounter = this.bb.getSharedCounters().read(WANBlackboard.operation_counter);
        if (opsCounter + (long)(ITERATIONS * mapSize) > maxOperations) {
            throw new StopSchedulingOrder("Time to stop as max number of operations reached. Operations=" + opsCounter);
        }
        opsCounter = this.bb.getSharedCounters().add(WANBlackboard.operation_counter, ITERATIONS * mapSize);
        Long entryCounter = WANBlackboard.increamentAndReadKeyCounter(region.getName(), mapSize);
        TreeSet<Object> keyMap = new TreeSet<Object>();
        for (long j = entryCounter - (long)mapSize + 1L; j <= entryCounter; ++j) {
            keyMap.add(this.getKeyForCounter(j));
        }
        logger.info("Working on key :" + keyMap + " for region " + region.getFullPath() + ". PutAll with the map size of " + mapSize + " opsCounter=" + opsCounter);
        HashMap<Object, BaseValueHolder> aMap = new HashMap<Object, BaseValueHolder>();
        for (long i = 1L; i <= (long)ITERATIONS; ++i) {
            MasterController.sleepForMs(sleepMs);
            for (long j = entryCounter - (long)mapSize + 1L; j <= entryCounter; ++j) {
                Object key = this.getKeyForCounter(j);
                BaseValueHolder val = this.getValueForCounter(i);
                aMap.put(key, val);
            }
            region.putAll(aMap);
        }
        logger.info("Done putall on keys " + aMap.keySet());
    }

    public static void waitTask() {
        MasterController.sleepForMs(120000);
    }

    public static String generateAllRemoteDSNameLists(String prefix, int n, int m) {
        return TestConfigFcns.generateNameListsRepeatedlyShift(prefix, n, m);
    }

    public static String generateRingRemoteDSName(String prefix, int n, int m) {
        return TestConfigFcns.generateNamesRepeatedlyShift(prefix, n, m, false, true);
    }

    public static String generateRandomRemoteDSName(String prefix, int n, int m) {
        String v = "";
        for (int i = 1; i <= n; ++i) {
            for (int j = 1; j <= m; ++j) {
                int suffix = i;
                while ((suffix = rand.nextInt(1, n)) == i) {
                }
                v = v + prefix + suffix;
                if (i * j >= m * n) continue;
                v = v + ", ";
            }
        }
        return v;
    }

    public static void killAndVerifyLocatorsTask() {
        instance.killAndVerifyLocators();
    }

    public void killAndVerifyLocators() {
        List locators = Locator.getLocators();
        ConcurrentMap lMap = ((InternalLocator)locators.get(0)).getAllLocatorsInfo();
        logger.info("Distribution locator map before kill: " + lMap);
        int numVMsToStop = TestConfig.tab().intAt(StopStartPrms.numVMsToStop);
        String dsName = DistributedSystemHelper.getDistributedSystemName();
        String locatorName = "locator" + dsName.substring(dsName.indexOf("_"));
        logger.info("killAndVerifyLocators: Looking for " + numVMsToStop + " with matching client name " + locatorName);
        Object[] tmpArr = StopStartVMs.getOtherVMs(numVMsToStop, locatorName);
        List vmList = (List)tmpArr[0];
        List stopModeList = (List)tmpArr[1];
        StopStartVMs.stopStartVMs(vmList, stopModeList);
        this.verifyLocators();
    }

    public static void restartVerifyLocatorsTask() {
        instance.startAndConnectLocator();
    }

    public static void printDistributionLocatorMapTask() {
        List locators = Locator.getLocators();
        ConcurrentMap gfLocMap = ((InternalLocator)locators.get(0)).getAllLocatorsInfo();
        logger.info("Distribution locator map from gemfire system is " + gfLocMap);
    }

    public static void verifyLocatorsTask() {
        instance.verifyLocators();
    }

    public void verifyLocators() {
        logger.info("Verify locators status. Sleeping for " + LocatorDiscovery.WAN_LOCATOR_CONNECTION_TIMEOUT + " ms for locator to exchange locator metadata");
        MasterController.sleepForMs(LocatorDiscovery.WAN_LOCATOR_CONNECTION_TIMEOUT);
        ConcurrentMap gfLocMap = null;
        try {
            List locators = Locator.getLocators();
            gfLocMap = ((InternalLocator)locators.get(0)).getAllLocatorsInfo();
        }
        catch (Exception e) {
            throw new TestException("Unexpected Exception occurred while reading Distribution locator map." + TestHelper.getStackTrace(e));
        }
        logger.info("Distribution locator map from gemfire system is " + gfLocMap);
        Object omap = this.bb.getSharedMap().get(WANBlackboard.LOCATORS_MAP);
        logger.info("Distribution locator map from blackboard is " + omap);
        if (omap != null) {
            Map bbLocMap = (Map)omap;
            Set keys = bbLocMap.keySet();
            for (Object ds : keys) {
                String bbLocList = (String)bbLocMap.get(ds);
                String[] bbLocArray = bbLocList.split(",");
                if (gfLocMap.get(ds) == null) {
                    throw new TestException("No locators found for distributed system " + ds + ", expected locators are :" + bbLocList);
                }
                Set gfLocSet = (Set)gfLocMap.get(ds);
                for (int i = 0; i < bbLocArray.length; ++i) {
                    String loc = bbLocArray[i];
                    DistributionLocatorId dls = new DistributionLocatorId(loc);
                    if (gfLocSet.contains(dls)) continue;
                    throw new TestException("Locator " + loc + " not found in distributed system " + ds);
                }
                logger.info("locators are available in distribution list for " + ds + ". locators are " + bbLocArray.toString());
            }
        } else {
            throw new TestException("No locator found in blackboard.");
        }
    }

    public static synchronized void killPeerAndDoOpsTask() {
        instance.killPeerAndDoOps();
    }

    public synchronized void killPeerAndDoOps() {
        String peerName;
        long cycleCounter = WANOperationsClientBB.getBB().getSharedCounters().read(WANOperationsClientBB.NumCycle);
        logger.info("HA cycle counter = " + cycleCounter);
        int numThreadsForTask = RemoteTestModule.getCurrentThread().getCurrentTask().getTotalThreads();
        try {
            TestHelper.waitForCounter(WANOperationsClientBB.getBB(), "WANOperationsClientBB.NumFinishedDoingOps", WANOperationsClientBB.NumFinishedDoingOps, numThreadsForTask - 1, false, 120000L);
        }
        catch (TestException e) {
            logger.info("Returning as timeout while waiting for WANOperationsClientBB.NumStartedDoingOps");
            return;
        }
        int numVMsToStop = TestConfig.tasktab().intAt(StopStartPrms.numVMsToStop, TestConfig.tab().intAt(StopStartPrms.numVMsToStop));
        if (numVMsToStop <= 0) {
            logger.warning("killPeerAndDoOps: Not doing anything as number of vm requested to kill is " + numVMsToStop);
            return;
        }
        String dsName = DistributedSystemHelper.getDistributedSystemName();
        if (this.isBridgeConfiguration) {
            String vmName = RemoteTestModule.getMyClientName();
            peerName = "bridge" + vmName.substring(vmName.indexOf("_"), vmName.indexOf("_", vmName.indexOf("_") + 1));
        } else {
            peerName = "peer" + dsName.substring(dsName.indexOf("_"));
        }
        PRObserver.initialize();
        logger.info("killPeerAndDoOps: Looking for " + numVMsToStop + " vm with client name " + peerName);
        Object[] tmpArr = StopStartVMs.getOtherVMs(numVMsToStop, peerName);
        List vmList = (List)tmpArr[0];
        List stopModeList = (List)tmpArr[1];
        List otherVms = (List)tmpArr[2];
        List threads = StopStartVMs.stopStartAsync(vmList, stopModeList);
        this.doEntryOperationAllRegions();
        StopStartVMs.joinStopStart(vmList, threads);
        logger.info("killPeerAndDoOps: done restarting " + vmList);
        WANOperationsClientBB.getBB().getSharedCounters().zero(WANOperationsClientBB.NumStartedDoingOps);
        WANOperationsClientBB.getBB().getSharedCounters().zero(WANOperationsClientBB.NumFinishedDoingOps);
        WANOperationsClientBB.getBB().getSharedCounters().increment(WANOperationsClientBB.NumCycle);
        for (int j = 0; j < regionDescriptNames.size(); ++j) {
            RegionDescription rd;
            DataPolicy policy;
            String regionDescriptName = regionDescriptNames.get(j);
            if (regionDescriptName.startsWith("client") || regionDescriptName.startsWith("accessor") || !(policy = (rd = RegionHelper.getRegionDescription(regionDescriptName)).getDataPolicy()).equals(DataPolicy.PARTITION) && !policy.equals(DataPolicy.PERSISTENT_PARTITION)) continue;
            this.waitForRecovery(vmList, otherVms);
            break;
        }
        if (this.isBridgeClient) {
            MasterController.sleepForMs(10000);
        }
        logger.info("killPeerAndDoOps: done");
    }

    public static synchronized void killPeerAndDoNonCoordinatedOpsTask() {
        instance.killPeerAndDoNonCoordinatedOps();
    }

    public synchronized void killPeerAndDoNonCoordinatedOps() {
        String peerName;
        int numVMsToStop = TestConfig.tasktab().intAt(StopStartPrms.numVMsToStop, TestConfig.tab().intAt(StopStartPrms.numVMsToStop));
        if (numVMsToStop <= 0) {
            logger.warning("killPeerAndDoOps: Not doing anything as number of vm requested to kill is " + numVMsToStop);
            return;
        }
        String dsName = DistributedSystemHelper.getDistributedSystemName();
        if (this.isBridgeConfiguration) {
            String vmName = RemoteTestModule.getMyClientName();
            peerName = "bridge" + vmName.substring(vmName.indexOf("_"), vmName.indexOf("_", vmName.indexOf("_") + 1));
        } else {
            peerName = "peer" + dsName.substring(dsName.indexOf("_"));
        }
        PRObserver.initialize();
        logger.info("killPeerAndDoOps: Looking for " + numVMsToStop + " vm with client name " + peerName);
        Object[] tmpArr = StopStartVMs.getOtherVMs(numVMsToStop, peerName);
        List vmList = (List)tmpArr[0];
        List stopModeList = (List)tmpArr[1];
        List otherVms = (List)tmpArr[2];
        List threads = StopStartVMs.stopStartAsync(vmList, stopModeList);
        this.doEntryOperationAllRegions();
        StopStartVMs.joinStopStart(vmList, threads);
        logger.info("killPeerAndDoOps: done restarting " + vmList);
        for (int j = 0; j < regionDescriptNames.size(); ++j) {
            RegionDescription rd;
            DataPolicy policy;
            String regionDescriptName = regionDescriptNames.get(j);
            if (regionDescriptName.startsWith("client") || regionDescriptName.startsWith("accessor") || !(policy = (rd = RegionHelper.getRegionDescription(regionDescriptName)).getDataPolicy()).equals(DataPolicy.PARTITION) && !policy.equals(DataPolicy.PERSISTENT_PARTITION)) continue;
            this.waitForRecovery(vmList, otherVms);
            break;
        }
        if (this.isBridgeClient) {
            MasterController.sleepForMs(10000);
        }
        logger.info("killPeerAndDoOps: done");
    }

    public void waitForRecovery(List startupRecoveryVms, List departedRecoveryVMs) {
        ArrayList<String> prnames = new ArrayList<String>();
        Set regions = CacheHelper.getCache().rootRegions();
        for (Region r : regions) {
            prnames.add(r.getFullPath());
        }
        for (GatewaySender s : gatewaySenders) {
            Set queues;
            if (!(s instanceof ParallelGatewaySenderImpl) || (queues = ((ParallelGatewaySenderImpl)s).getQueues()) == null) continue;
            ConcurrentParallelGatewaySenderQueue prq = (ConcurrentParallelGatewaySenderQueue)queues.toArray(new RegionQueue[1])[0];
            if (null == prq.getRegion()) {
                Set prs = prq.getRegions();
                Iterator sit = prs.iterator();
                while (sit.hasNext()) {
                    prnames.add(((PartitionedRegion)sit.next()).getRegion().getFullPath());
                }
                continue;
            }
            prnames.add(prq.getRegion().getFullPath());
        }
        if (this.isBridgeClient) {
            String vmName = RemoteTestModule.getMyClientName();
            String dsid = vmName.split("_")[1];
            String senderKey = SENDER_NAME_PREFIX + dsid;
            Set queueRegions = (Set)this.bb.getSharedMap().get(senderKey);
            prnames.addAll(queueRegions);
        }
        logger.info("waiting for startup recovery in " + startupRecoveryVms + ", for regions " + prnames);
        PRObserver.waitForRebalRecov(startupRecoveryVms, 1, prnames.size(), null, null, false);
        logger.info("done waiting for recovery activity for " + startupRecoveryVms + " for regions " + prnames);
    }

    public static void restartMembersTask() {
        instance.restartMembers();
    }

    public void restartMembers() {
        String clientVmName = WANTestPrms.getMemberClientName();
        int numVMsToStop = TestConfig.tasktab().intAt(StopStartPrms.numVMsToStop, TestConfig.tab().intAt(StopStartPrms.numVMsToStop));
        logger.info("Inside restartWanSite method. Looking for " + numVMsToStop + " vms with client name " + clientVmName);
        Object[] tmpArr = StopStartVMs.getOtherVMs(numVMsToStop, clientVmName);
        List vmList = (List)tmpArr[0];
        List stopModeList = (List)tmpArr[1];
        StopStartVMs.stopStartVMs(vmList, stopModeList);
    }

    public static void doSenderOperationTask() {
        opsClient.doSenderOperations();
    }

    public static void doHASenderOperationAndVerifyTask() {
        opsClient.doHASenderOperationsAndVerify();
    }

    public static void verifySenderOperationTask() {
        opsClient.verifySenderOperations();
    }

    public static void startResumeSenderTask() throws Exception {
        instance.startResumeSenders();
    }

    public void startResumeSenders() throws Exception {
        Set<GatewaySender> senders = GatewaySenderHelper.getGatewaySenders();
        for (GatewaySender sender : senders) {
            if (!sender.isRunning()) {
                logger.info("startResumeSenders: starting sender " + sender.getId());
                sender.start();
                logger.info("startResumeSenders: started sender " + sender.getId());
                continue;
            }
            if (sender.isPaused()) {
                logger.info("startResumeSenders: resuming sender " + sender.getId());
                sender.resume();
                logger.info("startResumeSenders: resumed sender " + sender.getId());
                continue;
            }
            logger.info("startResumeSenders: sender already running, no operation done on sender " + sender.getId());
        }
    }

    private void initPdxDiskStore() {
        String pdxDiskStoreName;
        if (CacheHelper.getCache().getPdxPersistent() && (pdxDiskStoreName = TestConfig.tab().stringAt(CachePrms.pdxDiskStoreName, null)) != null && CacheHelper.getCache().findDiskStore(pdxDiskStoreName) == null) {
            DiskStoreHelper.createDiskStore(pdxDiskStoreName);
        }
    }

    public static String generateDoubleSuffixedNames(String prefix, int n, int m, int start_n, int start_m, boolean varyFirst, boolean useComma) {
        String v = "";
        if (varyFirst) {
            for (int j = start_m; j < m + start_m; ++j) {
                for (int i = start_n; i < n + start_n; ++i) {
                    v = v + prefix + "_" + i + "_" + j;
                    if (i * j >= (m + start_m - 1) * (n + start_n - 1)) continue;
                    if (useComma) {
                        v = v + ",";
                    }
                    v = v + " ";
                }
            }
        } else {
            for (int i = start_n; i < n + start_n; ++i) {
                for (int j = start_m; j < m + start_m; ++j) {
                    v = v + prefix + "_" + i + "_" + j;
                    if (i * j >= (m + start_m - 1) * (n + start_n - 1)) continue;
                    if (useComma) {
                        v = v + ",";
                    }
                    v = v + " ";
                }
            }
        }
        return v;
    }

    static {
        updateRegionSnapshot = new MethodCoordinator(WANOperationsClient.class.getName(), "writeRegionSnapshotToBB");
        logger = Log.getLogWriter();
        rand = new GsRandom();
        rv = new RandomValues();
        gatewaySenders = new HashSet<GatewaySender>();
        SENDER_NAME_PREFIX = "SenderQueue_";
        validPrefix = false;
        invalidPrefix = false;
    }
}

