/*
 * Decompiled with CFR 0.152.
 */
package newWan;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderImpl;
import durableClients.DurableClientsBB;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GatewayHubHelper;
import hydra.GatewayReceiverHelper;
import hydra.GatewaySenderHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.RegionHelper;
import hydra.RegionPrms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import newWan.WANBlackboard;
import newWan.WANTestPrms;
import objects.PSTObject;
import splitBrain.RegionEntryComparator;
import util.NameFactory;
import util.QueryObject;
import util.RandomValues;
import util.SilenceListener;
import util.TestException;
import util.ValueHolder;
import wan.CacheClientPrms;

public class WanMultiVersion {
    static Set<String> regionNames = new HashSet<String>();
    static LogWriter logger = Log.getLogWriter();
    static final int ITERATIONS = WANTestPrms.getIterations();
    static RandomValues rd = new RandomValues();

    public static synchronized void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static synchronized void startLocatorAndAdminDSTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static synchronized void createGatewaySenderIdsTask() {
        String senderConfig = ConfigPrms.getGatewaySenderConfig();
        GatewaySenderHelper.createGatewaySenderIds(senderConfig);
    }

    public static synchronized void initPeerTask() {
        String cacheConfig = ConfigPrms.getCacheConfig();
        Cache c = CacheHelper.createCache(cacheConfig);
        if (WANTestPrms.isNewWanConfig()) {
            String senderConfig = ConfigPrms.getGatewaySenderConfig();
            GatewaySenderHelper.createGatewaySenders(senderConfig);
        }
        HydraVector regionDescriptions = TestConfig.tab().vecAt(RegionPrms.names, null);
        for (int j = 0; j < regionDescriptions.size(); ++j) {
            String regionDescriptName = (String)regionDescriptions.get(j);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            if (regionNames.contains(regionName)) continue;
            RegionHelper.createRegion(regionName, regionDescriptName);
            Log.getLogWriter().info("Created region " + regionName + " with region descript name " + regionDescriptName);
            regionNames.add(regionName);
        }
    }

    public static synchronized void initServerTask() {
        String cacheConfig = ConfigPrms.getCacheConfig();
        Cache c = CacheHelper.createCache(cacheConfig);
        if (WANTestPrms.isNewWanConfig()) {
            String senderConfig = ConfigPrms.getGatewaySenderConfig();
            GatewaySenderHelper.createGatewaySenders(senderConfig);
        }
        HydraVector regionDescriptions = TestConfig.tab().vecAt(RegionPrms.names, null);
        for (int j = 0; j < regionDescriptions.size(); ++j) {
            String regionDescriptName = (String)regionDescriptions.get(j);
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            if (regionNames.contains(regionName) || regionDescriptName.contains("client")) continue;
            RegionHelper.createRegion(regionName, regionDescriptName);
            Log.getLogWriter().info("Created region " + regionName + " with region descript name " + regionDescriptName);
            regionNames.add(regionName);
        }
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        BridgeHelper.startBridgeServer(bridgeConfig);
    }

    public static synchronized void initEdgeClientTask() {
        String cacheConfig = WANTestPrms.getClientCacheConfig();
        Cache cache = CacheHelper.createCache(cacheConfig);
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            Log.getLogWriter().info(" VM Durable Client Id is " + VmDurableId);
            if (!DurableClientsBB.getBB().getSharedMap().containsKey(VmDurableId)) {
                HashMap map = new HashMap();
                DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
            }
            cache.readyForEvents();
        }
        HydraVector regionDescriptions = TestConfig.tab().vecAt(RegionPrms.names, null);
        for (int j = 0; j < regionDescriptions.size(); ++j) {
            String regionDescriptName = (String)regionDescriptions.get(j);
            if (!regionDescriptName.startsWith("client")) continue;
            String regionName = RegionHelper.getRegionDescription(regionDescriptName).getRegionName();
            Region region = RegionHelper.createRegion(regionName, regionDescriptName);
            Log.getLogWriter().info("Created edge client region " + regionName + " with region descript name " + regionDescriptName);
            if (!regionNames.contains(regionName)) {
                regionNames.add(regionName);
            }
            PoolImpl mybw = ClientHelper.getPool(region);
            ServerLocation primaryEndpoint = mybw.getPrimary();
            Log.getLogWriter().info("The primary server endpoint is " + primaryEndpoint);
            WanMultiVersion.registerInterest(region);
        }
    }

    public static synchronized void initGatewaySenderTask() {
        String senderConfig = ConfigPrms.getGatewaySenderConfig();
        GatewaySenderHelper.startGatewaySenders(senderConfig);
    }

    public static synchronized void initGatewayReceiverTask() {
        String receiverConfig = ConfigPrms.getGatewayReceiverConfig();
        GatewayReceiverHelper.createAndStartGatewayReceivers(receiverConfig);
    }

    public static synchronized void createGatewayHubTask() {
        String gatewayHubConfig = ConfigPrms.getGatewayHubConfig();
        GatewayHubHelper.createGatewayHub(gatewayHubConfig);
    }

    public static synchronized void startGatewayHubTask() {
        String gatewayConfig = ConfigPrms.getGatewayConfig();
        GatewayHubHelper.addGateways(gatewayConfig);
        GatewayHubHelper.startGatewayHub();
    }

    public static void registerInterest(Region region) {
        InterestResultPolicy interestPolicy = CacheClientPrms.getInterestPolicy();
        LocalRegion localRegion = (LocalRegion)region;
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            Log.getLogWriter().info("Doing durable register interest");
            localRegion.registerInterest((Object)"ALL_KEYS", interestPolicy, true);
        } else {
            localRegion.registerInterest((Object)"ALL_KEYS", interestPolicy);
        }
        Log.getLogWriter().info("Initialized region " + region + "\nRegistered interest in ALL_KEYS with InterestResultPolicy = " + interestPolicy);
    }

    public static void putSequentialKeysTask() throws Exception {
        for (String name : regionNames) {
            Region region = RegionHelper.getRegion(name);
            WANBlackboard.getInstance();
            Long keyCounter = WANBlackboard.increamentAndReadKeyCounter(region.getName(), 1);
            String key = NameFactory.getObjectNameForCounter(keyCounter);
            logger.info("Working on key :" + key + " for region " + region.getFullPath());
            for (long i = 1L; i <= (long)ITERATIONS; ++i) {
                ValueHolder val = new ValueHolder(NameFactory.getObjectNameForCounter(i), rd);
                region.put((Object)key, (Object)val);
            }
        }
    }

    public static void waitForListenerSilence() {
        Log.getLogWriter().info("Silence Listeenr waiting for 30 seconds ...");
        SilenceListener.waitForSilence(30L, 5000L);
    }

    public static void waitForQueuesToDrainTask() {
        SharedMap bb = WANBlackboard.getInstance().getSharedMap();
        long startTime = System.currentTimeMillis();
        long maxWait = WANTestPrms.getSecToWaitForQueue();
        long entriesLeft = 0L;
        while (System.currentTimeMillis() - startTime < maxWait * 1000L) {
            boolean pass = true;
            entriesLeft = 0L;
            for (GatewaySender gs : GatewaySenderHelper.getGatewaySenders()) {
                if (gs instanceof SerialGatewaySenderImpl) {
                    int queuesize = 0;
                    Set rqs = ((SerialGatewaySenderImpl)gs).getQueues();
                    for (RegionQueue rq : rqs) {
                        queuesize += rq.size();
                    }
                    entriesLeft += (long)queuesize;
                    if (queuesize <= 0) continue;
                    logger.warning("Still waiting for queue to drain. SerialGatewaySender " + gs + " has " + queuesize + " entries in it.");
                    pass = false;
                    continue;
                }
                if (gs instanceof ParallelGatewaySenderImpl) {
                    RegionQueue rq = ((ParallelGatewaySenderImpl)gs).getQueues().toArray(new RegionQueue[1])[0];
                    int queuesize = rq.size();
                    entriesLeft += (long)queuesize;
                    if (queuesize <= 0) continue;
                    logger.warning("Still waiting for queue to drain. ParallelGatewaySender " + gs + " has " + queuesize + " entries in it.");
                    pass = false;
                    continue;
                }
                throw new TestException("Unknown class of gateway sender: " + GatewaySenderHelper.gatewaySenderToString(gs));
            }
            if (pass) {
                entriesLeft = 0L;
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (entriesLeft > 0L) {
            throw new TestException("Timed out waiting for queue to drain. Waited for " + maxWait + " sec, Entries left in queues are " + entriesLeft);
        }
        logger.info("SENDER QUEUES ARE DRAINED");
    }

    public static void validateSequentialKeysTask() {
        Log.getLogWriter().info("validateSequentialKeysInRegion: Validation started");
        SilenceListener.waitForSilence(30L, 5000L);
        for (String name : regionNames) {
            Region region = RegionHelper.getRegion(name);
            WanMultiVersion.validateRegion(region);
        }
        Log.getLogWriter().info("validateSequentialKeysInRegion: Validation complete");
    }

    public static void validateRegion(Region aRegion) {
        WANBlackboard bb;
        Log.getLogWriter().info("Validating region: " + aRegion.getFullPath());
        if (aRegion == null) {
            throw new TestException("Region is null ");
        }
        StringBuffer aStr = new StringBuffer();
        if (RemoteTestModule.getMyClientName().contains("edge")) {
            Set serverKeys = aRegion.keySetOnServer();
            int expectedRegionSize = serverKeys.size();
            Set localKeys = aRegion.keySet();
            Set myEntries = aRegion.entrySet();
            Object[] entries = myEntries.toArray();
            int localKeySize = entries.length;
            RegionEntryComparator myComparator = new RegionEntryComparator();
            Arrays.sort(entries, myComparator);
            if (entries.length == 0 && expectedRegionSize == 0) {
                return;
            }
            Log.getLogWriter().info("Expecting " + expectedRegionSize + " entries from server in Region " + aRegion.getFullPath() + ", found " + localKeySize + " entries locally\n");
            if (localKeySize != expectedRegionSize) {
                aStr.append("Expected " + expectedRegionSize + " keys from  server in Region " + aRegion.getFullPath() + " but found " + localKeySize + " entries locally\n");
            }
            Log.getLogWriter().info("Checking for missing or extra keys in client region");
            ArrayList unexpectedKeys = new ArrayList(localKeys);
            unexpectedKeys.removeAll(serverKeys);
            if (unexpectedKeys.size() > 0) {
                aStr.append("Extra keys (not found on server): " + unexpectedKeys + "\n");
            }
            ArrayList missingKeys = new ArrayList(serverKeys);
            missingKeys.removeAll(localKeys);
            if (missingKeys.size() > 0) {
                aStr.append("Missing keys (found on server, but not locally) = " + missingKeys + "\n");
            }
        }
        int requiredSizeFromBB = (bb = WANBlackboard.getInstance()).getSharedMap().get(aRegion.getName()) != null ? ((Long)bb.getSharedMap().get(aRegion.getName())).intValue() : 0;
        int keySize = aRegion.size();
        String str = "SUPPOSED TO HAVE:" + requiredSizeFromBB + " FROM BB, DOES HAVE:" + keySize;
        Log.getLogWriter().info(str);
        if (requiredSizeFromBB != keySize) {
            aStr.append(str);
        }
        Log.getLogWriter().info("Entering the validation loop ");
        for (long i = 1L; i < (long)requiredSizeFromBB; ++i) {
            String s;
            String key = NameFactory.getObjectNameForCounter(i);
            Object val = aRegion.get((Object)key);
            logger.info("Region " + aRegion.getName() + " has entry: " + key + " => " + val);
            if (val == null) {
                s = "No value in cache at " + key;
                throw new TestException(s);
            }
            if (val instanceof Integer) {
                int ival = (Integer)val;
                if (ival == ITERATIONS) continue;
                String s2 = "Wrong value in cache at " + key + ", expected " + ITERATIONS + " but got " + ival;
                throw new TestException(s2);
            }
            if (val instanceof byte[]) {
                if (((byte[])val).length == ITERATIONS) continue;
                s = "Wrong value in cache at " + key + ", expected byte[] of length " + ITERATIONS + " but got length " + ((byte[])val).length;
                throw new TestException(s);
            }
            if (val instanceof PSTObject) {
                if (((PSTObject)val).getIndex() == ITERATIONS) continue;
                s = "Wrong value in cache at " + key + ", expected PSTObject with index " + ITERATIONS + " but got index " + ((PSTObject)val).getIndex();
                throw new TestException(s);
            }
            if (val instanceof ValueHolder) {
                if (((ValueHolder)val).getMyValue().equals(new Long(ITERATIONS))) continue;
                s = "Wrong value in cache at " + key + ", expected ValueHolder with myValue " + ITERATIONS + " but got " + ((ValueHolder)val).getMyValue();
                throw new TestException(s);
            }
            if (val instanceof QueryObject) {
                if (((QueryObject)val).aPrimitiveLong == (long)ITERATIONS) continue;
                s = "Wrong value in cache at " + key + ", expected QueryObject with aPrimitiveLong=" + ITERATIONS + " but got " + ((QueryObject)val).aPrimitiveLong;
                throw new TestException(s);
            }
            s = "Wrong value object type in cache at " + key + ", got " + val + " of type " + val.getClass().getName();
            throw new TestException(s);
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
        Log.getLogWriter().info("Validated region: " + aRegion.getFullPath());
    }

    public static void printRegionDataTask() throws Exception {
        logger.info("Inside printRegionDataTask.");
        for (String regionName : regionNames) {
            Region region = RegionHelper.getRegion(regionName);
            if (region == null) {
                throw new TestException("Region in printRegionDataTask is null");
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append("printRegionDataTask: region data for " + region.getFullPath() + " => \n");
            TreeSet keyset = new TreeSet(region.keySet());
            for (Object key : keyset) {
                buffer.append(key).append(":").append(region.get(key)).append("\n");
            }
            logger.info(buffer.toString());
        }
        logger.info("Done printRegionDataTask.");
    }

    public static SortedSet<String> getDistributedSystemsForV70() {
        String localds = DistributedSystemHelper.getDistributedSystemName();
        TreeSet<String> hubds = new TreeSet<String>();
        if (localds.equals("ds_1")) {
            hubds.add("ds_2");
        } else if (localds.equals("ds_2")) {
            hubds.add("ds_1");
        }
        if (localds.equals("bridgeds_1")) {
            hubds.add("bridgeds_2");
        } else if (localds.equals("bridgeds_2")) {
            hubds.add("bridgeds_1");
        }
        return hubds;
    }
}

