/*
 * Decompiled with CFR 0.152.
 */
package newWan.orderPolicy;

import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.AbstractGatewaySender;
import hydra.ConfigPrms;
import hydra.GatewayReceiverHelper;
import hydra.GatewaySenderHelper;
import hydra.Log;
import java.util.HashMap;
import java.util.Set;
import newWan.WANTestPrms;
import orderPolicy.OrderPolicyTest;
import util.TestException;
import util.TestHelper;
import wan.WANBlackboard;

public class NewWanOrderPolicyTest
extends OrderPolicyTest {
    public static synchronized void createGatewaySenderIdsTask() {
        String senderConfig = ConfigPrms.getGatewaySenderConfig();
        GatewaySenderHelper.createGatewaySenderIds(senderConfig);
    }

    public static synchronized void HydraTask_initWANComponentsTask() {
        String senderConfig = ConfigPrms.getGatewaySenderConfig();
        GatewaySenderHelper.startGatewaySenders(senderConfig);
        String receiverConfig = ConfigPrms.getGatewayReceiverConfig();
        GatewayReceiverHelper.createAndStartGatewayReceivers(receiverConfig);
    }

    public static void checkForEventErrors() {
        TestHelper.checkForEventError(WANBlackboard.getInstance());
    }

    public static void waitForQueuesToDrain() {
        long startTime = System.currentTimeMillis();
        long maxWait = WANTestPrms.getSecToWaitForQueue();
        long entriesLeft = 0L;
        HashMap<String, Integer> queueEntryMap = new HashMap<String, Integer>();
        while (System.currentTimeMillis() - startTime < maxWait * 1000L) {
            boolean pass = true;
            entriesLeft = 0L;
            Set<GatewaySender> gwSender = GatewaySenderHelper.getGatewaySenders();
            for (GatewaySender gs : gwSender) {
                int queuesize = 0;
                Set qrs = ((AbstractGatewaySender)gs).getQueues();
                for (RegionQueue rq : qrs) {
                    queuesize += rq.size();
                }
                entriesLeft += (long)queuesize;
                queueEntryMap.put(gs.getId(), new Integer(queuesize));
                if (queuesize <= 0) continue;
                Log.getLogWriter().warning("Still waiting for queue to drain. SerialGatewaySender " + gs + " has " + queuesize + " entries in it.");
                pass = false;
            }
            if (pass) {
                entriesLeft = 0L;
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (entriesLeft > 0L) {
            throw new TestException("Timed out waiting for queue to drain. Waited for " + maxWait + " sec, total entries left in all queues are " + entriesLeft + ". queueEntryMap=" + queueEntryMap);
        }
        Log.getLogWriter().info("SENDER QUEUES ARE DRAINED");
    }
}

