/*
 * Decompiled with CFR 0.152.
 */
package newWan.security;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.EntryDestroyedException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.client.internal.PoolImpl;
import com.gemstone.gemfire.cache.wan.GatewaySender;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import com.gemstone.gemfire.internal.cache.RegionQueue;
import com.gemstone.gemfire.internal.cache.wan.parallel.ParallelGatewaySenderImpl;
import com.gemstone.gemfire.internal.cache.wan.serial.SerialGatewaySenderImpl;
import com.gemstone.gemfire.security.AuthenticationFailedException;
import hydra.BridgeHelper;
import hydra.ConfigPrms;
import hydra.GatewaySenderHelper;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.TestConfig;
import hydratest.security.SecurityTestPrms;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import newWan.WANBlackboard;
import newWan.WANTest;
import newWan.WANTestPrms;
import security.SecurityClientsPrms;
import util.TestException;
import wan.CacheClientPrms;

public class WanSecurity
extends WANTest {
    public static String VALID_PRIFIX = "Valid";
    public static String INVALID_PRIFIX = "Invalid";
    public static boolean isInvalid = false;
    private static WanSecurity instance;
    static ArrayList keyList;

    public static synchronized void initializeDatastore() {
        if (instance == null) {
            instance = new WanSecurity();
            WANTest.initializeDatastore();
        }
    }

    public static synchronized void HydraTask_initSecurityPeerCache() {
        if (instance == null) {
            WanSecurity.initializeDatastore();
        }
        instance.initSecurityPeerCache();
    }

    public void initSecurityPeerCache() {
        boolean expectedFail = SecurityClientsPrms.isExpectedException();
        try {
            this.initPeerCache();
            this.initDatastoreRegion();
            if (expectedFail) {
                throw new TestException("Expected this to throw AuthFailException");
            }
        }
        catch (AuthenticationFailedException e) {
            if (expectedFail) {
                Log.getLogWriter().info("Got expected AuthenticationFailedException: " + e.getMessage());
            }
            throw new TestException("AuthenticationFailedException while openCacheTask :" + e.getMessage());
        }
        catch (Exception e) {
            throw new TestException("Exception while openCacheTask :" + e.getMessage());
        }
    }

    public static void initSecurityServerCacheTask() {
        if (instance == null) {
            WanSecurity.initializeDatastore();
        }
        instance.initSecurityServerCache();
    }

    public void initSecurityServerCache() {
        boolean expectedFail = SecurityClientsPrms.isExpectedException();
        try {
            this.initPeerCache();
            this.initDatastoreRegion();
            String bridgeConfig = ConfigPrms.getBridgeConfig();
            BridgeHelper.startBridgeServer(bridgeConfig);
            if (expectedFail) {
                throw new TestException("Expected this to throw AuthFailException");
            }
        }
        catch (AuthenticationFailedException e) {
            if (expectedFail) {
                Log.getLogWriter().info("Got expected AuthenticationFailedException: " + e.getMessage());
            }
            throw new TestException("AuthenticationFailedException while openCacheTask :" + e.getMessage());
        }
        catch (Exception e) {
            throw new TestException("Exception while openCacheTask :" + e.getMessage());
        }
    }

    public static synchronized void HydraTask_initWANComponents() {
        if (instance == null) {
            WanSecurity.initializeDatastore();
        }
        instance.initWanComponents();
    }

    public void initWanComponents() {
        boolean expectedFail = SecurityClientsPrms.isExpectedException();
        isInvalid = SecurityTestPrms.useBogusPassword();
        try {
            this.initGatewaySender();
            this.startGatewaySender();
            if (expectedFail) {
                throw new TestException("Expected this to throw AuthenticationFailedException");
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof AuthenticationFailedException || e.getCause().getCause() instanceof AuthenticationFailedException) {
                if (expectedFail) {
                    Log.getLogWriter().info("Got expected AuthenticationFailedException: " + e.getMessage());
                }
                throw new TestException("AuthenticationFailedException while openCacheTask :" + e.getMessage());
            }
            throw new TestException("Exception while openCacheTask :" + e.getMessage());
        }
        this.initGatewayReceiver();
    }

    public static void putSequentialKeysTaskForValid() throws Exception {
        HashSet<String> regionVisited = new HashSet<String>();
        for (String regionName : regionNames) {
            if (regionVisited.contains(regionName)) continue;
            regionVisited.add(regionName);
            Region region = RegionHelper.getRegion(regionName);
            Log.getLogWriter().info("putSequentialKeysTaskForValid : working on region " + regionName);
            String key = VALID_PRIFIX + WANBlackboard.getInstance().getSharedCounters().incrementAndRead(WANBlackboard.currentEntry_valid);
            Log.getLogWriter().info("The vm will be operating on the key : " + key);
            for (int i = 1; i <= ITERATIONS; ++i) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    region.put((Object)key, (Object)new Integer(i));
                    continue;
                }
                Object v = region.replace((Object)key, (Object)new Integer(i));
                if (v != null) continue;
                region.put((Object)key, (Object)new Integer(i));
            }
        }
    }

    public static void putSequentialKeysTaskForInValid() throws Exception {
        HashSet<String> regionVisited = new HashSet<String>();
        for (String regionName : regionNames) {
            if (regionVisited.contains(regionName)) continue;
            regionVisited.add(regionName);
            Region region = RegionHelper.getRegion(regionName);
            Log.getLogWriter().info("putSequentialKeysTaskForInValid : working on region " + regionName);
            String key = INVALID_PRIFIX + WANBlackboard.getInstance().getSharedCounters().incrementAndRead(WANBlackboard.currentEntry_invalid);
            Log.getLogWriter().info("The vm will be operating on the key : " + key);
            for (int i = 1; i <= ITERATIONS; ++i) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    region.put((Object)key, (Object)new Integer(i));
                    continue;
                }
                Object v = region.replace((Object)key, (Object)new Integer(i));
                if (v != null) continue;
                region.put((Object)key, (Object)new Integer(i));
            }
        }
    }

    public static void clientPutSequentialKeysTask() throws Exception {
        Region region = RegionHelper.getRegion((String)regionNames.get(0));
        PoolImpl mybw = ClientHelper.getPool(region);
        ServerLocation primary = mybw.getPrimary();
        if (primary == null) {
            throw new InternalGemFireException("Primary is null" + primary);
        }
        BridgeHelper.Endpoint primaryEndpoint = WanSecurity.getEndpoint(primary);
        if (primaryEndpoint == null) {
            throw new InternalGemFireException("Unable to find endpoint for primary " + primary);
        }
        Log.getLogWriter().info("Primary name is " + primaryEndpoint.getName());
        if (primaryEndpoint.getName().startsWith("validbridge_")) {
            WanSecurity.putSequentialKeysTaskForValid();
        } else if (primaryEndpoint.getName().startsWith("invalidbridge_")) {
            WanSecurity.putSequentialKeysTaskForInValid();
        }
    }

    public static void waitForQueuesToDrainTask() {
        instance.waitForQueuesToDrain();
    }

    @Override
    public void waitForQueuesToDrain() {
        long startTime = System.currentTimeMillis();
        long maxWait = WANTestPrms.getSecToWaitForQueue();
        long entriesLeft = 0L;
        HashMap<String, Integer> queueEntryMap = new HashMap<String, Integer>();
        while (System.currentTimeMillis() - startTime < maxWait * 1000L) {
            boolean pass = true;
            entriesLeft = 0L;
            for (GatewaySender gs : gatewaySenders) {
                if (gs.getId().matches("(.*)_to_invalid_(.*)")) {
                    if (!(gs instanceof SerialGatewaySenderImpl)) continue;
                    if (((SerialGatewaySenderImpl)gs).getQueues() != null) {
                        int queuesize = 0;
                        Set rqs = ((SerialGatewaySenderImpl)gs).getQueues();
                        for (RegionQueue rq : rqs) {
                            queuesize += rq.size();
                        }
                        if (!queueEntryMap.containsKey(gs.getId())) {
                            queueEntryMap.put(gs.getId(), new Integer(queuesize));
                            continue;
                        }
                        int queueSizeInBB = (Integer)queueEntryMap.get(gs.getId());
                        if (queuesize >= queueSizeInBB) continue;
                        logger.warning("Invalid queue not expected to drain, expected queue size in " + gs.getId() + " to be " + queueSizeInBB + " but it has " + queuesize + " entries.");
                        continue;
                    }
                    if (gs instanceof ParallelGatewaySenderImpl) {
                        if (((ParallelGatewaySenderImpl)gs).getQueues() == null) continue;
                        RegionQueue rq = ((ParallelGatewaySenderImpl)gs).getQueues().toArray(new RegionQueue[1])[0];
                        int queuesize = rq.size();
                        if (!queueEntryMap.containsKey(gs.getId())) {
                            queueEntryMap.put(gs.getId(), new Integer(queuesize));
                            continue;
                        }
                        int queueSizeInBB = (Integer)queueEntryMap.get(gs.getId());
                        if (queuesize >= queueSizeInBB) continue;
                        logger.warning("Invalid queue not expected to drain, expected queue size in " + gs.getId() + " to be " + queueSizeInBB + " but it has " + queuesize + " entries.");
                        continue;
                    }
                    throw new TestException("Unknown class of gateway sender: " + GatewaySenderHelper.gatewaySenderToString(gs));
                }
                if (gs instanceof SerialGatewaySenderImpl) {
                    if (((SerialGatewaySenderImpl)gs).getQueues() == null) continue;
                    int queuesize = 0;
                    Set rqs = ((SerialGatewaySenderImpl)gs).getQueues();
                    for (RegionQueue rq : rqs) {
                        queuesize += rq.size();
                    }
                    entriesLeft += (long)queuesize;
                    queueEntryMap.put(gs.getId(), new Integer(queuesize));
                    if (queuesize <= 0) continue;
                    logger.warning("Still waiting for queue to drain. SerialGatewaySender " + gs + " has " + queuesize + " entries in it.");
                    pass = false;
                    continue;
                }
                if (gs instanceof ParallelGatewaySenderImpl) {
                    if (((ParallelGatewaySenderImpl)gs).getQueues() == null) continue;
                    RegionQueue rq = ((ParallelGatewaySenderImpl)gs).getQueues().toArray(new RegionQueue[1])[0];
                    int queuesize = rq.size();
                    entriesLeft += (long)queuesize;
                    queueEntryMap.put(gs.getId(), new Integer(queuesize));
                    if (queuesize <= 0) continue;
                    logger.warning("Still waiting for queue to drain. ParallelGatewaySender " + gs + " has " + queuesize + " entries in it.");
                    pass = false;
                    continue;
                }
                throw new TestException("Unknown class of gateway sender: " + GatewaySenderHelper.gatewaySenderToString(gs));
            }
            if (pass) {
                entriesLeft = 0L;
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.printQueueContents();
        }
        if (entriesLeft > 0L) {
            throw new TestException("Timed out waiting for queue to drain. Waited for " + maxWait + " sec, total entries left in all queues are " + entriesLeft + ". queueEntryMap=" + queueEntryMap);
        }
        logger.info("SENDER QUEUES ARE DRAINED");
    }

    public static void validateValidSequentialKeysTask() throws Exception {
        Log.getLogWriter().info("Validating regions for valid sequential keys");
        for (String regionName : regionNames) {
            Region region = RegionHelper.getRegion(regionName);
            Set keys = region.keySet();
            WanSecurity.checkKeys(regionName, VALID_PRIFIX);
            long requiredSize = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.currentEntry_valid);
            Log.getLogWriter().info("In Region " + region.getFullPath() + " SUPPOSED TO HAVE:" + requiredSize + " DOES HAVE:" + keys.size());
            if (requiredSize != (long)keys.size()) {
                throw new TestException("In Region " + region.getFullPath() + " SUPPOSED TO HAVE:" + requiredSize + " DOES HAVE:" + keys.size());
            }
            Iterator kI = keys.iterator();
            int i = 1;
            while ((long)i < requiredSize) {
                int ival;
                String key = VALID_PRIFIX + i;
                Object val = region.get((Object)key);
                if (val == null) {
                    String s = "No value in region " + region + " at " + key;
                    throw new TestException(s);
                }
                if (val instanceof Integer && (ival = ((Integer)val).intValue()) != ITERATIONS) {
                    String s = "Wrong value in region " + region.getFullPath() + " at " + key + ", expected " + ITERATIONS + " but got " + ival;
                    throw new TestException(s);
                }
                ++i;
            }
        }
    }

    public static void validateInvalidSequentialKeysTask() throws Exception {
        Log.getLogWriter().info("Validating regions for invalid sequential keys");
        for (String regionName : regionNames) {
            Region region = RegionHelper.getRegion(regionName);
            Set keys = region.keySet();
            WanSecurity.checkKeys(regionName, INVALID_PRIFIX);
            long requiredSize = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.currentEntry_invalid);
            Log.getLogWriter().info("In Region " + region.getFullPath() + " Entries count is:" + keys.size());
        }
    }

    public static void clientValidateSequentialKeysTask() throws Exception {
        Region region = RegionHelper.getRegion((String)regionNames.get(0));
        PoolImpl mybw = ClientHelper.getPool(region);
        ServerLocation primary = mybw.getPrimary();
        if (primary == null) {
            throw new InternalGemFireException("Primary is null" + primary);
        }
        BridgeHelper.Endpoint primaryEndpoint = WanSecurity.getEndpoint(primary);
        if (primaryEndpoint == null) {
            throw new InternalGemFireException("Unable to find endpoint for primary " + primary);
        }
        Log.getLogWriter().info("Primary name is " + primaryEndpoint.getName());
        if (primaryEndpoint.getName().startsWith("validbridge_")) {
            WanSecurity.validateValidSequentialKeysTask();
        } else if (primaryEndpoint.getName().startsWith("invalidbridge_")) {
            WanSecurity.validateInvalidSequentialKeysTask();
        }
    }

    public static void checkKeys(String regionName, String validKeyPrefix) {
        Region region = RegionHelper.getRegion(regionName);
        Set keys = region.keySet();
        for (String key : keys) {
            if (!key.startsWith(validKeyPrefix)) {
                throw new TestException("Invalid key found in the cache " + key);
            }
            Log.getLogWriter().info("Found valid key " + key);
        }
    }

    private static BridgeHelper.Endpoint getEndpoint(ServerLocation location) {
        List<BridgeHelper.Endpoint> endpoints = BridgeHelper.getEndpoints();
        InetSocketAddress ia = null;
        for (BridgeHelper.Endpoint next : endpoints) {
            if (next.getPort() != location.getPort()) continue;
            if (next.getHost().equals(location.getHostName())) {
                return next;
            }
            try {
                ia = new InetSocketAddress(location.getHostName(), location.getPort());
                if (!ia.getAddress().getHostAddress().equals(next.getAddress())) continue;
                return next;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static void putSequentialKeysTaskForReader() throws Exception {
        Region region = RegionHelper.getRegion((String)regionNames.get(0));
        String key = "reader_" + WANBlackboard.getInstance().getSharedCounters().incrementAndRead(WANBlackboard.currentEntry_reader);
        Log.getLogWriter().info("The vm will be operating on the key : " + key);
        keyList.add(key);
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        for (int i = 1; i <= ITERATIONS; ++i) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                region.put((Object)key, (Object)new Integer(i));
                continue;
            }
            Object v = region.replace((Object)key, (Object)new Integer(i));
            if (v != null) continue;
            region.put((Object)key, (Object)new Integer(i));
        }
    }

    public static void putSequentialKeysTaskForWriter() throws Exception {
        Region region = RegionHelper.getRegion((String)regionNames.get(0));
        String key = "writer_" + WANBlackboard.getInstance().getSharedCounters().incrementAndRead(WANBlackboard.currentEntry_writer);
        Log.getLogWriter().info("The vm will be operating on the key : " + key);
        keyList.add(key);
        int sleepMs = CacheClientPrms.getSleepSec() * 1000;
        for (int i = 1; i <= ITERATIONS; ++i) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                region.put((Object)key, (Object)new Integer(i));
                continue;
            }
            Object v = region.replace((Object)key, (Object)new Integer(i));
            if (v != null) continue;
            region.put((Object)key, (Object)new Integer(i));
        }
    }

    public static void printKeyListTask() {
        Iterator Itr2 = keyList.iterator();
        while (Itr2.hasNext()) {
            Log.getLogWriter().info((String)Itr2.next());
        }
    }

    public static void validateWriterWanSiteEntriesTask() {
        Log.getLogWriter().info("Sleeping for some time ..");
        MasterController.sleepForMs(100000);
        Region region = RegionHelper.getRegion((String)regionNames.get(0));
        if (region.isEmpty()) {
            throw new TestException(" Region has no entries to validate ");
        }
        WanSecurity.checkKeys(region.getName(), "writer_");
        long requiredSize = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.currentEntry_writer);
        WanSecurity.checkKeyRegionEntries(region.getName(), "writer_", requiredSize);
    }

    public static void validateReaderWanSiteEntriesTask() {
        Log.getLogWriter().info("Sleeping for some time ..");
        MasterController.sleepForMs(100000);
        Region region = RegionHelper.getRegion((String)regionNames.get(0));
        if (region.isEmpty()) {
            throw new TestException(" Region has no entries to validate ");
        }
        long requiredSize = WANBlackboard.getInstance().getSharedCounters().read(WANBlackboard.currentEntry_writer);
        WanSecurity.checkKeyRegionEntries(region.getName(), "writer_", requiredSize);
        Iterator iterator = region.entrySet(false).iterator();
        Region.Entry entry = null;
        Object key = null;
        Object value = null;
        while (iterator.hasNext()) {
            entry = (Region.Entry)iterator.next();
            key = entry.getKey();
            value = entry.getValue();
            if (!((String)key).startsWith("reader_")) continue;
            if (!keyList.contains(key)) {
                throw new TestException("Found reader key that is not present in the keyList");
            }
            if ((Integer)value == ITERATIONS) continue;
            String s = "Wrong value in region " + region.getFullPath() + " at " + key + ", expected " + ITERATIONS + " but got " + (Integer)value;
            throw new TestException(s);
        }
    }

    protected static void checkKeyRegionEntries(String regionName, String keyPrefix, long expectedsize) {
        Region region = RegionHelper.getRegion(regionName);
        Log.getLogWriter().info("Key prefix is " + keyPrefix + " Expected size is " + expectedsize);
        int i = 1;
        while ((long)i <= expectedsize) {
            String key = keyPrefix + i;
            Object val = region.get((Object)key);
            if (val == null) {
                String s = "No value in cache at " + key;
                throw new TestException(s);
            }
            if ((Integer)val != ITERATIONS) {
                Log.getLogWriter().info("Key is :" + key + " Value found in region is " + (Integer)val);
                String s = "Wrong value in cache at " + key + ", expected " + ITERATIONS + " but got " + (Integer)val;
                throw new TestException(s);
            }
            Log.getLogWriter().info("Key is :" + key + " Value found in region is " + (Integer)val);
            ++i;
        }
    }

    public static void readerDestroyAllKeysTask() {
        Region region = RegionHelper.getRegion((String)regionNames.get(0));
        Iterator iterator = region.entrySet(false).iterator();
        Region.Entry entry = null;
        Object key = null;
        while (iterator.hasNext()) {
            entry = (Region.Entry)iterator.next();
            key = entry.getKey();
            try {
                region.destroy(key);
            }
            catch (EntryNotFoundException e) {
                Log.getLogWriter().info("Entry Not found for key " + key + ". Expected in this test.");
            }
        }
        if (!region.isEmpty()) {
            throw new TestException("Region is supposed to be empty but that is not the case");
        }
        Log.getLogWriter().info("Completed the destroy operation for all the keys in the region");
    }

    public static void writerDestroyCreatedKeysTask() {
        Region region = RegionHelper.getRegion((String)regionNames.get(0));
        Iterator iterator = keyList.iterator();
        String key = null;
        while (iterator.hasNext()) {
            try {
                key = (String)iterator.next();
                Log.getLogWriter().info("Destroying key :" + key + " which is present in the keyList");
                region.destroy((Object)key);
            }
            catch (EntryNotFoundException e) {
                Log.getLogWriter().info("Entry Not found.");
            }
            catch (EntryDestroyedException e) {
                Log.getLogWriter().info("Entry Already destroyed.");
            }
        }
    }

    public static void checkWriterRegionContentsEmpty() {
        Region region = RegionHelper.getRegion((String)regionNames.get(0));
        if (!region.isEmpty()) {
            throw new TestException("Region content supposed to be empty but it is having size of " + region.size());
        }
        Log.getLogWriter().info("Region is empty as expected");
    }

    static {
        keyList = new ArrayList();
    }
}

