/*
 * Decompiled with CFR 0.152.
 */
package newWan.serial.filters;

import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.asyncqueue.AsyncEvent;
import com.gemstone.gemfire.cache.wan.GatewayEventFilter;
import com.gemstone.gemfire.cache.wan.GatewayQueueEvent;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventCallbackArgument;
import com.gemstone.gemfire.internal.cache.wan.GatewaySenderEventImpl;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RemoteTestModule;
import newWan.WANBlackboard;

public class MyEventFilterBeforeEnqueue
implements GatewayEventFilter {
    private String id = new String("MyEventFilterBeforeEnqueue");

    public void afterAcknowledgement(GatewayQueueEvent event) {
    }

    public boolean beforeEnqueue(GatewayQueueEvent event) {
        if (((String)event.getKey()).contains("FilterKey_")) {
            Log.getLogWriter().info("Filtering event beforeEnqueue for key " + event.getKey() + " in region " + event.getRegion().getFullPath());
            return false;
        }
        return true;
    }

    public boolean beforeTransmit(GatewayQueueEvent event) {
        if (((String)event.getKey()).contains("FilterKey_")) {
            WANBlackboard.throwException("Unexpected event for key " + event.getKey() + " in beforeTransmit of filter " + this.getClass().getName() + ". The event should have been already filtered in beforeEnqueue()");
            return false;
        }
        return true;
    }

    public void close() {
    }

    public void logCall(String methodName, AsyncEvent event) {
        StringBuffer aStr = new StringBuffer();
        String clientName = RemoteTestModule.getMyClientName();
        aStr.append("Invoked " + this.getClass().getName() + " for key " + event.getKey() + ": " + methodName + " in " + clientName + " event=" + event + "\n");
        aStr.append("   whereIWasRegistered: " + ProcessMgr.getProcessId() + "\n");
        aStr.append("   key: " + event.getKey() + "\n");
        GatewaySenderEventImpl e = (GatewaySenderEventImpl)event;
        aStr.append("   event.getEventId(): " + e.getEventId() + "\n");
        aStr.append("   event.getValue(): " + e.getValueAsString(true) + "\n");
        Region region = event.getRegion();
        aStr.append("   region: " + event.getRegion().getFullPath() + "\n");
        if (region.getAttributes() instanceof PartitionAttributes) {
            aStr.append("   event.getBucketId(): " + e.getBucketId() + "\n");
            aStr.append("   event.getShadowKey(): " + e.getShadowKey() + "\n");
        }
        aStr.append("   callbackArgument: " + e.getSenderCallbackArgument() + "\n");
        if (e.getSenderCallbackArgument() instanceof GatewaySenderEventCallbackArgument) {
            GatewaySenderEventCallbackArgument callback = e.getSenderCallbackArgument();
            aStr.append("   callback.getOriginatingDSId(): " + callback.getOriginatingDSId() + "\n");
            aStr.append("   callback.getRecipientDSIds(): " + callback.getRecipientDSIds() + "\n");
        }
        Operation op = event.getOperation();
        aStr.append("   operation: " + op.toString() + "\n");
        aStr.append("   Operation.isDistributed(): " + op.isDistributed() + "\n");
        Log.getLogWriter().info(aStr.toString());
    }

    public String toString() {
        return this.id;
    }
}

