/*
 * Decompiled with CFR 0.152.
 */
package objects;

import com.gemstone.gemfire.internal.NanoTimer;
import hydra.BasePrms;
import hydra.RemoteTestModule;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import objects.Asset;
import objects.AssetAccountPrms;
import objects.ConfigurableObject;
import objects.FastAssetAccountPrms;
import objects.ObjectAccessException;
import objects.TimestampedObject;
import objects.UpdatableObject;

public class AssetAccount
implements ConfigurableObject,
TimestampedObject,
UpdatableObject,
Serializable {
    protected static final boolean encodeTimestamp = AssetAccountPrms.encodeTimestamp();
    protected int acctId;
    protected String customerName;
    protected double netWorth = 0.0;
    protected Map assets;
    protected long timestamp;

    public void init(int index) {
        this.acctId = index;
        this.customerName = "Milton Moneybags";
        this.assets = new HashMap();
        int size = AssetAccountPrms.getSize();
        this.netWorth = 0.0;
        for (int i = 0; i < size; ++i) {
            Asset asset = new Asset();
            asset.init(i);
            this.assets.put(new Integer(i), asset);
            this.netWorth += asset.getValue();
        }
        if (encodeTimestamp) {
            this.timestamp = NanoTimer.getTime() - RemoteTestModule.getClockSkew();
        }
    }

    public int getAcctId() {
        return this.acctId;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public double getNetWorth() {
        return this.netWorth;
    }

    public void incrementNetWorth() {
        this.netWorth += 1.0;
    }

    public Map getAssets() {
        return this.assets;
    }

    public int getIndex() {
        return this.acctId;
    }

    public void validate(int index) {
        String s = this.getClass().getName() + " does not support validation";
        throw new UnsupportedOperationException(s);
    }

    @Override
    public long getTimestamp() {
        if (encodeTimestamp) {
            return this.timestamp;
        }
        String s = BasePrms.nameForKey(FastAssetAccountPrms.encodeTimestamp) + " is false, cannot get timestamp";
        throw new ObjectAccessException(s);
    }

    @Override
    public void resetTimestamp() {
        if (!encodeTimestamp) {
            String s = BasePrms.nameForKey(FastAssetAccountPrms.encodeTimestamp) + " is false, cannot reset timestamp";
            throw new ObjectAccessException(s);
        }
        this.timestamp = NanoTimer.getTime() - RemoteTestModule.getClockSkew();
    }

    @Override
    public synchronized void update() {
        this.incrementNetWorth();
        if (encodeTimestamp) {
            this.resetTimestamp();
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof AssetAccount) {
            AssetAccount acct = (AssetAccount)obj;
            if (this.acctId == acct.acctId) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.acctId;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("AssetAccount [acctId=" + this.acctId + " customerName=" + this.customerName + " netWorth=" + this.netWorth + " timestamp=" + this.timestamp);
        for (Object key : this.assets.keySet()) {
            buf.append(" " + key + "=" + this.assets.get(key));
        }
        return buf.toString();
    }
}

