/*
 * Decompiled with CFR 0.152.
 */
package objects;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.util.Sizeof;
import hydra.RemoteTestModule;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import objects.BatchObjectPrms;
import objects.BatchStringPrms;
import objects.ConfigurableObject;
import objects.ObjectValidationException;
import objects.TimestampedObject;

public class BatchObject
implements ConfigurableObject,
TimestampedObject,
ObjectSizer,
DataSerializable {
    private int index;
    private long timestamp;
    private int batch;
    private byte[] byteArray;

    public void init(int anIndex) {
        this.index = anIndex;
        this.timestamp = NanoTimer.getTime() - RemoteTestModule.getClockSkew();
        this.batch = anIndex / BatchStringPrms.getBatchSize();
        this.byteArray = new byte[BatchObjectPrms.getSize()];
    }

    public int getIndex() {
        return this.index;
    }

    public int getBatch() {
        return this.batch;
    }

    public void validate(int anIndex) {
        int encodedIndex = this.getIndex();
        if (encodedIndex != anIndex) {
            String s = "Expected index " + anIndex + ", got " + encodedIndex;
            throw new ObjectValidationException(s);
        }
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void resetTimestamp() {
        this.timestamp = NanoTimer.getTime() - RemoteTestModule.getClockSkew();
    }

    public String toString() {
        if (this.byteArray == null) {
            return "BatchObject@" + this.timestamp;
        }
        return "BatchObject(" + this.getIndex() + ", " + this.getBatch() + ")@" + this.timestamp;
    }

    public boolean equals(Object o) {
        if (o instanceof BatchObject) {
            BatchObject other = (BatchObject)o;
            if (this.index == other.index && this.timestamp == other.timestamp && this.batch == other.batch) {
                return true;
            }
        }
        return false;
    }

    public int sizeof(Object o) {
        if (o instanceof BatchObject) {
            BatchObject obj = (BatchObject)o;
            return Sizeof.sizeof((int)obj.index) + Sizeof.sizeof((long)obj.timestamp) + Sizeof.sizeof((int)obj.batch) + Sizeof.sizeof((byte[])obj.byteArray);
        }
        return Sizeof.sizeof((Object)o);
    }

    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.index);
        out.writeLong(this.timestamp);
        out.writeInt(this.batch);
        DataSerializer.writeByteArray((byte[])this.byteArray, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.index = in.readInt();
        this.timestamp = in.readLong();
        this.batch = in.readInt();
        this.byteArray = DataSerializer.readByteArray((DataInput)in);
    }
}

