/*
 * Decompiled with CFR 0.152.
 */
package objects;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Instantiator;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.util.Sizeof;
import hydra.BasePrms;
import hydra.Log;
import hydra.RemoteTestModule;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import objects.ConfigurableObject;
import objects.FastAsset;
import objects.FastAssetAccountPrms;
import objects.ObjectAccessException;
import objects.TimestampedObject;
import objects.UpdatableObject;

public class FastAssetAccount
implements ConfigurableObject,
TimestampedObject,
UpdatableObject,
ObjectSizer,
DataSerializable {
    protected static boolean fineEnabled;
    protected static final boolean encodeTimestamp;
    protected int acctId;
    protected String customerName;
    protected double netWorth = 0.0;
    protected Map assets;
    protected long timestamp;

    public void init(int index) {
        this.acctId = index;
        this.customerName = "Milton Moneybags";
        this.assets = new HashMap();
        int size = FastAssetAccountPrms.getSize();
        this.netWorth = 0.0;
        for (int i = 0; i < size; ++i) {
            FastAsset asset = new FastAsset();
            asset.init(i);
            this.assets.put(new Integer(i), asset);
            this.netWorth += asset.getValue();
        }
        if (encodeTimestamp) {
            this.timestamp = NanoTimer.getTime() - RemoteTestModule.getClockSkew();
        }
    }

    public int getAcctId() {
        return this.acctId;
    }

    public String getCustomerName() {
        return this.customerName;
    }

    public double getNetWorth() {
        return this.netWorth;
    }

    public void incrementNetWorth() {
        this.netWorth += 1.0;
    }

    public Map getAssets() {
        return this.assets;
    }

    public int getIndex() {
        return this.acctId;
    }

    public void validate(int index) {
        String s = this.getClass().getName() + " does not support validation";
        throw new UnsupportedOperationException(s);
    }

    @Override
    public long getTimestamp() {
        if (encodeTimestamp) {
            return this.timestamp;
        }
        String s = BasePrms.nameForKey(FastAssetAccountPrms.encodeTimestamp) + " is false, cannot get timestamp";
        throw new ObjectAccessException(s);
    }

    @Override
    public void resetTimestamp() {
        if (!encodeTimestamp) {
            String s = BasePrms.nameForKey(FastAssetAccountPrms.encodeTimestamp) + " is false, cannot reset timestamp";
            throw new ObjectAccessException(s);
        }
        this.timestamp = NanoTimer.getTime() - RemoteTestModule.getClockSkew();
    }

    @Override
    public synchronized void update() {
        this.incrementNetWorth();
        if (encodeTimestamp) {
            this.resetTimestamp();
        }
    }

    public int sizeof(Object o) {
        if (o instanceof FastAssetAccount) {
            FastAssetAccount obj = (FastAssetAccount)o;
            int mapSize = 0;
            if (obj.assets != null) {
                for (Object key : obj.assets.keySet()) {
                    FastAsset asset = (FastAsset)obj.assets.get(key);
                    mapSize += Sizeof.sizeof(key) + Sizeof.sizeof((Object)asset) + 16;
                }
            }
            return Sizeof.sizeof((int)obj.acctId) + Sizeof.sizeof((String)obj.customerName) + Sizeof.sizeof((double)obj.netWorth) + mapSize + Sizeof.sizeof((long)obj.timestamp);
        }
        return Sizeof.sizeof((Object)o);
    }

    public void toData(DataOutput out) throws IOException {
        out.writeInt(this.acctId);
        DataSerializer.writeString((String)this.customerName, (DataOutput)out);
        out.writeDouble(this.netWorth);
        DataSerializer.writeHashMap((HashMap)((HashMap)this.assets), (DataOutput)out);
        out.writeLong(this.timestamp);
        if (fineEnabled) {
            Log.getLogWriter().fine("INVOKED: toData on key " + this.acctId);
        }
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.acctId = in.readInt();
        this.customerName = DataSerializer.readString((DataInput)in);
        this.netWorth = in.readDouble();
        this.assets = DataSerializer.readHashMap((DataInput)in);
        this.timestamp = in.readLong();
        if (fineEnabled) {
            Log.getLogWriter().fine("INVOKED: fromData on key " + this.acctId);
        }
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof FastAssetAccount) {
            FastAssetAccount acct = (FastAssetAccount)obj;
            if (this.acctId == acct.acctId) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.acctId;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getClass().getName() + " [acctId=" + this.acctId + " customerName=" + this.customerName + " netWorth=" + this.netWorth + " timestamp=" + this.timestamp);
        for (Object key : this.assets.keySet()) {
            buf.append(" " + key + "=" + this.assets.get(key));
        }
        return buf.toString();
    }

    static {
        Instantiator.register((Instantiator)new Instantiator(FastAssetAccount.class, 23){

            public DataSerializable newInstance() {
                return new FastAssetAccount();
            }
        });
        fineEnabled = Log.getLogWriter().fineEnabled();
        encodeTimestamp = FastAssetAccountPrms.encodeTimestamp();
    }
}

