/*
 * Decompiled with CFR 0.152.
 */
package objects;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.util.Sizeof;
import hydra.BasePrms;
import hydra.Log;
import hydra.RemoteTestModule;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import objects.ConfigurableObject;
import objects.MessagePrms;
import objects.ObjectAccessException;
import objects.ObjectCreationException;
import objects.ObjectValidationException;
import objects.TimestampedObject;

public class Message
implements ConfigurableObject,
TimestampedObject,
ObjectSizer,
DataSerializable {
    private long timestamp;
    private String content;

    public void init(int index) {
        int size = MessagePrms.getSize();
        if (size == 0) {
            this.content = null;
        } else {
            StringBuffer buf = new StringBuffer(size);
            buf.insert(0, (double)index);
            int padding = size - buf.length();
            if (padding < 0) {
                throw new ObjectCreationException("Unable to encode index " + index + " into string of size " + size);
            }
            char[] c = new char[padding];
            for (int i = 0; i < padding; ++i) {
                c[i] = 48;
            }
            buf.append(c);
            this.content = buf.toString();
        }
        this.timestamp = NanoTimer.getTime() - RemoteTestModule.getClockSkew();
    }

    public int getIndex() {
        if (this.content == null) {
            throw new ObjectAccessException("No index is encoded when " + BasePrms.nameForKey(MessagePrms.size) + " is 0");
        }
        int marker = this.content.indexOf(".");
        String index = this.content.substring(0, marker);
        try {
            return new Integer(index);
        }
        catch (NumberFormatException e) {
            throw new ObjectAccessException(this.content + " does not contain an encoded integer index");
        }
    }

    public void validate(int index) {
        if (this.content == null) {
            Log.getLogWriter().info("Cannot validate encoded index of object " + index + ", it has no content");
        } else {
            int encodedIndex = this.getIndex();
            if (encodedIndex != index) {
                throw new ObjectValidationException("Expected index " + index + ", got " + encodedIndex);
            }
        }
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void resetTimestamp() {
        this.timestamp = NanoTimer.getTime() - RemoteTestModule.getClockSkew();
    }

    public String toString() {
        if (this.content == null) {
            return "Message@" + this.timestamp;
        }
        return "Message(" + this.getIndex() + ")@" + this.timestamp;
    }

    public boolean equals(Object o) {
        if (o instanceof Message) {
            Message other = (Message)o;
            if (this.timestamp == other.timestamp) {
                if (this.content != null) {
                    return this.content.equals(other.content);
                }
                return other.content == null;
            }
        }
        return false;
    }

    public int sizeof(Object o) {
        if (o instanceof Message) {
            Message obj = (Message)o;
            return Sizeof.sizeof((long)obj.timestamp) + Sizeof.sizeof((String)obj.content);
        }
        return Sizeof.sizeof((Object)o);
    }

    public void toData(DataOutput out) throws IOException {
        out.writeLong(this.timestamp);
        DataSerializer.writeString((String)this.content, (DataOutput)out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.timestamp = in.readLong();
        this.content = DataSerializer.readString((DataInput)in);
    }
}

