/*
 * Decompiled with CFR 0.152.
 */
package objects;

import com.gemstone.gemfire.internal.cache.lru.Sizeable;
import java.util.Vector;
import objects.ConfigurableObject;
import objects.NestedOrderVectorPrms;
import objects.ObjectHelper;
import objects.ObjectValidationException;
import objects.Order;

public class NestedOrderVector
extends Vector
implements ConfigurableObject,
Sizeable {
    int orderID;
    int bytes = 64;

    public NestedOrderVector() {
    }

    private NestedOrderVector(int index) {
        this.orderID = index;
    }

    public void init(int index) {
        this.orderID = index;
        int width = NestedOrderVectorPrms.getWidth();
        int depth = NestedOrderVectorPrms.getDepth();
        for (int i = 0; i < width; ++i) {
            this.add(NestedOrderVector.getNode(index, width, depth - 1));
        }
    }

    @Override
    public boolean add(Object o) {
        if (o instanceof Sizeable) {
            this.bytes += ((Sizeable)o).getSizeInBytes();
        }
        return super.add(o);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Sizeable) {
            this.bytes -= ((Sizeable)o).getSizeInBytes();
        }
        return super.remove(o);
    }

    private static Object getNode(int index, int width, int depth) {
        if (depth == 0) {
            Order order = new Order();
            order.init(index);
            return order;
        }
        NestedOrderVector orders = new NestedOrderVector(index);
        for (int i = 0; i < width; ++i) {
            orders.add(NestedOrderVector.getNode(index, width, depth - 1));
        }
        return orders;
    }

    public int getSizeInBytes() {
        return this.bytes + this.elementData.length * 4;
    }

    public int getIndex() {
        return this.orderID;
    }

    public void validate(int index) {
        int encodedIndex = this.getIndex();
        if (encodedIndex != index) {
            throw new ObjectValidationException("Expected index " + index + ", got " + encodedIndex);
        }
        for (Object obj : this) {
            if (obj instanceof NestedOrderVector) {
                ObjectHelper.validate(index, obj);
                continue;
            }
            if (obj instanceof Order) {
                ObjectHelper.validate(index, obj);
                continue;
            }
            throw new ObjectValidationException("Unexpected type: " + obj.getClass().getName());
        }
    }
}

