/*
 * Decompiled with CFR 0.152.
 */
package objects;

import com.gemstone.gemfire.internal.cache.lru.Sizeable;
import java.io.Serializable;
import java.util.Date;
import objects.ConfigurableObject;
import objects.ObjectValidationException;

public class Order
implements ConfigurableObject,
Serializable,
Sizeable {
    private int orderID;
    private String broker;
    private int quantity;
    private Date expiration;
    private double price;

    public int getSizeInBytes() {
        return this.broker.length() * 2 + 4 + 4 + 4 + 8 + 4 + 48 + 8 + 8;
    }

    public void init(int index) {
        this.orderID = index;
        this.broker = "John Doe";
        this.quantity = 1;
        this.expiration = new Date();
        this.price = 27.32;
    }

    public int getIndex() {
        return this.orderID;
    }

    public void validate(int index) {
        int encodedIndex = this.getIndex();
        if (encodedIndex != index) {
            throw new ObjectValidationException("Expected index " + index + ", got " + encodedIndex);
        }
    }

    public String getBroker() {
        return this.broker;
    }

    public void setBroker(String broker) {
        this.broker = broker;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public Date getExpiration() {
        return this.expiration;
    }

    public void setExpiration(Date expiration) {
        this.expiration = expiration;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public String toString() {
        return "Order(" + this.orderID + ")=" + this.expiration;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.broker == null ? 0 : this.broker.hashCode());
        result = 31 * result + (this.expiration == null ? 0 : this.expiration.hashCode());
        result = 31 * result + this.orderID;
        long temp = Double.doubleToLongBits(this.price);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.quantity;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Order other = (Order)obj;
        if (this.broker == null ? other.broker != null : !this.broker.equals(other.broker)) {
            return false;
        }
        if (this.expiration == null ? other.expiration != null : !this.expiration.equals(other.expiration)) {
            return false;
        }
        if (this.orderID != other.orderID) {
            return false;
        }
        if (Double.doubleToLongBits(this.price) != Double.doubleToLongBits(other.price)) {
            return false;
        }
        return this.quantity == other.quantity;
    }
}

