/*
 * Decompiled with CFR 0.152.
 */
package objects;

import com.gemstone.gemfire.internal.cache.lru.Sizeable;
import java.util.Vector;
import objects.ConfigurableObject;
import objects.ObjectHelper;
import objects.ObjectValidationException;
import objects.Order;
import objects.OrderVectorPrms;

public class OrderVector
extends Vector
implements ConfigurableObject,
Sizeable {
    int orderID;
    int bytes = 64;

    public void init(int index) {
        this.orderID = index;
        int size = OrderVectorPrms.getSize();
        for (int i = 0; i < size; ++i) {
            Order order = new Order();
            order.init(index);
            this.add(order);
        }
    }

    @Override
    public boolean add(Object o) {
        if (o instanceof Sizeable) {
            this.bytes += ((Sizeable)o).getSizeInBytes();
        }
        return super.add(o);
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof Sizeable) {
            this.bytes -= ((Sizeable)o).getSizeInBytes();
        }
        return super.remove(o);
    }

    public int getSizeInBytes() {
        return this.bytes + this.elementData.length * 4;
    }

    public int getIndex() {
        return this.orderID;
    }

    public void validate(int index) {
        int encodedIndex = this.getIndex();
        if (encodedIndex != index) {
            throw new ObjectValidationException("Expected index " + index + ", got " + encodedIndex);
        }
        for (Object obj : this) {
            if (obj instanceof Order) {
                ObjectHelper.validate(index, obj);
                continue;
            }
            throw new ObjectValidationException("Unexpected type: " + obj.getClass().getName());
        }
    }
}

