/*
 * Decompiled with CFR 0.152.
 */
package objects;

import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.internal.NanoTimer;
import com.gemstone.gemfire.internal.util.Sizeof;
import hydra.BasePrms;
import hydra.GsRandom;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import objects.ArrayOfByte;
import objects.ConfigurableObject;
import objects.ObjectAccessException;
import objects.ObjectValidationException;
import objects.PdxObjectPrms;
import objects.TimestampedObject;
import objects.UpdatableObject;

public class PdxObject
implements ConfigurableObject,
TimestampedObject,
UpdatableObject,
ObjectSizer {
    protected long timestamp;
    protected int field1;
    protected char field2;
    protected byte[] byteArray;

    public void init(int index) {
        int size = PdxObjectPrms.getSize();
        if (size == 0) {
            this.byteArray = null;
        } else {
            boolean encodeKey = true;
            this.byteArray = ArrayOfByte.init(index, size, encodeKey, false);
        }
        this.timestamp = NanoTimer.getTime() - RemoteTestModule.getClockSkew();
        GsRandom random = TestConfig.tab().getRandGen();
        this.field1 = random.nextInt();
        this.field2 = random.nextChar();
    }

    public int getIndex() {
        if (this.byteArray == null) {
            throw new ObjectAccessException("No index is encoded when " + BasePrms.nameForKey(PdxObjectPrms.size) + " is 0");
        }
        try {
            return ArrayOfByte.getIndex(this.byteArray);
        }
        catch (ObjectAccessException e) {
            throw new ObjectAccessException("PdxObject.byteArray  does not contain an encoded integer index");
        }
    }

    public void validate(int index) {
        if (this.byteArray == null) {
            Log.getLogWriter().info("Cannot validate encoded index of object " + index + ", it has no byteArray");
        } else {
            int encodedIndex = this.getIndex();
            if (encodedIndex != index) {
                throw new ObjectValidationException("Expected index " + index + ", got " + encodedIndex);
            }
        }
    }

    public void incrementField1() {
        ++this.field1;
    }

    @Override
    public synchronized void update() {
        this.incrementField1();
        this.resetTimestamp();
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void resetTimestamp() {
        this.timestamp = NanoTimer.getTime() - RemoteTestModule.getClockSkew();
    }

    public String toString() {
        if (this.byteArray == null) {
            return this.getClass().getName() + "@" + this.timestamp;
        }
        return this.getClass().getName() + "(" + this.getIndex() + ")@" + this.timestamp;
    }

    public boolean equals(Object o) {
        if (o instanceof PdxObject) {
            PdxObject other = (PdxObject)o;
            if (this.timestamp == other.timestamp && this.field1 == other.field1 && this.field2 == other.field2) {
                return true;
            }
        }
        return false;
    }

    public int sizeof(Object o) {
        if (o instanceof PdxObject) {
            PdxObject obj = (PdxObject)o;
            return Sizeof.sizeof((long)obj.timestamp) + Sizeof.sizeof((int)obj.field1) + Sizeof.sizeof((char)obj.field2) + Sizeof.sizeof((byte[])obj.byteArray);
        }
        return Sizeof.sizeof((Object)o);
    }
}

