/*
 * Decompiled with CFR 0.152.
 */
package objects.query;

import hydra.Log;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import objects.query.BaseQueryFactory;
import objects.query.SQLQueryFactory;

public abstract class BaseSQLQueryFactory
extends BaseQueryFactory
implements SQLQueryFactory {
    @Override
    public ResultSet execute(String stmt, Connection conn) throws SQLException {
        if (this.logQueries) {
            Log.getLogWriter().info("Executing: " + stmt + " on: " + conn);
        }
        ResultSet rs = null;
        Statement s = conn.createStatement();
        boolean result = s.execute(stmt);
        if (result) {
            rs = s.getResultSet();
        }
        if (this.logQueries) {
            Log.getLogWriter().info("Executed: " + stmt + " on: " + conn);
        }
        s.close();
        return rs;
    }

    @Override
    public int executeUpdate(String stmt, Connection conn) throws SQLException {
        if (this.logQueries) {
            Log.getLogWriter().info("Executing: " + stmt + " on: " + conn);
        }
        Statement s = conn.createStatement();
        int result = s.executeUpdate(stmt);
        s.close();
        if (this.logQueries) {
            Log.getLogWriter().info("Executed: " + stmt + " on: " + conn + " ended with result = " + result);
        }
        s.close();
        return result;
    }

    @Override
    public ResultSet executeQuery(String stmt, Connection conn) throws SQLException {
        if (this.logQueries) {
            Log.getLogWriter().info("Executing: " + stmt + " on: " + conn);
        }
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery(stmt);
        if (this.logQueries) {
            Log.getLogWriter().info("Executed: " + stmt + " on: " + conn);
        }
        s.close();
        return rs;
    }

    public ResultSet executeQueryPreparedStatement(PreparedStatement pstmt) throws SQLException {
        ResultSet rs = pstmt.executeQuery();
        if (this.logWarnings) {
            this.logWarnings(pstmt);
        }
        return rs;
    }

    public int executeUpdatePreparedStatement(PreparedStatement pstmt) throws SQLException {
        if (this.logQueries) {
            Log.getLogWriter().info("Executing query: " + pstmt);
        }
        int numUpdated = pstmt.executeUpdate();
        if (this.logWarnings) {
            this.logWarnings(pstmt);
        }
        if (this.logQueries) {
            Log.getLogWriter().info("Executed query: " + pstmt + ", " + numUpdated);
        }
        return numUpdated;
    }

    protected void logWarnings(PreparedStatement pstmt) throws SQLException {
        for (SQLWarning warning = pstmt.getWarnings(); warning != null; warning = warning.getNextWarning()) {
            String message = warning.getMessage();
            int errorCode = warning.getErrorCode();
            Log.getLogWriter().warning("While executing prepared statement: " + pstmt + " got error code: " + errorCode + " for: " + message);
        }
    }
}

