/*
 * Decompiled with CFR 0.152.
 */
package objects.query;

import hydra.BasePrms;
import hydra.HydraConfigException;
import hydra.HydraVector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import objects.query.QueryFactoryException;

public class QueryPrms
extends BasePrms {
    public static final String OQL_API = "OQL";
    public static final String GFXD_API = "GFXD";
    public static final String GFE_API = "GFE";
    public static final String MYSQL_API = "MYSQL";
    public static final String MYSQLC_API = "MYSQLC";
    public static final String ORACLE_API = "ORACLE";
    public static final String GPDB_API = "GPDB";
    public static final String RTE_API = "RTE";
    public static final int OQL = 0;
    public static final int GFXD = 1;
    public static final int GFE = 2;
    public static final int MYSQL = 3;
    public static final int MYSQLC = 4;
    public static final int ORACLE = 5;
    public static final int RTE = 6;
    public static final int GPDB = 7;
    public static final String GFE_GFK_DVD_API = "GFE_GFK_DVD";
    public static final String GFE_GFK_API = "GFE_GFK";
    public static final int GFE_GFK_DVD = 20;
    public static final int GFE_GFK = 21;
    public static final String BROKER_OBJECT_TYPE = "objects.query.broker.Broker";
    public static final String SECTOR_OBJECT_TYPE = "objects.query.sector.Sector";
    public static final String LARGE_OBJECT_OBJECT_TYPE = "objects.query.largeobject.LargeObject";
    public static final String TINY_OBJECT_OBJECT_TYPE = "objects.query.tinyobject.TinyObject";
    public static final String SECURITIES_TYPE = "objects.query.securities.Securities";
    public static final String REPLICATE_DATA_POLICY = "REPLICATE";
    public static final String PARTITION_DATA_POLICY = "PARTITION";
    public static final String NO_DATA_POLICY = "NONE";
    public static final int REPLICATE = 0;
    public static final int PARTITION = 1;
    public static final int NONE = 2;
    public static final String DEFAULT_PARTITION_TYPE = "PartitionByDefault";
    public static final String PARTITION_BY_PK_TYPE = "PartitionByPK";
    public static final String PARTITION_BY_COLUMN_TYPE = "PartitionByColumn";
    public static final String PARTITION_BY_RANGE_TYPE = "PartitionByRange";
    public static final String PARTITION_BY_LIST_TYPE = "PartitionByList";
    public static final String PARTITION_BY_LIST_SPECIAL_CASE_TYPE = "PartitionByListSpecialCase";
    public static final int PARTITION_BY_PK = 0;
    public static final int PARTITION_BY_COLUMN = 1;
    public static final int PARTITION_BY_RANGE = 2;
    public static final int DEFAULT_PARTITION = 3;
    public static final int PARTITION_BY_LIST = 4;
    public static final int PARTITION_BY_LIST_SPECIAL_CASE = 5;
    public static Long api;
    public static Long objectType;
    public static Long objectTypes;
    public static Long logIndexes;
    public static Long logQueries;
    public static Long logQueryResults;
    public static Long logQueryResultSize;
    public static Long logUpdates;
    public static Long logWarnings;
    public static Long validateResults;

    public static int getDataPolicy(Long key, String val) {
        if (val.equalsIgnoreCase(REPLICATE_DATA_POLICY)) {
            return 0;
        }
        if (val.equalsIgnoreCase(PARTITION_DATA_POLICY)) {
            return 1;
        }
        if (val.equalsIgnoreCase(NO_DATA_POLICY)) {
            return 2;
        }
        String s = "Illegal value for " + BasePrms.nameForKey(key) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static int getPartitionType(Long key, String val) {
        if (val.equalsIgnoreCase(PARTITION_BY_PK_TYPE)) {
            return 0;
        }
        if (val.equalsIgnoreCase(PARTITION_BY_COLUMN_TYPE)) {
            return 1;
        }
        if (val.equalsIgnoreCase(PARTITION_BY_RANGE_TYPE)) {
            return 2;
        }
        if (val.equalsIgnoreCase(PARTITION_BY_LIST_TYPE)) {
            return 4;
        }
        if (val.equalsIgnoreCase(PARTITION_BY_LIST_SPECIAL_CASE_TYPE)) {
            return 5;
        }
        if (val.equalsIgnoreCase(DEFAULT_PARTITION_TYPE)) {
            return 3;
        }
        String s = "Illegal value for " + BasePrms.nameForKey(key) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static int getAPI() {
        Long key = api;
        String val = QueryPrms.tasktab().stringAt(key, QueryPrms.tab().stringAt(key));
        if (val.equalsIgnoreCase(GFE_API)) {
            return 2;
        }
        if (val.equalsIgnoreCase(OQL_API)) {
            return 0;
        }
        if (val.equalsIgnoreCase(GFXD_API)) {
            return 1;
        }
        if (val.equalsIgnoreCase(MYSQL_API)) {
            return 3;
        }
        if (val.equalsIgnoreCase(MYSQLC_API)) {
            return 4;
        }
        if (val.equalsIgnoreCase(ORACLE_API)) {
            return 5;
        }
        if (val.equalsIgnoreCase(GPDB_API)) {
            return 7;
        }
        if (val.equalsIgnoreCase(RTE_API)) {
            return 6;
        }
        if (val.equalsIgnoreCase(GFE_GFK_API)) {
            return 21;
        }
        if (val.equalsIgnoreCase(GFE_GFK_DVD_API)) {
            return 20;
        }
        String s = "Illegal value for " + BasePrms.nameForKey(key) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static String getAPIString(int apiCode) {
        switch (apiCode) {
            case 0: {
                return OQL_API;
            }
            case 1: {
                return GFXD_API;
            }
            case 2: {
                return GFE_API;
            }
            case 21: {
                return GFE_GFK_API;
            }
            case 20: {
                return GFE_GFK_DVD_API;
            }
            case 3: {
                return MYSQL_API;
            }
            case 4: {
                return MYSQLC_API;
            }
            case 5: {
                return ORACLE_API;
            }
            case 6: {
                return RTE_API;
            }
            case 7: {
                return GPDB_API;
            }
        }
        String s = "Unknown API: " + apiCode;
        throw new QueryFactoryException(s);
    }

    public static String getObjectType() {
        Long key = objectType;
        String val = QueryPrms.tasktab().stringAt(key, QueryPrms.tab().stringAt(key));
        return QueryPrms.getObjectType(key, val);
    }

    private static String getObjectType(Long key, String val) {
        if (val.equals(BROKER_OBJECT_TYPE)) {
            return BROKER_OBJECT_TYPE;
        }
        if (val.equals(SECTOR_OBJECT_TYPE)) {
            return SECTOR_OBJECT_TYPE;
        }
        if (val.equals(LARGE_OBJECT_OBJECT_TYPE)) {
            return LARGE_OBJECT_OBJECT_TYPE;
        }
        if (val.equals(TINY_OBJECT_OBJECT_TYPE)) {
            return TINY_OBJECT_OBJECT_TYPE;
        }
        if (val.equals(SECURITIES_TYPE)) {
            return SECURITIES_TYPE;
        }
        String s = "Illegal value for " + BasePrms.nameForKey(key) + ": " + val;
        throw new HydraConfigException(s);
    }

    public static List getObjectTypes() {
        Long key = objectTypes;
        HydraVector val = QueryPrms.tasktab().vecAt(key, QueryPrms.tab().vecAt(key));
        ArrayList<String> vals = new ArrayList<String>();
        Iterator i = val.iterator();
        while (i.hasNext()) {
            vals.add(QueryPrms.getObjectType(key, (String)i.next()));
        }
        return vals;
    }

    public static boolean logIndexes() {
        Long key = logIndexes;
        return QueryPrms.tasktab().booleanAt(key, QueryPrms.tab().booleanAt(key, false));
    }

    public static boolean logQueries() {
        Long key = logQueries;
        return QueryPrms.tasktab().booleanAt(key, QueryPrms.tab().booleanAt(key, false));
    }

    public static boolean logQueryResults() {
        Long key = logQueryResults;
        return QueryPrms.tasktab().booleanAt(key, QueryPrms.tab().booleanAt(key, false));
    }

    public static boolean logQueryResultSize() {
        Long key = logQueryResultSize;
        return QueryPrms.tasktab().booleanAt(key, QueryPrms.tab().booleanAt(key, false));
    }

    public static boolean logUpdates() {
        Long key = logUpdates;
        return QueryPrms.tasktab().booleanAt(key, QueryPrms.tab().booleanAt(key, false));
    }

    public static boolean logWarnings() {
        Long key = logWarnings;
        return QueryPrms.tasktab().booleanAt(key, QueryPrms.tab().booleanAt(key, false));
    }

    public static boolean validateResults() {
        Long key = validateResults;
        return QueryPrms.tasktab().booleanAt(key, QueryPrms.tab().booleanAt(key, false));
    }

    public static void main(String[] args) {
        QueryPrms.dumpKeys();
    }

    static {
        QueryPrms.setValues(QueryPrms.class);
    }
}

